/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network.old;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import travellersgear.TravellersGear;
import travellersgear.api.TGSaveData;
import travellersgear.api.TravellersGearAPI;
import travellersgear.client.ClientProxy;
import travellersgear.client.ToolDisplayInfo;
import travellersgear.common.network.old.AbstractPacket;

public class PacketNBTSync
extends AbstractPacket {
    int dim;
    int playerid;
    NBTTagCompound tag;
    NBTTagCompound[] toolDisplay;

    public PacketNBTSync() {
    }

    public PacketNBTSync(EntityPlayer player) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.tag = TGSaveData.getPlayerData(player);
        if (this.tag == null) {
            this.tag = new NBTTagCompound();
            if (player.getEntityData().func_74775_l("TravellersRPG") != null) {
                this.tag = player.getEntityData().func_74775_l("TravellersRPG");
                player.getEntityData().func_82580_o("TravellersRPG");
            }
            this.tag.func_74772_a("UUIDMost", player.getPersistentID().getMostSignificantBits());
            this.tag.func_74772_a("UUIDLeast", player.getPersistentID().getLeastSignificantBits());
        }
        this.tag.func_74780_a("info_playerDamage", player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.playerid);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.tag);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.playerid = buffer.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer p) {
        World world = TravellersGear.proxy.getClientWorld();
        if (world == null) {
            return;
        }
        Entity player = world.func_73045_a(this.playerid);
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        if (this.tag == null) {
            throw new RuntimeException("HEYO!");
        }
        TGSaveData.setPlayerData((EntityPlayer)player, this.tag);
        TGSaveData.setDirty();
        ClientProxy.equipmentMap.put(player.func_70005_c_(), TravellersGearAPI.getExtendedInventory((EntityPlayer)player));
        if (this.tag.func_74764_b("toolDisplay")) {
            NBTTagList list = this.tag.func_150295_c("toolDisplay", 10);
            ToolDisplayInfo[] tdi = new ToolDisplayInfo[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                tdi[i] = ToolDisplayInfo.readFromNBT(list.func_150305_b(i));
            }
            ClientProxy.toolDisplayMap.put(player.func_70005_c_(), tdi);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer p) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return;
        }
        Entity player = world.func_73045_a(this.playerid);
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        TGSaveData.setPlayerData((EntityPlayer)player, this.tag);
        TGSaveData.setDirty();
    }
}

