/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.AutoValue_Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import java.util.function.BiConsumer;

abstract class $AutoValue_Slot
extends Slot {
    private final Point position;
    private final int slotWidth;
    private final Tooltip tooltip;
    private final BiConsumer<DiagramState, Point> drawFunction;

    $AutoValue_Slot(Point position, int slotWidth, Tooltip tooltip, BiConsumer<DiagramState, Point> drawFunction) {
        if (position == null) {
            throw new NullPointerException("Null position");
        }
        this.position = position;
        this.slotWidth = slotWidth;
        if (tooltip == null) {
            throw new NullPointerException("Null tooltip");
        }
        this.tooltip = tooltip;
        if (drawFunction == null) {
            throw new NullPointerException("Null drawFunction");
        }
        this.drawFunction = drawFunction;
    }

    @Override
    public Point position() {
        return this.position;
    }

    @Override
    public int slotWidth() {
        return this.slotWidth;
    }

    @Override
    public Tooltip tooltip() {
        return this.tooltip;
    }

    @Override
    public BiConsumer<DiagramState, Point> drawFunction() {
        return this.drawFunction;
    }

    public String toString() {
        return "Slot{position=" + this.position + ", slotWidth=" + this.slotWidth + ", tooltip=" + this.tooltip + ", drawFunction=" + this.drawFunction + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Slot) {
            Slot that = (Slot)o;
            return this.position.equals(that.position()) && this.slotWidth == that.slotWidth() && this.tooltip.equals(that.tooltip()) && this.drawFunction.equals(that.drawFunction());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.position.hashCode();
        h$ *= 1000003;
        h$ ^= this.slotWidth;
        h$ *= 1000003;
        h$ ^= this.tooltip.hashCode();
        h$ *= 1000003;
        return h$ ^= this.drawFunction.hashCode();
    }

    @Override
    public Slot.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends Slot.Builder {
        private Point position;
        private Integer slotWidth;
        private Tooltip tooltip;
        private BiConsumer<DiagramState, Point> drawFunction;

        Builder() {
        }

        private Builder(Slot source) {
            this.position = source.position();
            this.slotWidth = source.slotWidth();
            this.tooltip = source.tooltip();
            this.drawFunction = source.drawFunction();
        }

        @Override
        public Slot.Builder setPosition(Point position) {
            if (position == null) {
                throw new NullPointerException("Null position");
            }
            this.position = position;
            return this;
        }

        @Override
        public Slot.Builder setSlotWidth(int slotWidth) {
            this.slotWidth = slotWidth;
            return this;
        }

        @Override
        public Slot.Builder setTooltip(Tooltip tooltip) {
            if (tooltip == null) {
                throw new NullPointerException("Null tooltip");
            }
            this.tooltip = tooltip;
            return this;
        }

        @Override
        public Slot.Builder setDrawFunction(BiConsumer<DiagramState, Point> drawFunction) {
            if (drawFunction == null) {
                throw new NullPointerException("Null drawFunction");
            }
            this.drawFunction = drawFunction;
            return this;
        }

        @Override
        public Slot build() {
            if (this.position == null || this.slotWidth == null || this.tooltip == null || this.drawFunction == null) {
                StringBuilder missing = new StringBuilder();
                if (this.position == null) {
                    missing.append(" position");
                }
                if (this.slotWidth == null) {
                    missing.append(" slotWidth");
                }
                if (this.tooltip == null) {
                    missing.append(" tooltip");
                }
                if (this.drawFunction == null) {
                    missing.append(" drawFunction");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Slot(this.position, this.slotWidth, this.tooltip, this.drawFunction);
        }
    }
}

