/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.client.GUI.GG_UITextures;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_HatchElementBuilder;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.IDualInputHatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class PreciseAssembler
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<PreciseAssembler>
implements IConstructable,
ISurvivalConstructable {
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST_GLOW");
    protected IStructureDefinition<PreciseAssembler> multiDefinition = null;
    protected int casingAmount;
    protected int casingTier;
    protected int machineTier;
    protected int mode;
    protected int energyHatchTier;

    public PreciseAssembler(String name) {
        super(name);
    }

    public PreciseAssembler(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public IStructureDefinition<PreciseAssembler> getStructureDefinition() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"CCCC~CCCC", "CMMMMMMMC", "CMMMMMMMC", "CMMMMMMMC", "CCCCCCCCC"}})).addElement('C', (IStructureElement)GT_HatchElementBuilder.builder().atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Muffler, GT_HatchElement.ExoticEnergy.or((IHatchElement)GT_HatchElement.Energy)}).adder(PreciseAssembler::addToPAssList).casingIndex(1539).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == Loaders.preciseUnitCasing ? meta : -2, IntStream.range(0, 3).mapToObj(meta -> Pair.of((Object)Loaders.preciseUnitCasing, (Object)meta)).collect(Collectors.toList()), (Object)-1, PreciseAssembler::setCasingTier, PreciseAssembler::getCasingTier))})).addElement('F', GT_StructureUtility.ofFrame((Materials)Materials.TungstenSteel)).addElement('G', BW_Util.ofGlassTieredMixed((byte)4, (byte)127, (int)2)).addElement('M', StructureUtility.ofBlocksTiered((block, meta) -> block == GregTech_API.sBlockCasings1 ? meta : -2, IntStream.range(0, 10).mapToObj(meta -> Pair.of((Object)GregTech_API.sBlockCasings1, (Object)meta)).collect(Collectors.toList()), (Object)-1, PreciseAssembler::setMachineTier, PreciseAssembler::getMachineTier)).build();
        }
        return this.multiDefinition;
    }

    public boolean addToPAssList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof IDualInputHatch) {
            return this.mDualInputHatches.add((IDualInputHatch)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            return this.mExoticEnergyHatches.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
        }
        return false;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.casingTier = aNBT.func_74762_e("casingTier");
        this.machineTier = aNBT.func_74762_e("machineTier");
        this.mode = aNBT.func_74762_e("RunningMode");
        super.loadNBTData(aNBT);
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("casingTier", this.casingTier);
        aNBT.func_74768_a("machineTier", this.machineTier);
        aNBT.func_74768_a("RunningMode", this.mode);
        super.saveNBTData(aNBT);
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.mode = (this.mode + 1) % 2;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)("preciseassembler.chat." + this.mode)));
        }
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                if (PreciseAssembler.this.mode == 0 && recipe.mSpecialValue > PreciseAssembler.this.casingTier + 1) {
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)recipe.mSpecialValue);
                }
                if (this.availableVoltage < (long)recipe.mEUt) {
                    return CheckRecipeResultRegistry.insufficientPower((long)recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Nonnull
            protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).setSpeedBoost(PreciseAssembler.this.mode == 0 ? 1.0f : 0.5f);
            }
        }.setMaxParallelSupplier(() -> this.mode == 0 ? 1 : (int)Math.pow(2.0, 4 + (this.casingTier + 1)));
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        boolean useSingleAmp = this.mEnergyHatches.size() == 1 && this.mExoticEnergyHatches.isEmpty();
        logic.setAvailableVoltage(this.getMachineVoltageLimit());
        logic.setAvailableAmperage(useSingleAmp ? 1L : this.getMaxInputAmps());
        logic.setAmperageOC(true);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public long getMachineVoltageLimit() {
        if (this.machineTier < 0) {
            return 0L;
        }
        if (this.machineTier >= 9) {
            return GT_Values.V[this.energyHatchTier];
        }
        return GT_Values.V[Math.min(this.machineTier, this.energyHatchTier)];
    }

    public RecipeMap<?> getRecipeMap() {
        if (this.mode == 0) {
            return GoodGeneratorRecipeMaps.preciseAssemblerRecipes;
        }
        return RecipeMaps.assemblerRecipes;
    }

    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(GoodGeneratorRecipeMaps.preciseAssemblerRecipes, RecipeMaps.assemblerRecipes);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 4, 4, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.machineTier = -1;
        this.casingAmount = 0;
        this.casingTier = -1;
        this.energyHatchTier = 0;
        if (this.checkPiece(this.mName, 4, 4, 0)) {
            this.energyHatchTier = this.checkEnergyHatchTier();
            if (this.casingTier >= 0) {
                this.reUpdate(1539 + this.casingTier);
            }
            this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
            return this.casingAmount >= 42 && this.machineTier >= 0 && this.casingTier >= 0 && this.mMaintenanceHatches.size() == 1 && !this.mMufflerHatches.isEmpty();
        }
        return false;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Precise Assembler/Assembler").addInfo("Controller block for the Precise Assembler").addInfo("The error is no more than 7nm.").addInfo("Can assemble precise component in Precise Mode.").addInfo("Can work like a normal assembler in Normal Mode.").addInfo("Use screwdriver to change mode.").addInfo("Machine Casing and Energy Hatch limits the voltage tier the machine can work on.").addInfo("UHV Machine Casing will unlock all voltage, but you still need good Energy Hatch.").addInfo("Precise Electronic Unit Casing won't limit recipe in Normal Mode.").addInfo("But gives more parallel with more advanced one.").addInfo("It is 100% faster in Normal Mode.").addInfo("MK-I = 32x, MK-II = 64x, MK-III = 128x").addPollutionAmount(this.getPollutionPerSecond(null)).addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().beginStructureBlock(9, 5, 5, true).addController("Front bottom").addCasingInfoExactly("Machine Casing", 21, true).addCasingInfoExactly("Glass (EV+)", 42, false).addCasingInfoRange("Precise Electronic Unit Casing", 42, 86, true).addInputHatch("Any Casing").addInputBus("Any Casing").addOutputHatch("Any Casing").addOutputBus("Any Casing").addEnergyHatch("Any Casing").addMufflerHatch("Any Casing").addMaintenanceHatch("Any Casing").toolTipFinisher("Good Generator");
        return tt;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 780;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("PreciseAssembler.hint", 7);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new PreciseAssembler(this.mName);
    }

    private int checkEnergyHatchTier() {
        int tier = 0;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : (ArrayList)GT_Utility.filterValidMTEs((Collection)this.mEnergyHatches)) {
            tier = Math.max(tHatch.mTier, tier);
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : (List)GT_Utility.filterValidMTEs((Collection)this.mExoticEnergyHatches)) {
            tier = Math.max(tHatch.mTier, tier);
        }
        return tier;
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public void setCasingTier(int i) {
        this.casingTier = i;
    }

    public int getMachineTier() {
        return this.machineTier;
    }

    public void setMachineTier(int i) {
        this.machineTier = i;
    }

    public void reUpdate(int texture) {
        for (IDualInputHatch hatch : this.mDualInputHatches) {
            if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)((MetaTileEntity)hatch))) continue;
            hatch.updateTexture(texture);
        }
        for (IDualInputHatch hatch : this.mInputHatches) {
            if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)hatch)) continue;
            hatch.updateTexture(texture);
        }
        for (IDualInputHatch hatch : this.mInputBusses) {
            hatch.updateTexture(texture);
        }
        for (IDualInputHatch hatch : this.mOutputHatches) {
            hatch.updateTexture(texture);
        }
        for (IDualInputHatch hatch : this.mOutputBusses) {
            hatch.updateTexture(texture);
        }
        for (IDualInputHatch hatch : this.mEnergyHatches) {
            hatch.updateTexture(texture);
        }
        for (IDualInputHatch hatch : this.mMaintenanceHatches) {
            hatch.updateTexture(texture);
        }
        for (IDualInputHatch hatch : this.mMufflerHatches) {
            hatch.updateTexture(texture);
        }
        for (IDualInputHatch hatch : this.mExoticEnergyHatches) {
            hatch.updateTexture(texture);
        }
    }

    public byte getUpdateData() {
        return (byte)this.casingTier;
    }

    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && (aValue & 0x80) == 0) {
            this.casingTier = aValue;
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        int t = Math.max(this.getCasingTier(), 0);
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1539 + t)), TextureFactory.of((IIconContainer)textureFontOn), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOn_Glow}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1539 + t)), TextureFactory.of((IIconContainer)textureFontOff), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOff_Glow}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1539 + t))};
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget(new CycleButtonWidget().setToggle(() -> this.mode == 1, val -> {
            this.mode = val != false ? 1 : 0;
        }).setTextureGetter(state -> state == 1 ? GG_UITextures.OVERLAY_BUTTON_ASSEMBLER_MODE : GG_UITextures.OVERLAY_BUTTON_PRECISE_MODE).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD}).setPos(80, 91).setSize(16, 16).dynamicTooltip(() -> Collections.singletonList(StatCollector.func_74838_a((String)("preciseassembler.chat." + this.mode)))).setUpdateTooltipEveryTick(true).setTooltipShowUpDelay(5));
    }

    public boolean isInputSeparationEnabled() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean supportsVoidProtection() {
        return true;
    }
}

