/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goodgenerator.items.RadioactiveItem;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.util.GT_Utility;
import ic2.api.item.IBoxable;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class FuelRod
extends RadioactiveItem
implements IReactorComponent,
IBoxable {
    private final int numberOfCells;
    private final int maxDmg;
    private final float Power;
    private final int Heat;
    private float HeatBonus = 0.0f;
    private final ItemStack result;

    public FuelRod(String aName, int aCells, int aEUt, int aHeat, int aRads, int aDuration, ItemStack aResult, CreativeTabs Tab) {
        super(aName, Tab, aRads);
        this.func_77625_d(64);
        this.numberOfCells = aCells;
        this.maxDmg = aDuration;
        this.Power = (float)aEUt / 25.0f;
        this.result = aResult;
        this.Heat = aHeat;
        this.func_77656_e(100);
    }

    public FuelRod(String aName, int aCells, int aEUt, int aHeat, int aRads, int aDuration, float aHeatBonus, ItemStack aResult, CreativeTabs Tab) {
        super(aName, Tab, aRads);
        this.func_77625_d(64);
        this.numberOfCells = aCells;
        this.maxDmg = aDuration;
        this.Power = (float)aEUt / 25.0f;
        this.result = aResult;
        this.Heat = aHeat;
        this.HeatBonus = aHeatBonus;
        this.func_77656_e(100);
    }

    public void processChamber(IReactor reactor, ItemStack stack, int x, int y, boolean heatRun) {
        if (reactor.produceEnergy()) {
            for (int iteration = 0; iteration < this.numberOfCells; ++iteration) {
                int dheat;
                int heat;
                int pulses = 1 + this.numberOfCells / 2;
                if (!heatRun) {
                    for (heat = 0; heat < pulses; ++heat) {
                        this.acceptUraniumPulse(reactor, stack, stack, x, y, x, y, heatRun);
                    }
                    FuelRod.checkPulseable(reactor, x - 1, y, stack, x, y, heatRun);
                    FuelRod.checkPulseable(reactor, x + 1, y, stack, x, y, heatRun);
                    FuelRod.checkPulseable(reactor, x, y - 1, stack, x, y, heatRun);
                    FuelRod.checkPulseable(reactor, x, y + 1, stack, x, y, heatRun);
                    continue;
                }
                ArrayList<ItemStackCoord> heatAcceptors = new ArrayList<ItemStackCoord>();
                this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
                this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
                this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
                this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
                for (heat = FuelRod.sumUp(pulses += FuelRod.checkPulseable(reactor, x - 1, y, stack, x, y, heatRun) + FuelRod.checkPulseable(reactor, x + 1, y, stack, x, y, heatRun) + FuelRod.checkPulseable(reactor, x, y - 1, stack, x, y, heatRun) + FuelRod.checkPulseable(reactor, x, y + 1, stack, x, y, heatRun)) * this.Heat; heatAcceptors.size() > 0 && heat > 0; heat += dheat) {
                    dheat = heat / heatAcceptors.size();
                    heat -= dheat;
                    dheat = ((IReactorComponent)heatAcceptors.get((int)0).stack.func_77973_b()).alterHeat(reactor, heatAcceptors.get((int)0).stack, heatAcceptors.get((int)0).x, heatAcceptors.get((int)0).y, dheat);
                    heatAcceptors.remove(0);
                }
                if (heat <= 0) continue;
                reactor.addHeat(heat);
            }
            if (this.getCustomDamage(stack) >= this.getMaxCustomDamage(stack) - 1) {
                reactor.setItemAt(x, y, GT_Utility.copyAmount((int)1, (ItemStack)this.result));
            } else if (heatRun) {
                this.applyCustomDamage(stack, 1, null);
            }
        }
    }

    private static int checkPulseable(IReactor reactor, int x, int y, ItemStack me, int mex, int mey, boolean heatrun) {
        ItemStack other = reactor.getItemAt(x, y);
        return other != null && other.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)other.func_77973_b()).acceptUraniumPulse(reactor, other, me, x, y, mex, mey, heatrun) ? 1 : 0;
    }

    private static int sumUp(int x) {
        return (x * x + x) / 2;
    }

    private void checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList<ItemStackCoord> heatAcceptors) {
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing != null && thing.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)thing.func_77973_b()).canStoreHeat(reactor, thing, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
        }
    }

    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        if (!heatrun) {
            reactor.addOutput(this.Power * (1.0f + this.HeatBonus * ((float)reactor.getHeat() / (float)reactor.getMaxHeat())));
        }
        return true;
    }

    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 2 * this.numberOfCells;
    }

    public boolean canBeStoredInToolbox(ItemStack itemStack) {
        return true;
    }

    public int getCustomDamage(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        return nbt.func_74762_e("advDmg");
    }

    public int getMaxCustomDamage(ItemStack stack) {
        return this.maxDmg;
    }

    public void setCustomDamage(ItemStack stack, int damage) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        nbt.func_74768_a("advDmg", damage);
        int maxStackDamage = stack.func_77958_k();
        if (maxStackDamage > 2) {
            stack.func_77964_b(1 + (int)Util.map((double)damage, (double)this.maxDmg, (double)(maxStackDamage - 2)));
        }
    }

    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        this.setCustomDamage(stack, this.getCustomDamage(stack) + damage);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List tooltip, boolean p_77624_4_) {
        super.func_77624_a(item, player, tooltip, p_77624_4_);
        tooltip.add(String.format(DescTextLocalization.addText("fuelrod.tooltip", 1)[0], this.getMaxCustomDamage(item) - this.getCustomDamage(item), this.getMaxCustomDamage(item)));
        double tMut = (double)this.Heat / 4.0;
        if (this.Heat == 4) {
            tooltip.add(StatCollector.func_74838_a((String)"fuelrodheat.tooltip.0"));
        } else {
            tooltip.add(String.format(StatCollector.func_74838_a((String)"fuelrodheat.tooltip.1"), tMut));
        }
        if (this.HeatBonus != 0.0f) {
            tooltip.add(StatCollector.func_74838_a((String)"fuelrodheat.tooltip.2"));
        }
    }

    private static class ItemStackCoord {
        public ItemStack stack;
        public int x;
        public int y;

        public ItemStackCoord(ItemStack stack1, int x1, int y1) {
            this.stack = stack1;
            this.x = x1;
            this.y = y1;
        }
    }
}

