/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;

class FilterWriteStrategy {
    private static final int COMPUTE_STATS_EVERY_N_LINES = 8;
    final ImageInfo imgInfo;
    public final FilterType configuredType;
    private FilterType currentType;
    private int lastRowTested = -1000000;
    private double[] lastSums = new double[5];
    private double[] lastEntropies = new double[5];
    private double[] preference = new double[]{1.1, 1.1, 1.1, 1.1, 1.2};
    private int discoverEachLines = -1;
    private double[] histogram1 = new double[256];

    FilterWriteStrategy(ImageInfo imgInfo, FilterType configuredType) {
        this.imgInfo = imgInfo;
        this.configuredType = configuredType;
        this.currentType = configuredType.val < 0 ? (imgInfo.rows < 8 && imgInfo.cols < 8 || imgInfo.indexed || imgInfo.bitDepth < 8 ? FilterType.FILTER_NONE : FilterType.FILTER_PAETH) : configuredType;
        if (configuredType == FilterType.FILTER_AGGRESSIVE) {
            this.discoverEachLines = 8;
        }
        if (configuredType == FilterType.FILTER_VERYAGGRESSIVE) {
            this.discoverEachLines = 1;
        }
    }

    boolean shouldTestAll(int rown) {
        if (this.discoverEachLines > 0 && this.lastRowTested + this.discoverEachLines <= rown) {
            this.currentType = null;
            return true;
        }
        return false;
    }

    public void setPreference(double none, double sub, double up, double ave, double paeth) {
        this.preference = new double[]{none, sub, up, ave, paeth};
    }

    public boolean computesStatistics() {
        return this.discoverEachLines > 0;
    }

    void fillResultsForFilter(int rown, FilterType type, double sum, int[] histo, boolean tentative) {
        this.lastRowTested = rown;
        this.lastSums[type.val] = sum;
        if (histo != null) {
            double alfa = rown == 0 ? 0.0 : 0.3;
            double beta = 1.0 - alfa;
            double e = 0.0;
            for (int i = 0; i < 256; ++i) {
                double v = (double)histo[i] / (double)this.imgInfo.cols;
                v = this.histogram1[i] * alfa + v * beta;
                if (tentative) {
                    e += v > 1.0E-8 ? v * Math.log(v) : 0.0;
                    continue;
                }
                this.histogram1[i] = v;
            }
            this.lastEntropies[type.val] = -e;
        }
    }

    FilterType gimmeFilterType(int rown, boolean useEntropy) {
        if (this.currentType == null) {
            if (rown == 0) {
                this.currentType = FilterType.FILTER_SUB;
            } else {
                double bestval = Double.MAX_VALUE;
                for (int i = 0; i < 5; ++i) {
                    double val = useEntropy ? this.lastEntropies[i] : this.lastSums[i];
                    if (!((val /= this.preference[i]) <= bestval)) continue;
                    bestval = val;
                    this.currentType = FilterType.getByVal(i);
                }
            }
        }
        if (this.configuredType == FilterType.FILTER_CYCLIC) {
            this.currentType = FilterType.getByVal((this.currentType.val + 1) % 5);
        }
        return this.currentType;
    }
}

