/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import alexiil.mods.load.BetterLoadingScreen;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

@Deprecated
public class Translation {
    private static Map<String, Translation> translators = new HashMap<String, Translation>();
    private static Translation currentTranslation = null;
    private Map<String, String> translations = new HashMap<String, String>();

    public static String translate(String toTranslate) {
        return Translation.translate(toTranslate, toTranslate);
    }

    public static String translate(String toTranslate, String failure) {
        if (currentTranslation != null) {
            return currentTranslation.translateInternal(toTranslate, failure);
        }
        return failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTranslations(File modLocation) {
        String lookingFor = "assets/betterloadingscreen/lang/";
        if (modLocation == null) {
            BetterLoadingScreen.log.warn("Could not find the translation file!");
            return;
        }
        if (modLocation.isDirectory()) {
            File langFolder = new File(modLocation, lookingFor);
            BetterLoadingScreen.log.trace(langFolder.getAbsolutePath() + ", " + langFolder.isDirectory());
            for (File f : langFolder.listFiles()) {
                if (f != null) {
                    BetterLoadingScreen.log.trace(f.getAbsolutePath());
                    continue;
                }
                BetterLoadingScreen.log.trace("null");
            }
        } else if (modLocation.isFile()) {
            JarFile modJar = null;
            try {
                modJar = new JarFile(modLocation);
                Enumeration<JarEntry> entries = modJar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    String name = je.getName();
                    if (!name.startsWith(lookingFor) || name.equals(lookingFor)) continue;
                    try {
                        Translation.addTranslation(name.replace(lookingFor, "").replace(".lang", ""), new BufferedReader(new InputStreamReader(modJar.getInputStream(je), StandardCharsets.UTF_8)));
                    }
                    catch (IOException e) {
                        BetterLoadingScreen.log.error("Had trouble opening " + name);
                    }
                }
            }
            catch (IOException e) {
                BetterLoadingScreen.log.error("Could not open file");
            }
            finally {
                if (modJar != null) {
                    try {
                        modJar.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        File options = new File("./options.txt");
        String language = "en_US";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(options));
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(":");
                if (!parts[0].equals("lang")) continue;
                language = parts[1];
            }
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (translators.containsKey(language)) {
            currentTranslation = translators.get(language);
        } else if (translators.containsKey("en_US")) {
            BetterLoadingScreen.log.info("Failed to load " + language + ", loading en_US instead");
            currentTranslation = translators.get("en_US");
        } else if (!translators.isEmpty()) {
            String name = translators.keySet().iterator().next();
            BetterLoadingScreen.log.warn("Failed to load " + language + ", AND FAILED TO LOAD en_US! One available however is " + name + ", using that and keeping quiet...");
            currentTranslation = translators.values().iterator().next();
        } else {
            BetterLoadingScreen.log.error("Failed to load ANY languages! All strings fail now!");
        }
    }

    public static boolean addTranslation(String locale, BufferedReader from) {
        try {
            BetterLoadingScreen.log.trace("Adding locale " + locale);
            translators.put(locale, new Translation(from));
        }
        catch (IOException e) {
            BetterLoadingScreen.log.error("Failed to add" + locale);
        }
        return true;
    }

    private Translation(BufferedReader loadFrom) throws IOException {
        try (BufferedReader reader = loadFrom;){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.equals("")) continue;
                Object[] splitter = line.split("=");
                if (splitter.length != 2) {
                    BetterLoadingScreen.log.warn("Found an invalid line (" + line + ")");
                    continue;
                }
                this.translations.put(splitter[0], splitter[1]);
                BetterLoadingScreen.log.debug("Found a translation " + Arrays.toString(splitter));
            }
        }
    }

    private String translateInternal(String toTranslate, String failure) {
        if (this.translations.containsKey(toTranslate)) {
            return this.translations.get(toTranslate);
        }
        return failure;
    }
}

