/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseModClient;
import gcewing.sg.BaseTexture;
import gcewing.sg.Vector3;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;

public abstract class BaseRenderTarget
implements BaseModClient.IRenderTarget {
    protected double blockX;
    protected double blockY;
    protected double blockZ;
    protected int verticesPerFace;
    protected int vertexCount;
    protected BaseModClient.ITexture texture;
    protected Vector3 normal;
    protected EnumFacing face;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    protected float alpha = 1.0f;
    protected float shade;
    protected boolean expandTrianglesToQuads;
    protected boolean textureOverride;

    public BaseRenderTarget(double x, double y, double z, IIcon overrideIcon) {
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        if (overrideIcon != null) {
            this.texture = BaseTexture.fromSprite(overrideIcon);
            this.textureOverride = true;
        }
    }

    @Override
    public boolean isRenderingBreakEffects() {
        return this.textureOverride;
    }

    @Override
    public void beginTriangle() {
        this.setMode(3);
    }

    @Override
    public void beginQuad() {
        this.setMode(4);
    }

    protected void setMode(int mode) {
        if (this.vertexCount != 0) {
            throw new IllegalStateException("Changing mode in mid-face");
        }
        this.verticesPerFace = mode;
    }

    @Override
    public void setTexture(BaseModClient.ITexture texture) {
        if (!this.textureOverride) {
            if (texture == null) {
                throw new IllegalArgumentException("Setting null texture");
            }
            this.texture = texture;
        }
    }

    @Override
    public void setColor(double r, double g, double b, double a) {
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.alpha = (float)a;
    }

    @Override
    public void setNormal(Vector3 n) {
        this.normal = n;
        this.face = n.facing();
        this.shade = (float)(0.6 * n.x * n.x + 0.8 * n.z * n.z + (n.y > 0.0 ? 1.0 : 0.5) * n.y * n.y);
    }

    @Override
    public void addVertex(Vector3 p, double u, double v) {
        if (this.texture.isProjected()) {
            this.addProjectedVertex(p, this.face);
        } else {
            this.addUVVertex(p, u, v);
        }
    }

    public void addUVVertex(Vector3 p, double u, double v) {
        if (this.verticesPerFace == 0) {
            throw new IllegalStateException("No face active");
        }
        if (this.vertexCount >= this.verticesPerFace) {
            throw new IllegalStateException("Too many vertices in face");
        }
        if (this.normal == null) {
            throw new IllegalStateException("No normal");
        }
        if (this.texture == null) {
            throw new IllegalStateException("No texture");
        }
        double iu = this.texture.interpolateU(u);
        double iv = this.texture.interpolateV(v);
        this.rawAddVertex(p, iu, iv);
        if (++this.vertexCount == 3 && this.expandTrianglesToQuads && this.verticesPerFace == 3) {
            this.rawAddVertex(p, iu, iv);
        }
    }

    @Override
    public void endFace() {
        if (this.vertexCount < this.verticesPerFace) {
            throw new IllegalStateException("Too few vertices in face");
        }
        this.vertexCount = 0;
        this.verticesPerFace = 0;
    }

    public void finish() {
        if (this.vertexCount > 0) {
            throw new IllegalStateException("Rendering ended with incomplete face");
        }
    }

    protected abstract void rawAddVertex(Vector3 var1, double var2, double var4);

    public float r() {
        return (float)((double)this.red * this.texture.red());
    }

    public float g() {
        return (float)((double)this.green * this.texture.green());
    }

    public float b() {
        return (float)((double)this.blue * this.texture.blue());
    }

    public float a() {
        return this.alpha;
    }

    @Override
    public void addProjectedVertex(Vector3 p, EnumFacing face) {
        double v;
        double u;
        double x = p.x - this.blockX;
        double y = p.y - this.blockY;
        double z = p.z - this.blockZ;
        switch (face) {
            case DOWN: {
                u = x;
                v = 1.0 - z;
                break;
            }
            case UP: {
                u = x;
                v = z;
                break;
            }
            case NORTH: {
                u = 1.0 - x;
                v = 1.0 - y;
                break;
            }
            case SOUTH: {
                u = x;
                v = 1.0 - y;
                break;
            }
            case WEST: {
                u = 1.0 - z;
                v = 1.0 - y;
                break;
            }
            case EAST: {
                u = z;
                v = 1.0 - y;
                break;
            }
            default: {
                u = 0.0;
                v = 0.0;
            }
        }
        this.addUVVertex(p, u, v);
    }
}

