/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.inventory.IInventoryBackpack;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.InventoryAdventure;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.CoordsUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public class InventoryBackpack
extends InventoryAdventure
implements IInventoryBackpack {
    private static final String TAG_IS_SLEEPING_BAG = "sleepingBag";
    private static final String TAG_SLEEPING_BAG_X = "sleepingBagX";
    private static final String TAG_SLEEPING_BAG_Y = "sleepingBagY";
    private static final String TAG_SLEEPING_BAG_Z = "sleepingBagZ";
    private BackpackTypes type = BackpackTypes.STANDARD;
    private final FluidTank leftTank = new FluidTank(4000);
    private final FluidTank rightTank = new FluidTank(4000);
    private NBTTagCompound extendedProperties = new NBTTagCompound();
    private boolean sleepingBagDeployed = false;
    private int sleepingBagX;
    private int sleepingBagY;
    private int sleepingBagZ;
    private boolean disableNVision = false;
    private boolean disableCycling = false;
    private int lastTime = 0;

    public InventoryBackpack(ItemStack backpack) {
        super(backpack, 54);
        this.detectAndConvertFromOldNBTFormat(this.containerStack.field_77990_d);
        this.func_70295_k_();
    }

    @Override
    public BackpackTypes getType() {
        return this.type;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public FluidTank[] getTanksArray() {
        return new FluidTank[]{this.leftTank, this.rightTank};
    }

    @Override
    public int[] getSlotsOnClosing() {
        return new int[]{50, 52, 51, 53};
    }

    @Override
    public NBTTagCompound getExtendedProperties() {
        return this.extendedProperties;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound == null) {
            return;
        }
        NBTTagCompound backpackTag = compound.func_74775_l("wearableData");
        this.type = BackpackTypes.getType(backpackTag.func_74771_c("type"));
        this.setInventoryFromTagList(backpackTag.func_150295_c("inventory", 10));
        this.leftTank.readFromNBT(backpackTag.func_74775_l("leftTank"));
        this.rightTank.readFromNBT(backpackTag.func_74775_l("rightTank"));
        this.extendedProperties = backpackTag.func_74775_l("extendedProperties");
        this.loadSleepingBag();
        this.disableCycling = backpackTag.func_74767_n("disableCycling");
        this.disableNVision = backpackTag.func_74767_n("disableNVision");
        this.lastTime = backpackTag.func_74762_e("lastTime");
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        NBTTagCompound backpackTag = new NBTTagCompound();
        backpackTag.func_74774_a("type", BackpackTypes.getMeta(this.type));
        backpackTag.func_74782_a("inventory", (NBTBase)this.getInventoryTagList());
        backpackTag.func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
        backpackTag.func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        backpackTag.func_74782_a("extendedProperties", (NBTBase)this.extendedProperties);
        this.saveSleepingBag();
        backpackTag.func_74757_a("disableCycling", this.disableCycling);
        backpackTag.func_74757_a("disableNVision", this.disableNVision);
        backpackTag.func_74768_a("lastTime", this.lastTime);
        compound.func_74782_a("wearableData", (NBTBase)backpackTag);
    }

    @Override
    public boolean updateTankSlots() {
        boolean changesMade = false;
        while (InventoryActions.transferContainerTank(this, this.getLeftTank(), 50)) {
            changesMade = true;
        }
        while (InventoryActions.transferContainerTank(this, this.getRightTank(), 52)) {
            changesMade = true;
        }
        return changesMade;
    }

    @Override
    public void dirtyTanks() {
        this.getWearableCompound().func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        this.getWearableCompound().func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void dirtyExtended() {
        this.getWearableCompound().func_82580_o("extendedProperties");
        this.getWearableCompound().func_74782_a("extendedProperties", (NBTBase)this.extendedProperties);
    }

    @Override
    public void dirtyTime() {
        this.getWearableCompound().func_74768_a("lastTime", this.lastTime);
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public boolean hasItem(Item item) {
        return InventoryActions.hasItem(this, item);
    }

    @Override
    public void consumeInventoryItem(Item item) {
        InventoryActions.consumeItemInInventory(this, item);
    }

    public boolean getDisableCycling() {
        return this.disableCycling;
    }

    public void setDisableCycling(boolean b) {
        this.disableCycling = b;
    }

    public boolean getDisableNVision() {
        return this.disableNVision;
    }

    public void setDisableNVision(boolean b) {
        this.disableNVision = b;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.sleepingBagDeployed;
    }

    private void loadSleepingBag() {
        this.sleepingBagDeployed = this.extendedProperties.func_74767_n(TAG_IS_SLEEPING_BAG);
        if (this.sleepingBagDeployed) {
            this.sleepingBagX = this.extendedProperties.func_74762_e(TAG_SLEEPING_BAG_X);
            this.sleepingBagY = this.extendedProperties.func_74762_e(TAG_SLEEPING_BAG_Y);
            this.sleepingBagZ = this.extendedProperties.func_74762_e(TAG_SLEEPING_BAG_Z);
        }
    }

    private void saveSleepingBag() {
        if (this.sleepingBagDeployed) {
            this.extendedProperties.func_74757_a(TAG_IS_SLEEPING_BAG, this.sleepingBagDeployed);
            this.extendedProperties.func_74768_a(TAG_SLEEPING_BAG_X, this.sleepingBagX);
            this.extendedProperties.func_74768_a(TAG_SLEEPING_BAG_Y, this.sleepingBagY);
            this.extendedProperties.func_74768_a(TAG_SLEEPING_BAG_Z, this.sleepingBagZ);
        } else {
            this.extendedProperties.func_82580_o(TAG_IS_SLEEPING_BAG);
            this.extendedProperties.func_82580_o(TAG_SLEEPING_BAG_X);
            this.extendedProperties.func_82580_o(TAG_SLEEPING_BAG_Y);
            this.extendedProperties.func_82580_o(TAG_SLEEPING_BAG_Z);
        }
    }

    public boolean deploySleepingBag(EntityPlayer player, World world, int meta, int cX, int cY, int cZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (this.sleepingBagDeployed) {
            this.removeSleepingBag(world);
        }
        this.sleepingBagDeployed = CoordsUtils.spawnSleepingBag(player, world, meta, cX, cY, cZ);
        if (this.sleepingBagDeployed) {
            this.sleepingBagX = cX;
            this.sleepingBagY = cY;
            this.sleepingBagZ = cZ;
            this.func_70296_d();
        }
        return this.sleepingBagDeployed;
    }

    public void removeSleepingBag(World world) {
        if (this.sleepingBagDeployed && world.func_147439_a(this.sleepingBagX, this.sleepingBagY, this.sleepingBagZ) == ModBlocks.blockSleepingBag) {
            world.func_147480_a(this.sleepingBagX, this.sleepingBagY, this.sleepingBagZ, false);
        }
        this.sleepingBagDeployed = false;
        this.func_70296_d();
    }

    private void detectAndConvertFromOldNBTFormat(NBTTagCompound compound) {
        if (compound == null || !compound.func_74764_b("backpackData")) {
            return;
        }
        NBTTagCompound oldBackpackTag = compound.func_74775_l("backpackData");
        NBTTagList oldItems = oldBackpackTag.func_150295_c("ABPItems", 10);
        this.leftTank.readFromNBT(oldBackpackTag.func_74775_l("leftTank"));
        this.rightTank.readFromNBT(oldBackpackTag.func_74775_l("rightTank"));
        this.type = BackpackTypes.getType(oldBackpackTag.func_74779_i("colorName"));
        NBTTagCompound newBackpackTag = new NBTTagCompound();
        newBackpackTag.func_74782_a("inventory", (NBTBase)oldItems);
        newBackpackTag.func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
        newBackpackTag.func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        newBackpackTag.func_74774_a("type", BackpackTypes.getMeta(this.type));
        compound.func_74782_a("wearableData", (NBTBase)newBackpackTag);
        compound.func_82580_o("backpackData");
    }
}

