/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.IFlowerColor;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.AlleleColor;
import binnie.botany.genetics.ColorMix;
import binnie.core.util.I18N;
import forestry.api.genetics.IAlleleInteger;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public enum EnumFlowerColor implements IFlowerColor
{
    AQUAMARINE("aquamarine", 8388564),
    BLACK("black", 0x282828),
    BLUE("blue", 255),
    BROWN("brown", 0xA52A2A),
    CADET_BLUE("cadetBlue", 6266528),
    CHOCOLATE("chocolate", 13789470),
    CORAL("coral", 16744272),
    CRIMSON("crimson", 14423100),
    CYAN("cyan", 65535),
    DARK_GOLDENROD("darkGoldenrod", 12092939),
    DARK_GRAY("darkGray", 0xA9A9A9),
    DARK_GREEN("darkGreen", 25600),
    DARK_KHAKI("darkKhaki", 12433259),
    DARK_OLIVE_GREEN("darkOliveGreen", 5597999),
    DARK_ORANGE("darkOrange", 16747520),
    DARK_SALMON("darkSalmon", 15308410),
    DARK_SEA_GREEN("darkSeaGreen", 9419915),
    DARK_SLATE_BLUE("darkSlateBlue", 4734347),
    DARK_SLATE_GRAY("darkSlateGray", 0x2F4F4F),
    DARK_TURQUOISE("darkTurquoise", 52945),
    DARK_VIOLET("darkViolet", 9699539),
    DEEP_PINK("deepPink", 16716947),
    DEEP_SKY_BLUE("deepSkyBlue", 49151),
    DIM_GRAY("dimGray", 0x696969),
    DODGER_BLUE("dodgerBlue", 2003199),
    GOLD("gold", 16766720),
    GOLDENROD("goldenrod", 14329120),
    GRAY("gray", 0x808080),
    GREEN("green", 32768),
    HOT_PINK("hotPink", 16738740),
    INDIAN_RED("indianRed", 0xCD5C5C),
    INDIGO("indigo", 4915330),
    KHAKI("khaki", 15787660),
    LAVENDER("lavender", 15132410),
    LEMON_CHIFFON("lemonChiffon", 16775885),
    LIGHT_GRAY("lightGray", 0xD3D3D3),
    LIGHT_SEA_GREEN("lightSeaGreen", 2142890),
    LIGHT_STEEL_BLUE("lightSteelBlue", 11584734),
    LIME("lime", 65280),
    LIME_GREEN("limeGreen", 3329330),
    MAGENTA("magenta", 0xFF00FF),
    MAROON("maroon", 0x800000),
    MEDIUM_AQUAMARINE("mediumAquamarine", 6737322),
    MEDIUM_ORCHID("mediumOrchid", 12211667),
    MEDIUM_PURPLE("mediumPurple", 9662683),
    MEDIUM_SEA_GREEN("mediumSeaGreen", 3978097),
    MEDIUM_VIOLET_RED("mediumVioletRed", 13047173),
    MISTY_ROSE("mistyRose", 16770273),
    NAVY("navy", 128),
    OLIVE("olive", 0x808000),
    OLIVE_DRAB("oliveDrab", 7048739),
    ORANGE("orange", 16753920),
    PALE_GREEN("paleGreen", 10025880),
    PALE_TURQUOISE("paleTurquoise", 0xAFEEEE),
    PALE_VIOLET_RED("paleVioletRed", 14381203),
    PERU("peru", 13468991),
    PINK("pink", 16761035),
    PLUM("plum", 0xDDA0DD),
    PURPLE("purple", 0x800080),
    RED("red", 0xFF0000),
    ROSY_BROWN("rosyBrown", 12357519),
    ROYAL_BLUE("royalBlue", 4286945),
    SALMON("salmon", 16416882),
    SANDY_BROWN("sandyBrown", 16032864),
    SEA_GREEN("seaGreen", 3050327),
    SIENNA("sienna", 10506797),
    SKY_BLUE("skyBlue", 8900331),
    SLATE_BLUE("slateBlue", 6970061),
    SLATE_GRAY("slateGray", 7372944),
    SPRING_GREEN("springGreen", 65407),
    STEEL_BLUE("steelBlue", 4620980),
    TAN("tan", 13808780),
    TEAL("teal", 32896),
    THISTLE("thistle", 14204888),
    TURQUOISE("turquoise", 4251856),
    VIOLET("violet", 0xEE82EE),
    WHEAT("wheat", 16113331),
    WHITE("white", 0xFFFFFF),
    YELLOW("yellow", 0xFFFF00),
    YELLOW_GREEN("yellowGreen", 10145074);

    private static final EnumFlowerColor[] ALL_VALUES;
    private int color;
    private int colorDis;
    private String name;
    private AlleleColor allele;

    private EnumFlowerColor(String name, int color) {
        this.name = name;
        this.color = color;
        this.allele = new AlleleColor(this, "botany.color" + StringUtils.capitalize((String)name), color);
        int r = color >> 16 & 0xFF;
        r = (int)(0.45 * (double)(r + 214));
        int g = (int)(0.45 * (double)(r + 174));
        int b = (int)(0.45 * (double)(r + 131));
        this.colorDis = (r << 16) + (g << 8) + b;
    }

    public static void addMix(EnumFlowerColor start1, EnumFlowerColor start2, EnumFlowerColor result, int chance) {
        BotanyCore.getFlowerRoot().registerColourMix(new ColorMix(start1, start2, result, chance));
    }

    /*
     * Opcode count of 14077 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void setupMutations() {
        EnumFlowerColor.addMix(BLUE, AQUAMARINE, STEEL_BLUE, 55);
        EnumFlowerColor.addMix(BLUE, BLACK, NAVY, 85);
        EnumFlowerColor.addMix(BROWN, AQUAMARINE, GRAY, 50);
        EnumFlowerColor.addMix(BROWN, BLACK, MAROON, 90);
        EnumFlowerColor.addMix(BROWN, BLUE, INDIGO, 85);
        EnumFlowerColor.addMix(CADET_BLUE, AQUAMARINE, MEDIUM_AQUAMARINE, 100);
        EnumFlowerColor.addMix(CADET_BLUE, BLACK, DARK_SLATE_GRAY, 75);
        EnumFlowerColor.addMix(CADET_BLUE, BLUE, SLATE_BLUE, 85);
        EnumFlowerColor.addMix(CHOCOLATE, AQUAMARINE, DARK_KHAKI, 65);
        EnumFlowerColor.addMix(CHOCOLATE, BLUE, DARK_SLATE_BLUE, 65);
        EnumFlowerColor.addMix(CHOCOLATE, BROWN, SIENNA, 100);
        EnumFlowerColor.addMix(CORAL, AQUAMARINE, DARK_KHAKI, 65);
        EnumFlowerColor.addMix(CORAL, BLACK, SIENNA, 65);
        EnumFlowerColor.addMix(CORAL, BLUE, DARK_VIOLET, 65);
        EnumFlowerColor.addMix(CORAL, BROWN, INDIAN_RED, 95);
        EnumFlowerColor.addMix(CORAL, CADET_BLUE, ROSY_BROWN, 80);
        EnumFlowerColor.addMix(CORAL, CHOCOLATE, PERU, 115);
        EnumFlowerColor.addMix(CRIMSON, AQUAMARINE, ROSY_BROWN, 45);
        EnumFlowerColor.addMix(CRIMSON, BLACK, MAROON, 80);
        EnumFlowerColor.addMix(CRIMSON, BLUE, INDIGO, 85);
        EnumFlowerColor.addMix(CRIMSON, BROWN, INDIAN_RED, 115);
        EnumFlowerColor.addMix(CRIMSON, CHOCOLATE, RED, 100);
        EnumFlowerColor.addMix(CRIMSON, CORAL, INDIAN_RED, 105);
        EnumFlowerColor.addMix(CYAN, AQUAMARINE, TURQUOISE, 115);
        EnumFlowerColor.addMix(CYAN, BLUE, DODGER_BLUE, 60);
        EnumFlowerColor.addMix(CYAN, BROWN, CADET_BLUE, 50);
        EnumFlowerColor.addMix(CYAN, CADET_BLUE, DARK_TURQUOISE, 100);
        EnumFlowerColor.addMix(CYAN, CHOCOLATE, MEDIUM_AQUAMARINE, 65);
        EnumFlowerColor.addMix(CYAN, CORAL, MEDIUM_AQUAMARINE, 65);
        EnumFlowerColor.addMix(CYAN, CRIMSON, SLATE_GRAY, 50);
        EnumFlowerColor.addMix(DARK_GOLDENROD, AQUAMARINE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(DARK_GOLDENROD, BLUE, DARK_SLATE_BLUE, 55);
        EnumFlowerColor.addMix(DARK_GOLDENROD, BROWN, SIENNA, 85);
        EnumFlowerColor.addMix(DARK_GOLDENROD, CADET_BLUE, OLIVE_DRAB, 90);
        EnumFlowerColor.addMix(DARK_GOLDENROD, CHOCOLATE, PERU, 110);
        EnumFlowerColor.addMix(DARK_GOLDENROD, CORAL, PERU, 100);
        EnumFlowerColor.addMix(DARK_GOLDENROD, CRIMSON, SIENNA, 85);
        EnumFlowerColor.addMix(DARK_GOLDENROD, CYAN, MEDIUM_SEA_GREEN, 75);
        EnumFlowerColor.addMix(DARK_GRAY, AQUAMARINE, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(DARK_GRAY, BLACK, DIM_GRAY, 70);
        EnumFlowerColor.addMix(DARK_GRAY, BLUE, SLATE_BLUE, 75);
        EnumFlowerColor.addMix(DARK_GRAY, BROWN, INDIAN_RED, 85);
        EnumFlowerColor.addMix(DARK_GRAY, CHOCOLATE, PERU, 95);
        EnumFlowerColor.addMix(DARK_GRAY, CORAL, DARK_SALMON, 100);
        EnumFlowerColor.addMix(DARK_GRAY, CRIMSON, INDIAN_RED, 90);
        EnumFlowerColor.addMix(DARK_GRAY, CYAN, DARK_TURQUOISE, 95);
        EnumFlowerColor.addMix(DARK_GRAY, DARK_GOLDENROD, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(DARK_GREEN, AQUAMARINE, MEDIUM_SEA_GREEN, 75);
        EnumFlowerColor.addMix(DARK_GREEN, BLUE, DARK_SLATE_BLUE, 65);
        EnumFlowerColor.addMix(DARK_GREEN, CADET_BLUE, SEA_GREEN, 90);
        EnumFlowerColor.addMix(DARK_GREEN, CHOCOLATE, DARK_OLIVE_GREEN, 70);
        EnumFlowerColor.addMix(DARK_GREEN, CORAL, OLIVE, 60);
        EnumFlowerColor.addMix(DARK_GREEN, CRIMSON, SIENNA, 55);
        EnumFlowerColor.addMix(DARK_GREEN, CYAN, MEDIUM_SEA_GREEN, 70);
        EnumFlowerColor.addMix(DARK_GREEN, DARK_GOLDENROD, DARK_OLIVE_GREEN, 85);
        EnumFlowerColor.addMix(DARK_GREEN, DARK_GRAY, SEA_GREEN, 85);
        EnumFlowerColor.addMix(DARK_KHAKI, AQUAMARINE, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(DARK_KHAKI, BLACK, DARK_OLIVE_GREEN, 60);
        EnumFlowerColor.addMix(DARK_KHAKI, BROWN, CHOCOLATE, 75);
        EnumFlowerColor.addMix(DARK_KHAKI, CADET_BLUE, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(DARK_KHAKI, CHOCOLATE, PERU, 95);
        EnumFlowerColor.addMix(DARK_KHAKI, CORAL, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(DARK_KHAKI, CRIMSON, INDIAN_RED, 75);
        EnumFlowerColor.addMix(DARK_KHAKI, CYAN, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(DARK_KHAKI, DARK_GOLDENROD, GOLDENROD, 110);
        EnumFlowerColor.addMix(DARK_KHAKI, DARK_GRAY, TAN, 105);
        EnumFlowerColor.addMix(DARK_KHAKI, DARK_GREEN, OLIVE_DRAB, 85);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, AQUAMARINE, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, BLUE, DARK_SLATE_BLUE, 50);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, BROWN, SIENNA, 80);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, CADET_BLUE, SEA_GREEN, 95);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, CHOCOLATE, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, CORAL, PERU, 75);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, CRIMSON, BROWN, 70);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, CYAN, LIGHT_SEA_GREEN, 75);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, DARK_GOLDENROD, OLIVE, 100);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, DARK_GREEN, GREEN, 115);
        EnumFlowerColor.addMix(DARK_OLIVE_GREEN, DARK_KHAKI, OLIVE_DRAB, 95);
        EnumFlowerColor.addMix(DARK_ORANGE, AQUAMARINE, DARK_KHAKI, 70);
        EnumFlowerColor.addMix(DARK_ORANGE, BLACK, SIENNA, 60);
        EnumFlowerColor.addMix(DARK_ORANGE, BLUE, VIOLET, 55);
        EnumFlowerColor.addMix(DARK_ORANGE, BROWN, CHOCOLATE, 85);
        EnumFlowerColor.addMix(DARK_ORANGE, CADET_BLUE, DARK_GOLDENROD, 80);
        EnumFlowerColor.addMix(DARK_ORANGE, CHOCOLATE, PERU, 115);
        EnumFlowerColor.addMix(DARK_ORANGE, CORAL, SANDY_BROWN, 115);
        EnumFlowerColor.addMix(DARK_ORANGE, CRIMSON, RED, 90);
        EnumFlowerColor.addMix(DARK_ORANGE, CYAN, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(DARK_ORANGE, DARK_GOLDENROD, PERU, 110);
        EnumFlowerColor.addMix(DARK_ORANGE, DARK_GRAY, PERU, 95);
        EnumFlowerColor.addMix(DARK_ORANGE, DARK_GREEN, OLIVE, 70);
        EnumFlowerColor.addMix(DARK_ORANGE, DARK_KHAKI, GOLDENROD, 100);
        EnumFlowerColor.addMix(DARK_ORANGE, DARK_OLIVE_GREEN, DARK_GOLDENROD, 80);
        EnumFlowerColor.addMix(DARK_SALMON, AQUAMARINE, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(DARK_SALMON, BLACK, SIENNA, 65);
        EnumFlowerColor.addMix(DARK_SALMON, BLUE, SLATE_BLUE, 70);
        EnumFlowerColor.addMix(DARK_SALMON, BROWN, INDIAN_RED, 95);
        EnumFlowerColor.addMix(DARK_SALMON, CADET_BLUE, DARK_GRAY, 85);
        EnumFlowerColor.addMix(DARK_SALMON, CHOCOLATE, CORAL, 110);
        EnumFlowerColor.addMix(DARK_SALMON, CORAL, SALMON, 120);
        EnumFlowerColor.addMix(DARK_SALMON, CRIMSON, INDIAN_RED, 100);
        EnumFlowerColor.addMix(DARK_SALMON, CYAN, MEDIUM_AQUAMARINE, 75);
        EnumFlowerColor.addMix(DARK_SALMON, DARK_GOLDENROD, PERU, 100);
        EnumFlowerColor.addMix(DARK_SALMON, DARK_GRAY, ROSY_BROWN, 105);
        EnumFlowerColor.addMix(DARK_SALMON, DARK_GREEN, OLIVE, 65);
        EnumFlowerColor.addMix(DARK_SALMON, DARK_KHAKI, TAN, 95);
        EnumFlowerColor.addMix(DARK_SALMON, DARK_OLIVE_GREEN, PERU, 80);
        EnumFlowerColor.addMix(DARK_SALMON, DARK_ORANGE, SANDY_BROWN, 110);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, AQUAMARINE, MEDIUM_AQUAMARINE, 110);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, BLACK, DARK_OLIVE_GREEN, 60);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, BLUE, ROYAL_BLUE, 60);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, BROWN, SIENNA, 65);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, CADET_BLUE, MEDIUM_AQUAMARINE, 105);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, CHOCOLATE, DARK_GOLDENROD, 80);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, CORAL, TAN, 80);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, CRIMSON, INDIAN_RED, 60);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, CYAN, TURQUOISE, 100);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, DARK_GOLDENROD, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, DARK_GREEN, SEA_GREEN, 90);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, DARK_KHAKI, YELLOW_GREEN, 110);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, DARK_OLIVE_GREEN, OLIVE_DRAB, 100);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, DARK_ORANGE, GOLDENROD, 85);
        EnumFlowerColor.addMix(DARK_SEA_GREEN, DARK_SALMON, TAN, 85);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, AQUAMARINE, CADET_BLUE, 60);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, BLUE, INDIGO, 110);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, BROWN, PURPLE, 90);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, CADET_BLUE, ROYAL_BLUE, 85);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, CHOCOLATE, BROWN, 75);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, CORAL, INDIAN_RED, 70);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, CRIMSON, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, CYAN, DEEP_SKY_BLUE, 60);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, DARK_GOLDENROD, SIENNA, 65);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, DARK_GREEN, DARK_SLATE_GRAY, 75);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, DARK_KHAKI, GRAY, 55);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, DARK_OLIVE_GREEN, DIM_GRAY, 70);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, DARK_ORANGE, SIENNA, 60);
        EnumFlowerColor.addMix(DARK_SLATE_BLUE, DARK_SEA_GREEN, SLATE_GRAY, 65);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, AQUAMARINE, LIGHT_SEA_GREEN, 70);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, BLUE, NAVY, 95);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, CADET_BLUE, TEAL, 95);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, CHOCOLATE, SIENNA, 80);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, CORAL, SIENNA, 75);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, CRIMSON, BROWN, 80);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, CYAN, LIGHT_SEA_GREEN, 70);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, DARK_GOLDENROD, DARK_OLIVE_GREEN, 85);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, DARK_GRAY, GRAY, 85);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, DARK_GREEN, DARK_OLIVE_GREEN, 100);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, DARK_KHAKI, DARK_OLIVE_GREEN, 75);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, DARK_ORANGE, DARK_GOLDENROD, 70);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, DARK_SALMON, GRAY, 75);
        EnumFlowerColor.addMix(DARK_SLATE_GRAY, DARK_SEA_GREEN, SEA_GREEN, 80);
        EnumFlowerColor.addMix(DARK_TURQUOISE, AQUAMARINE, TURQUOISE, 110);
        EnumFlowerColor.addMix(DARK_TURQUOISE, BLACK, TEAL, 55);
        EnumFlowerColor.addMix(DARK_TURQUOISE, BLUE, ROYAL_BLUE, 65);
        EnumFlowerColor.addMix(DARK_TURQUOISE, BROWN, TEAL, 60);
        EnumFlowerColor.addMix(DARK_TURQUOISE, CADET_BLUE, LIGHT_SEA_GREEN, 115);
        EnumFlowerColor.addMix(DARK_TURQUOISE, CHOCOLATE, SEA_GREEN, 70);
        EnumFlowerColor.addMix(DARK_TURQUOISE, CORAL, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(DARK_TURQUOISE, CRIMSON, SLATE_GRAY, 55);
        EnumFlowerColor.addMix(DARK_TURQUOISE, CYAN, TURQUOISE, 115);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_GOLDENROD, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_GRAY, LIGHT_SEA_GREEN, 100);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_GREEN, SEA_GREEN, 80);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_KHAKI, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_OLIVE_GREEN, SEA_GREEN, 85);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_ORANGE, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_SALMON, LIGHT_SEA_GREEN, 80);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_SEA_GREEN, MEDIUM_AQUAMARINE, 105);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_SLATE_BLUE, STEEL_BLUE, 70);
        EnumFlowerColor.addMix(DARK_TURQUOISE, DARK_SLATE_GRAY, TEAL, 80);
        EnumFlowerColor.addMix(DARK_VIOLET, AQUAMARINE, MEDIUM_PURPLE, 60);
        EnumFlowerColor.addMix(DARK_VIOLET, BLACK, INDIGO, 85);
        EnumFlowerColor.addMix(DARK_VIOLET, BROWN, PURPLE, 90);
        EnumFlowerColor.addMix(DARK_VIOLET, CADET_BLUE, SLATE_BLUE, 90);
        EnumFlowerColor.addMix(DARK_VIOLET, CHOCOLATE, MEDIUM_VIOLET_RED, 70);
        EnumFlowerColor.addMix(DARK_VIOLET, CORAL, MEDIUM_VIOLET_RED, 75);
        EnumFlowerColor.addMix(DARK_VIOLET, CRIMSON, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(DARK_VIOLET, CYAN, STEEL_BLUE, 60);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_GOLDENROD, MEDIUM_VIOLET_RED, 55);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_GRAY, MEDIUM_ORCHID, 85);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_KHAKI, MEDIUM_ORCHID, 50);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_OLIVE_GREEN, PURPLE, 55);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_ORANGE, INDIAN_RED, 60);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_SALMON, MEDIUM_ORCHID, 75);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_SEA_GREEN, MEDIUM_ORCHID, 70);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_SLATE_BLUE, INDIGO, 110);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_SLATE_GRAY, INDIGO, 100);
        EnumFlowerColor.addMix(DARK_VIOLET, DARK_TURQUOISE, ROYAL_BLUE, 70);
        EnumFlowerColor.addMix(DEEP_PINK, BLUE, DARK_VIOLET, 90);
        EnumFlowerColor.addMix(DEEP_PINK, BROWN, CRIMSON, 100);
        EnumFlowerColor.addMix(DEEP_PINK, CADET_BLUE, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(DEEP_PINK, CHOCOLATE, INDIAN_RED, 85);
        EnumFlowerColor.addMix(DEEP_PINK, CORAL, INDIAN_RED, 95);
        EnumFlowerColor.addMix(DEEP_PINK, CRIMSON, INDIAN_RED, 105);
        EnumFlowerColor.addMix(DEEP_PINK, CYAN, MEDIUM_PURPLE, 45);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_GOLDENROD, INDIAN_RED, 70);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_GRAY, PALE_VIOLET_RED, 95);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_KHAKI, PALE_VIOLET_RED, 65);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_OLIVE_GREEN, MEDIUM_VIOLET_RED, 60);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_ORANGE, SALMON, 80);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_SALMON, PALE_VIOLET_RED, 95);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_SEA_GREEN, PALE_VIOLET_RED, 55);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_SLATE_BLUE, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_SLATE_GRAY, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_TURQUOISE, MEDIUM_PURPLE, 55);
        EnumFlowerColor.addMix(DEEP_PINK, DARK_VIOLET, MEDIUM_VIOLET_RED, 100);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, AQUAMARINE, DARK_TURQUOISE, 90);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, BLUE, ROYAL_BLUE, 75);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, BROWN, STEEL_BLUE, 60);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, CADET_BLUE, SKY_BLUE, 105);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, CHOCOLATE, CADET_BLUE, 70);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, CORAL, CADET_BLUE, 70);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, CRIMSON, SLATE_BLUE, 60);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, CYAN, SKY_BLUE, 105);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_GOLDENROD, MEDIUM_SEA_GREEN, 70);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_GRAY, SKY_BLUE, 105);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_GREEN, TEAL, 65);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_KHAKI, LIGHT_SEA_GREEN, 75);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_OLIVE_GREEN, CADET_BLUE, 70);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_ORANGE, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_SALMON, CADET_BLUE, 80);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_SEA_GREEN, DARK_TURQUOISE, 85);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_SLATE_BLUE, STEEL_BLUE, 75);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_SLATE_GRAY, STEEL_BLUE, 80);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_TURQUOISE, SKY_BLUE, 110);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DARK_VIOLET, ROYAL_BLUE, 70);
        EnumFlowerColor.addMix(DEEP_SKY_BLUE, DEEP_PINK, MEDIUM_PURPLE, 55);
        EnumFlowerColor.addMix(DIM_GRAY, AQUAMARINE, MEDIUM_AQUAMARINE, 80);
        EnumFlowerColor.addMix(DIM_GRAY, BLUE, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(DIM_GRAY, CADET_BLUE, SLATE_GRAY, 100);
        EnumFlowerColor.addMix(DIM_GRAY, CHOCOLATE, SIENNA, 95);
        EnumFlowerColor.addMix(DIM_GRAY, CORAL, INDIAN_RED, 90);
        EnumFlowerColor.addMix(DIM_GRAY, CRIMSON, BROWN, 100);
        EnumFlowerColor.addMix(DIM_GRAY, CYAN, LIGHT_SEA_GREEN, 80);
        EnumFlowerColor.addMix(DIM_GRAY, DARK_GOLDENROD, OLIVE, 95);
        EnumFlowerColor.addMix(DIM_GRAY, DARK_GRAY, GRAY, 105);
        EnumFlowerColor.addMix(DIM_GRAY, DARK_GREEN, DARK_OLIVE_GREEN, 100);
        EnumFlowerColor.addMix(DIM_GRAY, DARK_ORANGE, PERU, 90);
        EnumFlowerColor.addMix(DIM_GRAY, DARK_SALMON, ROSY_BROWN, 95);
        EnumFlowerColor.addMix(DIM_GRAY, DARK_TURQUOISE, CADET_BLUE, 90);
        EnumFlowerColor.addMix(DIM_GRAY, DARK_VIOLET, PURPLE, 95);
        EnumFlowerColor.addMix(DIM_GRAY, DEEP_PINK, MEDIUM_VIOLET_RED, 95);
        EnumFlowerColor.addMix(DIM_GRAY, DEEP_SKY_BLUE, STEEL_BLUE, 90);
        EnumFlowerColor.addMix(DODGER_BLUE, AQUAMARINE, SKY_BLUE, 80);
        EnumFlowerColor.addMix(DODGER_BLUE, BLACK, DARK_SLATE_BLUE, 75);
        EnumFlowerColor.addMix(DODGER_BLUE, BLUE, SLATE_BLUE, 90);
        EnumFlowerColor.addMix(DODGER_BLUE, BROWN, SLATE_BLUE, 75);
        EnumFlowerColor.addMix(DODGER_BLUE, CADET_BLUE, STEEL_BLUE, 100);
        EnumFlowerColor.addMix(DODGER_BLUE, CHOCOLATE, SLATE_GRAY, 75);
        EnumFlowerColor.addMix(DODGER_BLUE, CRIMSON, SLATE_BLUE, 75);
        EnumFlowerColor.addMix(DODGER_BLUE, CYAN, DEEP_SKY_BLUE, 85);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_GOLDENROD, CADET_BLUE, 70);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_GRAY, STEEL_BLUE, 100);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_GREEN, TEAL, 65);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_KHAKI, CADET_BLUE, 65);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_OLIVE_GREEN, STEEL_BLUE, 70);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_ORANGE, GRAY, 70);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_SALMON, SLATE_GRAY, 80);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_SEA_GREEN, DEEP_SKY_BLUE, 80);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_SLATE_BLUE, ROYAL_BLUE, 90);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_SLATE_GRAY, STEEL_BLUE, 90);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_TURQUOISE, DEEP_SKY_BLUE, 95);
        EnumFlowerColor.addMix(DODGER_BLUE, DARK_VIOLET, SLATE_BLUE, 90);
        EnumFlowerColor.addMix(DODGER_BLUE, DEEP_PINK, SLATE_BLUE, 80);
        EnumFlowerColor.addMix(DODGER_BLUE, DIM_GRAY, STEEL_BLUE, 95);
        EnumFlowerColor.addMix(GOLD, AQUAMARINE, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(GOLD, BROWN, PERU, 65);
        EnumFlowerColor.addMix(GOLD, CADET_BLUE, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(GOLD, CHOCOLATE, ORANGE, 90);
        EnumFlowerColor.addMix(GOLD, CORAL, ORANGE, 90);
        EnumFlowerColor.addMix(GOLD, CRIMSON, CHOCOLATE, 65);
        EnumFlowerColor.addMix(GOLD, CYAN, PALE_GREEN, 80);
        EnumFlowerColor.addMix(GOLD, DARK_GOLDENROD, GOLDENROD, 105);
        EnumFlowerColor.addMix(GOLD, DARK_GRAY, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(GOLD, DARK_GREEN, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(GOLD, DARK_KHAKI, KHAKI, 110);
        EnumFlowerColor.addMix(GOLD, DARK_OLIVE_GREEN, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(GOLD, DARK_ORANGE, ORANGE, 100);
        EnumFlowerColor.addMix(GOLD, DARK_SALMON, GOLDENROD, 90);
        EnumFlowerColor.addMix(GOLD, DARK_SEA_GREEN, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(GOLD, DARK_SLATE_GRAY, OLIVE, 65);
        EnumFlowerColor.addMix(GOLD, DARK_TURQUOISE, LIME_GREEN, 80);
        EnumFlowerColor.addMix(GOLD, DEEP_PINK, CORAL, 55);
        EnumFlowerColor.addMix(GOLD, DEEP_SKY_BLUE, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(GOLD, DIM_GRAY, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(GOLD, DODGER_BLUE, DARK_SEA_GREEN, 60);
        EnumFlowerColor.addMix(GOLDENROD, AQUAMARINE, YELLOW_GREEN, 85);
        EnumFlowerColor.addMix(GOLDENROD, BLUE, DARK_SLATE_BLUE, 45);
        EnumFlowerColor.addMix(GOLDENROD, BROWN, CHOCOLATE, 80);
        EnumFlowerColor.addMix(GOLDENROD, CADET_BLUE, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(GOLDENROD, CHOCOLATE, PERU, 105);
        EnumFlowerColor.addMix(GOLDENROD, CORAL, DARK_ORANGE, 100);
        EnumFlowerColor.addMix(GOLDENROD, CRIMSON, CHOCOLATE, 80);
        EnumFlowerColor.addMix(GOLDENROD, CYAN, MEDIUM_AQUAMARINE, 80);
        EnumFlowerColor.addMix(GOLDENROD, DARK_GOLDENROD, ORANGE, 115);
        EnumFlowerColor.addMix(GOLDENROD, DARK_GRAY, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(GOLDENROD, DARK_GREEN, OLIVE_DRAB, 80);
        EnumFlowerColor.addMix(GOLDENROD, DARK_KHAKI, DARK_GOLDENROD, 110);
        EnumFlowerColor.addMix(GOLDENROD, DARK_OLIVE_GREEN, OLIVE, 90);
        EnumFlowerColor.addMix(GOLDENROD, DARK_ORANGE, ORANGE, 110);
        EnumFlowerColor.addMix(GOLDENROD, DARK_SALMON, SANDY_BROWN, 100);
        EnumFlowerColor.addMix(GOLDENROD, DARK_SEA_GREEN, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(GOLDENROD, DARK_SLATE_GRAY, OLIVE, 75);
        EnumFlowerColor.addMix(GOLDENROD, DARK_TURQUOISE, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(GOLDENROD, DARK_VIOLET, MEDIUM_VIOLET_RED, 50);
        EnumFlowerColor.addMix(GOLDENROD, DEEP_PINK, INDIAN_RED, 65);
        EnumFlowerColor.addMix(GOLDENROD, DEEP_SKY_BLUE, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(GOLDENROD, DIM_GRAY, DARK_GOLDENROD, 90);
        EnumFlowerColor.addMix(GOLDENROD, DODGER_BLUE, CADET_BLUE, 65);
        EnumFlowerColor.addMix(GOLDENROD, GOLD, ORANGE, 115);
        EnumFlowerColor.addMix(GRAY, AQUAMARINE, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(GRAY, BLUE, DARK_SLATE_BLUE, 85);
        EnumFlowerColor.addMix(GRAY, CADET_BLUE, SLATE_GRAY, 105);
        EnumFlowerColor.addMix(GRAY, CHOCOLATE, PERU, 100);
        EnumFlowerColor.addMix(GRAY, CORAL, DARK_SALMON, 95);
        EnumFlowerColor.addMix(GRAY, CRIMSON, INDIAN_RED, 95);
        EnumFlowerColor.addMix(GRAY, CYAN, DARK_TURQUOISE, 90);
        EnumFlowerColor.addMix(GRAY, DARK_GOLDENROD, OLIVE, 100);
        EnumFlowerColor.addMix(GRAY, DARK_GRAY, SLATE_GRAY, 115);
        EnumFlowerColor.addMix(GRAY, DARK_GREEN, DARK_OLIVE_GREEN, 95);
        EnumFlowerColor.addMix(GRAY, DARK_ORANGE, PERU, 95);
        EnumFlowerColor.addMix(GRAY, DARK_SALMON, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(GRAY, DARK_SLATE_GRAY, DIM_GRAY, 100);
        EnumFlowerColor.addMix(GRAY, DARK_TURQUOISE, CADET_BLUE, 95);
        EnumFlowerColor.addMix(GRAY, DARK_VIOLET, PURPLE, 90);
        EnumFlowerColor.addMix(GRAY, DEEP_PINK, MEDIUM_VIOLET_RED, 95);
        EnumFlowerColor.addMix(GRAY, DEEP_SKY_BLUE, CADET_BLUE, 100);
        EnumFlowerColor.addMix(GRAY, DIM_GRAY, SLATE_GRAY, 120);
        EnumFlowerColor.addMix(GRAY, DODGER_BLUE, STEEL_BLUE, 100);
        EnumFlowerColor.addMix(GRAY, GOLD, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(GRAY, GOLDENROD, DARK_GOLDENROD, 95);
        EnumFlowerColor.addMix(GREEN, AQUAMARINE, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(GREEN, BLACK, DARK_GREEN, 85);
        EnumFlowerColor.addMix(GREEN, BLUE, DARK_SLATE_BLUE, 60);
        EnumFlowerColor.addMix(GREEN, BROWN, DARK_OLIVE_GREEN, 60);
        EnumFlowerColor.addMix(GREEN, CADET_BLUE, SEA_GREEN, 95);
        EnumFlowerColor.addMix(GREEN, CHOCOLATE, OLIVE, 70);
        EnumFlowerColor.addMix(GREEN, CORAL, OLIVE, 65);
        EnumFlowerColor.addMix(GREEN, CYAN, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(GREEN, DARK_GOLDENROD, OLIVE_DRAB, 90);
        EnumFlowerColor.addMix(GREEN, DARK_GRAY, SEA_GREEN, 90);
        EnumFlowerColor.addMix(GREEN, DARK_GREEN, DARK_OLIVE_GREEN, 120);
        EnumFlowerColor.addMix(GREEN, DARK_KHAKI, OLIVE_DRAB, 95);
        EnumFlowerColor.addMix(GREEN, DARK_OLIVE_GREEN, DARK_GREEN, 115);
        EnumFlowerColor.addMix(GREEN, DARK_ORANGE, OLIVE, 70);
        EnumFlowerColor.addMix(GREEN, DARK_SALMON, OLIVE_DRAB, 70);
        EnumFlowerColor.addMix(GREEN, DARK_SEA_GREEN, MEDIUM_SEA_GREEN, 100);
        EnumFlowerColor.addMix(GREEN, DARK_SLATE_BLUE, DARK_SLATE_GRAY, 70);
        EnumFlowerColor.addMix(GREEN, DARK_SLATE_GRAY, DARK_GREEN, 95);
        EnumFlowerColor.addMix(GREEN, DARK_TURQUOISE, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(GREEN, DEEP_SKY_BLUE, SEA_GREEN, 70);
        EnumFlowerColor.addMix(GREEN, DIM_GRAY, DARK_GREEN, 100);
        EnumFlowerColor.addMix(GREEN, DODGER_BLUE, TEAL, 65);
        EnumFlowerColor.addMix(GREEN, GOLD, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(GREEN, GOLDENROD, OLIVE_DRAB, 85);
        EnumFlowerColor.addMix(GREEN, GRAY, SEA_GREEN, 100);
        EnumFlowerColor.addMix(HOT_PINK, AQUAMARINE, THISTLE, 50);
        EnumFlowerColor.addMix(HOT_PINK, BLUE, DARK_VIOLET, 80);
        EnumFlowerColor.addMix(HOT_PINK, BROWN, INDIAN_RED, 90);
        EnumFlowerColor.addMix(HOT_PINK, CADET_BLUE, PLUM, 85);
        EnumFlowerColor.addMix(HOT_PINK, CHOCOLATE, INDIAN_RED, 85);
        EnumFlowerColor.addMix(HOT_PINK, CORAL, SALMON, 95);
        EnumFlowerColor.addMix(HOT_PINK, CRIMSON, DEEP_PINK, 100);
        EnumFlowerColor.addMix(HOT_PINK, CYAN, SKY_BLUE, 55);
        EnumFlowerColor.addMix(HOT_PINK, DARK_GOLDENROD, SALMON, 70);
        EnumFlowerColor.addMix(HOT_PINK, DARK_GRAY, PALE_VIOLET_RED, 100);
        EnumFlowerColor.addMix(HOT_PINK, DARK_KHAKI, ROSY_BROWN, 70);
        EnumFlowerColor.addMix(HOT_PINK, DARK_OLIVE_GREEN, INDIAN_RED, 60);
        EnumFlowerColor.addMix(HOT_PINK, DARK_ORANGE, CORAL, 80);
        EnumFlowerColor.addMix(HOT_PINK, DARK_SALMON, PALE_VIOLET_RED, 100);
        EnumFlowerColor.addMix(HOT_PINK, DARK_SEA_GREEN, ROSY_BROWN, 60);
        EnumFlowerColor.addMix(HOT_PINK, DARK_SLATE_BLUE, MEDIUM_ORCHID, 85);
        EnumFlowerColor.addMix(HOT_PINK, DARK_TURQUOISE, DODGER_BLUE, 60);
        EnumFlowerColor.addMix(HOT_PINK, DARK_VIOLET, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(HOT_PINK, DEEP_PINK, PALE_VIOLET_RED, 115);
        EnumFlowerColor.addMix(HOT_PINK, DEEP_SKY_BLUE, DODGER_BLUE, 65);
        EnumFlowerColor.addMix(HOT_PINK, DIM_GRAY, PALE_VIOLET_RED, 95);
        EnumFlowerColor.addMix(HOT_PINK, DODGER_BLUE, MEDIUM_PURPLE, 85);
        EnumFlowerColor.addMix(HOT_PINK, GOLD, SANDY_BROWN, 60);
        EnumFlowerColor.addMix(HOT_PINK, GOLDENROD, DARK_SALMON, 70);
        EnumFlowerColor.addMix(HOT_PINK, GRAY, PALE_VIOLET_RED, 100);
        EnumFlowerColor.addMix(INDIAN_RED, AQUAMARINE, DARK_GRAY, 55);
        EnumFlowerColor.addMix(INDIAN_RED, BLACK, MAROON, 80);
        EnumFlowerColor.addMix(INDIAN_RED, BLUE, DARK_VIOLET, 80);
        EnumFlowerColor.addMix(INDIAN_RED, BROWN, CRIMSON, 110);
        EnumFlowerColor.addMix(INDIAN_RED, CADET_BLUE, ROSY_BROWN, 80);
        EnumFlowerColor.addMix(INDIAN_RED, CHOCOLATE, RED, 105);
        EnumFlowerColor.addMix(INDIAN_RED, CORAL, SALMON, 110);
        EnumFlowerColor.addMix(INDIAN_RED, CRIMSON, BROWN, 115);
        EnumFlowerColor.addMix(INDIAN_RED, CYAN, CADET_BLUE, 60);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_GOLDENROD, CHOCOLATE, 90);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_GRAY, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_GREEN, DARK_OLIVE_GREEN, 60);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_KHAKI, PERU, 85);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_OLIVE_GREEN, SIENNA, 80);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_ORANGE, CHOCOLATE, 95);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_SALMON, SALMON, 110);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_SEA_GREEN, PERU, 75);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_SLATE_BLUE, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_TURQUOISE, CADET_BLUE, 65);
        EnumFlowerColor.addMix(INDIAN_RED, DARK_VIOLET, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(INDIAN_RED, DEEP_PINK, PALE_VIOLET_RED, 110);
        EnumFlowerColor.addMix(INDIAN_RED, DEEP_SKY_BLUE, STEEL_BLUE, 70);
        EnumFlowerColor.addMix(INDIAN_RED, DODGER_BLUE, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(INDIAN_RED, GOLD, ORANGE, 75);
        EnumFlowerColor.addMix(INDIAN_RED, GOLDENROD, PERU, 85);
        EnumFlowerColor.addMix(INDIAN_RED, GRAY, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(INDIAN_RED, GREEN, DARK_OLIVE_GREEN, 60);
        EnumFlowerColor.addMix(INDIAN_RED, HOT_PINK, PALE_VIOLET_RED, 105);
        EnumFlowerColor.addMix(INDIGO, BLACK, NAVY, 95);
        EnumFlowerColor.addMix(INDIGO, BLUE, NAVY, 110);
        EnumFlowerColor.addMix(INDIGO, BROWN, PURPLE, 90);
        EnumFlowerColor.addMix(INDIGO, CADET_BLUE, DARK_SLATE_BLUE, 80);
        EnumFlowerColor.addMix(INDIGO, CORAL, MEDIUM_VIOLET_RED, 65);
        EnumFlowerColor.addMix(INDIGO, CRIMSON, PURPLE, 85);
        EnumFlowerColor.addMix(INDIGO, DARK_GOLDENROD, BROWN, 55);
        EnumFlowerColor.addMix(INDIGO, DARK_GRAY, SLATE_BLUE, 70);
        EnumFlowerColor.addMix(INDIGO, DARK_ORANGE, BROWN, 55);
        EnumFlowerColor.addMix(INDIGO, DARK_SALMON, MEDIUM_VIOLET_RED, 65);
        EnumFlowerColor.addMix(INDIGO, DARK_SLATE_BLUE, NAVY, 115);
        EnumFlowerColor.addMix(INDIGO, DARK_SLATE_GRAY, DARK_SLATE_BLUE, 100);
        EnumFlowerColor.addMix(INDIGO, DARK_TURQUOISE, ROYAL_BLUE, 55);
        EnumFlowerColor.addMix(INDIGO, DARK_VIOLET, PURPLE, 110);
        EnumFlowerColor.addMix(INDIGO, DEEP_PINK, PURPLE, 90);
        EnumFlowerColor.addMix(INDIGO, DEEP_SKY_BLUE, ROYAL_BLUE, 60);
        EnumFlowerColor.addMix(INDIGO, DIM_GRAY, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(INDIGO, DODGER_BLUE, SLATE_BLUE, 80);
        EnumFlowerColor.addMix(INDIGO, GOLDENROD, BROWN, 45);
        EnumFlowerColor.addMix(INDIGO, GRAY, DARK_SLATE_BLUE, 85);
        EnumFlowerColor.addMix(INDIGO, GREEN, DARK_SLATE_GRAY, 65);
        EnumFlowerColor.addMix(INDIGO, HOT_PINK, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(INDIGO, INDIAN_RED, PURPLE, 85);
        EnumFlowerColor.addMix(KHAKI, AQUAMARINE, PALE_GREEN, 100);
        EnumFlowerColor.addMix(KHAKI, BROWN, PERU, 65);
        EnumFlowerColor.addMix(KHAKI, CADET_BLUE, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(KHAKI, CHOCOLATE, GOLDENROD, 85);
        EnumFlowerColor.addMix(KHAKI, CORAL, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(KHAKI, CRIMSON, SALMON, 65);
        EnumFlowerColor.addMix(KHAKI, CYAN, AQUAMARINE, 90);
        EnumFlowerColor.addMix(KHAKI, DARK_GOLDENROD, GOLDENROD, 100);
        EnumFlowerColor.addMix(KHAKI, DARK_GRAY, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(KHAKI, DARK_GREEN, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(KHAKI, DARK_KHAKI, WHEAT, 115);
        EnumFlowerColor.addMix(KHAKI, DARK_OLIVE_GREEN, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(KHAKI, DARK_ORANGE, GOLDENROD, 95);
        EnumFlowerColor.addMix(KHAKI, DARK_SALMON, TAN, 95);
        EnumFlowerColor.addMix(KHAKI, DARK_SEA_GREEN, DARK_KHAKI, 105);
        EnumFlowerColor.addMix(KHAKI, DARK_SLATE_BLUE, GRAY, 50);
        EnumFlowerColor.addMix(KHAKI, DARK_SLATE_GRAY, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(KHAKI, DARK_TURQUOISE, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(KHAKI, DEEP_PINK, PALE_VIOLET_RED, 60);
        EnumFlowerColor.addMix(KHAKI, DEEP_SKY_BLUE, TURQUOISE, 75);
        EnumFlowerColor.addMix(KHAKI, DIM_GRAY, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(KHAKI, DODGER_BLUE, SKY_BLUE, 60);
        EnumFlowerColor.addMix(KHAKI, GOLD, YELLOW, 115);
        EnumFlowerColor.addMix(KHAKI, GOLDENROD, GOLD, 110);
        EnumFlowerColor.addMix(KHAKI, GRAY, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(KHAKI, GREEN, YELLOW_GREEN, 85);
        EnumFlowerColor.addMix(KHAKI, HOT_PINK, DARK_SALMON, 65);
        EnumFlowerColor.addMix(KHAKI, INDIAN_RED, SANDY_BROWN, 75);
        EnumFlowerColor.addMix(LAVENDER, AQUAMARINE, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(LAVENDER, BLUE, MEDIUM_PURPLE, 65);
        EnumFlowerColor.addMix(LAVENDER, BROWN, ROSY_BROWN, 70);
        EnumFlowerColor.addMix(LAVENDER, CADET_BLUE, SKY_BLUE, 95);
        EnumFlowerColor.addMix(LAVENDER, CHOCOLATE, DARK_SALMON, 85);
        EnumFlowerColor.addMix(LAVENDER, CORAL, DARK_SALMON, 90);
        EnumFlowerColor.addMix(LAVENDER, CRIMSON, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(LAVENDER, CYAN, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(LAVENDER, DARK_GOLDENROD, TAN, 85);
        EnumFlowerColor.addMix(LAVENDER, DARK_GRAY, LIGHT_GRAY, 110);
        EnumFlowerColor.addMix(LAVENDER, DARK_GREEN, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(LAVENDER, DARK_KHAKI, WHEAT, 90);
        EnumFlowerColor.addMix(LAVENDER, DARK_OLIVE_GREEN, DARK_GRAY, 75);
        EnumFlowerColor.addMix(LAVENDER, DARK_ORANGE, SANDY_BROWN, 85);
        EnumFlowerColor.addMix(LAVENDER, DARK_SALMON, PINK, 95);
        EnumFlowerColor.addMix(LAVENDER, DARK_SEA_GREEN, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(LAVENDER, DARK_SLATE_BLUE, MEDIUM_PURPLE, 70);
        EnumFlowerColor.addMix(LAVENDER, DARK_SLATE_GRAY, DARK_GRAY, 70);
        EnumFlowerColor.addMix(LAVENDER, DARK_TURQUOISE, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(LAVENDER, DARK_VIOLET, MEDIUM_ORCHID, 75);
        EnumFlowerColor.addMix(LAVENDER, DEEP_PINK, HOT_PINK, 85);
        EnumFlowerColor.addMix(LAVENDER, DEEP_SKY_BLUE, SKY_BLUE, 95);
        EnumFlowerColor.addMix(LAVENDER, DIM_GRAY, DARK_GRAY, 85);
        EnumFlowerColor.addMix(LAVENDER, DODGER_BLUE, LIGHT_STEEL_BLUE, 95);
        EnumFlowerColor.addMix(LAVENDER, GOLD, KHAKI, 85);
        EnumFlowerColor.addMix(LAVENDER, GOLDENROD, TAN, 85);
        EnumFlowerColor.addMix(LAVENDER, GRAY, DARK_GRAY, 95);
        EnumFlowerColor.addMix(LAVENDER, GREEN, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(LAVENDER, HOT_PINK, PLUM, 95);
        EnumFlowerColor.addMix(LAVENDER, INDIAN_RED, ROSY_BROWN, 85);
        EnumFlowerColor.addMix(LAVENDER, INDIGO, MEDIUM_PURPLE, 55);
        EnumFlowerColor.addMix(LAVENDER, KHAKI, LEMON_CHIFFON, 90);
        EnumFlowerColor.addMix(LEMON_CHIFFON, AQUAMARINE, PALE_GREEN, 105);
        EnumFlowerColor.addMix(LEMON_CHIFFON, BLUE, MEDIUM_PURPLE, 45);
        EnumFlowerColor.addMix(LEMON_CHIFFON, BROWN, DARK_SALMON, 65);
        EnumFlowerColor.addMix(LEMON_CHIFFON, CADET_BLUE, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(LEMON_CHIFFON, CHOCOLATE, SANDY_BROWN, 85);
        EnumFlowerColor.addMix(LEMON_CHIFFON, CORAL, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(LEMON_CHIFFON, CRIMSON, SALMON, 70);
        EnumFlowerColor.addMix(LEMON_CHIFFON, CYAN, AQUAMARINE, 95);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_GOLDENROD, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_GRAY, LIGHT_GRAY, 100);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_GREEN, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_KHAKI, KHAKI, 110);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_OLIVE_GREEN, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_ORANGE, ORANGE, 95);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_SALMON, TAN, 95);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_SEA_GREEN, KHAKI, 105);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_SLATE_BLUE, DARK_GRAY, 55);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_SLATE_GRAY, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_TURQUOISE, TURQUOISE, 95);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DARK_VIOLET, VIOLET, 50);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DEEP_PINK, HOT_PINK, 65);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DEEP_SKY_BLUE, PALE_TURQUOISE, 80);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DIM_GRAY, DARK_GRAY, 80);
        EnumFlowerColor.addMix(LEMON_CHIFFON, DODGER_BLUE, SKY_BLUE, 70);
        EnumFlowerColor.addMix(LEMON_CHIFFON, GOLD, KHAKI, 105);
        EnumFlowerColor.addMix(LEMON_CHIFFON, GOLDENROD, KHAKI, 100);
        EnumFlowerColor.addMix(LEMON_CHIFFON, GRAY, DARK_GRAY, 90);
        EnumFlowerColor.addMix(LEMON_CHIFFON, GREEN, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(LEMON_CHIFFON, HOT_PINK, PINK, 75);
        EnumFlowerColor.addMix(LEMON_CHIFFON, INDIAN_RED, DARK_SALMON, 80);
        EnumFlowerColor.addMix(LEMON_CHIFFON, KHAKI, WHEAT, 115);
        EnumFlowerColor.addMix(LIGHT_GRAY, AQUAMARINE, PALE_TURQUOISE, 100);
        EnumFlowerColor.addMix(LIGHT_GRAY, BLACK, DIM_GRAY, 45);
        EnumFlowerColor.addMix(LIGHT_GRAY, BLUE, ROYAL_BLUE, 65);
        EnumFlowerColor.addMix(LIGHT_GRAY, BROWN, ROSY_BROWN, 75);
        EnumFlowerColor.addMix(LIGHT_GRAY, CADET_BLUE, SKY_BLUE, 100);
        EnumFlowerColor.addMix(LIGHT_GRAY, CHOCOLATE, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(LIGHT_GRAY, CORAL, DARK_SALMON, 95);
        EnumFlowerColor.addMix(LIGHT_GRAY, CRIMSON, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(LIGHT_GRAY, CYAN, TURQUOISE, 100);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_GOLDENROD, TAN, 95);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_GRAY, LIGHT_STEEL_BLUE, 115);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_GREEN, SEA_GREEN, 75);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_KHAKI, WHEAT, 105);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_OLIVE_GREEN, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_ORANGE, SANDY_BROWN, 95);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_SALMON, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_SLATE_GRAY, GRAY, 75);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_TURQUOISE, TURQUOISE, 100);
        EnumFlowerColor.addMix(LIGHT_GRAY, DARK_VIOLET, MEDIUM_ORCHID, 75);
        EnumFlowerColor.addMix(LIGHT_GRAY, DEEP_PINK, HOT_PINK, 90);
        EnumFlowerColor.addMix(LIGHT_GRAY, DEEP_SKY_BLUE, SKY_BLUE, 100);
        EnumFlowerColor.addMix(LIGHT_GRAY, DIM_GRAY, DARK_GRAY, 95);
        EnumFlowerColor.addMix(LIGHT_GRAY, DODGER_BLUE, DEEP_SKY_BLUE, 95);
        EnumFlowerColor.addMix(LIGHT_GRAY, GOLD, KHAKI, 95);
        EnumFlowerColor.addMix(LIGHT_GRAY, GOLDENROD, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(LIGHT_GRAY, GRAY, DARK_GRAY, 100);
        EnumFlowerColor.addMix(LIGHT_GRAY, GREEN, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(LIGHT_GRAY, HOT_PINK, PLUM, 95);
        EnumFlowerColor.addMix(LIGHT_GRAY, INDIAN_RED, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(LIGHT_GRAY, INDIGO, MEDIUM_PURPLE, 55);
        EnumFlowerColor.addMix(LIGHT_GRAY, KHAKI, LEMON_CHIFFON, 105);
        EnumFlowerColor.addMix(LIGHT_GRAY, LEMON_CHIFFON, WHEAT, 110);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, AQUAMARINE, TURQUOISE, 105);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, BLACK, DARK_SLATE_GRAY, 65);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, BLUE, ROYAL_BLUE, 70);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, BROWN, DIM_GRAY, 60);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, CADET_BLUE, DARK_TURQUOISE, 120);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, CHOCOLATE, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, CYAN, DARK_TURQUOISE, 110);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_GOLDENROD, OLIVE_DRAB, 85);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_GRAY, CADET_BLUE, 105);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_GREEN, SEA_GREEN, 90);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_KHAKI, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_OLIVE_GREEN, SEA_GREEN, 95);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_ORANGE, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_SALMON, CADET_BLUE, 80);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_SEA_GREEN, MEDIUM_AQUAMARINE, 110);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_SLATE_BLUE, STEEL_BLUE, 75);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_SLATE_GRAY, TEAL, 90);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_TURQUOISE, TURQUOISE, 120);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DARK_VIOLET, SLATE_BLUE, 75);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DEEP_PINK, MEDIUM_ORCHID, 65);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DEEP_SKY_BLUE, SKY_BLUE, 105);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DIM_GRAY, TEAL, 95);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, DODGER_BLUE, DEEP_SKY_BLUE, 95);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, GOLD, YELLOW_GREEN, 85);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, GOLDENROD, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, GRAY, CADET_BLUE, 100);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, GREEN, SEA_GREEN, 95);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, INDIAN_RED, GRAY, 70);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, INDIGO, ROYAL_BLUE, 65);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, KHAKI, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, LAVENDER, DARK_TURQUOISE, 95);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, LEMON_CHIFFON, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(LIGHT_SEA_GREEN, LIGHT_GRAY, DARK_TURQUOISE, 100);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, AQUAMARINE, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, BLACK, DIM_GRAY, 55);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, BLUE, ROYAL_BLUE, 80);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, BROWN, ROSY_BROWN, 75);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, CADET_BLUE, SKY_BLUE, 105);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, CHOCOLATE, DARK_SALMON, 85);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, CORAL, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, CRIMSON, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, CYAN, DARK_TURQUOISE, 100);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_GOLDENROD, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_GRAY, LIGHT_GRAY, 115);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_GREEN, SEA_GREEN, 70);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_KHAKI, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_OLIVE_GREEN, CADET_BLUE, 80);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_ORANGE, TAN, 85);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_SALMON, ROSY_BROWN, 95);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_SEA_GREEN, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_SLATE_BLUE, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_SLATE_GRAY, SLATE_GRAY, 80);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_TURQUOISE, SKY_BLUE, 105);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DARK_VIOLET, MEDIUM_PURPLE, 85);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DEEP_PINK, HOT_PINK, 85);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DEEP_SKY_BLUE, SKY_BLUE, 110);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DIM_GRAY, SLATE_GRAY, 95);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, DODGER_BLUE, DEEP_SKY_BLUE, 105);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, GOLD, KHAKI, 80);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, GOLDENROD, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, GRAY, DARK_GRAY, 105);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, GREEN, MEDIUM_SEA_GREEN, 75);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, HOT_PINK, PLUM, 90);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, INDIAN_RED, ROSY_BROWN, 85);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, INDIGO, SLATE_BLUE, 65);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, KHAKI, LEMON_CHIFFON, 85);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, LAVENDER, LIGHT_GRAY, 115);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, LEMON_CHIFFON, LIGHT_GRAY, 95);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, LIGHT_GRAY, LAVENDER, 115);
        EnumFlowerColor.addMix(LIGHT_STEEL_BLUE, LIGHT_SEA_GREEN, DARK_TURQUOISE, 100);
        EnumFlowerColor.addMix(LIME, AQUAMARINE, SPRING_GREEN, 105);
        EnumFlowerColor.addMix(LIME, CADET_BLUE, LIME_GREEN, 85);
        EnumFlowerColor.addMix(LIME, CHOCOLATE, YELLOW_GREEN, 60);
        EnumFlowerColor.addMix(LIME, CORAL, YELLOW_GREEN, 55);
        EnumFlowerColor.addMix(LIME, CYAN, SPRING_GREEN, 90);
        EnumFlowerColor.addMix(LIME, DARK_GOLDENROD, LIME_GREEN, 80);
        EnumFlowerColor.addMix(LIME, DARK_GRAY, LIME_GREEN, 90);
        EnumFlowerColor.addMix(LIME, DARK_GREEN, LIME_GREEN, 80);
        EnumFlowerColor.addMix(LIME, DARK_KHAKI, LIME_GREEN, 100);
        EnumFlowerColor.addMix(LIME, DARK_OLIVE_GREEN, LIME_GREEN, 85);
        EnumFlowerColor.addMix(LIME, DARK_ORANGE, YELLOW_GREEN, 65);
        EnumFlowerColor.addMix(LIME, DARK_SALMON, LIME_GREEN, 65);
        EnumFlowerColor.addMix(LIME, DARK_SEA_GREEN, LIME_GREEN, 105);
        EnumFlowerColor.addMix(LIME, DARK_SLATE_BLUE, MEDIUM_SEA_GREEN, 50);
        EnumFlowerColor.addMix(LIME, DARK_SLATE_GRAY, MEDIUM_SEA_GREEN, 65);
        EnumFlowerColor.addMix(LIME, DARK_TURQUOISE, SPRING_GREEN, 90);
        EnumFlowerColor.addMix(LIME, DEEP_SKY_BLUE, SPRING_GREEN, 65);
        EnumFlowerColor.addMix(LIME, DIM_GRAY, LIME_GREEN, 80);
        EnumFlowerColor.addMix(LIME, DODGER_BLUE, MEDIUM_SEA_GREEN, 55);
        EnumFlowerColor.addMix(LIME, GOLD, YELLOW_GREEN, 95);
        EnumFlowerColor.addMix(LIME, GOLDENROD, LIME_GREEN, 85);
        EnumFlowerColor.addMix(LIME, GRAY, LIME_GREEN, 85);
        EnumFlowerColor.addMix(LIME, GREEN, LIME_GREEN, 90);
        EnumFlowerColor.addMix(LIME, INDIAN_RED, LIME_GREEN, 45);
        EnumFlowerColor.addMix(LIME, KHAKI, PALE_GREEN, 100);
        EnumFlowerColor.addMix(LIME, LAVENDER, PALE_GREEN, 85);
        EnumFlowerColor.addMix(LIME, LEMON_CHIFFON, PALE_GREEN, 100);
        EnumFlowerColor.addMix(LIME, LIGHT_GRAY, SPRING_GREEN, 95);
        EnumFlowerColor.addMix(LIME, LIGHT_SEA_GREEN, LIME_GREEN, 90);
        EnumFlowerColor.addMix(LIME, LIGHT_STEEL_BLUE, SPRING_GREEN, 80);
        EnumFlowerColor.addMix(LIME_GREEN, AQUAMARINE, SPRING_GREEN, 105);
        EnumFlowerColor.addMix(LIME_GREEN, BLACK, DARK_GREEN, 55);
        EnumFlowerColor.addMix(LIME_GREEN, BLUE, STEEL_BLUE, 50);
        EnumFlowerColor.addMix(LIME_GREEN, BROWN, DARK_OLIVE_GREEN, 45);
        EnumFlowerColor.addMix(LIME_GREEN, CADET_BLUE, MEDIUM_SEA_GREEN, 95);
        EnumFlowerColor.addMix(LIME_GREEN, CHOCOLATE, OLIVE_DRAB, 65);
        EnumFlowerColor.addMix(LIME_GREEN, CORAL, DARK_KHAKI, 60);
        EnumFlowerColor.addMix(LIME_GREEN, CYAN, SPRING_GREEN, 90);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_GOLDENROD, OLIVE_DRAB, 90);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_GRAY, MEDIUM_SEA_GREEN, 95);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_GREEN, GREEN, 90);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_KHAKI, YELLOW_GREEN, 105);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_OLIVE_GREEN, OLIVE_DRAB, 95);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_ORANGE, YELLOW_GREEN, 70);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_SALMON, YELLOW_GREEN, 70);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_SEA_GREEN, MEDIUM_SEA_GREEN, 110);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_SLATE_BLUE, SEA_GREEN, 55);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_SLATE_GRAY, SEA_GREEN, 75);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_TURQUOISE, MEDIUM_SEA_GREEN, 95);
        EnumFlowerColor.addMix(LIME_GREEN, DARK_VIOLET, DIM_GRAY, 55);
        EnumFlowerColor.addMix(LIME_GREEN, DEEP_SKY_BLUE, MEDIUM_AQUAMARINE, 70);
        EnumFlowerColor.addMix(LIME_GREEN, DIM_GRAY, SEA_GREEN, 85);
        EnumFlowerColor.addMix(LIME_GREEN, DODGER_BLUE, LIGHT_SEA_GREEN, 65);
        EnumFlowerColor.addMix(LIME_GREEN, GOLD, YELLOW_GREEN, 95);
        EnumFlowerColor.addMix(LIME_GREEN, GOLDENROD, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(LIME_GREEN, GRAY, MEDIUM_SEA_GREEN, 90);
        EnumFlowerColor.addMix(LIME_GREEN, GREEN, MEDIUM_SEA_GREEN, 105);
        EnumFlowerColor.addMix(LIME_GREEN, INDIAN_RED, OLIVE_DRAB, 55);
        EnumFlowerColor.addMix(LIME_GREEN, INDIGO, DARK_SLATE_GRAY, 50);
        EnumFlowerColor.addMix(LIME_GREEN, KHAKI, YELLOW_GREEN, 100);
        EnumFlowerColor.addMix(LIME_GREEN, LAVENDER, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(LIME_GREEN, LEMON_CHIFFON, PALE_GREEN, 100);
        EnumFlowerColor.addMix(LIME_GREEN, LIGHT_GRAY, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(LIME_GREEN, LIGHT_SEA_GREEN, MEDIUM_SEA_GREEN, 100);
        EnumFlowerColor.addMix(LIME_GREEN, LIGHT_STEEL_BLUE, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(LIME_GREEN, LIME, SPRING_GREEN, 115);
        EnumFlowerColor.addMix(MAGENTA, AQUAMARINE, VIOLET, 70);
        EnumFlowerColor.addMix(MAGENTA, BLACK, PURPLE, 70);
        EnumFlowerColor.addMix(MAGENTA, BLUE, DARK_VIOLET, 95);
        EnumFlowerColor.addMix(MAGENTA, BROWN, MEDIUM_VIOLET_RED, 85);
        EnumFlowerColor.addMix(MAGENTA, CADET_BLUE, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(MAGENTA, CHOCOLATE, DEEP_PINK, 75);
        EnumFlowerColor.addMix(MAGENTA, CORAL, DEEP_PINK, 80);
        EnumFlowerColor.addMix(MAGENTA, CRIMSON, DEEP_PINK, 90);
        EnumFlowerColor.addMix(MAGENTA, CYAN, MEDIUM_PURPLE, 65);
        EnumFlowerColor.addMix(MAGENTA, DARK_GOLDENROD, DEEP_PINK, 60);
        EnumFlowerColor.addMix(MAGENTA, DARK_GRAY, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(MAGENTA, DARK_KHAKI, HOT_PINK, 55);
        EnumFlowerColor.addMix(MAGENTA, DARK_OLIVE_GREEN, MEDIUM_VIOLET_RED, 50);
        EnumFlowerColor.addMix(MAGENTA, DARK_ORANGE, DEEP_PINK, 65);
        EnumFlowerColor.addMix(MAGENTA, DARK_SALMON, HOT_PINK, 85);
        EnumFlowerColor.addMix(MAGENTA, DARK_SEA_GREEN, MEDIUM_ORCHID, 50);
        EnumFlowerColor.addMix(MAGENTA, DARK_SLATE_BLUE, DARK_VIOLET, 90);
        EnumFlowerColor.addMix(MAGENTA, DARK_SLATE_GRAY, DARK_VIOLET, 90);
        EnumFlowerColor.addMix(MAGENTA, DARK_TURQUOISE, MEDIUM_PURPLE, 75);
        EnumFlowerColor.addMix(MAGENTA, DARK_VIOLET, MEDIUM_ORCHID, 105);
        EnumFlowerColor.addMix(MAGENTA, DEEP_PINK, HOT_PINK, 110);
        EnumFlowerColor.addMix(MAGENTA, DEEP_SKY_BLUE, MEDIUM_PURPLE, 70);
        EnumFlowerColor.addMix(MAGENTA, DIM_GRAY, MEDIUM_ORCHID, 90);
        EnumFlowerColor.addMix(MAGENTA, DODGER_BLUE, SLATE_BLUE, 85);
        EnumFlowerColor.addMix(MAGENTA, GOLDENROD, DEEP_PINK, 55);
        EnumFlowerColor.addMix(MAGENTA, GRAY, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(MAGENTA, HOT_PINK, VIOLET, 110);
        EnumFlowerColor.addMix(MAGENTA, INDIAN_RED, DEEP_PINK, 95);
        EnumFlowerColor.addMix(MAGENTA, INDIGO, DARK_VIOLET, 90);
        EnumFlowerColor.addMix(MAGENTA, KHAKI, HOT_PINK, 50);
        EnumFlowerColor.addMix(MAGENTA, LAVENDER, VIOLET, 90);
        EnumFlowerColor.addMix(MAGENTA, LEMON_CHIFFON, VIOLET, 60);
        EnumFlowerColor.addMix(MAGENTA, LIGHT_GRAY, VIOLET, 90);
        EnumFlowerColor.addMix(MAGENTA, LIGHT_SEA_GREEN, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(MAGENTA, LIGHT_STEEL_BLUE, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(MAROON, BLUE, INDIGO, 80);
        EnumFlowerColor.addMix(MAROON, CHOCOLATE, SIENNA, 95);
        EnumFlowerColor.addMix(MAROON, CORAL, SIENNA, 85);
        EnumFlowerColor.addMix(MAROON, CRIMSON, BROWN, 105);
        EnumFlowerColor.addMix(MAROON, DARK_GOLDENROD, SIENNA, 85);
        EnumFlowerColor.addMix(MAROON, DARK_GRAY, BROWN, 75);
        EnumFlowerColor.addMix(MAROON, DARK_KHAKI, SIENNA, 65);
        EnumFlowerColor.addMix(MAROON, DARK_ORANGE, SIENNA, 80);
        EnumFlowerColor.addMix(MAROON, DARK_SALMON, BROWN, 80);
        EnumFlowerColor.addMix(MAROON, DARK_SEA_GREEN, SIENNA, 55);
        EnumFlowerColor.addMix(MAROON, DARK_TURQUOISE, DARK_SLATE_GRAY, 50);
        EnumFlowerColor.addMix(MAROON, DARK_VIOLET, PURPLE, 85);
        EnumFlowerColor.addMix(MAROON, DEEP_PINK, CRIMSON, 90);
        EnumFlowerColor.addMix(MAROON, DEEP_SKY_BLUE, ROYAL_BLUE, 50);
        EnumFlowerColor.addMix(MAROON, DIM_GRAY, BROWN, 95);
        EnumFlowerColor.addMix(MAROON, DODGER_BLUE, DARK_SLATE_BLUE, 70);
        EnumFlowerColor.addMix(MAROON, GOLD, CHOCOLATE, 55);
        EnumFlowerColor.addMix(MAROON, GOLDENROD, SIENNA, 70);
        EnumFlowerColor.addMix(MAROON, GRAY, BROWN, 90);
        EnumFlowerColor.addMix(MAROON, GREEN, OLIVE, 60);
        EnumFlowerColor.addMix(MAROON, HOT_PINK, CRIMSON, 80);
        EnumFlowerColor.addMix(MAROON, INDIAN_RED, BROWN, 100);
        EnumFlowerColor.addMix(MAROON, INDIGO, PURPLE, 90);
        EnumFlowerColor.addMix(MAROON, KHAKI, CHOCOLATE, 55);
        EnumFlowerColor.addMix(MAROON, LAVENDER, ROSY_BROWN, 60);
        EnumFlowerColor.addMix(MAROON, LEMON_CHIFFON, DARK_SALMON, 55);
        EnumFlowerColor.addMix(MAROON, LIGHT_GRAY, INDIAN_RED, 65);
        EnumFlowerColor.addMix(MAROON, LIGHT_SEA_GREEN, DIM_GRAY, 60);
        EnumFlowerColor.addMix(MAROON, MAGENTA, MEDIUM_VIOLET_RED, 75);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, AQUAMARINE, TURQUOISE, 115);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, BLACK, DARK_SLATE_GRAY, 55);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, BLUE, ROYAL_BLUE, 60);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, BROWN, GRAY, 55);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, CADET_BLUE, LIGHT_SEA_GREEN, 110);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, CHOCOLATE, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, CORAL, TAN, 70);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, CRIMSON, ROSY_BROWN, 55);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, CYAN, TURQUOISE, 110);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_GOLDENROD, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_GRAY, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_GREEN, SEA_GREEN, 85);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_KHAKI, DARK_SEA_GREEN, 105);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_OLIVE_GREEN, SEA_GREEN, 90);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_ORANGE, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_SALMON, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_SEA_GREEN, MEDIUM_SEA_GREEN, 115);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_SLATE_BLUE, SLATE_GRAY, 65);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_SLATE_GRAY, TEAL, 80);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_TURQUOISE, TURQUOISE, 115);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DARK_VIOLET, SLATE_BLUE, 70);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DEEP_PINK, PALE_VIOLET_RED, 45);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DEEP_SKY_BLUE, DARK_TURQUOISE, 95);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DIM_GRAY, CADET_BLUE, 90);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, DODGER_BLUE, DEEP_SKY_BLUE, 85);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, GOLD, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, GOLDENROD, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, GRAY, CADET_BLUE, 95);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, GREEN, MEDIUM_SEA_GREEN, 95);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, HOT_PINK, THISTLE, 55);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, INDIAN_RED, DARK_GRAY, 65);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, INDIGO, SLATE_BLUE, 55);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, KHAKI, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, LAVENDER, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, LEMON_CHIFFON, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, LIGHT_GRAY, PALE_TURQUOISE, 100);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, LIGHT_SEA_GREEN, TURQUOISE, 115);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, LIGHT_STEEL_BLUE, PALE_TURQUOISE, 100);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, LIME, LIME_GREEN, 100);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, LIME_GREEN, MEDIUM_SEA_GREEN, 110);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, MAGENTA, MEDIUM_ORCHID, 75);
        EnumFlowerColor.addMix(MEDIUM_AQUAMARINE, MAROON, DIM_GRAY, 50);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, AQUAMARINE, LIGHT_STEEL_BLUE, 70);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, BLACK, PURPLE, 75);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, BLUE, DARK_VIOLET, 100);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, BROWN, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, CADET_BLUE, MEDIUM_PURPLE, 95);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, CHOCOLATE, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, CORAL, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, CRIMSON, MEDIUM_VIOLET_RED, 95);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, CYAN, DODGER_BLUE, 70);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_GOLDENROD, INDIAN_RED, 65);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_GRAY, PLUM, 95);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_KHAKI, ROSY_BROWN, 60);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_ORANGE, INDIAN_RED, 70);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_SALMON, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_SEA_GREEN, PLUM, 55);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_SLATE_BLUE, SLATE_BLUE, 100);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_SLATE_GRAY, DARK_SLATE_BLUE, 95);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DARK_TURQUOISE, DODGER_BLUE, 75);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DEEP_PINK, MEDIUM_VIOLET_RED, 110);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DEEP_SKY_BLUE, DODGER_BLUE, 75);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DIM_GRAY, MEDIUM_PURPLE, 95);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, DODGER_BLUE, ROYAL_BLUE, 95);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, GOLD, SANDY_BROWN, 50);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, GOLDENROD, ROSY_BROWN, 60);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, GRAY, MEDIUM_PURPLE, 100);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, HOT_PINK, VIOLET, 110);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, INDIAN_RED, MEDIUM_VIOLET_RED, 95);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, INDIGO, DARK_VIOLET, 100);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, KHAKI, ROSY_BROWN, 55);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, LAVENDER, PLUM, 90);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, LEMON_CHIFFON, PLUM, 65);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, LIGHT_GRAY, PLUM, 90);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, LIGHT_SEA_GREEN, STEEL_BLUE, 80);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, LIGHT_STEEL_BLUE, PLUM, 95);
        EnumFlowerColor.addMix(MEDIUM_ORCHID, MAROON, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, AQUAMARINE, SKY_BLUE, 75);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, BLACK, DARK_SLATE_BLUE, 75);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, BLUE, SLATE_BLUE, 100);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, BROWN, MEDIUM_VIOLET_RED, 85);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, CADET_BLUE, SLATE_GRAY, 95);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, CHOCOLATE, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, CORAL, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, CRIMSON, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, CYAN, DEEP_SKY_BLUE, 75);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_GOLDENROD, ROSY_BROWN, 65);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_GREEN, DARK_SLATE_GRAY, 70);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_KHAKI, ROSY_BROWN, 65);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_OLIVE_GREEN, DIM_GRAY, 65);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_ORANGE, DARK_SALMON, 70);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_SALMON, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_SEA_GREEN, SLATE_GRAY, 80);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_SLATE_BLUE, SLATE_BLUE, 105);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_SLATE_GRAY, SLATE_BLUE, 95);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_TURQUOISE, DODGER_BLUE, 85);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DARK_VIOLET, SLATE_BLUE, 110);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DEEP_PINK, MEDIUM_ORCHID, 100);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DEEP_SKY_BLUE, DODGER_BLUE, 90);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DIM_GRAY, SLATE_BLUE, 100);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, DODGER_BLUE, ROYAL_BLUE, 105);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, GOLD, TAN, 55);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, GOLDENROD, ROSY_BROWN, 65);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, GREEN, TEAL, 70);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, HOT_PINK, MEDIUM_ORCHID, 105);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, INDIAN_RED, PALE_VIOLET_RED, 95);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, INDIGO, DARK_VIOLET, 95);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, KHAKI, THISTLE, 60);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, LAVENDER, PLUM, 95);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, LEMON_CHIFFON, THISTLE, 65);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, LIGHT_GRAY, PLUM, 90);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, LIGHT_SEA_GREEN, STEEL_BLUE, 85);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, LIME, MEDIUM_SEA_GREEN, 60);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, LIME_GREEN, CADET_BLUE, 65);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, MAGENTA, MEDIUM_ORCHID, 110);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, MAROON, PURPLE, 80);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, MEDIUM_AQUAMARINE, DODGER_BLUE, 80);
        EnumFlowerColor.addMix(MEDIUM_PURPLE, MEDIUM_ORCHID, SLATE_BLUE, 115);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, AQUAMARINE, MEDIUM_AQUAMARINE, 105);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, BLACK, DARK_GREEN, 65);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, BLUE, ROYAL_BLUE, 60);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, BROWN, DARK_OLIVE_GREEN, 55);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, CADET_BLUE, LIGHT_SEA_GREEN, 105);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, CHOCOLATE, OLIVE_DRAB, 70);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, CORAL, DARK_KHAKI, 65);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, CRIMSON, SIENNA, 50);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, CYAN, MEDIUM_AQUAMARINE, 100);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_GOLDENROD, OLIVE_DRAB, 90);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_GRAY, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_GREEN, SEA_GREEN, 95);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_KHAKI, DARK_SEA_GREEN, 105);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_OLIVE_GREEN, SEA_GREEN, 100);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_ORANGE, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_SALMON, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_SEA_GREEN, MEDIUM_AQUAMARINE, 115);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_SLATE_BLUE, TEAL, 70);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_SLATE_GRAY, SEA_GREEN, 85);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_TURQUOISE, MEDIUM_AQUAMARINE, 105);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DARK_VIOLET, SLATE_BLUE, 65);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DEEP_SKY_BLUE, LIGHT_SEA_GREEN, 85);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DIM_GRAY, SEA_GREEN, 95);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, DODGER_BLUE, CADET_BLUE, 75);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, GOLD, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, GOLDENROD, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, GRAY, SEA_GREEN, 100);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, GREEN, SEA_GREEN, 105);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, HOT_PINK, GRAY, 45);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, INDIGO, DARK_SLATE_BLUE, 60);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, KHAKI, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, LAVENDER, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, LEMON_CHIFFON, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, LIGHT_GRAY, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, LIGHT_SEA_GREEN, MEDIUM_AQUAMARINE, 110);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, LIGHT_STEEL_BLUE, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, LIME, LIME_GREEN, 105);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, MAGENTA, MEDIUM_ORCHID, 70);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, MAROON, DARK_OLIVE_GREEN, 50);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, MEDIUM_AQUAMARINE, DARK_SEA_GREEN, 115);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, MEDIUM_ORCHID, SLATE_GRAY, 75);
        EnumFlowerColor.addMix(MEDIUM_SEA_GREEN, MEDIUM_PURPLE, SLATE_GRAY, 75);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, BLACK, PURPLE, 85);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, BLUE, DARK_VIOLET, 95);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, CHOCOLATE, CRIMSON, 85);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, CORAL, INDIAN_RED, 85);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, CRIMSON, DEEP_PINK, 105);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, CYAN, STEEL_BLUE, 45);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_GOLDENROD, INDIAN_RED, 70);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_GRAY, PALE_VIOLET_RED, 90);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_KHAKI, PALE_VIOLET_RED, 60);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_ORANGE, INDIAN_RED, 70);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_SALMON, PALE_VIOLET_RED, 90);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_SEA_GREEN, PALE_VIOLET_RED, 55);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_SLATE_BLUE, PURPLE, 100);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_SLATE_GRAY, PURPLE, 100);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_TURQUOISE, ROYAL_BLUE, 55);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DARK_VIOLET, PURPLE, 110);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DEEP_SKY_BLUE, SLATE_BLUE, 60);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DIM_GRAY, PURPLE, 100);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, DODGER_BLUE, SLATE_BLUE, 80);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, GOLD, CORAL, 50);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, GOLDENROD, INDIAN_RED, 60);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, HOT_PINK, DEEP_PINK, 105);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, INDIAN_RED, DEEP_PINK, 105);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, INDIGO, PURPLE, 100);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, KHAKI, PALE_VIOLET_RED, 55);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, LAVENDER, VIOLET, 80);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, LEMON_CHIFFON, PALE_VIOLET_RED, 60);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, LIGHT_GRAY, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, LIGHT_SEA_GREEN, SLATE_BLUE, 65);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, LIGHT_STEEL_BLUE, MEDIUM_ORCHID, 80);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, MAGENTA, MEDIUM_ORCHID, 105);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, MAROON, BROWN, 95);
        EnumFlowerColor.addMix(MEDIUM_VIOLET_RED, MEDIUM_PURPLE, MEDIUM_ORCHID, 105);
        EnumFlowerColor.addMix(MISTY_ROSE, AQUAMARINE, PALE_TURQUOISE, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, BLUE, MEDIUM_PURPLE, 65);
        EnumFlowerColor.addMix(MISTY_ROSE, BROWN, ROSY_BROWN, 75);
        EnumFlowerColor.addMix(MISTY_ROSE, CADET_BLUE, LIGHT_GRAY, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, CHOCOLATE, DARK_SALMON, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, CORAL, DARK_SALMON, 100);
        EnumFlowerColor.addMix(MISTY_ROSE, CRIMSON, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, CYAN, PALE_TURQUOISE, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_GOLDENROD, TAN, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_GRAY, LIGHT_GRAY, 105);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_GREEN, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_KHAKI, WHEAT, 100);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_OLIVE_GREEN, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_ORANGE, SANDY_BROWN, 95);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_SALMON, PINK, 105);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_SEA_GREEN, LEMON_CHIFFON, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_SLATE_BLUE, PLUM, 65);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_SLATE_GRAY, DARK_GRAY, 65);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_TURQUOISE, PALE_TURQUOISE, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, DARK_VIOLET, VIOLET, 70);
        EnumFlowerColor.addMix(MISTY_ROSE, DEEP_PINK, HOT_PINK, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, DEEP_SKY_BLUE, SKY_BLUE, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, DIM_GRAY, DARK_GRAY, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, DODGER_BLUE, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, GOLD, KHAKI, 95);
        EnumFlowerColor.addMix(MISTY_ROSE, GOLDENROD, TAN, 95);
        EnumFlowerColor.addMix(MISTY_ROSE, GRAY, DARK_GRAY, 95);
        EnumFlowerColor.addMix(MISTY_ROSE, GREEN, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(MISTY_ROSE, HOT_PINK, PINK, 95);
        EnumFlowerColor.addMix(MISTY_ROSE, INDIAN_RED, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, INDIGO, MEDIUM_ORCHID, 50);
        EnumFlowerColor.addMix(MISTY_ROSE, KHAKI, WHEAT, 100);
        EnumFlowerColor.addMix(MISTY_ROSE, LEMON_CHIFFON, WHEAT, 105);
        EnumFlowerColor.addMix(MISTY_ROSE, LIGHT_SEA_GREEN, PALE_TURQUOISE, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, LIGHT_STEEL_BLUE, LAVENDER, 105);
        EnumFlowerColor.addMix(MISTY_ROSE, LIME, PALE_GREEN, 80);
        EnumFlowerColor.addMix(MISTY_ROSE, LIME_GREEN, PALE_GREEN, 80);
        EnumFlowerColor.addMix(MISTY_ROSE, MAGENTA, VIOLET, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, MAROON, INDIAN_RED, 60);
        EnumFlowerColor.addMix(MISTY_ROSE, MEDIUM_AQUAMARINE, PALE_TURQUOISE, 90);
        EnumFlowerColor.addMix(MISTY_ROSE, MEDIUM_ORCHID, PLUM, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, MEDIUM_PURPLE, PLUM, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, MEDIUM_SEA_GREEN, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(MISTY_ROSE, MEDIUM_VIOLET_RED, HOT_PINK, 80);
        EnumFlowerColor.addMix(NAVY, BLUE, INDIGO, 110);
        EnumFlowerColor.addMix(NAVY, BROWN, PURPLE, 85);
        EnumFlowerColor.addMix(NAVY, CADET_BLUE, DARK_SLATE_BLUE, 75);
        EnumFlowerColor.addMix(NAVY, CORAL, PURPLE, 60);
        EnumFlowerColor.addMix(NAVY, CRIMSON, PURPLE, 80);
        EnumFlowerColor.addMix(NAVY, DARK_GRAY, DARK_SLATE_BLUE, 65);
        EnumFlowerColor.addMix(NAVY, DARK_GREEN, DARK_SLATE_GRAY, 65);
        EnumFlowerColor.addMix(NAVY, DARK_OLIVE_GREEN, DARK_SLATE_BLUE, 55);
        EnumFlowerColor.addMix(NAVY, DARK_ORANGE, BROWN, 50);
        EnumFlowerColor.addMix(NAVY, DARK_SEA_GREEN, ROYAL_BLUE, 55);
        EnumFlowerColor.addMix(NAVY, DARK_SLATE_BLUE, INDIGO, 110);
        EnumFlowerColor.addMix(NAVY, DARK_SLATE_GRAY, DARK_SLATE_BLUE, 95);
        EnumFlowerColor.addMix(NAVY, DARK_TURQUOISE, STEEL_BLUE, 55);
        EnumFlowerColor.addMix(NAVY, DARK_VIOLET, INDIGO, 105);
        EnumFlowerColor.addMix(NAVY, DEEP_PINK, PURPLE, 80);
        EnumFlowerColor.addMix(NAVY, DEEP_SKY_BLUE, ROYAL_BLUE, 60);
        EnumFlowerColor.addMix(NAVY, DIM_GRAY, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(NAVY, DODGER_BLUE, DARK_SLATE_BLUE, 80);
        EnumFlowerColor.addMix(NAVY, GRAY, DARK_SLATE_BLUE, 80);
        EnumFlowerColor.addMix(NAVY, GREEN, TEAL, 60);
        EnumFlowerColor.addMix(NAVY, HOT_PINK, PURPLE, 75);
        EnumFlowerColor.addMix(NAVY, INDIAN_RED, PURPLE, 80);
        EnumFlowerColor.addMix(NAVY, LIGHT_GRAY, SLATE_BLUE, 50);
        EnumFlowerColor.addMix(NAVY, LIGHT_SEA_GREEN, ROYAL_BLUE, 65);
        EnumFlowerColor.addMix(NAVY, LIGHT_STEEL_BLUE, SLATE_BLUE, 60);
        EnumFlowerColor.addMix(NAVY, MAGENTA, DARK_VIOLET, 85);
        EnumFlowerColor.addMix(NAVY, MAROON, PURPLE, 85);
        EnumFlowerColor.addMix(NAVY, MEDIUM_AQUAMARINE, ROYAL_BLUE, 50);
        EnumFlowerColor.addMix(NAVY, MEDIUM_ORCHID, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(NAVY, MEDIUM_PURPLE, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(NAVY, MEDIUM_VIOLET_RED, INDIGO, 95);
        EnumFlowerColor.addMix(OLIVE, AQUAMARINE, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(OLIVE, BLUE, DARK_SLATE_BLUE, 45);
        EnumFlowerColor.addMix(OLIVE, BROWN, SIENNA, 80);
        EnumFlowerColor.addMix(OLIVE, CADET_BLUE, OLIVE_DRAB, 95);
        EnumFlowerColor.addMix(OLIVE, CHOCOLATE, DARK_GOLDENROD, 95);
        EnumFlowerColor.addMix(OLIVE, CORAL, PERU, 85);
        EnumFlowerColor.addMix(OLIVE, CRIMSON, SIENNA, 75);
        EnumFlowerColor.addMix(OLIVE, CYAN, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(OLIVE, DARK_GRAY, OLIVE_DRAB, 95);
        EnumFlowerColor.addMix(OLIVE, DARK_GREEN, GREEN, 105);
        EnumFlowerColor.addMix(OLIVE, DARK_KHAKI, OLIVE_DRAB, 110);
        EnumFlowerColor.addMix(OLIVE, DARK_OLIVE_GREEN, OLIVE_DRAB, 110);
        EnumFlowerColor.addMix(OLIVE, DARK_ORANGE, DARK_GOLDENROD, 95);
        EnumFlowerColor.addMix(OLIVE, DARK_SALMON, DARK_GOLDENROD, 90);
        EnumFlowerColor.addMix(OLIVE, DARK_SEA_GREEN, OLIVE_DRAB, 100);
        EnumFlowerColor.addMix(OLIVE, DARK_SLATE_BLUE, DIM_GRAY, 60);
        EnumFlowerColor.addMix(OLIVE, DARK_SLATE_GRAY, DARK_OLIVE_GREEN, 90);
        EnumFlowerColor.addMix(OLIVE, DARK_TURQUOISE, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(OLIVE, DARK_VIOLET, MEDIUM_VIOLET_RED, 50);
        EnumFlowerColor.addMix(OLIVE, DEEP_PINK, INDIAN_RED, 60);
        EnumFlowerColor.addMix(OLIVE, DEEP_SKY_BLUE, MEDIUM_SEA_GREEN, 70);
        EnumFlowerColor.addMix(OLIVE, DIM_GRAY, DARK_OLIVE_GREEN, 100);
        EnumFlowerColor.addMix(OLIVE, DODGER_BLUE, TEAL, 60);
        EnumFlowerColor.addMix(OLIVE, GOLD, GOLDENROD, 95);
        EnumFlowerColor.addMix(OLIVE, GOLDENROD, DARK_GOLDENROD, 105);
        EnumFlowerColor.addMix(OLIVE, GRAY, OLIVE_DRAB, 100);
        EnumFlowerColor.addMix(OLIVE, GREEN, OLIVE_DRAB, 110);
        EnumFlowerColor.addMix(OLIVE, HOT_PINK, INDIAN_RED, 60);
        EnumFlowerColor.addMix(OLIVE, INDIAN_RED, PERU, 80);
        EnumFlowerColor.addMix(OLIVE, KHAKI, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(OLIVE, LAVENDER, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(OLIVE, LEMON_CHIFFON, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(OLIVE, LIGHT_GRAY, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(OLIVE, LIGHT_SEA_GREEN, SEA_GREEN, 90);
        EnumFlowerColor.addMix(OLIVE, LIGHT_STEEL_BLUE, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(OLIVE, LIME, LIME_GREEN, 90);
        EnumFlowerColor.addMix(OLIVE, LIME_GREEN, OLIVE_DRAB, 100);
        EnumFlowerColor.addMix(OLIVE, MAGENTA, MEDIUM_VIOLET_RED, 45);
        EnumFlowerColor.addMix(OLIVE, MAROON, SIENNA, 80);
        EnumFlowerColor.addMix(OLIVE, MEDIUM_AQUAMARINE, OLIVE_DRAB, 95);
        EnumFlowerColor.addMix(OLIVE, MEDIUM_ORCHID, INDIAN_RED, 55);
        EnumFlowerColor.addMix(OLIVE, MEDIUM_PURPLE, GRAY, 60);
        EnumFlowerColor.addMix(OLIVE, MEDIUM_SEA_GREEN, OLIVE_DRAB, 100);
        EnumFlowerColor.addMix(OLIVE, MEDIUM_VIOLET_RED, BROWN, 60);
        EnumFlowerColor.addMix(OLIVE, MISTY_ROSE, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(OLIVE, NAVY, GRAY, 50);
        EnumFlowerColor.addMix(OLIVE_DRAB, AQUAMARINE, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(OLIVE_DRAB, BLACK, DARK_OLIVE_GREEN, 75);
        EnumFlowerColor.addMix(OLIVE_DRAB, BROWN, SIENNA, 70);
        EnumFlowerColor.addMix(OLIVE_DRAB, CADET_BLUE, SEA_GREEN, 95);
        EnumFlowerColor.addMix(OLIVE_DRAB, CHOCOLATE, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(OLIVE_DRAB, CORAL, DARK_GOLDENROD, 75);
        EnumFlowerColor.addMix(OLIVE_DRAB, CRIMSON, SIENNA, 65);
        EnumFlowerColor.addMix(OLIVE_DRAB, CYAN, MEDIUM_AQUAMARINE, 85);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_GOLDENROD, OLIVE, 100);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_GRAY, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_GREEN, GREEN, 105);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_KHAKI, OLIVE, 110);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_OLIVE_GREEN, OLIVE, 115);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_ORANGE, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_SALMON, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_SEA_GREEN, MEDIUM_SEA_GREEN, 110);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_SLATE_BLUE, DIM_GRAY, 55);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_SLATE_GRAY, DARK_OLIVE_GREEN, 90);
        EnumFlowerColor.addMix(OLIVE_DRAB, DARK_TURQUOISE, MEDIUM_SEA_GREEN, 90);
        EnumFlowerColor.addMix(OLIVE_DRAB, DEEP_PINK, INDIAN_RED, 50);
        EnumFlowerColor.addMix(OLIVE_DRAB, DEEP_SKY_BLUE, LIGHT_SEA_GREEN, 70);
        EnumFlowerColor.addMix(OLIVE_DRAB, DIM_GRAY, DARK_OLIVE_GREEN, 100);
        EnumFlowerColor.addMix(OLIVE_DRAB, DODGER_BLUE, CADET_BLUE, 65);
        EnumFlowerColor.addMix(OLIVE_DRAB, GOLD, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(OLIVE_DRAB, GOLDENROD, OLIVE, 100);
        EnumFlowerColor.addMix(OLIVE_DRAB, GRAY, DARK_OLIVE_GREEN, 100);
        EnumFlowerColor.addMix(OLIVE_DRAB, GREEN, SEA_GREEN, 115);
        EnumFlowerColor.addMix(OLIVE_DRAB, HOT_PINK, ROSY_BROWN, 55);
        EnumFlowerColor.addMix(OLIVE_DRAB, INDIAN_RED, DARK_GOLDENROD, 70);
        EnumFlowerColor.addMix(OLIVE_DRAB, KHAKI, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(OLIVE_DRAB, LAVENDER, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(OLIVE_DRAB, LEMON_CHIFFON, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(OLIVE_DRAB, LIGHT_GRAY, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(OLIVE_DRAB, LIGHT_SEA_GREEN, MEDIUM_SEA_GREEN, 95);
        EnumFlowerColor.addMix(OLIVE_DRAB, LIGHT_STEEL_BLUE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(OLIVE_DRAB, LIME, LIME_GREEN, 95);
        EnumFlowerColor.addMix(OLIVE_DRAB, LIME_GREEN, MEDIUM_SEA_GREEN, 105);
        EnumFlowerColor.addMix(OLIVE_DRAB, MAROON, SIENNA, 70);
        EnumFlowerColor.addMix(OLIVE_DRAB, MEDIUM_AQUAMARINE, MEDIUM_SEA_GREEN, 100);
        EnumFlowerColor.addMix(OLIVE_DRAB, MEDIUM_ORCHID, ROSY_BROWN, 50);
        EnumFlowerColor.addMix(OLIVE_DRAB, MEDIUM_PURPLE, GRAY, 55);
        EnumFlowerColor.addMix(OLIVE_DRAB, MEDIUM_SEA_GREEN, SEA_GREEN, 110);
        EnumFlowerColor.addMix(OLIVE_DRAB, MEDIUM_VIOLET_RED, BROWN, 50);
        EnumFlowerColor.addMix(OLIVE_DRAB, MISTY_ROSE, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(ORANGE, AQUAMARINE, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(ORANGE, BLUE, PLUM, 45);
        EnumFlowerColor.addMix(ORANGE, BROWN, CHOCOLATE, 80);
        EnumFlowerColor.addMix(ORANGE, CADET_BLUE, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(ORANGE, CHOCOLATE, DARK_ORANGE, 105);
        EnumFlowerColor.addMix(ORANGE, CORAL, DARK_ORANGE, 105);
        EnumFlowerColor.addMix(ORANGE, CRIMSON, CHOCOLATE, 80);
        EnumFlowerColor.addMix(ORANGE, CYAN, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(ORANGE, DARK_GOLDENROD, GOLDENROD, 110);
        EnumFlowerColor.addMix(ORANGE, DARK_GRAY, GOLDENROD, 95);
        EnumFlowerColor.addMix(ORANGE, DARK_GREEN, OLIVE, 70);
        EnumFlowerColor.addMix(ORANGE, DARK_KHAKI, GOLDENROD, 105);
        EnumFlowerColor.addMix(ORANGE, DARK_OLIVE_GREEN, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(ORANGE, DARK_ORANGE, SANDY_BROWN, 120);
        EnumFlowerColor.addMix(ORANGE, DARK_SALMON, SANDY_BROWN, 105);
        EnumFlowerColor.addMix(ORANGE, DARK_SEA_GREEN, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(ORANGE, DARK_SLATE_BLUE, PERU, 55);
        EnumFlowerColor.addMix(ORANGE, DARK_SLATE_GRAY, DARK_GOLDENROD, 70);
        EnumFlowerColor.addMix(ORANGE, DARK_TURQUOISE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(ORANGE, DARK_VIOLET, INDIAN_RED, 55);
        EnumFlowerColor.addMix(ORANGE, DEEP_PINK, SALMON, 70);
        EnumFlowerColor.addMix(ORANGE, DEEP_SKY_BLUE, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(ORANGE, DIM_GRAY, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(ORANGE, DODGER_BLUE, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(ORANGE, GOLD, GOLDENROD, 110);
        EnumFlowerColor.addMix(ORANGE, GOLDENROD, DARK_GOLDENROD, 120);
        EnumFlowerColor.addMix(ORANGE, GRAY, DARK_GOLDENROD, 90);
        EnumFlowerColor.addMix(ORANGE, GREEN, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(ORANGE, HOT_PINK, CORAL, 75);
        EnumFlowerColor.addMix(ORANGE, INDIAN_RED, PERU, 90);
        EnumFlowerColor.addMix(ORANGE, KHAKI, GOLD, 105);
        EnumFlowerColor.addMix(ORANGE, LAVENDER, TAN, 85);
        EnumFlowerColor.addMix(ORANGE, LEMON_CHIFFON, GOLD, 100);
        EnumFlowerColor.addMix(ORANGE, LIGHT_GRAY, GOLDENROD, 95);
        EnumFlowerColor.addMix(ORANGE, LIGHT_SEA_GREEN, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(ORANGE, LIGHT_STEEL_BLUE, TAN, 85);
        EnumFlowerColor.addMix(ORANGE, LIME, YELLOW_GREEN, 75);
        EnumFlowerColor.addMix(ORANGE, LIME_GREEN, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(ORANGE, MAGENTA, PALE_VIOLET_RED, 60);
        EnumFlowerColor.addMix(ORANGE, MAROON, CHOCOLATE, 70);
        EnumFlowerColor.addMix(ORANGE, MEDIUM_AQUAMARINE, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(ORANGE, MEDIUM_ORCHID, SALMON, 65);
        EnumFlowerColor.addMix(ORANGE, MEDIUM_PURPLE, DARK_SALMON, 65);
        EnumFlowerColor.addMix(ORANGE, MEDIUM_SEA_GREEN, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(ORANGE, MEDIUM_VIOLET_RED, RED, 65);
        EnumFlowerColor.addMix(ORANGE, MISTY_ROSE, SANDY_BROWN, 95);
        EnumFlowerColor.addMix(ORANGE, OLIVE, DARK_GOLDENROD, 95);
        EnumFlowerColor.addMix(ORANGE, OLIVE_DRAB, GOLDENROD, 90);
        EnumFlowerColor.addMix(PALE_GREEN, AQUAMARINE, SPRING_GREEN, 115);
        EnumFlowerColor.addMix(PALE_GREEN, BLUE, STEEL_BLUE, 50);
        EnumFlowerColor.addMix(PALE_GREEN, BROWN, DARK_KHAKI, 45);
        EnumFlowerColor.addMix(PALE_GREEN, CADET_BLUE, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(PALE_GREEN, CHOCOLATE, DARK_KHAKI, 65);
        EnumFlowerColor.addMix(PALE_GREEN, CORAL, DARK_KHAKI, 65);
        EnumFlowerColor.addMix(PALE_GREEN, CYAN, AQUAMARINE, 100);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_GOLDENROD, YELLOW_GREEN, 85);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_GRAY, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_GREEN, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_KHAKI, YELLOW_GREEN, 105);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_OLIVE_GREEN, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_ORANGE, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_SALMON, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_SEA_GREEN, MEDIUM_AQUAMARINE, 110);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_SLATE_BLUE, CADET_BLUE, 55);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_SLATE_GRAY, MEDIUM_SEA_GREEN, 70);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_TURQUOISE, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(PALE_GREEN, DARK_VIOLET, MEDIUM_PURPLE, 55);
        EnumFlowerColor.addMix(PALE_GREEN, DEEP_SKY_BLUE, TURQUOISE, 75);
        EnumFlowerColor.addMix(PALE_GREEN, DIM_GRAY, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(PALE_GREEN, DODGER_BLUE, DARK_TURQUOISE, 65);
        EnumFlowerColor.addMix(PALE_GREEN, GOLD, YELLOW_GREEN, 95);
        EnumFlowerColor.addMix(PALE_GREEN, GOLDENROD, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(PALE_GREEN, GRAY, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(PALE_GREEN, GREEN, LIME_GREEN, 90);
        EnumFlowerColor.addMix(PALE_GREEN, INDIAN_RED, DARK_KHAKI, 55);
        EnumFlowerColor.addMix(PALE_GREEN, KHAKI, YELLOW_GREEN, 105);
        EnumFlowerColor.addMix(PALE_GREEN, LAVENDER, AQUAMARINE, 90);
        EnumFlowerColor.addMix(PALE_GREEN, LIGHT_GRAY, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(PALE_GREEN, LIGHT_SEA_GREEN, MEDIUM_AQUAMARINE, 100);
        EnumFlowerColor.addMix(PALE_GREEN, LIGHT_STEEL_BLUE, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(PALE_GREEN, LIME, SPRING_GREEN, 115);
        EnumFlowerColor.addMix(PALE_GREEN, LIME_GREEN, SPRING_GREEN, 115);
        EnumFlowerColor.addMix(PALE_GREEN, MEDIUM_AQUAMARINE, AQUAMARINE, 110);
        EnumFlowerColor.addMix(PALE_GREEN, MEDIUM_ORCHID, DARK_GRAY, 65);
        EnumFlowerColor.addMix(PALE_GREEN, MEDIUM_PURPLE, CADET_BLUE, 65);
        EnumFlowerColor.addMix(PALE_GREEN, MEDIUM_SEA_GREEN, LIME_GREEN, 110);
        EnumFlowerColor.addMix(PALE_GREEN, MISTY_ROSE, LEMON_CHIFFON, 90);
        EnumFlowerColor.addMix(PALE_GREEN, OLIVE, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(PALE_GREEN, OLIVE_DRAB, LIME_GREEN, 95);
        EnumFlowerColor.addMix(PALE_GREEN, ORANGE, KHAKI, 80);
        EnumFlowerColor.addMix(PALE_TURQUOISE, AQUAMARINE, TURQUOISE, 110);
        EnumFlowerColor.addMix(PALE_TURQUOISE, BLUE, ROYAL_BLUE, 65);
        EnumFlowerColor.addMix(PALE_TURQUOISE, BROWN, ROSY_BROWN, 60);
        EnumFlowerColor.addMix(PALE_TURQUOISE, CADET_BLUE, DARK_TURQUOISE, 105);
        EnumFlowerColor.addMix(PALE_TURQUOISE, CHOCOLATE, TAN, 75);
        EnumFlowerColor.addMix(PALE_TURQUOISE, CORAL, TAN, 80);
        EnumFlowerColor.addMix(PALE_TURQUOISE, CRIMSON, PALE_VIOLET_RED, 65);
        EnumFlowerColor.addMix(PALE_TURQUOISE, CYAN, TURQUOISE, 115);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_GOLDENROD, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_GRAY, SKY_BLUE, 105);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_GREEN, MEDIUM_SEA_GREEN, 75);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_KHAKI, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_OLIVE_GREEN, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_ORANGE, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_SALMON, LIGHT_GRAY, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_SEA_GREEN, MEDIUM_AQUAMARINE, 105);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_SLATE_BLUE, STEEL_BLUE, 65);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_SLATE_GRAY, CADET_BLUE, 75);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_TURQUOISE, TURQUOISE, 115);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DARK_VIOLET, MEDIUM_PURPLE, 75);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DEEP_PINK, PLUM, 75);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DEEP_SKY_BLUE, SKY_BLUE, 105);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DIM_GRAY, CADET_BLUE, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, DODGER_BLUE, DEEP_SKY_BLUE, 90);
        EnumFlowerColor.addMix(PALE_TURQUOISE, GOLD, KHAKI, 90);
        EnumFlowerColor.addMix(PALE_TURQUOISE, GOLDENROD, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, GRAY, CADET_BLUE, 95);
        EnumFlowerColor.addMix(PALE_TURQUOISE, GREEN, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(PALE_TURQUOISE, HOT_PINK, PLUM, 80);
        EnumFlowerColor.addMix(PALE_TURQUOISE, INDIAN_RED, ROSY_BROWN, 70);
        EnumFlowerColor.addMix(PALE_TURQUOISE, INDIGO, MEDIUM_PURPLE, 50);
        EnumFlowerColor.addMix(PALE_TURQUOISE, KHAKI, LEMON_CHIFFON, 95);
        EnumFlowerColor.addMix(PALE_TURQUOISE, LAVENDER, SKY_BLUE, 105);
        EnumFlowerColor.addMix(PALE_TURQUOISE, LIGHT_GRAY, SKY_BLUE, 110);
        EnumFlowerColor.addMix(PALE_TURQUOISE, LIGHT_SEA_GREEN, DARK_TURQUOISE, 110);
        EnumFlowerColor.addMix(PALE_TURQUOISE, LIGHT_STEEL_BLUE, SKY_BLUE, 110);
        EnumFlowerColor.addMix(PALE_TURQUOISE, LIME, SPRING_GREEN, 95);
        EnumFlowerColor.addMix(PALE_TURQUOISE, LIME_GREEN, PALE_GREEN, 95);
        EnumFlowerColor.addMix(PALE_TURQUOISE, MAGENTA, VIOLET, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, MAROON, ROSY_BROWN, 50);
        EnumFlowerColor.addMix(PALE_TURQUOISE, MEDIUM_AQUAMARINE, TURQUOISE, 110);
        EnumFlowerColor.addMix(PALE_TURQUOISE, MEDIUM_ORCHID, PLUM, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, MEDIUM_PURPLE, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, MEDIUM_SEA_GREEN, MEDIUM_AQUAMARINE, 100);
        EnumFlowerColor.addMix(PALE_TURQUOISE, MEDIUM_VIOLET_RED, PLUM, 70);
        EnumFlowerColor.addMix(PALE_TURQUOISE, MISTY_ROSE, LIGHT_GRAY, 95);
        EnumFlowerColor.addMix(PALE_TURQUOISE, OLIVE, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, OLIVE_DRAB, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, ORANGE, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(PALE_TURQUOISE, PALE_GREEN, AQUAMARINE, 100);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, AQUAMARINE, DARK_GRAY, 55);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, BLUE, DARK_VIOLET, 85);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, BROWN, INDIAN_RED, 100);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, CADET_BLUE, ROSY_BROWN, 80);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, CHOCOLATE, INDIAN_RED, 95);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, CORAL, SALMON, 100);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, CRIMSON, INDIAN_RED, 105);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, CYAN, SKY_BLUE, 50);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_GOLDENROD, CHOCOLATE, 80);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_GRAY, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_GREEN, DARK_OLIVE_GREEN, 55);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_KHAKI, DARK_SALMON, 75);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_OLIVE_GREEN, SIENNA, 70);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_ORANGE, CORAL, 85);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_SALMON, SALMON, 105);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_SEA_GREEN, ROSY_BROWN, 70);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_SLATE_BLUE, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_TURQUOISE, CADET_BLUE, 60);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DARK_VIOLET, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DEEP_PINK, HOT_PINK, 115);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DEEP_SKY_BLUE, DODGER_BLUE, 70);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, DODGER_BLUE, MEDIUM_PURPLE, 85);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, GOLD, SANDY_BROWN, 65);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, GOLDENROD, PERU, 80);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, GRAY, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, GREEN, DARK_OLIVE_GREEN, 55);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, HOT_PINK, DEEP_PINK, 120);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, INDIGO, PURPLE, 85);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, KHAKI, DARK_SALMON, 70);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, LAVENDER, THISTLE, 95);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, LEMON_CHIFFON, PINK, 80);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, LIGHT_GRAY, PINK, 95);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, LIGHT_SEA_GREEN, SLATE_GRAY, 65);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, LIGHT_STEEL_BLUE, PLUM, 90);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, LIME_GREEN, DARK_SEA_GREEN, 50);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, MAGENTA, MEDIUM_ORCHID, 105);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, MAROON, BROWN, 90);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, MEDIUM_AQUAMARINE, DARK_GRAY, 60);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, MEDIUM_ORCHID, HOT_PINK, 105);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, MEDIUM_PURPLE, MEDIUM_ORCHID, 100);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, MEDIUM_SEA_GREEN, GRAY, 55);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, MEDIUM_VIOLET_RED, DEEP_PINK, 110);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, MISTY_ROSE, PINK, 95);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, NAVY, PURPLE, 80);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, OLIVE, PERU, 70);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, OLIVE_DRAB, PERU, 65);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, ORANGE, SANDY_BROWN, 80);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, PALE_GREEN, DARK_KHAKI, 55);
        EnumFlowerColor.addMix(PALE_VIOLET_RED, PALE_TURQUOISE, THISTLE, 80);
        EnumFlowerColor.addMix(PERU, AQUAMARINE, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(PERU, BLUE, DARK_SLATE_BLUE, 60);
        EnumFlowerColor.addMix(PERU, BROWN, SIENNA, 95);
        EnumFlowerColor.addMix(PERU, CHOCOLATE, DARK_ORANGE, 120);
        EnumFlowerColor.addMix(PERU, CORAL, CHOCOLATE, 115);
        EnumFlowerColor.addMix(PERU, CRIMSON, INDIAN_RED, 95);
        EnumFlowerColor.addMix(PERU, CYAN, MEDIUM_AQUAMARINE, 75);
        EnumFlowerColor.addMix(PERU, DARK_GOLDENROD, GOLDENROD, 115);
        EnumFlowerColor.addMix(PERU, DARK_GRAY, TAN, 100);
        EnumFlowerColor.addMix(PERU, DARK_GREEN, DARK_OLIVE_GREEN, 80);
        EnumFlowerColor.addMix(PERU, DARK_KHAKI, GOLDENROD, 105);
        EnumFlowerColor.addMix(PERU, DARK_OLIVE_GREEN, OLIVE, 90);
        EnumFlowerColor.addMix(PERU, DARK_ORANGE, SANDY_BROWN, 115);
        EnumFlowerColor.addMix(PERU, DARK_SALMON, SANDY_BROWN, 115);
        EnumFlowerColor.addMix(PERU, DARK_SEA_GREEN, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(PERU, DARK_TURQUOISE, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(PERU, DARK_VIOLET, MEDIUM_VIOLET_RED, 65);
        EnumFlowerColor.addMix(PERU, DEEP_PINK, INDIAN_RED, 85);
        EnumFlowerColor.addMix(PERU, DEEP_SKY_BLUE, CADET_BLUE, 75);
        EnumFlowerColor.addMix(PERU, DODGER_BLUE, SLATE_GRAY, 75);
        EnumFlowerColor.addMix(PERU, GOLD, GOLDENROD, 100);
        EnumFlowerColor.addMix(PERU, GOLDENROD, DARK_GOLDENROD, 110);
        EnumFlowerColor.addMix(PERU, GREEN, OLIVE_DRAB, 80);
        EnumFlowerColor.addMix(PERU, HOT_PINK, SALMON, 85);
        EnumFlowerColor.addMix(PERU, INDIAN_RED, CHOCOLATE, 100);
        EnumFlowerColor.addMix(PERU, INDIGO, MEDIUM_VIOLET_RED, 65);
        EnumFlowerColor.addMix(PERU, KHAKI, GOLDENROD, 95);
        EnumFlowerColor.addMix(PERU, LAVENDER, TAN, 90);
        EnumFlowerColor.addMix(PERU, LEMON_CHIFFON, TAN, 95);
        EnumFlowerColor.addMix(PERU, LIGHT_GRAY, TAN, 95);
        EnumFlowerColor.addMix(PERU, LIGHT_SEA_GREEN, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(PERU, LIGHT_STEEL_BLUE, TAN, 90);
        EnumFlowerColor.addMix(PERU, LIME, LIME_GREEN, 75);
        EnumFlowerColor.addMix(PERU, LIME_GREEN, OLIVE_DRAB, 80);
        EnumFlowerColor.addMix(PERU, MAGENTA, DEEP_PINK, 70);
        EnumFlowerColor.addMix(PERU, MAROON, SIENNA, 90);
        EnumFlowerColor.addMix(PERU, MEDIUM_AQUAMARINE, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(PERU, MEDIUM_ORCHID, PALE_VIOLET_RED, 75);
        EnumFlowerColor.addMix(PERU, MEDIUM_PURPLE, PALE_VIOLET_RED, 75);
        EnumFlowerColor.addMix(PERU, MEDIUM_SEA_GREEN, OLIVE_DRAB, 80);
        EnumFlowerColor.addMix(PERU, MEDIUM_VIOLET_RED, INDIAN_RED, 80);
        EnumFlowerColor.addMix(PERU, MISTY_ROSE, TAN, 95);
        EnumFlowerColor.addMix(PERU, OLIVE, DARK_GOLDENROD, 100);
        EnumFlowerColor.addMix(PERU, OLIVE_DRAB, OLIVE, 95);
        EnumFlowerColor.addMix(PERU, ORANGE, DARK_ORANGE, 115);
        EnumFlowerColor.addMix(PERU, PALE_GREEN, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(PERU, PALE_TURQUOISE, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(PERU, PALE_VIOLET_RED, SALMON, 90);
        EnumFlowerColor.addMix(PINK, AQUAMARINE, PALE_TURQUOISE, 75);
        EnumFlowerColor.addMix(PINK, BLUE, SLATE_BLUE, 70);
        EnumFlowerColor.addMix(PINK, BROWN, INDIAN_RED, 85);
        EnumFlowerColor.addMix(PINK, CADET_BLUE, DARK_GRAY, 80);
        EnumFlowerColor.addMix(PINK, CHOCOLATE, DARK_SALMON, 90);
        EnumFlowerColor.addMix(PINK, CORAL, DARK_SALMON, 100);
        EnumFlowerColor.addMix(PINK, CRIMSON, PALE_VIOLET_RED, 90);
        EnumFlowerColor.addMix(PINK, CYAN, PALE_TURQUOISE, 60);
        EnumFlowerColor.addMix(PINK, DARK_GOLDENROD, SANDY_BROWN, 85);
        EnumFlowerColor.addMix(PINK, DARK_GRAY, THISTLE, 105);
        EnumFlowerColor.addMix(PINK, DARK_GREEN, OLIVE_DRAB, 60);
        EnumFlowerColor.addMix(PINK, DARK_KHAKI, TAN, 90);
        EnumFlowerColor.addMix(PINK, DARK_OLIVE_GREEN, TAN, 70);
        EnumFlowerColor.addMix(PINK, DARK_ORANGE, SANDY_BROWN, 95);
        EnumFlowerColor.addMix(PINK, DARK_SALMON, SALMON, 110);
        EnumFlowerColor.addMix(PINK, DARK_SEA_GREEN, TAN, 80);
        EnumFlowerColor.addMix(PINK, DARK_SLATE_GRAY, GRAY, 65);
        EnumFlowerColor.addMix(PINK, DARK_TURQUOISE, SKY_BLUE, 65);
        EnumFlowerColor.addMix(PINK, DARK_VIOLET, MEDIUM_ORCHID, 80);
        EnumFlowerColor.addMix(PINK, DEEP_PINK, HOT_PINK, 100);
        EnumFlowerColor.addMix(PINK, DEEP_SKY_BLUE, SKY_BLUE, 80);
        EnumFlowerColor.addMix(PINK, DIM_GRAY, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(PINK, DODGER_BLUE, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(PINK, GOLD, GOLDENROD, 80);
        EnumFlowerColor.addMix(PINK, GOLDENROD, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(PINK, GRAY, ROSY_BROWN, 95);
        EnumFlowerColor.addMix(PINK, GREEN, DARK_SEA_GREEN, 60);
        EnumFlowerColor.addMix(PINK, HOT_PINK, PALE_VIOLET_RED, 105);
        EnumFlowerColor.addMix(PINK, INDIAN_RED, SALMON, 100);
        EnumFlowerColor.addMix(PINK, INDIGO, MEDIUM_ORCHID, 60);
        EnumFlowerColor.addMix(PINK, KHAKI, WHEAT, 90);
        EnumFlowerColor.addMix(PINK, LAVENDER, THISTLE, 105);
        EnumFlowerColor.addMix(PINK, LEMON_CHIFFON, MISTY_ROSE, 95);
        EnumFlowerColor.addMix(PINK, LIGHT_GRAY, MISTY_ROSE, 105);
        EnumFlowerColor.addMix(PINK, LIGHT_SEA_GREEN, CADET_BLUE, 70);
        EnumFlowerColor.addMix(PINK, LIGHT_STEEL_BLUE, THISTLE, 100);
        EnumFlowerColor.addMix(PINK, LIME, LIME_GREEN, 60);
        EnumFlowerColor.addMix(PINK, LIME_GREEN, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(PINK, MAGENTA, VIOLET, 95);
        EnumFlowerColor.addMix(PINK, MAROON, INDIAN_RED, 65);
        EnumFlowerColor.addMix(PINK, MEDIUM_AQUAMARINE, LIGHT_GRAY, 75);
        EnumFlowerColor.addMix(PINK, MEDIUM_ORCHID, PLUM, 95);
        EnumFlowerColor.addMix(PINK, MEDIUM_PURPLE, PLUM, 95);
        EnumFlowerColor.addMix(PINK, MEDIUM_SEA_GREEN, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(PINK, MEDIUM_VIOLET_RED, HOT_PINK, 90);
        EnumFlowerColor.addMix(PINK, MISTY_ROSE, THISTLE, 115);
        EnumFlowerColor.addMix(PINK, NAVY, SLATE_BLUE, 50);
        EnumFlowerColor.addMix(PINK, OLIVE, TAN, 75);
        EnumFlowerColor.addMix(PINK, OLIVE_DRAB, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(PINK, ORANGE, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(PINK, PALE_GREEN, LEMON_CHIFFON, 70);
        EnumFlowerColor.addMix(PINK, PALE_TURQUOISE, LIGHT_GRAY, 80);
        EnumFlowerColor.addMix(PINK, PALE_VIOLET_RED, HOT_PINK, 105);
        EnumFlowerColor.addMix(PINK, PERU, DARK_SALMON, 95);
        EnumFlowerColor.addMix(PLUM, AQUAMARINE, SKY_BLUE, 80);
        EnumFlowerColor.addMix(PLUM, BLUE, SLATE_BLUE, 80);
        EnumFlowerColor.addMix(PLUM, BROWN, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(PLUM, CADET_BLUE, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(PLUM, CHOCOLATE, SALMON, 85);
        EnumFlowerColor.addMix(PLUM, CORAL, SALMON, 90);
        EnumFlowerColor.addMix(PLUM, CRIMSON, PALE_VIOLET_RED, 90);
        EnumFlowerColor.addMix(PLUM, CYAN, SKY_BLUE, 75);
        EnumFlowerColor.addMix(PLUM, DARK_GOLDENROD, DARK_SALMON, 75);
        EnumFlowerColor.addMix(PLUM, DARK_GRAY, THISTLE, 105);
        EnumFlowerColor.addMix(PLUM, DARK_KHAKI, ROSY_BROWN, 75);
        EnumFlowerColor.addMix(PLUM, DARK_OLIVE_GREEN, ROSY_BROWN, 65);
        EnumFlowerColor.addMix(PLUM, DARK_ORANGE, DARK_SALMON, 80);
        EnumFlowerColor.addMix(PLUM, DARK_SALMON, PINK, 95);
        EnumFlowerColor.addMix(PLUM, DARK_SEA_GREEN, DARK_GRAY, 70);
        EnumFlowerColor.addMix(PLUM, DARK_SLATE_BLUE, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(PLUM, DARK_TURQUOISE, SKY_BLUE, 80);
        EnumFlowerColor.addMix(PLUM, DARK_VIOLET, MEDIUM_ORCHID, 90);
        EnumFlowerColor.addMix(PLUM, DEEP_PINK, HOT_PINK, 105);
        EnumFlowerColor.addMix(PLUM, DEEP_SKY_BLUE, DODGER_BLUE, 80);
        EnumFlowerColor.addMix(PLUM, GOLD, TAN, 65);
        EnumFlowerColor.addMix(PLUM, GOLDENROD, DARK_SALMON, 75);
        EnumFlowerColor.addMix(PLUM, GRAY, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(PLUM, GREEN, SEA_GREEN, 50);
        EnumFlowerColor.addMix(PLUM, HOT_PINK, VIOLET, 115);
        EnumFlowerColor.addMix(PLUM, INDIAN_RED, PALE_VIOLET_RED, 95);
        EnumFlowerColor.addMix(PLUM, INDIGO, MEDIUM_ORCHID, 70);
        EnumFlowerColor.addMix(PLUM, KHAKI, MISTY_ROSE, 70);
        EnumFlowerColor.addMix(PLUM, LAVENDER, THISTLE, 105);
        EnumFlowerColor.addMix(PLUM, LEMON_CHIFFON, MISTY_ROSE, 80);
        EnumFlowerColor.addMix(PLUM, LIGHT_GRAY, THISTLE, 100);
        EnumFlowerColor.addMix(PLUM, LIGHT_SEA_GREEN, SKY_BLUE, 80);
        EnumFlowerColor.addMix(PLUM, LIGHT_STEEL_BLUE, THISTLE, 105);
        EnumFlowerColor.addMix(PLUM, LIME, LIME_GREEN, 45);
        EnumFlowerColor.addMix(PLUM, LIME_GREEN, DARK_SEA_GREEN, 50);
        EnumFlowerColor.addMix(PLUM, MAGENTA, VIOLET, 105);
        EnumFlowerColor.addMix(PLUM, MAROON, MEDIUM_VIOLET_RED, 70);
        EnumFlowerColor.addMix(PLUM, MEDIUM_AQUAMARINE, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(PLUM, MEDIUM_ORCHID, VIOLET, 105);
        EnumFlowerColor.addMix(PLUM, MEDIUM_PURPLE, VIOLET, 105);
        EnumFlowerColor.addMix(PLUM, MEDIUM_SEA_GREEN, CADET_BLUE, 80);
        EnumFlowerColor.addMix(PLUM, MEDIUM_VIOLET_RED, MEDIUM_ORCHID, 100);
        EnumFlowerColor.addMix(PLUM, MISTY_ROSE, THISTLE, 105);
        EnumFlowerColor.addMix(PLUM, NAVY, SLATE_BLUE, 65);
        EnumFlowerColor.addMix(PLUM, OLIVE, TAN, 65);
        EnumFlowerColor.addMix(PLUM, OLIVE_DRAB, TAN, 60);
        EnumFlowerColor.addMix(PLUM, ORANGE, SANDY_BROWN, 75);
        EnumFlowerColor.addMix(PLUM, PALE_GREEN, DARK_SEA_GREEN, 55);
        EnumFlowerColor.addMix(PLUM, PALE_TURQUOISE, LAVENDER, 90);
        EnumFlowerColor.addMix(PLUM, PALE_VIOLET_RED, HOT_PINK, 110);
        EnumFlowerColor.addMix(PLUM, PERU, ROSY_BROWN, 85);
        EnumFlowerColor.addMix(PLUM, PINK, THISTLE, 110);
        EnumFlowerColor.addMix(PURPLE, AQUAMARINE, MEDIUM_PURPLE, 50);
        EnumFlowerColor.addMix(PURPLE, BLACK, INDIGO, 95);
        EnumFlowerColor.addMix(PURPLE, BLUE, INDIGO, 105);
        EnumFlowerColor.addMix(PURPLE, BROWN, MEDIUM_VIOLET_RED, 95);
        EnumFlowerColor.addMix(PURPLE, CADET_BLUE, DARK_SLATE_BLUE, 80);
        EnumFlowerColor.addMix(PURPLE, CHOCOLATE, BROWN, 75);
        EnumFlowerColor.addMix(PURPLE, CORAL, MEDIUM_VIOLET_RED, 70);
        EnumFlowerColor.addMix(PURPLE, CRIMSON, MEDIUM_VIOLET_RED, 95);
        EnumFlowerColor.addMix(PURPLE, CYAN, STEEL_BLUE, 50);
        EnumFlowerColor.addMix(PURPLE, DARK_GOLDENROD, BROWN, 60);
        EnumFlowerColor.addMix(PURPLE, DARK_GRAY, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(PURPLE, DARK_ORANGE, CRIMSON, 60);
        EnumFlowerColor.addMix(PURPLE, DARK_SALMON, MEDIUM_VIOLET_RED, 75);
        EnumFlowerColor.addMix(PURPLE, DARK_SLATE_BLUE, INDIGO, 110);
        EnumFlowerColor.addMix(PURPLE, DARK_SLATE_GRAY, INDIGO, 105);
        EnumFlowerColor.addMix(PURPLE, DARK_TURQUOISE, ROYAL_BLUE, 60);
        EnumFlowerColor.addMix(PURPLE, DARK_VIOLET, INDIGO, 115);
        EnumFlowerColor.addMix(PURPLE, DEEP_PINK, MEDIUM_VIOLET_RED, 100);
        EnumFlowerColor.addMix(PURPLE, DEEP_SKY_BLUE, ROYAL_BLUE, 60);
        EnumFlowerColor.addMix(PURPLE, DODGER_BLUE, SLATE_BLUE, 80);
        EnumFlowerColor.addMix(PURPLE, GOLDENROD, INDIAN_RED, 50);
        EnumFlowerColor.addMix(PURPLE, HOT_PINK, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(PURPLE, INDIAN_RED, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(PURPLE, LAVENDER, MEDIUM_ORCHID, 65);
        EnumFlowerColor.addMix(PURPLE, LEMON_CHIFFON, PALE_VIOLET_RED, 50);
        EnumFlowerColor.addMix(PURPLE, LIGHT_GRAY, MEDIUM_ORCHID, 70);
        EnumFlowerColor.addMix(PURPLE, LIGHT_SEA_GREEN, DARK_SLATE_BLUE, 65);
        EnumFlowerColor.addMix(PURPLE, LIGHT_STEEL_BLUE, MEDIUM_ORCHID, 70);
        EnumFlowerColor.addMix(PURPLE, MAGENTA, DARK_VIOLET, 95);
        EnumFlowerColor.addMix(PURPLE, MEDIUM_AQUAMARINE, SLATE_BLUE, 60);
        EnumFlowerColor.addMix(PURPLE, MEDIUM_ORCHID, DARK_VIOLET, 105);
        EnumFlowerColor.addMix(PURPLE, MEDIUM_PURPLE, DARK_VIOLET, 100);
        EnumFlowerColor.addMix(PURPLE, MISTY_ROSE, PALE_VIOLET_RED, 65);
        EnumFlowerColor.addMix(PURPLE, NAVY, INDIGO, 110);
        EnumFlowerColor.addMix(PURPLE, OLIVE, BROWN, 55);
        EnumFlowerColor.addMix(PURPLE, ORANGE, INDIAN_RED, 50);
        EnumFlowerColor.addMix(PURPLE, PALE_TURQUOISE, MEDIUM_PURPLE, 65);
        EnumFlowerColor.addMix(PURPLE, PALE_VIOLET_RED, MEDIUM_VIOLET_RED, 95);
        EnumFlowerColor.addMix(PURPLE, PERU, MEDIUM_VIOLET_RED, 70);
        EnumFlowerColor.addMix(PURPLE, PINK, MEDIUM_ORCHID, 70);
        EnumFlowerColor.addMix(PURPLE, PLUM, MEDIUM_ORCHID, 80);
        EnumFlowerColor.addMix(RED, AQUAMARINE, DARK_SALMON, 50);
        EnumFlowerColor.addMix(RED, BLACK, MAROON, 75);
        EnumFlowerColor.addMix(RED, BLUE, MAGENTA, 70);
        EnumFlowerColor.addMix(RED, BROWN, CRIMSON, 110);
        EnumFlowerColor.addMix(RED, CADET_BLUE, INDIAN_RED, 75);
        EnumFlowerColor.addMix(RED, CRIMSON, INDIAN_RED, 115);
        EnumFlowerColor.addMix(RED, DARK_GOLDENROD, CHOCOLATE, 90);
        EnumFlowerColor.addMix(RED, DARK_GRAY, INDIAN_RED, 90);
        EnumFlowerColor.addMix(RED, DARK_GREEN, MAROON, 55);
        EnumFlowerColor.addMix(RED, DARK_KHAKI, CHOCOLATE, 80);
        EnumFlowerColor.addMix(RED, DARK_OLIVE_GREEN, BROWN, 70);
        EnumFlowerColor.addMix(RED, DARK_ORANGE, CORAL, 100);
        EnumFlowerColor.addMix(RED, DARK_SALMON, INDIAN_RED, 105);
        EnumFlowerColor.addMix(RED, DARK_SEA_GREEN, INDIAN_RED, 65);
        EnumFlowerColor.addMix(RED, DARK_SLATE_BLUE, BROWN, 80);
        EnumFlowerColor.addMix(RED, DARK_SLATE_GRAY, BROWN, 75);
        EnumFlowerColor.addMix(RED, DARK_TURQUOISE, DIM_GRAY, 60);
        EnumFlowerColor.addMix(RED, DARK_VIOLET, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(RED, DEEP_PINK, CRIMSON, 95);
        EnumFlowerColor.addMix(RED, DEEP_SKY_BLUE, PLUM, 60);
        EnumFlowerColor.addMix(RED, DIM_GRAY, BROWN, 95);
        EnumFlowerColor.addMix(RED, DODGER_BLUE, MEDIUM_VIOLET_RED, 75);
        EnumFlowerColor.addMix(RED, GOLD, CHOCOLATE, 75);
        EnumFlowerColor.addMix(RED, GOLDENROD, CHOCOLATE, 85);
        EnumFlowerColor.addMix(RED, GRAY, CRIMSON, 95);
        EnumFlowerColor.addMix(RED, GREEN, SIENNA, 50);
        EnumFlowerColor.addMix(RED, HOT_PINK, INDIAN_RED, 95);
        EnumFlowerColor.addMix(RED, INDIAN_RED, CRIMSON, 110);
        EnumFlowerColor.addMix(RED, INDIGO, BROWN, 75);
        EnumFlowerColor.addMix(RED, KHAKI, CORAL, 75);
        EnumFlowerColor.addMix(RED, LAVENDER, SALMON, 80);
        EnumFlowerColor.addMix(RED, LEMON_CHIFFON, SALMON, 75);
        EnumFlowerColor.addMix(RED, LIGHT_GRAY, INDIAN_RED, 85);
        EnumFlowerColor.addMix(RED, LIGHT_SEA_GREEN, SIENNA, 60);
        EnumFlowerColor.addMix(RED, LIGHT_STEEL_BLUE, INDIAN_RED, 80);
        EnumFlowerColor.addMix(RED, MAGENTA, DEEP_PINK, 85);
        EnumFlowerColor.addMix(RED, MAROON, BROWN, 100);
        EnumFlowerColor.addMix(RED, MEDIUM_AQUAMARINE, INDIAN_RED, 60);
        EnumFlowerColor.addMix(RED, MEDIUM_ORCHID, DEEP_PINK, 85);
        EnumFlowerColor.addMix(RED, MEDIUM_PURPLE, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(RED, MEDIUM_SEA_GREEN, SIENNA, 55);
        EnumFlowerColor.addMix(RED, MEDIUM_VIOLET_RED, CRIMSON, 95);
        EnumFlowerColor.addMix(RED, MISTY_ROSE, SALMON, 85);
        EnumFlowerColor.addMix(RED, OLIVE, SIENNA, 75);
        EnumFlowerColor.addMix(RED, OLIVE_DRAB, SIENNA, 65);
        EnumFlowerColor.addMix(RED, ORANGE, CORAL, 90);
        EnumFlowerColor.addMix(RED, PALE_GREEN, PERU, 50);
        EnumFlowerColor.addMix(RED, PALE_TURQUOISE, INDIAN_RED, 65);
        EnumFlowerColor.addMix(RED, PALE_VIOLET_RED, CRIMSON, 100);
        EnumFlowerColor.addMix(RED, PERU, CHOCOLATE, 105);
        EnumFlowerColor.addMix(RED, PINK, SALMON, 90);
        EnumFlowerColor.addMix(RED, PLUM, INDIAN_RED, 85);
        EnumFlowerColor.addMix(RED, PURPLE, CRIMSON, 80);
        EnumFlowerColor.addMix(ROSY_BROWN, AQUAMARINE, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(ROSY_BROWN, BLUE, SLATE_BLUE, 80);
        EnumFlowerColor.addMix(ROSY_BROWN, BROWN, INDIAN_RED, 95);
        EnumFlowerColor.addMix(ROSY_BROWN, CADET_BLUE, DARK_GRAY, 90);
        EnumFlowerColor.addMix(ROSY_BROWN, CHOCOLATE, PERU, 105);
        EnumFlowerColor.addMix(ROSY_BROWN, CORAL, DARK_SALMON, 105);
        EnumFlowerColor.addMix(ROSY_BROWN, CRIMSON, INDIAN_RED, 100);
        EnumFlowerColor.addMix(ROSY_BROWN, CYAN, DARK_TURQUOISE, 75);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_GOLDENROD, PERU, 95);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_GREEN, DARK_OLIVE_GREEN, 75);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_KHAKI, TAN, 95);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_ORANGE, PERU, 100);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_SALMON, SALMON, 115);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_SEA_GREEN, DARK_GRAY, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_SLATE_GRAY, DIM_GRAY, 80);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_TURQUOISE, CADET_BLUE, 80);
        EnumFlowerColor.addMix(ROSY_BROWN, DARK_VIOLET, MEDIUM_ORCHID, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, DEEP_PINK, PALE_VIOLET_RED, 105);
        EnumFlowerColor.addMix(ROSY_BROWN, DEEP_SKY_BLUE, SKY_BLUE, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, DIM_GRAY, GRAY, 100);
        EnumFlowerColor.addMix(ROSY_BROWN, DODGER_BLUE, STEEL_BLUE, 90);
        EnumFlowerColor.addMix(ROSY_BROWN, GOLD, GOLDENROD, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, GOLDENROD, PERU, 95);
        EnumFlowerColor.addMix(ROSY_BROWN, GREEN, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(ROSY_BROWN, HOT_PINK, PALE_VIOLET_RED, 105);
        EnumFlowerColor.addMix(ROSY_BROWN, INDIAN_RED, PALE_VIOLET_RED, 110);
        EnumFlowerColor.addMix(ROSY_BROWN, INDIGO, PURPLE, 80);
        EnumFlowerColor.addMix(ROSY_BROWN, KHAKI, TAN, 90);
        EnumFlowerColor.addMix(ROSY_BROWN, LAVENDER, THISTLE, 100);
        EnumFlowerColor.addMix(ROSY_BROWN, LEMON_CHIFFON, TAN, 90);
        EnumFlowerColor.addMix(ROSY_BROWN, LIGHT_GRAY, DARK_GRAY, 105);
        EnumFlowerColor.addMix(ROSY_BROWN, LIGHT_SEA_GREEN, CADET_BLUE, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, LIGHT_STEEL_BLUE, THISTLE, 100);
        EnumFlowerColor.addMix(ROSY_BROWN, LIME, LIME_GREEN, 65);
        EnumFlowerColor.addMix(ROSY_BROWN, LIME_GREEN, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(ROSY_BROWN, MAGENTA, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(ROSY_BROWN, MAROON, BROWN, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, MEDIUM_AQUAMARINE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(ROSY_BROWN, MEDIUM_ORCHID, PALE_VIOLET_RED, 100);
        EnumFlowerColor.addMix(ROSY_BROWN, MEDIUM_PURPLE, PLUM, 100);
        EnumFlowerColor.addMix(ROSY_BROWN, MEDIUM_SEA_GREEN, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(ROSY_BROWN, MEDIUM_VIOLET_RED, DEEP_PINK, 100);
        EnumFlowerColor.addMix(ROSY_BROWN, MISTY_ROSE, PINK, 105);
        EnumFlowerColor.addMix(ROSY_BROWN, NAVY, DARK_SLATE_BLUE, 75);
        EnumFlowerColor.addMix(ROSY_BROWN, OLIVE, DARK_GOLDENROD, 90);
        EnumFlowerColor.addMix(ROSY_BROWN, OLIVE_DRAB, OLIVE, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, ORANGE, SANDY_BROWN, 95);
        EnumFlowerColor.addMix(ROSY_BROWN, PALE_GREEN, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(ROSY_BROWN, PALE_TURQUOISE, DARK_GRAY, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, PALE_VIOLET_RED, HOT_PINK, 115);
        EnumFlowerColor.addMix(ROSY_BROWN, PERU, DARK_SALMON, 105);
        EnumFlowerColor.addMix(ROSY_BROWN, PINK, THISTLE, 110);
        EnumFlowerColor.addMix(ROSY_BROWN, PLUM, THISTLE, 105);
        EnumFlowerColor.addMix(ROSY_BROWN, PURPLE, MEDIUM_VIOLET_RED, 85);
        EnumFlowerColor.addMix(ROSY_BROWN, RED, INDIAN_RED, 100);
        EnumFlowerColor.addMix(ROYAL_BLUE, AQUAMARINE, DEEP_SKY_BLUE, 70);
        EnumFlowerColor.addMix(ROYAL_BLUE, BLACK, DARK_SLATE_BLUE, 80);
        EnumFlowerColor.addMix(ROYAL_BLUE, BLUE, SLATE_BLUE, 105);
        EnumFlowerColor.addMix(ROYAL_BLUE, BROWN, DARK_SLATE_BLUE, 85);
        EnumFlowerColor.addMix(ROYAL_BLUE, CADET_BLUE, STEEL_BLUE, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, CRIMSON, PURPLE, 85);
        EnumFlowerColor.addMix(ROYAL_BLUE, CYAN, DEEP_SKY_BLUE, 75);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_GOLDENROD, GRAY, 65);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_GRAY, STEEL_BLUE, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_GREEN, DARK_SLATE_GRAY, 70);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_KHAKI, SLATE_GRAY, 60);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_OLIVE_GREEN, STEEL_BLUE, 70);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_ORANGE, ROSY_BROWN, 65);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_SALMON, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_SEA_GREEN, STEEL_BLUE, 75);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_SLATE_BLUE, SLATE_BLUE, 110);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_SLATE_GRAY, SLATE_BLUE, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_TURQUOISE, DODGER_BLUE, 85);
        EnumFlowerColor.addMix(ROYAL_BLUE, DARK_VIOLET, BLUE, 105);
        EnumFlowerColor.addMix(ROYAL_BLUE, DEEP_PINK, DARK_VIOLET, 90);
        EnumFlowerColor.addMix(ROYAL_BLUE, DEEP_SKY_BLUE, DODGER_BLUE, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, DIM_GRAY, SLATE_BLUE, 100);
        EnumFlowerColor.addMix(ROYAL_BLUE, DODGER_BLUE, STEEL_BLUE, 110);
        EnumFlowerColor.addMix(ROYAL_BLUE, GOLD, DARK_KHAKI, 50);
        EnumFlowerColor.addMix(ROYAL_BLUE, GOLDENROD, GRAY, 60);
        EnumFlowerColor.addMix(ROYAL_BLUE, GRAY, STEEL_BLUE, 100);
        EnumFlowerColor.addMix(ROYAL_BLUE, GREEN, TEAL, 65);
        EnumFlowerColor.addMix(ROYAL_BLUE, HOT_PINK, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(ROYAL_BLUE, INDIAN_RED, MEDIUM_PURPLE, 85);
        EnumFlowerColor.addMix(ROYAL_BLUE, INDIGO, DARK_SLATE_BLUE, 100);
        EnumFlowerColor.addMix(ROYAL_BLUE, KHAKI, DARK_GRAY, 55);
        EnumFlowerColor.addMix(ROYAL_BLUE, LAVENDER, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(ROYAL_BLUE, LEMON_CHIFFON, LIGHT_STEEL_BLUE, 65);
        EnumFlowerColor.addMix(ROYAL_BLUE, LIGHT_GRAY, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(ROYAL_BLUE, LIGHT_SEA_GREEN, STEEL_BLUE, 85);
        EnumFlowerColor.addMix(ROYAL_BLUE, LIGHT_STEEL_BLUE, DODGER_BLUE, 100);
        EnumFlowerColor.addMix(ROYAL_BLUE, LIME, MEDIUM_SEA_GREEN, 55);
        EnumFlowerColor.addMix(ROYAL_BLUE, LIME_GREEN, LIGHT_SEA_GREEN, 60);
        EnumFlowerColor.addMix(ROYAL_BLUE, MAGENTA, DARK_VIOLET, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, MAROON, PURPLE, 80);
        EnumFlowerColor.addMix(ROYAL_BLUE, MEDIUM_AQUAMARINE, DODGER_BLUE, 80);
        EnumFlowerColor.addMix(ROYAL_BLUE, MEDIUM_ORCHID, SLATE_BLUE, 105);
        EnumFlowerColor.addMix(ROYAL_BLUE, MEDIUM_PURPLE, SLATE_BLUE, 115);
        EnumFlowerColor.addMix(ROYAL_BLUE, MEDIUM_SEA_GREEN, STEEL_BLUE, 75);
        EnumFlowerColor.addMix(ROYAL_BLUE, MEDIUM_VIOLET_RED, DARK_VIOLET, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, MISTY_ROSE, LIGHT_STEEL_BLUE, 80);
        EnumFlowerColor.addMix(ROYAL_BLUE, NAVY, DARK_SLATE_BLUE, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, OLIVE, DIM_GRAY, 60);
        EnumFlowerColor.addMix(ROYAL_BLUE, OLIVE_DRAB, SLATE_GRAY, 65);
        EnumFlowerColor.addMix(ROYAL_BLUE, PALE_GREEN, CADET_BLUE, 60);
        EnumFlowerColor.addMix(ROYAL_BLUE, PALE_TURQUOISE, DODGER_BLUE, 80);
        EnumFlowerColor.addMix(ROYAL_BLUE, PALE_VIOLET_RED, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(ROYAL_BLUE, PINK, MEDIUM_PURPLE, 85);
        EnumFlowerColor.addMix(ROYAL_BLUE, PLUM, MEDIUM_PURPLE, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, PURPLE, DARK_SLATE_BLUE, 95);
        EnumFlowerColor.addMix(ROYAL_BLUE, RED, MEDIUM_VIOLET_RED, 75);
        EnumFlowerColor.addMix(ROYAL_BLUE, ROSY_BROWN, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(SALMON, AQUAMARINE, DARK_KHAKI, 60);
        EnumFlowerColor.addMix(SALMON, BLACK, BROWN, 65);
        EnumFlowerColor.addMix(SALMON, BLUE, DARK_VIOLET, 70);
        EnumFlowerColor.addMix(SALMON, BROWN, INDIAN_RED, 95);
        EnumFlowerColor.addMix(SALMON, CADET_BLUE, ROSY_BROWN, 80);
        EnumFlowerColor.addMix(SALMON, CHOCOLATE, CORAL, 110);
        EnumFlowerColor.addMix(SALMON, CORAL, DARK_SALMON, 120);
        EnumFlowerColor.addMix(SALMON, CRIMSON, INDIAN_RED, 105);
        EnumFlowerColor.addMix(SALMON, CYAN, LIGHT_SEA_GREEN, 65);
        EnumFlowerColor.addMix(SALMON, DARK_GOLDENROD, PERU, 95);
        EnumFlowerColor.addMix(SALMON, DARK_GRAY, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(SALMON, DARK_GREEN, OLIVE, 60);
        EnumFlowerColor.addMix(SALMON, DARK_KHAKI, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(SALMON, DARK_OLIVE_GREEN, PERU, 75);
        EnumFlowerColor.addMix(SALMON, DARK_ORANGE, CORAL, 105);
        EnumFlowerColor.addMix(SALMON, DARK_SALMON, CORAL, 120);
        EnumFlowerColor.addMix(SALMON, DARK_SEA_GREEN, TAN, 75);
        EnumFlowerColor.addMix(SALMON, DARK_SLATE_BLUE, MEDIUM_VIOLET_RED, 75);
        EnumFlowerColor.addMix(SALMON, DARK_TURQUOISE, CADET_BLUE, 70);
        EnumFlowerColor.addMix(SALMON, DARK_VIOLET, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(SALMON, DEEP_PINK, PALE_VIOLET_RED, 105);
        EnumFlowerColor.addMix(SALMON, DEEP_SKY_BLUE, SLATE_GRAY, 70);
        EnumFlowerColor.addMix(SALMON, DIM_GRAY, INDIAN_RED, 95);
        EnumFlowerColor.addMix(SALMON, DODGER_BLUE, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(SALMON, GOLD, ORANGE, 80);
        EnumFlowerColor.addMix(SALMON, GOLDENROD, SANDY_BROWN, 95);
        EnumFlowerColor.addMix(SALMON, GRAY, ROSY_BROWN, 100);
        EnumFlowerColor.addMix(SALMON, GREEN, OLIVE, 60);
        EnumFlowerColor.addMix(SALMON, HOT_PINK, PALE_VIOLET_RED, 105);
        EnumFlowerColor.addMix(SALMON, INDIAN_RED, DARK_SALMON, 115);
        EnumFlowerColor.addMix(SALMON, INDIGO, MEDIUM_VIOLET_RED, 70);
        EnumFlowerColor.addMix(SALMON, KHAKI, SANDY_BROWN, 85);
        EnumFlowerColor.addMix(SALMON, LAVENDER, PINK, 95);
        EnumFlowerColor.addMix(SALMON, LEMON_CHIFFON, DARK_SALMON, 85);
        EnumFlowerColor.addMix(SALMON, LIGHT_GRAY, DARK_SALMON, 100);
        EnumFlowerColor.addMix(SALMON, LIGHT_SEA_GREEN, DARK_GRAY, 70);
        EnumFlowerColor.addMix(SALMON, LIGHT_STEEL_BLUE, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(SALMON, LIME, YELLOW_GREEN, 50);
        EnumFlowerColor.addMix(SALMON, LIME_GREEN, DARK_KHAKI, 55);
        EnumFlowerColor.addMix(SALMON, MAGENTA, HOT_PINK, 90);
        EnumFlowerColor.addMix(SALMON, MAROON, CRIMSON, 85);
        EnumFlowerColor.addMix(SALMON, MEDIUM_AQUAMARINE, TAN, 70);
        EnumFlowerColor.addMix(SALMON, MEDIUM_ORCHID, PALE_VIOLET_RED, 90);
        EnumFlowerColor.addMix(SALMON, MEDIUM_PURPLE, PALE_VIOLET_RED, 90);
        EnumFlowerColor.addMix(SALMON, MEDIUM_SEA_GREEN, DARK_KHAKI, 65);
        EnumFlowerColor.addMix(SALMON, MEDIUM_VIOLET_RED, DEEP_PINK, 95);
        EnumFlowerColor.addMix(SALMON, MISTY_ROSE, PINK, 100);
        EnumFlowerColor.addMix(SALMON, NAVY, PURPLE, 65);
        EnumFlowerColor.addMix(SALMON, OLIVE, PERU, 80);
        EnumFlowerColor.addMix(SALMON, OLIVE_DRAB, PERU, 75);
        EnumFlowerColor.addMix(SALMON, ORANGE, DARK_ORANGE, 95);
        EnumFlowerColor.addMix(SALMON, PALE_GREEN, DARK_KHAKI, 60);
        EnumFlowerColor.addMix(SALMON, PALE_TURQUOISE, MISTY_ROSE, 80);
        EnumFlowerColor.addMix(SALMON, PALE_VIOLET_RED, INDIAN_RED, 110);
        EnumFlowerColor.addMix(SALMON, PERU, CORAL, 105);
        EnumFlowerColor.addMix(SALMON, PINK, DARK_SALMON, 110);
        EnumFlowerColor.addMix(SALMON, PLUM, PALE_VIOLET_RED, 100);
        EnumFlowerColor.addMix(SALMON, PURPLE, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(SALMON, RED, INDIAN_RED, 110);
        EnumFlowerColor.addMix(SALMON, ROSY_BROWN, DARK_SALMON, 110);
        EnumFlowerColor.addMix(SALMON, ROYAL_BLUE, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(SANDY_BROWN, AQUAMARINE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SANDY_BROWN, BLACK, SIENNA, 60);
        EnumFlowerColor.addMix(SANDY_BROWN, BLUE, SLATE_BLUE, 55);
        EnumFlowerColor.addMix(SANDY_BROWN, BROWN, CHOCOLATE, 85);
        EnumFlowerColor.addMix(SANDY_BROWN, CADET_BLUE, TAN, 85);
        EnumFlowerColor.addMix(SANDY_BROWN, CHOCOLATE, PERU, 110);
        EnumFlowerColor.addMix(SANDY_BROWN, CORAL, DARK_SALMON, 115);
        EnumFlowerColor.addMix(SANDY_BROWN, CRIMSON, INDIAN_RED, 90);
        EnumFlowerColor.addMix(SANDY_BROWN, CYAN, MEDIUM_AQUAMARINE, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_GOLDENROD, PERU, 110);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_GRAY, TAN, 100);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_GREEN, OLIVE, 70);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_KHAKI, TAN, 105);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_OLIVE_GREEN, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_ORANGE, ORANGE, 120);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_SALMON, CORAL, 115);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_SEA_GREEN, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_SLATE_BLUE, ROSY_BROWN, 65);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_TURQUOISE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SANDY_BROWN, DARK_VIOLET, MEDIUM_VIOLET_RED, 65);
        EnumFlowerColor.addMix(SANDY_BROWN, DEEP_PINK, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(SANDY_BROWN, DEEP_SKY_BLUE, CADET_BLUE, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, DIM_GRAY, PERU, 90);
        EnumFlowerColor.addMix(SANDY_BROWN, DODGER_BLUE, SLATE_GRAY, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, GOLD, GOLDENROD, 105);
        EnumFlowerColor.addMix(SANDY_BROWN, GOLDENROD, ORANGE, 115);
        EnumFlowerColor.addMix(SANDY_BROWN, GRAY, PERU, 95);
        EnumFlowerColor.addMix(SANDY_BROWN, GREEN, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, HOT_PINK, SALMON, 85);
        EnumFlowerColor.addMix(SANDY_BROWN, INDIAN_RED, CORAL, 100);
        EnumFlowerColor.addMix(SANDY_BROWN, INDIGO, MEDIUM_VIOLET_RED, 55);
        EnumFlowerColor.addMix(SANDY_BROWN, KHAKI, TAN, 100);
        EnumFlowerColor.addMix(SANDY_BROWN, LAVENDER, TAN, 95);
        EnumFlowerColor.addMix(SANDY_BROWN, LEMON_CHIFFON, WHEAT, 100);
        EnumFlowerColor.addMix(SANDY_BROWN, LIGHT_GRAY, TAN, 100);
        EnumFlowerColor.addMix(SANDY_BROWN, LIGHT_SEA_GREEN, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SANDY_BROWN, LIGHT_STEEL_BLUE, TAN, 90);
        EnumFlowerColor.addMix(SANDY_BROWN, LIME, YELLOW_GREEN, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, LIME_GREEN, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(SANDY_BROWN, MAGENTA, HOT_PINK, 70);
        EnumFlowerColor.addMix(SANDY_BROWN, MAROON, SIENNA, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, MEDIUM_AQUAMARINE, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(SANDY_BROWN, MEDIUM_ORCHID, PALE_VIOLET_RED, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, MEDIUM_PURPLE, ROSY_BROWN, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, MEDIUM_SEA_GREEN, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(SANDY_BROWN, MEDIUM_VIOLET_RED, INDIAN_RED, 75);
        EnumFlowerColor.addMix(SANDY_BROWN, MISTY_ROSE, TAN, 105);
        EnumFlowerColor.addMix(SANDY_BROWN, OLIVE, DARK_GOLDENROD, 95);
        EnumFlowerColor.addMix(SANDY_BROWN, OLIVE_DRAB, DARK_GOLDENROD, 90);
        EnumFlowerColor.addMix(SANDY_BROWN, ORANGE, DARK_ORANGE, 115);
        EnumFlowerColor.addMix(SANDY_BROWN, PALE_GREEN, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(SANDY_BROWN, PALE_TURQUOISE, WHEAT, 85);
        EnumFlowerColor.addMix(SANDY_BROWN, PALE_VIOLET_RED, SALMON, 90);
        EnumFlowerColor.addMix(SANDY_BROWN, PERU, DARK_ORANGE, 115);
        EnumFlowerColor.addMix(SANDY_BROWN, PINK, DARK_SALMON, 100);
        EnumFlowerColor.addMix(SANDY_BROWN, PLUM, DARK_SALMON, 85);
        EnumFlowerColor.addMix(SANDY_BROWN, PURPLE, PALE_VIOLET_RED, 60);
        EnumFlowerColor.addMix(SANDY_BROWN, RED, CORAL, 100);
        EnumFlowerColor.addMix(SANDY_BROWN, ROSY_BROWN, DARK_SALMON, 105);
        EnumFlowerColor.addMix(SANDY_BROWN, SALMON, DARK_SALMON, 105);
        EnumFlowerColor.addMix(SEA_GREEN, AQUAMARINE, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(SEA_GREEN, BLUE, DARK_SLATE_BLUE, 70);
        EnumFlowerColor.addMix(SEA_GREEN, CADET_BLUE, LIGHT_SEA_GREEN, 105);
        EnumFlowerColor.addMix(SEA_GREEN, CHOCOLATE, OLIVE, 75);
        EnumFlowerColor.addMix(SEA_GREEN, CORAL, OLIVE, 70);
        EnumFlowerColor.addMix(SEA_GREEN, CRIMSON, BROWN, 55);
        EnumFlowerColor.addMix(SEA_GREEN, CYAN, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_GOLDENROD, OLIVE_DRAB, 90);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_GRAY, CADET_BLUE, 100);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_GREEN, GREEN, 110);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_KHAKI, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_OLIVE_GREEN, GREEN, 110);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_ORANGE, OLIVE, 75);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_SEA_GREEN, MEDIUM_SEA_GREEN, 110);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_SLATE_BLUE, DARK_SLATE_GRAY, 80);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_TURQUOISE, LIGHT_SEA_GREEN, 100);
        EnumFlowerColor.addMix(SEA_GREEN, DARK_VIOLET, DARK_SLATE_BLUE, 75);
        EnumFlowerColor.addMix(SEA_GREEN, DEEP_PINK, MEDIUM_VIOLET_RED, 45);
        EnumFlowerColor.addMix(SEA_GREEN, DEEP_SKY_BLUE, CADET_BLUE, 85);
        EnumFlowerColor.addMix(SEA_GREEN, DIM_GRAY, TEAL, 100);
        EnumFlowerColor.addMix(SEA_GREEN, DODGER_BLUE, STEEL_BLUE, 80);
        EnumFlowerColor.addMix(SEA_GREEN, GOLD, YELLOW_GREEN, 85);
        EnumFlowerColor.addMix(SEA_GREEN, GOLDENROD, OLIVE_DRAB, 90);
        EnumFlowerColor.addMix(SEA_GREEN, GREEN, DARK_GREEN, 115);
        EnumFlowerColor.addMix(SEA_GREEN, HOT_PINK, ROSY_BROWN, 50);
        EnumFlowerColor.addMix(SEA_GREEN, INDIAN_RED, DIM_GRAY, 65);
        EnumFlowerColor.addMix(SEA_GREEN, INDIGO, DARK_SLATE_BLUE, 70);
        EnumFlowerColor.addMix(SEA_GREEN, KHAKI, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(SEA_GREEN, LAVENDER, MEDIUM_AQUAMARINE, 85);
        EnumFlowerColor.addMix(SEA_GREEN, LEMON_CHIFFON, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(SEA_GREEN, LIGHT_GRAY, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(SEA_GREEN, LIGHT_SEA_GREEN, MEDIUM_SEA_GREEN, 105);
        EnumFlowerColor.addMix(SEA_GREEN, LIGHT_STEEL_BLUE, CADET_BLUE, 90);
        EnumFlowerColor.addMix(SEA_GREEN, LIME, LIME_GREEN, 95);
        EnumFlowerColor.addMix(SEA_GREEN, LIME_GREEN, MEDIUM_SEA_GREEN, 105);
        EnumFlowerColor.addMix(SEA_GREEN, MAGENTA, DARK_VIOLET, 75);
        EnumFlowerColor.addMix(SEA_GREEN, MEDIUM_AQUAMARINE, MEDIUM_SEA_GREEN, 105);
        EnumFlowerColor.addMix(SEA_GREEN, MEDIUM_PURPLE, SLATE_GRAY, 80);
        EnumFlowerColor.addMix(SEA_GREEN, MISTY_ROSE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SEA_GREEN, NAVY, DARK_SLATE_BLUE, 70);
        EnumFlowerColor.addMix(SEA_GREEN, OLIVE, OLIVE_DRAB, 105);
        EnumFlowerColor.addMix(SEA_GREEN, OLIVE_DRAB, GREEN, 110);
        EnumFlowerColor.addMix(SEA_GREEN, ORANGE, OLIVE, 80);
        EnumFlowerColor.addMix(SEA_GREEN, PALE_GREEN, MEDIUM_SEA_GREEN, 95);
        EnumFlowerColor.addMix(SEA_GREEN, PALE_TURQUOISE, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(SEA_GREEN, PALE_VIOLET_RED, GRAY, 60);
        EnumFlowerColor.addMix(SEA_GREEN, PERU, OLIVE_DRAB, 85);
        EnumFlowerColor.addMix(SEA_GREEN, PINK, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(SEA_GREEN, PLUM, SLATE_GRAY, 80);
        EnumFlowerColor.addMix(SEA_GREEN, PURPLE, DARK_SLATE_BLUE, 75);
        EnumFlowerColor.addMix(SEA_GREEN, RED, SIENNA, 60);
        EnumFlowerColor.addMix(SEA_GREEN, ROYAL_BLUE, STEEL_BLUE, 80);
        EnumFlowerColor.addMix(SEA_GREEN, SANDY_BROWN, OLIVE_DRAB, 80);
        EnumFlowerColor.addMix(SIENNA, AQUAMARINE, DARK_SEA_GREEN, 60);
        EnumFlowerColor.addMix(SIENNA, BLUE, DARK_SLATE_BLUE, 75);
        EnumFlowerColor.addMix(SIENNA, BROWN, MAROON, 115);
        EnumFlowerColor.addMix(SIENNA, CADET_BLUE, GRAY, 85);
        EnumFlowerColor.addMix(SIENNA, CORAL, CHOCOLATE, 105);
        EnumFlowerColor.addMix(SIENNA, CRIMSON, BROWN, 110);
        EnumFlowerColor.addMix(SIENNA, CYAN, LIGHT_SEA_GREEN, 60);
        EnumFlowerColor.addMix(SIENNA, DARK_GOLDENROD, PERU, 100);
        EnumFlowerColor.addMix(SIENNA, DARK_GRAY, ROSY_BROWN, 95);
        EnumFlowerColor.addMix(SIENNA, DARK_GREEN, DARK_OLIVE_GREEN, 80);
        EnumFlowerColor.addMix(SIENNA, DARK_KHAKI, PERU, 90);
        EnumFlowerColor.addMix(SIENNA, DARK_ORANGE, CHOCOLATE, 100);
        EnumFlowerColor.addMix(SIENNA, DARK_SALMON, CHOCOLATE, 100);
        EnumFlowerColor.addMix(SIENNA, DARK_TURQUOISE, CADET_BLUE, 70);
        EnumFlowerColor.addMix(SIENNA, DARK_VIOLET, PURPLE, 80);
        EnumFlowerColor.addMix(SIENNA, DEEP_PINK, CRIMSON, 90);
        EnumFlowerColor.addMix(SIENNA, DEEP_SKY_BLUE, CADET_BLUE, 70);
        EnumFlowerColor.addMix(SIENNA, DODGER_BLUE, SLATE_GRAY, 75);
        EnumFlowerColor.addMix(SIENNA, GOLD, GOLDENROD, 80);
        EnumFlowerColor.addMix(SIENNA, GOLDENROD, PERU, 95);
        EnumFlowerColor.addMix(SIENNA, GREEN, DARK_OLIVE_GREEN, 75);
        EnumFlowerColor.addMix(SIENNA, HOT_PINK, INDIAN_RED, 90);
        EnumFlowerColor.addMix(SIENNA, INDIAN_RED, BROWN, 110);
        EnumFlowerColor.addMix(SIENNA, INDIGO, PURPLE, 80);
        EnumFlowerColor.addMix(SIENNA, KHAKI, TAN, 80);
        EnumFlowerColor.addMix(SIENNA, LAVENDER, ROSY_BROWN, 80);
        EnumFlowerColor.addMix(SIENNA, LEMON_CHIFFON, TAN, 75);
        EnumFlowerColor.addMix(SIENNA, LIGHT_GRAY, ROSY_BROWN, 85);
        EnumFlowerColor.addMix(SIENNA, LIGHT_SEA_GREEN, SEA_GREEN, 75);
        EnumFlowerColor.addMix(SIENNA, LIGHT_STEEL_BLUE, ROSY_BROWN, 80);
        EnumFlowerColor.addMix(SIENNA, LIME, OLIVE_DRAB, 55);
        EnumFlowerColor.addMix(SIENNA, LIME_GREEN, OLIVE_DRAB, 65);
        EnumFlowerColor.addMix(SIENNA, MAGENTA, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(SIENNA, MAROON, BROWN, 110);
        EnumFlowerColor.addMix(SIENNA, MEDIUM_ORCHID, MEDIUM_VIOLET_RED, 85);
        EnumFlowerColor.addMix(SIENNA, MEDIUM_SEA_GREEN, DARK_OLIVE_GREEN, 70);
        EnumFlowerColor.addMix(SIENNA, MEDIUM_VIOLET_RED, CRIMSON, 95);
        EnumFlowerColor.addMix(SIENNA, MISTY_ROSE, DARK_SALMON, 85);
        EnumFlowerColor.addMix(SIENNA, NAVY, PURPLE, 75);
        EnumFlowerColor.addMix(SIENNA, OLIVE, DARK_GOLDENROD, 95);
        EnumFlowerColor.addMix(SIENNA, OLIVE_DRAB, OLIVE, 85);
        EnumFlowerColor.addMix(SIENNA, ORANGE, PERU, 95);
        EnumFlowerColor.addMix(SIENNA, PALE_GREEN, DARK_KHAKI, 65);
        EnumFlowerColor.addMix(SIENNA, PALE_TURQUOISE, DARK_GRAY, 70);
        EnumFlowerColor.addMix(SIENNA, PALE_VIOLET_RED, INDIAN_RED, 95);
        EnumFlowerColor.addMix(SIENNA, PERU, CHOCOLATE, 105);
        EnumFlowerColor.addMix(SIENNA, PINK, DARK_SALMON, 90);
        EnumFlowerColor.addMix(SIENNA, PLUM, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(SIENNA, PURPLE, MEDIUM_VIOLET_RED, 85);
        EnumFlowerColor.addMix(SIENNA, RED, CRIMSON, 110);
        EnumFlowerColor.addMix(SIENNA, ROSY_BROWN, INDIAN_RED, 100);
        EnumFlowerColor.addMix(SIENNA, SALMON, INDIAN_RED, 100);
        EnumFlowerColor.addMix(SIENNA, SANDY_BROWN, PERU, 100);
        EnumFlowerColor.addMix(SIENNA, SEA_GREEN, DARK_OLIVE_GREEN, 80);
        EnumFlowerColor.addMix(SKY_BLUE, AQUAMARINE, TURQUOISE, 100);
        EnumFlowerColor.addMix(SKY_BLUE, BLACK, DARK_SLATE_GRAY, 55);
        EnumFlowerColor.addMix(SKY_BLUE, BLUE, ROYAL_BLUE, 75);
        EnumFlowerColor.addMix(SKY_BLUE, BROWN, ROSY_BROWN, 60);
        EnumFlowerColor.addMix(SKY_BLUE, CADET_BLUE, DARK_TURQUOISE, 110);
        EnumFlowerColor.addMix(SKY_BLUE, CHOCOLATE, TAN, 75);
        EnumFlowerColor.addMix(SKY_BLUE, CORAL, ROSY_BROWN, 75);
        EnumFlowerColor.addMix(SKY_BLUE, CRIMSON, PALE_VIOLET_RED, 60);
        EnumFlowerColor.addMix(SKY_BLUE, CYAN, DARK_TURQUOISE, 110);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_GOLDENROD, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_GRAY, LIGHT_STEEL_BLUE, 105);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_GREEN, SEA_GREEN, 70);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_KHAKI, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_OLIVE_GREEN, CADET_BLUE, 80);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_ORANGE, TAN, 80);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_SALMON, DARK_GRAY, 80);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_SEA_GREEN, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_SLATE_BLUE, STEEL_BLUE, 75);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_SLATE_GRAY, CADET_BLUE, 80);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_TURQUOISE, TURQUOISE, 115);
        EnumFlowerColor.addMix(SKY_BLUE, DARK_VIOLET, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(SKY_BLUE, DEEP_PINK, MEDIUM_ORCHID, 65);
        EnumFlowerColor.addMix(SKY_BLUE, DIM_GRAY, CADET_BLUE, 90);
        EnumFlowerColor.addMix(SKY_BLUE, DODGER_BLUE, DEEP_SKY_BLUE, 105);
        EnumFlowerColor.addMix(SKY_BLUE, GOLD, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(SKY_BLUE, GOLDENROD, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(SKY_BLUE, GRAY, CADET_BLUE, 100);
        EnumFlowerColor.addMix(SKY_BLUE, GREEN, MEDIUM_SEA_GREEN, 75);
        EnumFlowerColor.addMix(SKY_BLUE, HOT_PINK, PLUM, 75);
        EnumFlowerColor.addMix(SKY_BLUE, INDIAN_RED, ROSY_BROWN, 70);
        EnumFlowerColor.addMix(SKY_BLUE, INDIGO, SLATE_BLUE, 60);
        EnumFlowerColor.addMix(SKY_BLUE, KHAKI, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(SKY_BLUE, LAVENDER, LIGHT_STEEL_BLUE, 105);
        EnumFlowerColor.addMix(SKY_BLUE, LEMON_CHIFFON, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(SKY_BLUE, LIGHT_GRAY, LIGHT_STEEL_BLUE, 110);
        EnumFlowerColor.addMix(SKY_BLUE, LIGHT_SEA_GREEN, DARK_TURQUOISE, 110);
        EnumFlowerColor.addMix(SKY_BLUE, LIGHT_STEEL_BLUE, DEEP_SKY_BLUE, 115);
        EnumFlowerColor.addMix(SKY_BLUE, LIME, SPRING_GREEN, 80);
        EnumFlowerColor.addMix(SKY_BLUE, LIME_GREEN, MEDIUM_AQUAMARINE, 80);
        EnumFlowerColor.addMix(SKY_BLUE, MAGENTA, MEDIUM_ORCHID, 85);
        EnumFlowerColor.addMix(SKY_BLUE, MEDIUM_AQUAMARINE, DARK_TURQUOISE, 100);
        EnumFlowerColor.addMix(SKY_BLUE, MEDIUM_ORCHID, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(SKY_BLUE, MEDIUM_PURPLE, LIGHT_STEEL_BLUE, 95);
        EnumFlowerColor.addMix(SKY_BLUE, MEDIUM_SEA_GREEN, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(SKY_BLUE, MEDIUM_VIOLET_RED, MEDIUM_ORCHID, 70);
        EnumFlowerColor.addMix(SKY_BLUE, MISTY_ROSE, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(SKY_BLUE, NAVY, ROYAL_BLUE, 55);
        EnumFlowerColor.addMix(SKY_BLUE, OLIVE, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(SKY_BLUE, OLIVE_DRAB, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SKY_BLUE, ORANGE, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(SKY_BLUE, PALE_GREEN, MEDIUM_AQUAMARINE, 85);
        EnumFlowerColor.addMix(SKY_BLUE, PALE_TURQUOISE, DARK_TURQUOISE, 115);
        EnumFlowerColor.addMix(SKY_BLUE, PALE_VIOLET_RED, THISTLE, 75);
        EnumFlowerColor.addMix(SKY_BLUE, PERU, DARK_GRAY, 80);
        EnumFlowerColor.addMix(SKY_BLUE, PINK, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(SKY_BLUE, PLUM, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(SKY_BLUE, PURPLE, MEDIUM_PURPLE, 65);
        EnumFlowerColor.addMix(SKY_BLUE, RED, INDIAN_RED, 65);
        EnumFlowerColor.addMix(SKY_BLUE, ROSY_BROWN, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(SKY_BLUE, ROYAL_BLUE, DODGER_BLUE, 95);
        EnumFlowerColor.addMix(SKY_BLUE, SALMON, ROSY_BROWN, 75);
        EnumFlowerColor.addMix(SKY_BLUE, SANDY_BROWN, DARK_GRAY, 85);
        EnumFlowerColor.addMix(SKY_BLUE, SEA_GREEN, LIGHT_SEA_GREEN, 90);
        EnumFlowerColor.addMix(SKY_BLUE, SIENNA, GRAY, 70);
        EnumFlowerColor.addMix(SLATE_BLUE, AQUAMARINE, DEEP_SKY_BLUE, 70);
        EnumFlowerColor.addMix(SLATE_BLUE, BLACK, DARK_SLATE_BLUE, 85);
        EnumFlowerColor.addMix(SLATE_BLUE, BLUE, DARK_VIOLET, 110);
        EnumFlowerColor.addMix(SLATE_BLUE, BROWN, PURPLE, 90);
        EnumFlowerColor.addMix(SLATE_BLUE, CADET_BLUE, STEEL_BLUE, 95);
        EnumFlowerColor.addMix(SLATE_BLUE, CORAL, PALE_VIOLET_RED, 75);
        EnumFlowerColor.addMix(SLATE_BLUE, CRIMSON, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(SLATE_BLUE, CYAN, DEEP_SKY_BLUE, 70);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_GOLDENROD, ROSY_BROWN, 65);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_GRAY, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_GREEN, DARK_SLATE_GRAY, 70);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_KHAKI, GRAY, 60);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_ORANGE, INDIAN_RED, 65);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_SALMON, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_SEA_GREEN, SLATE_GRAY, 75);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_SLATE_GRAY, DARK_SLATE_BLUE, 100);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_TURQUOISE, DODGER_BLUE, 80);
        EnumFlowerColor.addMix(SLATE_BLUE, DARK_VIOLET, BLUE, 115);
        EnumFlowerColor.addMix(SLATE_BLUE, DEEP_PINK, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(SLATE_BLUE, DEEP_SKY_BLUE, DODGER_BLUE, 90);
        EnumFlowerColor.addMix(SLATE_BLUE, DIM_GRAY, DARK_SLATE_BLUE, 100);
        EnumFlowerColor.addMix(SLATE_BLUE, DODGER_BLUE, ROYAL_BLUE, 105);
        EnumFlowerColor.addMix(SLATE_BLUE, GOLD, TAN, 50);
        EnumFlowerColor.addMix(SLATE_BLUE, GOLDENROD, ROSY_BROWN, 60);
        EnumFlowerColor.addMix(SLATE_BLUE, GRAY, MEDIUM_PURPLE, 100);
        EnumFlowerColor.addMix(SLATE_BLUE, GREEN, TEAL, 70);
        EnumFlowerColor.addMix(SLATE_BLUE, HOT_PINK, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(SLATE_BLUE, INDIAN_RED, MEDIUM_ORCHID, 90);
        EnumFlowerColor.addMix(SLATE_BLUE, INDIGO, DARK_SLATE_BLUE, 105);
        EnumFlowerColor.addMix(SLATE_BLUE, KHAKI, DARK_GRAY, 55);
        EnumFlowerColor.addMix(SLATE_BLUE, LAVENDER, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(SLATE_BLUE, LEMON_CHIFFON, THISTLE, 60);
        EnumFlowerColor.addMix(SLATE_BLUE, LIGHT_GRAY, MEDIUM_PURPLE, 85);
        EnumFlowerColor.addMix(SLATE_BLUE, LIGHT_SEA_GREEN, STEEL_BLUE, 85);
        EnumFlowerColor.addMix(SLATE_BLUE, LIGHT_STEEL_BLUE, MEDIUM_PURPLE, 95);
        EnumFlowerColor.addMix(SLATE_BLUE, LIME, MEDIUM_SEA_GREEN, 55);
        EnumFlowerColor.addMix(SLATE_BLUE, LIME_GREEN, CADET_BLUE, 60);
        EnumFlowerColor.addMix(SLATE_BLUE, MAGENTA, MEDIUM_ORCHID, 100);
        EnumFlowerColor.addMix(SLATE_BLUE, MAROON, PURPLE, 80);
        EnumFlowerColor.addMix(SLATE_BLUE, MEDIUM_AQUAMARINE, STEEL_BLUE, 75);
        EnumFlowerColor.addMix(SLATE_BLUE, MEDIUM_ORCHID, MEDIUM_PURPLE, 110);
        EnumFlowerColor.addMix(SLATE_BLUE, MEDIUM_PURPLE, ROYAL_BLUE, 115);
        EnumFlowerColor.addMix(SLATE_BLUE, MEDIUM_SEA_GREEN, STEEL_BLUE, 75);
        EnumFlowerColor.addMix(SLATE_BLUE, MEDIUM_VIOLET_RED, DARK_VIOLET, 100);
        EnumFlowerColor.addMix(SLATE_BLUE, MISTY_ROSE, PLUM, 80);
        EnumFlowerColor.addMix(SLATE_BLUE, NAVY, DARK_SLATE_BLUE, 100);
        EnumFlowerColor.addMix(SLATE_BLUE, OLIVE, DIM_GRAY, 60);
        EnumFlowerColor.addMix(SLATE_BLUE, OLIVE_DRAB, DIM_GRAY, 55);
        EnumFlowerColor.addMix(SLATE_BLUE, ORANGE, DARK_SALMON, 60);
        EnumFlowerColor.addMix(SLATE_BLUE, PALE_GREEN, CADET_BLUE, 60);
        EnumFlowerColor.addMix(SLATE_BLUE, PALE_TURQUOISE, LIGHT_STEEL_BLUE, 80);
        EnumFlowerColor.addMix(SLATE_BLUE, PALE_VIOLET_RED, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(SLATE_BLUE, PINK, PLUM, 85);
        EnumFlowerColor.addMix(SLATE_BLUE, PLUM, MEDIUM_PURPLE, 95);
        EnumFlowerColor.addMix(SLATE_BLUE, PURPLE, DARK_VIOLET, 105);
        EnumFlowerColor.addMix(SLATE_BLUE, RED, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(SLATE_BLUE, ROSY_BROWN, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(SLATE_BLUE, ROYAL_BLUE, MEDIUM_PURPLE, 120);
        EnumFlowerColor.addMix(SLATE_BLUE, SALMON, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(SLATE_BLUE, SANDY_BROWN, ROSY_BROWN, 70);
        EnumFlowerColor.addMix(SLATE_BLUE, SEA_GREEN, STEEL_BLUE, 80);
        EnumFlowerColor.addMix(SLATE_BLUE, SKY_BLUE, DODGER_BLUE, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, AQUAMARINE, MEDIUM_AQUAMARINE, 85);
        EnumFlowerColor.addMix(SLATE_GRAY, BLACK, DARK_SLATE_GRAY, 85);
        EnumFlowerColor.addMix(SLATE_GRAY, BLUE, DARK_SLATE_BLUE, 100);
        EnumFlowerColor.addMix(SLATE_GRAY, CHOCOLATE, SIENNA, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, CORAL, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, CRIMSON, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, CYAN, DARK_TURQUOISE, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_GOLDENROD, OLIVE, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_GRAY, GRAY, 110);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_GREEN, SEA_GREEN, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_ORANGE, PERU, 85);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_SALMON, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_SEA_GREEN, CADET_BLUE, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_SLATE_BLUE, SLATE_BLUE, 105);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_SLATE_GRAY, DIM_GRAY, 105);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_TURQUOISE, CADET_BLUE, 100);
        EnumFlowerColor.addMix(SLATE_GRAY, DARK_VIOLET, SLATE_BLUE, 105);
        EnumFlowerColor.addMix(SLATE_GRAY, DEEP_PINK, MEDIUM_VIOLET_RED, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, DEEP_SKY_BLUE, STEEL_BLUE, 105);
        EnumFlowerColor.addMix(SLATE_GRAY, DIM_GRAY, GRAY, 115);
        EnumFlowerColor.addMix(SLATE_GRAY, DODGER_BLUE, STEEL_BLUE, 110);
        EnumFlowerColor.addMix(SLATE_GRAY, GOLD, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(SLATE_GRAY, GOLDENROD, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(SLATE_GRAY, GRAY, DIM_GRAY, 120);
        EnumFlowerColor.addMix(SLATE_GRAY, GREEN, SEA_GREEN, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, HOT_PINK, PALE_VIOLET_RED, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, INDIAN_RED, ROSY_BROWN, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, INDIGO, DARK_SLATE_BLUE, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, KHAKI, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(SLATE_GRAY, LAVENDER, LIGHT_STEEL_BLUE, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, LEMON_CHIFFON, DARK_GRAY, 85);
        EnumFlowerColor.addMix(SLATE_GRAY, LIGHT_GRAY, DARK_GRAY, 100);
        EnumFlowerColor.addMix(SLATE_GRAY, LIGHT_SEA_GREEN, CADET_BLUE, 100);
        EnumFlowerColor.addMix(SLATE_GRAY, LIGHT_STEEL_BLUE, DARK_GRAY, 105);
        EnumFlowerColor.addMix(SLATE_GRAY, LIME, LIME_GREEN, 75);
        EnumFlowerColor.addMix(SLATE_GRAY, LIME_GREEN, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(SLATE_GRAY, MAGENTA, MEDIUM_ORCHID, 100);
        EnumFlowerColor.addMix(SLATE_GRAY, MEDIUM_AQUAMARINE, CADET_BLUE, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, MEDIUM_ORCHID, MEDIUM_PURPLE, 110);
        EnumFlowerColor.addMix(SLATE_GRAY, MEDIUM_PURPLE, SLATE_BLUE, 115);
        EnumFlowerColor.addMix(SLATE_GRAY, MEDIUM_SEA_GREEN, SEA_GREEN, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, MISTY_ROSE, DARK_GRAY, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, NAVY, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, OLIVE, OLIVE_DRAB, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, OLIVE_DRAB, SEA_GREEN, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, ORANGE, DARK_GOLDENROD, 85);
        EnumFlowerColor.addMix(SLATE_GRAY, PALE_GREEN, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SLATE_GRAY, PALE_TURQUOISE, SKY_BLUE, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, PALE_VIOLET_RED, ROSY_BROWN, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, PINK, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, PURPLE, DARK_SLATE_BLUE, 95);
        EnumFlowerColor.addMix(SLATE_GRAY, RED, CRIMSON, 85);
        EnumFlowerColor.addMix(SLATE_GRAY, ROSY_BROWN, GRAY, 100);
        EnumFlowerColor.addMix(SLATE_GRAY, ROYAL_BLUE, STEEL_BLUE, 115);
        EnumFlowerColor.addMix(SLATE_GRAY, SALMON, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, SANDY_BROWN, TAN, 90);
        EnumFlowerColor.addMix(SLATE_GRAY, SEA_GREEN, TEAL, 100);
        EnumFlowerColor.addMix(SLATE_GRAY, SKY_BLUE, CADET_BLUE, 100);
        EnumFlowerColor.addMix(SLATE_GRAY, SLATE_BLUE, MEDIUM_PURPLE, 115);
        EnumFlowerColor.addMix(SPRING_GREEN, AQUAMARINE, PALE_GREEN, 110);
        EnumFlowerColor.addMix(SPRING_GREEN, BLUE, STEEL_BLUE, 45);
        EnumFlowerColor.addMix(SPRING_GREEN, CADET_BLUE, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(SPRING_GREEN, CHOCOLATE, LIME_GREEN, 60);
        EnumFlowerColor.addMix(SPRING_GREEN, CORAL, DARK_SEA_GREEN, 55);
        EnumFlowerColor.addMix(SPRING_GREEN, CYAN, AQUAMARINE, 100);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_GOLDENROD, LIME_GREEN, 80);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_GRAY, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_GREEN, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_KHAKI, LIME_GREEN, 100);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_OLIVE_GREEN, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_ORANGE, YELLOW_GREEN, 65);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_SALMON, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_SEA_GREEN, PALE_GREEN, 105);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_SLATE_BLUE, LIGHT_SEA_GREEN, 50);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_SLATE_GRAY, MEDIUM_SEA_GREEN, 65);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_TURQUOISE, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(SPRING_GREEN, DARK_VIOLET, STEEL_BLUE, 55);
        EnumFlowerColor.addMix(SPRING_GREEN, DEEP_SKY_BLUE, TURQUOISE, 75);
        EnumFlowerColor.addMix(SPRING_GREEN, DIM_GRAY, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(SPRING_GREEN, DODGER_BLUE, DARK_TURQUOISE, 65);
        EnumFlowerColor.addMix(SPRING_GREEN, GOLD, LIME, 90);
        EnumFlowerColor.addMix(SPRING_GREEN, GOLDENROD, LIME_GREEN, 85);
        EnumFlowerColor.addMix(SPRING_GREEN, GRAY, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(SPRING_GREEN, GREEN, LIME_GREEN, 90);
        EnumFlowerColor.addMix(SPRING_GREEN, INDIAN_RED, MEDIUM_SEA_GREEN, 45);
        EnumFlowerColor.addMix(SPRING_GREEN, KHAKI, PALE_GREEN, 100);
        EnumFlowerColor.addMix(SPRING_GREEN, LAVENDER, AQUAMARINE, 90);
        EnumFlowerColor.addMix(SPRING_GREEN, LEMON_CHIFFON, PALE_GREEN, 100);
        EnumFlowerColor.addMix(SPRING_GREEN, LIGHT_GRAY, AQUAMARINE, 95);
        EnumFlowerColor.addMix(SPRING_GREEN, LIGHT_SEA_GREEN, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(SPRING_GREEN, LIGHT_STEEL_BLUE, MEDIUM_AQUAMARINE, 85);
        EnumFlowerColor.addMix(SPRING_GREEN, LIME, PALE_GREEN, 120);
        EnumFlowerColor.addMix(SPRING_GREEN, LIME_GREEN, LIME, 115);
        EnumFlowerColor.addMix(SPRING_GREEN, MAGENTA, MEDIUM_PURPLE, 60);
        EnumFlowerColor.addMix(SPRING_GREEN, MEDIUM_AQUAMARINE, PALE_GREEN, 110);
        EnumFlowerColor.addMix(SPRING_GREEN, MEDIUM_ORCHID, CADET_BLUE, 65);
        EnumFlowerColor.addMix(SPRING_GREEN, MEDIUM_PURPLE, LIGHT_SEA_GREEN, 65);
        EnumFlowerColor.addMix(SPRING_GREEN, MEDIUM_SEA_GREEN, LIME_GREEN, 110);
        EnumFlowerColor.addMix(SPRING_GREEN, MISTY_ROSE, AQUAMARINE, 80);
        EnumFlowerColor.addMix(SPRING_GREEN, OLIVE, LIME_GREEN, 90);
        EnumFlowerColor.addMix(SPRING_GREEN, OLIVE_DRAB, LIME_GREEN, 95);
        EnumFlowerColor.addMix(SPRING_GREEN, ORANGE, YELLOW_GREEN, 75);
        EnumFlowerColor.addMix(SPRING_GREEN, PALE_GREEN, LIME, 120);
        EnumFlowerColor.addMix(SPRING_GREEN, PALE_TURQUOISE, AQUAMARINE, 100);
        EnumFlowerColor.addMix(SPRING_GREEN, PERU, LIME_GREEN, 75);
        EnumFlowerColor.addMix(SPRING_GREEN, PINK, MEDIUM_AQUAMARINE, 65);
        EnumFlowerColor.addMix(SPRING_GREEN, PLUM, MEDIUM_AQUAMARINE, 75);
        EnumFlowerColor.addMix(SPRING_GREEN, PURPLE, TEAL, 50);
        EnumFlowerColor.addMix(SPRING_GREEN, ROSY_BROWN, MEDIUM_SEA_GREEN, 70);
        EnumFlowerColor.addMix(SPRING_GREEN, ROYAL_BLUE, LIGHT_SEA_GREEN, 60);
        EnumFlowerColor.addMix(SPRING_GREEN, SALMON, DARK_SEA_GREEN, 50);
        EnumFlowerColor.addMix(SPRING_GREEN, SANDY_BROWN, LIME_GREEN, 75);
        EnumFlowerColor.addMix(SPRING_GREEN, SEA_GREEN, MEDIUM_SEA_GREEN, 95);
        EnumFlowerColor.addMix(SPRING_GREEN, SIENNA, MEDIUM_SEA_GREEN, 55);
        EnumFlowerColor.addMix(SPRING_GREEN, SKY_BLUE, AQUAMARINE, 85);
        EnumFlowerColor.addMix(SPRING_GREEN, SLATE_BLUE, LIGHT_SEA_GREEN, 60);
        EnumFlowerColor.addMix(SPRING_GREEN, SLATE_GRAY, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, AQUAMARINE, DARK_TURQUOISE, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, BLACK, DARK_SLATE_BLUE, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, BLUE, SLATE_BLUE, 100);
        EnumFlowerColor.addMix(STEEL_BLUE, CADET_BLUE, SLATE_GRAY, 105);
        EnumFlowerColor.addMix(STEEL_BLUE, CHOCOLATE, GRAY, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, CORAL, ROSY_BROWN, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, CRIMSON, MEDIUM_VIOLET_RED, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, CYAN, DARK_TURQUOISE, 90);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_GRAY, SLATE_GRAY, 105);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_GREEN, SEA_GREEN, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_KHAKI, CADET_BLUE, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_OLIVE_GREEN, TEAL, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_ORANGE, DARK_GOLDENROD, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_SALMON, GRAY, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_SEA_GREEN, CADET_BLUE, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_SLATE_BLUE, ROYAL_BLUE, 100);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_SLATE_GRAY, ROYAL_BLUE, 100);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_TURQUOISE, CADET_BLUE, 100);
        EnumFlowerColor.addMix(STEEL_BLUE, DARK_VIOLET, SLATE_BLUE, 95);
        EnumFlowerColor.addMix(STEEL_BLUE, DEEP_PINK, MEDIUM_ORCHID, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, DEEP_SKY_BLUE, DODGER_BLUE, 105);
        EnumFlowerColor.addMix(STEEL_BLUE, DIM_GRAY, SLATE_GRAY, 105);
        EnumFlowerColor.addMix(STEEL_BLUE, GOLD, DARK_KHAKI, 60);
        EnumFlowerColor.addMix(STEEL_BLUE, GRAY, SLATE_GRAY, 110);
        EnumFlowerColor.addMix(STEEL_BLUE, GREEN, SEA_GREEN, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, HOT_PINK, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, INDIGO, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(STEEL_BLUE, KHAKI, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(STEEL_BLUE, LAVENDER, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(STEEL_BLUE, LEMON_CHIFFON, SKY_BLUE, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, LIGHT_GRAY, LIGHT_STEEL_BLUE, 95);
        EnumFlowerColor.addMix(STEEL_BLUE, LIGHT_SEA_GREEN, CADET_BLUE, 100);
        EnumFlowerColor.addMix(STEEL_BLUE, LIGHT_STEEL_BLUE, DODGER_BLUE, 105);
        EnumFlowerColor.addMix(STEEL_BLUE, LIME, MEDIUM_SEA_GREEN, 65);
        EnumFlowerColor.addMix(STEEL_BLUE, LIME_GREEN, MEDIUM_SEA_GREEN, 70);
        EnumFlowerColor.addMix(STEEL_BLUE, MAGENTA, MEDIUM_ORCHID, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, MEDIUM_AQUAMARINE, CADET_BLUE, 90);
        EnumFlowerColor.addMix(STEEL_BLUE, MEDIUM_ORCHID, MEDIUM_PURPLE, 95);
        EnumFlowerColor.addMix(STEEL_BLUE, MEDIUM_PURPLE, ROYAL_BLUE, 105);
        EnumFlowerColor.addMix(STEEL_BLUE, MEDIUM_SEA_GREEN, CADET_BLUE, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, MEDIUM_VIOLET_RED, DARK_VIOLET, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, MISTY_ROSE, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, NAVY, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(STEEL_BLUE, OLIVE, SEA_GREEN, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, OLIVE_DRAB, SEA_GREEN, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, ORANGE, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, PALE_GREEN, MEDIUM_AQUAMARINE, 70);
        EnumFlowerColor.addMix(STEEL_BLUE, PALE_TURQUOISE, SKY_BLUE, 90);
        EnumFlowerColor.addMix(STEEL_BLUE, PERU, GRAY, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, PINK, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, PLUM, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(STEEL_BLUE, PURPLE, DARK_SLATE_BLUE, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, RED, MEDIUM_VIOLET_RED, 75);
        EnumFlowerColor.addMix(STEEL_BLUE, ROSY_BROWN, SLATE_GRAY, 95);
        EnumFlowerColor.addMix(STEEL_BLUE, ROYAL_BLUE, DODGER_BLUE, 115);
        EnumFlowerColor.addMix(STEEL_BLUE, SALMON, ROSY_BROWN, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, SANDY_BROWN, DARK_GRAY, 80);
        EnumFlowerColor.addMix(STEEL_BLUE, SEA_GREEN, TEAL, 90);
        EnumFlowerColor.addMix(STEEL_BLUE, SIENNA, DIM_GRAY, 85);
        EnumFlowerColor.addMix(STEEL_BLUE, SKY_BLUE, DEEP_SKY_BLUE, 105);
        EnumFlowerColor.addMix(STEEL_BLUE, SLATE_BLUE, ROYAL_BLUE, 110);
        EnumFlowerColor.addMix(STEEL_BLUE, SLATE_GRAY, ROYAL_BLUE, 115);
        EnumFlowerColor.addMix(STEEL_BLUE, SPRING_GREEN, MEDIUM_AQUAMARINE, 70);
        EnumFlowerColor.addMix(TAN, AQUAMARINE, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(TAN, BLACK, DIM_GRAY, 60);
        EnumFlowerColor.addMix(TAN, BLUE, SLATE_BLUE, 60);
        EnumFlowerColor.addMix(TAN, BROWN, INDIAN_RED, 85);
        EnumFlowerColor.addMix(TAN, CADET_BLUE, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(TAN, CHOCOLATE, PERU, 105);
        EnumFlowerColor.addMix(TAN, CORAL, DARK_SALMON, 105);
        EnumFlowerColor.addMix(TAN, CRIMSON, INDIAN_RED, 85);
        EnumFlowerColor.addMix(TAN, CYAN, TURQUOISE, 90);
        EnumFlowerColor.addMix(TAN, DARK_GOLDENROD, GOLDENROD, 110);
        EnumFlowerColor.addMix(TAN, DARK_GREEN, OLIVE_DRAB, 80);
        EnumFlowerColor.addMix(TAN, DARK_KHAKI, WHEAT, 115);
        EnumFlowerColor.addMix(TAN, DARK_OLIVE_GREEN, OLIVE, 90);
        EnumFlowerColor.addMix(TAN, DARK_ORANGE, SANDY_BROWN, 105);
        EnumFlowerColor.addMix(TAN, DARK_SALMON, SANDY_BROWN, 110);
        EnumFlowerColor.addMix(TAN, DARK_SEA_GREEN, DARK_KHAKI, 105);
        EnumFlowerColor.addMix(TAN, DARK_SLATE_GRAY, GRAY, 75);
        EnumFlowerColor.addMix(TAN, DARK_TURQUOISE, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(TAN, DARK_VIOLET, MEDIUM_ORCHID, 65);
        EnumFlowerColor.addMix(TAN, DEEP_PINK, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(TAN, DEEP_SKY_BLUE, CADET_BLUE, 85);
        EnumFlowerColor.addMix(TAN, DIM_GRAY, GRAY, 95);
        EnumFlowerColor.addMix(TAN, DODGER_BLUE, STEEL_BLUE, 80);
        EnumFlowerColor.addMix(TAN, GOLD, GOLDENROD, 105);
        EnumFlowerColor.addMix(TAN, GOLDENROD, DARK_KHAKI, 110);
        EnumFlowerColor.addMix(TAN, GRAY, DARK_GRAY, 100);
        EnumFlowerColor.addMix(TAN, GREEN, OLIVE_DRAB, 85);
        EnumFlowerColor.addMix(TAN, HOT_PINK, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(TAN, INDIAN_RED, DARK_SALMON, 95);
        EnumFlowerColor.addMix(TAN, KHAKI, WHEAT, 110);
        EnumFlowerColor.addMix(TAN, LAVENDER, LIGHT_GRAY, 100);
        EnumFlowerColor.addMix(TAN, LEMON_CHIFFON, WHEAT, 110);
        EnumFlowerColor.addMix(TAN, LIGHT_GRAY, WHEAT, 110);
        EnumFlowerColor.addMix(TAN, LIGHT_SEA_GREEN, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(TAN, LIGHT_STEEL_BLUE, DARK_GRAY, 100);
        EnumFlowerColor.addMix(TAN, LIME, LIME_GREEN, 90);
        EnumFlowerColor.addMix(TAN, LIME_GREEN, YELLOW_GREEN, 95);
        EnumFlowerColor.addMix(TAN, MAGENTA, HOT_PINK, 75);
        EnumFlowerColor.addMix(TAN, MAROON, SIENNA, 70);
        EnumFlowerColor.addMix(TAN, MEDIUM_AQUAMARINE, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(TAN, MEDIUM_ORCHID, PALE_VIOLET_RED, 75);
        EnumFlowerColor.addMix(TAN, MEDIUM_PURPLE, PLUM, 80);
        EnumFlowerColor.addMix(TAN, MEDIUM_SEA_GREEN, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(TAN, MEDIUM_VIOLET_RED, PALE_VIOLET_RED, 75);
        EnumFlowerColor.addMix(TAN, MISTY_ROSE, WHEAT, 110);
        EnumFlowerColor.addMix(TAN, NAVY, DARK_SLATE_BLUE, 50);
        EnumFlowerColor.addMix(TAN, OLIVE, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(TAN, OLIVE_DRAB, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(TAN, ORANGE, GOLDENROD, 110);
        EnumFlowerColor.addMix(TAN, PALE_GREEN, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(TAN, PALE_TURQUOISE, LIGHT_GRAY, 95);
        EnumFlowerColor.addMix(TAN, PALE_VIOLET_RED, ROSY_BROWN, 90);
        EnumFlowerColor.addMix(TAN, PERU, SANDY_BROWN, 110);
        EnumFlowerColor.addMix(TAN, PINK, DARK_SALMON, 100);
        EnumFlowerColor.addMix(TAN, PLUM, PINK, 90);
        EnumFlowerColor.addMix(TAN, PURPLE, MEDIUM_VIOLET_RED, 60);
        EnumFlowerColor.addMix(TAN, RED, INDIAN_RED, 90);
        EnumFlowerColor.addMix(TAN, ROSY_BROWN, DARK_SALMON, 105);
        EnumFlowerColor.addMix(TAN, ROYAL_BLUE, SLATE_GRAY, 75);
        EnumFlowerColor.addMix(TAN, SALMON, DARK_SALMON, 100);
        EnumFlowerColor.addMix(TAN, SANDY_BROWN, PERU, 115);
        EnumFlowerColor.addMix(TAN, SEA_GREEN, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(TAN, SIENNA, PERU, 95);
        EnumFlowerColor.addMix(TAN, SKY_BLUE, DARK_GRAY, 95);
        EnumFlowerColor.addMix(TAN, SLATE_GRAY, DARK_GRAY, 95);
        EnumFlowerColor.addMix(TAN, SPRING_GREEN, PALE_GREEN, 90);
        EnumFlowerColor.addMix(TAN, STEEL_BLUE, DARK_GRAY, 85);
        EnumFlowerColor.addMix(TEAL, AQUAMARINE, LIGHT_SEA_GREEN, 90);
        EnumFlowerColor.addMix(TEAL, BLACK, DARK_SLATE_GRAY, 85);
        EnumFlowerColor.addMix(TEAL, BLUE, DARK_SLATE_BLUE, 85);
        EnumFlowerColor.addMix(TEAL, BROWN, DIM_GRAY, 75);
        EnumFlowerColor.addMix(TEAL, CADET_BLUE, LIGHT_SEA_GREEN, 115);
        EnumFlowerColor.addMix(TEAL, CHOCOLATE, DARK_OLIVE_GREEN, 80);
        EnumFlowerColor.addMix(TEAL, CORAL, GRAY, 75);
        EnumFlowerColor.addMix(TEAL, CYAN, DARK_TURQUOISE, 90);
        EnumFlowerColor.addMix(TEAL, DARK_GOLDENROD, OLIVE_DRAB, 85);
        EnumFlowerColor.addMix(TEAL, DARK_GRAY, CADET_BLUE, 100);
        EnumFlowerColor.addMix(TEAL, DARK_GREEN, SEA_GREEN, 100);
        EnumFlowerColor.addMix(TEAL, DARK_KHAKI, SEA_GREEN, 90);
        EnumFlowerColor.addMix(TEAL, DARK_OLIVE_GREEN, SEA_GREEN, 100);
        EnumFlowerColor.addMix(TEAL, DARK_ORANGE, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(TEAL, DARK_SALMON, CADET_BLUE, 80);
        EnumFlowerColor.addMix(TEAL, DARK_SEA_GREEN, LIGHT_SEA_GREEN, 100);
        EnumFlowerColor.addMix(TEAL, DARK_TURQUOISE, LIGHT_SEA_GREEN, 105);
        EnumFlowerColor.addMix(TEAL, DARK_VIOLET, DARK_SLATE_BLUE, 90);
        EnumFlowerColor.addMix(TEAL, DEEP_PINK, PURPLE, 70);
        EnumFlowerColor.addMix(TEAL, DEEP_SKY_BLUE, CADET_BLUE, 100);
        EnumFlowerColor.addMix(TEAL, DODGER_BLUE, STEEL_BLUE, 95);
        EnumFlowerColor.addMix(TEAL, GOLD, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(TEAL, GOLDENROD, OLIVE_DRAB, 80);
        EnumFlowerColor.addMix(TEAL, GRAY, CADET_BLUE, 105);
        EnumFlowerColor.addMix(TEAL, GREEN, SEA_GREEN, 100);
        EnumFlowerColor.addMix(TEAL, INDIAN_RED, DIM_GRAY, 75);
        EnumFlowerColor.addMix(TEAL, INDIGO, DARK_SLATE_BLUE, 85);
        EnumFlowerColor.addMix(TEAL, KHAKI, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(TEAL, LAVENDER, CADET_BLUE, 85);
        EnumFlowerColor.addMix(TEAL, LEMON_CHIFFON, MEDIUM_AQUAMARINE, 80);
        EnumFlowerColor.addMix(TEAL, LIGHT_GRAY, CADET_BLUE, 90);
        EnumFlowerColor.addMix(TEAL, LIGHT_SEA_GREEN, CADET_BLUE, 110);
        EnumFlowerColor.addMix(TEAL, LIGHT_STEEL_BLUE, CADET_BLUE, 95);
        EnumFlowerColor.addMix(TEAL, LIME, LIME_GREEN, 80);
        EnumFlowerColor.addMix(TEAL, LIME_GREEN, MEDIUM_SEA_GREEN, 90);
        EnumFlowerColor.addMix(TEAL, MAGENTA, DARK_VIOLET, 85);
        EnumFlowerColor.addMix(TEAL, MAROON, GRAY, 70);
        EnumFlowerColor.addMix(TEAL, MEDIUM_AQUAMARINE, LIGHT_SEA_GREEN, 100);
        EnumFlowerColor.addMix(TEAL, MEDIUM_ORCHID, ROYAL_BLUE, 85);
        EnumFlowerColor.addMix(TEAL, MEDIUM_PURPLE, STEEL_BLUE, 90);
        EnumFlowerColor.addMix(TEAL, MEDIUM_SEA_GREEN, SEA_GREEN, 100);
        EnumFlowerColor.addMix(TEAL, MEDIUM_VIOLET_RED, DARK_SLATE_BLUE, 75);
        EnumFlowerColor.addMix(TEAL, MISTY_ROSE, CADET_BLUE, 75);
        EnumFlowerColor.addMix(TEAL, NAVY, DARK_SLATE_BLUE, 80);
        EnumFlowerColor.addMix(TEAL, OLIVE, SEA_GREEN, 95);
        EnumFlowerColor.addMix(TEAL, OLIVE_DRAB, SEA_GREEN, 95);
        EnumFlowerColor.addMix(TEAL, ORANGE, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(TEAL, PALE_GREEN, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(TEAL, PALE_TURQUOISE, LIGHT_SEA_GREEN, 95);
        EnumFlowerColor.addMix(TEAL, PALE_VIOLET_RED, SLATE_GRAY, 70);
        EnumFlowerColor.addMix(TEAL, PERU, SEA_GREEN, 85);
        EnumFlowerColor.addMix(TEAL, PINK, CADET_BLUE, 65);
        EnumFlowerColor.addMix(TEAL, PLUM, STEEL_BLUE, 80);
        EnumFlowerColor.addMix(TEAL, PURPLE, DARK_SLATE_BLUE, 80);
        EnumFlowerColor.addMix(TEAL, RED, BROWN, 70);
        EnumFlowerColor.addMix(TEAL, ROSY_BROWN, CADET_BLUE, 85);
        EnumFlowerColor.addMix(TEAL, ROYAL_BLUE, STEEL_BLUE, 95);
        EnumFlowerColor.addMix(TEAL, SALMON, GRAY, 70);
        EnumFlowerColor.addMix(TEAL, SANDY_BROWN, SEA_GREEN, 80);
        EnumFlowerColor.addMix(TEAL, SIENNA, DARK_OLIVE_GREEN, 80);
        EnumFlowerColor.addMix(TEAL, SKY_BLUE, CADET_BLUE, 100);
        EnumFlowerColor.addMix(TEAL, SLATE_BLUE, STEEL_BLUE, 95);
        EnumFlowerColor.addMix(TEAL, SLATE_GRAY, CADET_BLUE, 105);
        EnumFlowerColor.addMix(TEAL, SPRING_GREEN, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(TEAL, TAN, CADET_BLUE, 85);
        EnumFlowerColor.addMix(THISTLE, AQUAMARINE, PALE_TURQUOISE, 85);
        EnumFlowerColor.addMix(THISTLE, BLACK, DIM_GRAY, 55);
        EnumFlowerColor.addMix(THISTLE, BLUE, SLATE_BLUE, 75);
        EnumFlowerColor.addMix(THISTLE, BROWN, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(THISTLE, CADET_BLUE, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(THISTLE, CHOCOLATE, DARK_SALMON, 90);
        EnumFlowerColor.addMix(THISTLE, CORAL, DARK_SALMON, 95);
        EnumFlowerColor.addMix(THISTLE, CRIMSON, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(THISTLE, CYAN, DARK_TURQUOISE, 80);
        EnumFlowerColor.addMix(THISTLE, DARK_GOLDENROD, TAN, 85);
        EnumFlowerColor.addMix(THISTLE, DARK_GRAY, LIGHT_GRAY, 110);
        EnumFlowerColor.addMix(THISTLE, DARK_GREEN, SEA_GREEN, 60);
        EnumFlowerColor.addMix(THISTLE, DARK_KHAKI, TAN, 85);
        EnumFlowerColor.addMix(THISTLE, DARK_OLIVE_GREEN, DARK_GRAY, 75);
        EnumFlowerColor.addMix(THISTLE, DARK_ORANGE, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(THISTLE, DARK_SALMON, PINK, 100);
        EnumFlowerColor.addMix(THISTLE, DARK_SEA_GREEN, DARK_GRAY, 85);
        EnumFlowerColor.addMix(THISTLE, DARK_SLATE_BLUE, MEDIUM_PURPLE, 75);
        EnumFlowerColor.addMix(THISTLE, DARK_SLATE_GRAY, SLATE_GRAY, 70);
        EnumFlowerColor.addMix(THISTLE, DARK_TURQUOISE, SKY_BLUE, 85);
        EnumFlowerColor.addMix(THISTLE, DARK_VIOLET, MEDIUM_ORCHID, 85);
        EnumFlowerColor.addMix(THISTLE, DEEP_PINK, HOT_PINK, 95);
        EnumFlowerColor.addMix(THISTLE, DEEP_SKY_BLUE, SKY_BLUE, 85);
        EnumFlowerColor.addMix(THISTLE, DIM_GRAY, DARK_GRAY, 90);
        EnumFlowerColor.addMix(THISTLE, DODGER_BLUE, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(THISTLE, GOLD, KHAKI, 80);
        EnumFlowerColor.addMix(THISTLE, GOLDENROD, TAN, 85);
        EnumFlowerColor.addMix(THISTLE, GRAY, DARK_GRAY, 100);
        EnumFlowerColor.addMix(THISTLE, GREEN, MEDIUM_SEA_GREEN, 65);
        EnumFlowerColor.addMix(THISTLE, HOT_PINK, PLUM, 105);
        EnumFlowerColor.addMix(THISTLE, INDIAN_RED, ROSY_BROWN, 95);
        EnumFlowerColor.addMix(THISTLE, INDIGO, MEDIUM_ORCHID, 60);
        EnumFlowerColor.addMix(THISTLE, KHAKI, WHEAT, 85);
        EnumFlowerColor.addMix(THISTLE, LAVENDER, MISTY_ROSE, 115);
        EnumFlowerColor.addMix(THISTLE, LEMON_CHIFFON, MISTY_ROSE, 90);
        EnumFlowerColor.addMix(THISTLE, LIGHT_GRAY, LAVENDER, 110);
        EnumFlowerColor.addMix(THISTLE, LIGHT_SEA_GREEN, CADET_BLUE, 85);
        EnumFlowerColor.addMix(THISTLE, LIGHT_STEEL_BLUE, LAVENDER, 110);
        EnumFlowerColor.addMix(THISTLE, LIME, LIME_GREEN, 65);
        EnumFlowerColor.addMix(THISTLE, LIME_GREEN, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(THISTLE, MAGENTA, VIOLET, 95);
        EnumFlowerColor.addMix(THISTLE, MAROON, INDIAN_RED, 65);
        EnumFlowerColor.addMix(THISTLE, MEDIUM_AQUAMARINE, PALE_TURQUOISE, 90);
        EnumFlowerColor.addMix(THISTLE, MEDIUM_ORCHID, PLUM, 95);
        EnumFlowerColor.addMix(THISTLE, MEDIUM_PURPLE, PLUM, 100);
        EnumFlowerColor.addMix(THISTLE, MEDIUM_SEA_GREEN, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(THISTLE, MEDIUM_VIOLET_RED, HOT_PINK, 90);
        EnumFlowerColor.addMix(THISTLE, MISTY_ROSE, PINK, 115);
        EnumFlowerColor.addMix(THISTLE, NAVY, SLATE_BLUE, 55);
        EnumFlowerColor.addMix(THISTLE, OLIVE, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(THISTLE, OLIVE_DRAB, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(THISTLE, ORANGE, SANDY_BROWN, 85);
        EnumFlowerColor.addMix(THISTLE, PALE_GREEN, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(THISTLE, PALE_TURQUOISE, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(THISTLE, PALE_VIOLET_RED, PLUM, 105);
        EnumFlowerColor.addMix(THISTLE, PERU, DARK_SALMON, 90);
        EnumFlowerColor.addMix(THISTLE, PINK, MISTY_ROSE, 115);
        EnumFlowerColor.addMix(THISTLE, PLUM, PINK, 115);
        EnumFlowerColor.addMix(THISTLE, PURPLE, MEDIUM_ORCHID, 75);
        EnumFlowerColor.addMix(THISTLE, RED, INDIAN_RED, 85);
        EnumFlowerColor.addMix(THISTLE, ROSY_BROWN, PINK, 110);
        EnumFlowerColor.addMix(THISTLE, ROYAL_BLUE, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(THISTLE, SALMON, PINK, 100);
        EnumFlowerColor.addMix(THISTLE, SANDY_BROWN, DARK_SALMON, 95);
        EnumFlowerColor.addMix(THISTLE, SEA_GREEN, CADET_BLUE, 85);
        EnumFlowerColor.addMix(THISTLE, SIENNA, ROSY_BROWN, 85);
        EnumFlowerColor.addMix(THISTLE, SKY_BLUE, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(THISTLE, SLATE_BLUE, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(THISTLE, SLATE_GRAY, DARK_GRAY, 100);
        EnumFlowerColor.addMix(THISTLE, SPRING_GREEN, MEDIUM_AQUAMARINE, 85);
        EnumFlowerColor.addMix(THISTLE, STEEL_BLUE, LIGHT_STEEL_BLUE, 90);
        EnumFlowerColor.addMix(THISTLE, TAN, MISTY_ROSE, 100);
        EnumFlowerColor.addMix(THISTLE, TEAL, CADET_BLUE, 80);
        EnumFlowerColor.addMix(TURQUOISE, AQUAMARINE, MEDIUM_AQUAMARINE, 115);
        EnumFlowerColor.addMix(TURQUOISE, BLACK, TEAL, 50);
        EnumFlowerColor.addMix(TURQUOISE, BLUE, ROYAL_BLUE, 60);
        EnumFlowerColor.addMix(TURQUOISE, BROWN, GRAY, 55);
        EnumFlowerColor.addMix(TURQUOISE, CADET_BLUE, LIGHT_SEA_GREEN, 110);
        EnumFlowerColor.addMix(TURQUOISE, CHOCOLATE, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(TURQUOISE, CORAL, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(TURQUOISE, CRIMSON, GRAY, 50);
        EnumFlowerColor.addMix(TURQUOISE, CYAN, DARK_TURQUOISE, 120);
        EnumFlowerColor.addMix(TURQUOISE, DARK_GOLDENROD, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(TURQUOISE, DARK_GRAY, DARK_TURQUOISE, 100);
        EnumFlowerColor.addMix(TURQUOISE, DARK_GREEN, MEDIUM_SEA_GREEN, 80);
        EnumFlowerColor.addMix(TURQUOISE, DARK_KHAKI, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(TURQUOISE, DARK_OLIVE_GREEN, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(TURQUOISE, DARK_ORANGE, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(TURQUOISE, DARK_SALMON, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(TURQUOISE, DARK_SEA_GREEN, MEDIUM_AQUAMARINE, 110);
        EnumFlowerColor.addMix(TURQUOISE, DARK_SLATE_BLUE, STEEL_BLUE, 65);
        EnumFlowerColor.addMix(TURQUOISE, DARK_SLATE_GRAY, CADET_BLUE, 75);
        EnumFlowerColor.addMix(TURQUOISE, DARK_TURQUOISE, CYAN, 120);
        EnumFlowerColor.addMix(TURQUOISE, DARK_VIOLET, ROYAL_BLUE, 65);
        EnumFlowerColor.addMix(TURQUOISE, DEEP_PINK, MEDIUM_PURPLE, 55);
        EnumFlowerColor.addMix(TURQUOISE, DEEP_SKY_BLUE, DARK_TURQUOISE, 100);
        EnumFlowerColor.addMix(TURQUOISE, DIM_GRAY, CADET_BLUE, 85);
        EnumFlowerColor.addMix(TURQUOISE, DODGER_BLUE, DEEP_SKY_BLUE, 90);
        EnumFlowerColor.addMix(TURQUOISE, GOLD, YELLOW_GREEN, 85);
        EnumFlowerColor.addMix(TURQUOISE, GOLDENROD, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(TURQUOISE, GRAY, LIGHT_SEA_GREEN, 95);
        EnumFlowerColor.addMix(TURQUOISE, GREEN, MEDIUM_SEA_GREEN, 90);
        EnumFlowerColor.addMix(TURQUOISE, HOT_PINK, LIGHT_STEEL_BLUE, 65);
        EnumFlowerColor.addMix(TURQUOISE, INDIAN_RED, CADET_BLUE, 60);
        EnumFlowerColor.addMix(TURQUOISE, INDIGO, ROYAL_BLUE, 50);
        EnumFlowerColor.addMix(TURQUOISE, KHAKI, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(TURQUOISE, LAVENDER, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(TURQUOISE, LEMON_CHIFFON, AQUAMARINE, 100);
        EnumFlowerColor.addMix(TURQUOISE, LIGHT_GRAY, PALE_TURQUOISE, 100);
        EnumFlowerColor.addMix(TURQUOISE, LIGHT_SEA_GREEN, DARK_TURQUOISE, 115);
        EnumFlowerColor.addMix(TURQUOISE, LIGHT_STEEL_BLUE, DARK_TURQUOISE, 100);
        EnumFlowerColor.addMix(TURQUOISE, LIME, SPRING_GREEN, 95);
        EnumFlowerColor.addMix(TURQUOISE, LIME_GREEN, MEDIUM_SEA_GREEN, 100);
        EnumFlowerColor.addMix(TURQUOISE, MAGENTA, MEDIUM_PURPLE, 75);
        EnumFlowerColor.addMix(TURQUOISE, MAROON, DIM_GRAY, 45);
        EnumFlowerColor.addMix(TURQUOISE, MEDIUM_AQUAMARINE, DARK_TURQUOISE, 120);
        EnumFlowerColor.addMix(TURQUOISE, MEDIUM_ORCHID, DODGER_BLUE, 75);
        EnumFlowerColor.addMix(TURQUOISE, MEDIUM_PURPLE, DEEP_SKY_BLUE, 80);
        EnumFlowerColor.addMix(TURQUOISE, MEDIUM_SEA_GREEN, MEDIUM_AQUAMARINE, 110);
        EnumFlowerColor.addMix(TURQUOISE, MEDIUM_VIOLET_RED, MEDIUM_PURPLE, 60);
        EnumFlowerColor.addMix(TURQUOISE, MISTY_ROSE, PALE_TURQUOISE, 90);
        EnumFlowerColor.addMix(TURQUOISE, NAVY, STEEL_BLUE, 45);
        EnumFlowerColor.addMix(TURQUOISE, OLIVE, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(TURQUOISE, OLIVE_DRAB, MEDIUM_SEA_GREEN, 90);
        EnumFlowerColor.addMix(TURQUOISE, ORANGE, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(TURQUOISE, PALE_GREEN, AQUAMARINE, 105);
        EnumFlowerColor.addMix(TURQUOISE, PALE_TURQUOISE, CYAN, 115);
        EnumFlowerColor.addMix(TURQUOISE, PALE_VIOLET_RED, DARK_GRAY, 60);
        EnumFlowerColor.addMix(TURQUOISE, PERU, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(TURQUOISE, PINK, PALE_TURQUOISE, 75);
        EnumFlowerColor.addMix(TURQUOISE, PLUM, SKY_BLUE, 80);
        EnumFlowerColor.addMix(TURQUOISE, PURPLE, ROYAL_BLUE, 55);
        EnumFlowerColor.addMix(TURQUOISE, RED, ROSY_BROWN, 55);
        EnumFlowerColor.addMix(TURQUOISE, ROSY_BROWN, CADET_BLUE, 80);
        EnumFlowerColor.addMix(TURQUOISE, ROYAL_BLUE, DEEP_SKY_BLUE, 80);
        EnumFlowerColor.addMix(TURQUOISE, SALMON, DARK_GRAY, 65);
        EnumFlowerColor.addMix(TURQUOISE, SANDY_BROWN, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(TURQUOISE, SEA_GREEN, MEDIUM_AQUAMARINE, 100);
        EnumFlowerColor.addMix(TURQUOISE, SIENNA, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(TURQUOISE, SKY_BLUE, DARK_TURQUOISE, 110);
        EnumFlowerColor.addMix(TURQUOISE, SLATE_BLUE, DODGER_BLUE, 75);
        EnumFlowerColor.addMix(TURQUOISE, SLATE_GRAY, LIGHT_SEA_GREEN, 95);
        EnumFlowerColor.addMix(TURQUOISE, SPRING_GREEN, AQUAMARINE, 105);
        EnumFlowerColor.addMix(TURQUOISE, STEEL_BLUE, CADET_BLUE, 90);
        EnumFlowerColor.addMix(TURQUOISE, TAN, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(TURQUOISE, TEAL, LIGHT_SEA_GREEN, 100);
        EnumFlowerColor.addMix(TURQUOISE, THISTLE, PALE_TURQUOISE, 85);
        EnumFlowerColor.addMix(VIOLET, AQUAMARINE, LIGHT_STEEL_BLUE, 75);
        EnumFlowerColor.addMix(VIOLET, BLACK, PURPLE, 60);
        EnumFlowerColor.addMix(VIOLET, BLUE, SLATE_BLUE, 85);
        EnumFlowerColor.addMix(VIOLET, BROWN, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(VIOLET, CADET_BLUE, PLUM, 95);
        EnumFlowerColor.addMix(VIOLET, CHOCOLATE, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(VIOLET, CORAL, PALE_VIOLET_RED, 85);
        EnumFlowerColor.addMix(VIOLET, CRIMSON, DEEP_PINK, 90);
        EnumFlowerColor.addMix(VIOLET, CYAN, DEEP_SKY_BLUE, 70);
        EnumFlowerColor.addMix(VIOLET, DARK_GOLDENROD, SALMON, 65);
        EnumFlowerColor.addMix(VIOLET, DARK_GRAY, PLUM, 100);
        EnumFlowerColor.addMix(VIOLET, DARK_KHAKI, ROSY_BROWN, 65);
        EnumFlowerColor.addMix(VIOLET, DARK_OLIVE_GREEN, ROSY_BROWN, 55);
        EnumFlowerColor.addMix(VIOLET, DARK_ORANGE, SALMON, 75);
        EnumFlowerColor.addMix(VIOLET, DARK_SALMON, HOT_PINK, 90);
        EnumFlowerColor.addMix(VIOLET, DARK_SEA_GREEN, THISTLE, 60);
        EnumFlowerColor.addMix(VIOLET, DARK_SLATE_BLUE, MEDIUM_ORCHID, 85);
        EnumFlowerColor.addMix(VIOLET, DARK_SLATE_GRAY, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(VIOLET, DARK_TURQUOISE, DODGER_BLUE, 75);
        EnumFlowerColor.addMix(VIOLET, DARK_VIOLET, MEDIUM_ORCHID, 95);
        EnumFlowerColor.addMix(VIOLET, DEEP_PINK, HOT_PINK, 110);
        EnumFlowerColor.addMix(VIOLET, DEEP_SKY_BLUE, DODGER_BLUE, 75);
        EnumFlowerColor.addMix(VIOLET, DIM_GRAY, MEDIUM_ORCHID, 90);
        EnumFlowerColor.addMix(VIOLET, DODGER_BLUE, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(VIOLET, GOLD, SANDY_BROWN, 55);
        EnumFlowerColor.addMix(VIOLET, GOLDENROD, DARK_SALMON, 65);
        EnumFlowerColor.addMix(VIOLET, GRAY, PLUM, 95);
        EnumFlowerColor.addMix(VIOLET, HOT_PINK, PLUM, 115);
        EnumFlowerColor.addMix(VIOLET, INDIAN_RED, PALE_VIOLET_RED, 95);
        EnumFlowerColor.addMix(VIOLET, INDIGO, DARK_VIOLET, 80);
        EnumFlowerColor.addMix(VIOLET, KHAKI, PINK, 60);
        EnumFlowerColor.addMix(VIOLET, LAVENDER, PLUM, 100);
        EnumFlowerColor.addMix(VIOLET, LEMON_CHIFFON, PINK, 70);
        EnumFlowerColor.addMix(VIOLET, LIGHT_GRAY, PLUM, 95);
        EnumFlowerColor.addMix(VIOLET, LIGHT_STEEL_BLUE, PLUM, 100);
        EnumFlowerColor.addMix(VIOLET, MAGENTA, MEDIUM_ORCHID, 115);
        EnumFlowerColor.addMix(VIOLET, MAROON, MEDIUM_VIOLET_RED, 70);
        EnumFlowerColor.addMix(VIOLET, MEDIUM_AQUAMARINE, THISTLE, 80);
        EnumFlowerColor.addMix(VIOLET, MEDIUM_ORCHID, MAGENTA, 115);
        EnumFlowerColor.addMix(VIOLET, MEDIUM_PURPLE, MEDIUM_ORCHID, 110);
        EnumFlowerColor.addMix(VIOLET, MEDIUM_SEA_GREEN, DARK_GRAY, 75);
        EnumFlowerColor.addMix(VIOLET, MEDIUM_VIOLET_RED, MEDIUM_ORCHID, 100);
        EnumFlowerColor.addMix(VIOLET, MISTY_ROSE, PLUM, 95);
        EnumFlowerColor.addMix(VIOLET, NAVY, DARK_VIOLET, 75);
        EnumFlowerColor.addMix(VIOLET, OLIVE, ROSY_BROWN, 55);
        EnumFlowerColor.addMix(VIOLET, OLIVE_DRAB, ROSY_BROWN, 50);
        EnumFlowerColor.addMix(VIOLET, ORANGE, DARK_SALMON, 65);
        EnumFlowerColor.addMix(VIOLET, PALE_TURQUOISE, THISTLE, 90);
        EnumFlowerColor.addMix(VIOLET, PALE_VIOLET_RED, HOT_PINK, 110);
        EnumFlowerColor.addMix(VIOLET, PERU, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(VIOLET, PINK, PLUM, 105);
        EnumFlowerColor.addMix(VIOLET, PLUM, HOT_PINK, 120);
        EnumFlowerColor.addMix(VIOLET, PURPLE, MEDIUM_ORCHID, 85);
        EnumFlowerColor.addMix(VIOLET, RED, DEEP_PINK, 85);
        EnumFlowerColor.addMix(VIOLET, ROSY_BROWN, PLUM, 100);
        EnumFlowerColor.addMix(VIOLET, ROYAL_BLUE, MEDIUM_PURPLE, 95);
        EnumFlowerColor.addMix(VIOLET, SALMON, HOT_PINK, 95);
        EnumFlowerColor.addMix(VIOLET, SANDY_BROWN, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(VIOLET, SIENNA, PALE_VIOLET_RED, 80);
        EnumFlowerColor.addMix(VIOLET, SKY_BLUE, PLUM, 90);
        EnumFlowerColor.addMix(VIOLET, SLATE_BLUE, MEDIUM_PURPLE, 100);
        EnumFlowerColor.addMix(VIOLET, SLATE_GRAY, PLUM, 100);
        EnumFlowerColor.addMix(VIOLET, SPRING_GREEN, LIGHT_SEA_GREEN, 70);
        EnumFlowerColor.addMix(VIOLET, STEEL_BLUE, MEDIUM_PURPLE, 90);
        EnumFlowerColor.addMix(VIOLET, TAN, PLUM, 80);
        EnumFlowerColor.addMix(VIOLET, TEAL, MEDIUM_PURPLE, 80);
        EnumFlowerColor.addMix(VIOLET, THISTLE, PLUM, 105);
        EnumFlowerColor.addMix(VIOLET, TURQUOISE, LIGHT_STEEL_BLUE, 75);
        EnumFlowerColor.addMix(WHEAT, AQUAMARINE, PALE_GREEN, 100);
        EnumFlowerColor.addMix(WHEAT, BLUE, MEDIUM_PURPLE, 50);
        EnumFlowerColor.addMix(WHEAT, BROWN, DARK_SALMON, 75);
        EnumFlowerColor.addMix(WHEAT, CADET_BLUE, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(WHEAT, CHOCOLATE, SANDY_BROWN, 95);
        EnumFlowerColor.addMix(WHEAT, CORAL, SANDY_BROWN, 100);
        EnumFlowerColor.addMix(WHEAT, CRIMSON, SALMON, 80);
        EnumFlowerColor.addMix(WHEAT, CYAN, TURQUOISE, 90);
        EnumFlowerColor.addMix(WHEAT, DARK_GOLDENROD, GOLDENROD, 100);
        EnumFlowerColor.addMix(WHEAT, DARK_GRAY, TAN, 105);
        EnumFlowerColor.addMix(WHEAT, DARK_GREEN, OLIVE_DRAB, 75);
        EnumFlowerColor.addMix(WHEAT, DARK_KHAKI, KHAKI, 110);
        EnumFlowerColor.addMix(WHEAT, DARK_OLIVE_GREEN, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(WHEAT, DARK_ORANGE, ORANGE, 100);
        EnumFlowerColor.addMix(WHEAT, DARK_SALMON, TAN, 105);
        EnumFlowerColor.addMix(WHEAT, DARK_SEA_GREEN, DARK_KHAKI, 105);
        EnumFlowerColor.addMix(WHEAT, DARK_SLATE_BLUE, ROSY_BROWN, 60);
        EnumFlowerColor.addMix(WHEAT, DARK_SLATE_GRAY, DARK_GRAY, 70);
        EnumFlowerColor.addMix(WHEAT, DARK_TURQUOISE, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(WHEAT, DARK_VIOLET, MEDIUM_ORCHID, 60);
        EnumFlowerColor.addMix(WHEAT, DEEP_PINK, PALE_VIOLET_RED, 75);
        EnumFlowerColor.addMix(WHEAT, DEEP_SKY_BLUE, SKY_BLUE, 80);
        EnumFlowerColor.addMix(WHEAT, DIM_GRAY, TAN, 85);
        EnumFlowerColor.addMix(WHEAT, DODGER_BLUE, SKY_BLUE, 75);
        EnumFlowerColor.addMix(WHEAT, GOLD, KHAKI, 110);
        EnumFlowerColor.addMix(WHEAT, GOLDENROD, DARK_KHAKI, 105);
        EnumFlowerColor.addMix(WHEAT, GRAY, TAN, 95);
        EnumFlowerColor.addMix(WHEAT, GREEN, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(WHEAT, HOT_PINK, PINK, 80);
        EnumFlowerColor.addMix(WHEAT, INDIAN_RED, DARK_SALMON, 85);
        EnumFlowerColor.addMix(WHEAT, KHAKI, LEMON_CHIFFON, 115);
        EnumFlowerColor.addMix(WHEAT, LAVENDER, LIGHT_GRAY, 100);
        EnumFlowerColor.addMix(WHEAT, LEMON_CHIFFON, KHAKI, 120);
        EnumFlowerColor.addMix(WHEAT, LIGHT_GRAY, LEMON_CHIFFON, 110);
        EnumFlowerColor.addMix(WHEAT, LIGHT_SEA_GREEN, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(WHEAT, LIGHT_STEEL_BLUE, LIGHT_GRAY, 95);
        EnumFlowerColor.addMix(WHEAT, LIME, PALE_GREEN, 95);
        EnumFlowerColor.addMix(WHEAT, LIME_GREEN, YELLOW_GREEN, 95);
        EnumFlowerColor.addMix(WHEAT, MAGENTA, VIOLET, 70);
        EnumFlowerColor.addMix(WHEAT, MAROON, INDIAN_RED, 60);
        EnumFlowerColor.addMix(WHEAT, MEDIUM_AQUAMARINE, DARK_SEA_GREEN, 100);
        EnumFlowerColor.addMix(WHEAT, MEDIUM_ORCHID, PLUM, 70);
        EnumFlowerColor.addMix(WHEAT, MEDIUM_PURPLE, THISTLE, 75);
        EnumFlowerColor.addMix(WHEAT, MEDIUM_SEA_GREEN, DARK_SEA_GREEN, 95);
        EnumFlowerColor.addMix(WHEAT, MEDIUM_VIOLET_RED, PALE_VIOLET_RED, 70);
        EnumFlowerColor.addMix(WHEAT, MISTY_ROSE, TAN, 110);
        EnumFlowerColor.addMix(WHEAT, OLIVE, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(WHEAT, OLIVE_DRAB, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(WHEAT, ORANGE, GOLDENROD, 105);
        EnumFlowerColor.addMix(WHEAT, PALE_GREEN, LEMON_CHIFFON, 100);
        EnumFlowerColor.addMix(WHEAT, PALE_TURQUOISE, LEMON_CHIFFON, 100);
        EnumFlowerColor.addMix(WHEAT, PALE_VIOLET_RED, PINK, 85);
        EnumFlowerColor.addMix(WHEAT, PERU, TAN, 100);
        EnumFlowerColor.addMix(WHEAT, PINK, MISTY_ROSE, 100);
        EnumFlowerColor.addMix(WHEAT, PLUM, PINK, 85);
        EnumFlowerColor.addMix(WHEAT, PURPLE, PALE_VIOLET_RED, 55);
        EnumFlowerColor.addMix(WHEAT, RED, SALMON, 85);
        EnumFlowerColor.addMix(WHEAT, ROSY_BROWN, TAN, 100);
        EnumFlowerColor.addMix(WHEAT, ROYAL_BLUE, LIGHT_STEEL_BLUE, 70);
        EnumFlowerColor.addMix(WHEAT, SALMON, DARK_SALMON, 95);
        EnumFlowerColor.addMix(WHEAT, SANDY_BROWN, TAN, 110);
        EnumFlowerColor.addMix(WHEAT, SEA_GREEN, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(WHEAT, SIENNA, PERU, 85);
        EnumFlowerColor.addMix(WHEAT, SKY_BLUE, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(WHEAT, SLATE_BLUE, PLUM, 65);
        EnumFlowerColor.addMix(WHEAT, SLATE_GRAY, DARK_GRAY, 90);
        EnumFlowerColor.addMix(WHEAT, SPRING_GREEN, PALE_GREEN, 95);
        EnumFlowerColor.addMix(WHEAT, STEEL_BLUE, DARK_GRAY, 75);
        EnumFlowerColor.addMix(WHEAT, TAN, DARK_KHAKI, 115);
        EnumFlowerColor.addMix(WHEAT, TEAL, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(WHEAT, THISTLE, MISTY_ROSE, 95);
        EnumFlowerColor.addMix(WHEAT, TURQUOISE, MEDIUM_AQUAMARINE, 95);
        EnumFlowerColor.addMix(WHEAT, VIOLET, PINK, 75);
        EnumFlowerColor.addMix(WHITE, AQUAMARINE, PALE_TURQUOISE, 100);
        EnumFlowerColor.addMix(WHITE, BLUE, MEDIUM_PURPLE, 60);
        EnumFlowerColor.addMix(WHITE, BROWN, ROSY_BROWN, 70);
        EnumFlowerColor.addMix(WHITE, CADET_BLUE, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(WHITE, CHOCOLATE, TAN, 85);
        EnumFlowerColor.addMix(WHITE, CORAL, DARK_SALMON, 90);
        EnumFlowerColor.addMix(WHITE, CRIMSON, PALE_VIOLET_RED, 75);
        EnumFlowerColor.addMix(WHITE, CYAN, PALE_TURQUOISE, 100);
        EnumFlowerColor.addMix(WHITE, DARK_GOLDENROD, TAN, 85);
        EnumFlowerColor.addMix(WHITE, DARK_GRAY, LIGHT_GRAY, 105);
        EnumFlowerColor.addMix(WHITE, DARK_GREEN, DARK_SEA_GREEN, 70);
        EnumFlowerColor.addMix(WHITE, DARK_KHAKI, LEMON_CHIFFON, 100);
        EnumFlowerColor.addMix(WHITE, DARK_OLIVE_GREEN, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(WHITE, DARK_ORANGE, SANDY_BROWN, 90);
        EnumFlowerColor.addMix(WHITE, DARK_SALMON, MISTY_ROSE, 95);
        EnumFlowerColor.addMix(WHITE, DARK_SLATE_GRAY, DARK_GRAY, 70);
        EnumFlowerColor.addMix(WHITE, DARK_TURQUOISE, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(WHITE, DARK_VIOLET, VIOLET, 70);
        EnumFlowerColor.addMix(WHITE, DEEP_PINK, HOT_PINK, 85);
        EnumFlowerColor.addMix(WHITE, DEEP_SKY_BLUE, SKY_BLUE, 95);
        EnumFlowerColor.addMix(WHITE, DIM_GRAY, DARK_GRAY, 85);
        EnumFlowerColor.addMix(WHITE, DODGER_BLUE, SKY_BLUE, 85);
        EnumFlowerColor.addMix(WHITE, GOLD, KHAKI, 95);
        EnumFlowerColor.addMix(WHITE, GOLDENROD, WHEAT, 95);
        EnumFlowerColor.addMix(WHITE, GRAY, LIGHT_GRAY, 95);
        EnumFlowerColor.addMix(WHITE, GREEN, DARK_SEA_GREEN, 75);
        EnumFlowerColor.addMix(WHITE, HOT_PINK, PINK, 90);
        EnumFlowerColor.addMix(WHITE, INDIAN_RED, PINK, 85);
        EnumFlowerColor.addMix(WHITE, INDIGO, MEDIUM_PURPLE, 50);
        EnumFlowerColor.addMix(WHITE, KHAKI, LEMON_CHIFFON, 105);
        EnumFlowerColor.addMix(WHITE, LAVENDER, LIGHT_GRAY, 115);
        EnumFlowerColor.addMix(WHITE, LEMON_CHIFFON, WHEAT, 110);
        EnumFlowerColor.addMix(WHITE, LIGHT_GRAY, LAVENDER, 120);
        EnumFlowerColor.addMix(WHITE, LIGHT_SEA_GREEN, PALE_TURQUOISE, 95);
        EnumFlowerColor.addMix(WHITE, LIGHT_STEEL_BLUE, LAVENDER, 110);
        EnumFlowerColor.addMix(WHITE, LIME, PALE_GREEN, 95);
        EnumFlowerColor.addMix(WHITE, LIME_GREEN, PALE_GREEN, 90);
        EnumFlowerColor.addMix(WHITE, MAGENTA, VIOLET, 85);
        EnumFlowerColor.addMix(WHITE, MAROON, ROSY_BROWN, 55);
        EnumFlowerColor.addMix(WHITE, MEDIUM_AQUAMARINE, PALE_TURQUOISE, 100);
        EnumFlowerColor.addMix(WHITE, MEDIUM_ORCHID, PLUM, 80);
        EnumFlowerColor.addMix(WHITE, MEDIUM_PURPLE, THISTLE, 85);
        EnumFlowerColor.addMix(WHITE, MEDIUM_SEA_GREEN, MEDIUM_AQUAMARINE, 90);
        EnumFlowerColor.addMix(WHITE, MEDIUM_VIOLET_RED, PLUM, 75);
        EnumFlowerColor.addMix(WHITE, MISTY_ROSE, LIGHT_GRAY, 115);
        EnumFlowerColor.addMix(WHITE, OLIVE, DARK_KHAKI, 85);
        EnumFlowerColor.addMix(WHITE, OLIVE_DRAB, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(WHITE, ORANGE, WHEAT, 95);
        EnumFlowerColor.addMix(WHITE, PALE_GREEN, AQUAMARINE, 100);
        EnumFlowerColor.addMix(WHITE, PALE_VIOLET_RED, PINK, 90);
        EnumFlowerColor.addMix(WHITE, PERU, TAN, 90);
        EnumFlowerColor.addMix(WHITE, PINK, MISTY_ROSE, 105);
        EnumFlowerColor.addMix(WHITE, PLUM, THISTLE, 100);
        EnumFlowerColor.addMix(WHITE, PURPLE, PLUM, 60);
        EnumFlowerColor.addMix(WHITE, RED, SALMON, 80);
        EnumFlowerColor.addMix(WHITE, ROSY_BROWN, MISTY_ROSE, 95);
        EnumFlowerColor.addMix(WHITE, ROYAL_BLUE, LIGHT_STEEL_BLUE, 80);
        EnumFlowerColor.addMix(WHITE, SALMON, PINK, 95);
        EnumFlowerColor.addMix(WHITE, SANDY_BROWN, WHEAT, 95);
        EnumFlowerColor.addMix(WHITE, SEA_GREEN, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(WHITE, SIENNA, DARK_SALMON, 75);
        EnumFlowerColor.addMix(WHITE, SKY_BLUE, PALE_TURQUOISE, 105);
        EnumFlowerColor.addMix(WHITE, SLATE_BLUE, LIGHT_STEEL_BLUE, 75);
        EnumFlowerColor.addMix(WHITE, SLATE_GRAY, LIGHT_GRAY, 90);
        EnumFlowerColor.addMix(WHITE, SPRING_GREEN, AQUAMARINE, 95);
        EnumFlowerColor.addMix(WHITE, STEEL_BLUE, LIGHT_STEEL_BLUE, 85);
        EnumFlowerColor.addMix(WHITE, TAN, WHEAT, 105);
        EnumFlowerColor.addMix(WHITE, TEAL, DARK_TURQUOISE, 80);
        EnumFlowerColor.addMix(WHITE, THISTLE, LAVENDER, 105);
        EnumFlowerColor.addMix(WHITE, TURQUOISE, PALE_TURQUOISE, 100);
        EnumFlowerColor.addMix(WHITE, VIOLET, PLUM, 95);
        EnumFlowerColor.addMix(WHITE, WHEAT, LEMON_CHIFFON, 110);
        EnumFlowerColor.addMix(YELLOW, AQUAMARINE, PALE_GREEN, 95);
        EnumFlowerColor.addMix(YELLOW, BROWN, GOLDENROD, 55);
        EnumFlowerColor.addMix(YELLOW, CADET_BLUE, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(YELLOW, CHOCOLATE, GOLDENROD, 80);
        EnumFlowerColor.addMix(YELLOW, CORAL, GOLDENROD, 75);
        EnumFlowerColor.addMix(YELLOW, CRIMSON, DARK_ORANGE, 55);
        EnumFlowerColor.addMix(YELLOW, CYAN, PALE_GREEN, 85);
        EnumFlowerColor.addMix(YELLOW, DARK_GOLDENROD, GOLD, 95);
        EnumFlowerColor.addMix(YELLOW, DARK_GRAY, KHAKI, 90);
        EnumFlowerColor.addMix(YELLOW, DARK_GREEN, YELLOW_GREEN, 70);
        EnumFlowerColor.addMix(YELLOW, DARK_KHAKI, KHAKI, 105);
        EnumFlowerColor.addMix(YELLOW, DARK_OLIVE_GREEN, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(YELLOW, DARK_ORANGE, GOLD, 90);
        EnumFlowerColor.addMix(YELLOW, DARK_SALMON, GOLD, 80);
        EnumFlowerColor.addMix(YELLOW, DARK_SEA_GREEN, YELLOW_GREEN, 95);
        EnumFlowerColor.addMix(YELLOW, DARK_SLATE_GRAY, DARK_KHAKI, 60);
        EnumFlowerColor.addMix(YELLOW, DARK_TURQUOISE, PALE_GREEN, 80);
        EnumFlowerColor.addMix(YELLOW, DEEP_SKY_BLUE, PALE_GREEN, 60);
        EnumFlowerColor.addMix(YELLOW, DIM_GRAY, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(YELLOW, DODGER_BLUE, DARK_SEA_GREEN, 45);
        EnumFlowerColor.addMix(YELLOW, GOLD, KHAKI, 115);
        EnumFlowerColor.addMix(YELLOW, GOLDENROD, GOLD, 100);
        EnumFlowerColor.addMix(YELLOW, GRAY, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(YELLOW, GREEN, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(YELLOW, HOT_PINK, SANDY_BROWN, 50);
        EnumFlowerColor.addMix(YELLOW, INDIAN_RED, GOLDENROD, 65);
        EnumFlowerColor.addMix(YELLOW, KHAKI, GOLD, 115);
        EnumFlowerColor.addMix(YELLOW, LAVENDER, KHAKI, 80);
        EnumFlowerColor.addMix(YELLOW, LEMON_CHIFFON, KHAKI, 105);
        EnumFlowerColor.addMix(YELLOW, LIGHT_GRAY, KHAKI, 95);
        EnumFlowerColor.addMix(YELLOW, LIGHT_SEA_GREEN, YELLOW_GREEN, 80);
        EnumFlowerColor.addMix(YELLOW, LIGHT_STEEL_BLUE, KHAKI, 75);
        EnumFlowerColor.addMix(YELLOW, LIME, SPRING_GREEN, 105);
        EnumFlowerColor.addMix(YELLOW, LIME_GREEN, YELLOW_GREEN, 100);
        EnumFlowerColor.addMix(YELLOW, MAROON, DARK_GOLDENROD, 45);
        EnumFlowerColor.addMix(YELLOW, MEDIUM_AQUAMARINE, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(YELLOW, MEDIUM_SEA_GREEN, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(YELLOW, MISTY_ROSE, KHAKI, 90);
        EnumFlowerColor.addMix(YELLOW, OLIVE, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(YELLOW, OLIVE_DRAB, YELLOW_GREEN, 90);
        EnumFlowerColor.addMix(YELLOW, ORANGE, GOLD, 95);
        EnumFlowerColor.addMix(YELLOW, PALE_GREEN, YELLOW_GREEN, 105);
        EnumFlowerColor.addMix(YELLOW, PALE_TURQUOISE, KHAKI, 90);
        EnumFlowerColor.addMix(YELLOW, PALE_VIOLET_RED, GOLDENROD, 55);
        EnumFlowerColor.addMix(YELLOW, PERU, GOLD, 90);
        EnumFlowerColor.addMix(YELLOW, PINK, GOLD, 75);
        EnumFlowerColor.addMix(YELLOW, PLUM, KHAKI, 55);
        EnumFlowerColor.addMix(YELLOW, RED, DARK_ORANGE, 60);
        EnumFlowerColor.addMix(YELLOW, ROSY_BROWN, GOLD, 75);
        EnumFlowerColor.addMix(YELLOW, SALMON, GOLDENROD, 70);
        EnumFlowerColor.addMix(YELLOW, SANDY_BROWN, GOLD, 90);
        EnumFlowerColor.addMix(YELLOW, SEA_GREEN, YELLOW_GREEN, 85);
        EnumFlowerColor.addMix(YELLOW, SIENNA, GOLDENROD, 70);
        EnumFlowerColor.addMix(YELLOW, SKY_BLUE, YELLOW_GREEN, 75);
        EnumFlowerColor.addMix(YELLOW, SLATE_GRAY, DARK_KHAKI, 70);
        EnumFlowerColor.addMix(YELLOW, SPRING_GREEN, LIME, 100);
        EnumFlowerColor.addMix(YELLOW, STEEL_BLUE, YELLOW_GREEN, 55);
        EnumFlowerColor.addMix(YELLOW, TAN, GOLD, 100);
        EnumFlowerColor.addMix(YELLOW, TEAL, YELLOW_GREEN, 70);
        EnumFlowerColor.addMix(YELLOW, THISTLE, KHAKI, 75);
        EnumFlowerColor.addMix(YELLOW, TURQUOISE, PALE_GREEN, 85);
        EnumFlowerColor.addMix(YELLOW, WHEAT, KHAKI, 105);
        EnumFlowerColor.addMix(YELLOW, WHITE, KHAKI, 95);
        EnumFlowerColor.addMix(YELLOW_GREEN, AQUAMARINE, PALE_GREEN, 100);
        EnumFlowerColor.addMix(YELLOW_GREEN, BLACK, DARK_OLIVE_GREEN, 55);
        EnumFlowerColor.addMix(YELLOW_GREEN, BROWN, DARK_GOLDENROD, 55);
        EnumFlowerColor.addMix(YELLOW_GREEN, CADET_BLUE, DARK_SEA_GREEN, 90);
        EnumFlowerColor.addMix(YELLOW_GREEN, CHOCOLATE, GOLDENROD, 75);
        EnumFlowerColor.addMix(YELLOW_GREEN, CORAL, GOLDENROD, 75);
        EnumFlowerColor.addMix(YELLOW_GREEN, CRIMSON, CHOCOLATE, 50);
        EnumFlowerColor.addMix(YELLOW_GREEN, CYAN, SPRING_GREEN, 90);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_GOLDENROD, DARK_KHAKI, 95);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_GRAY, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_GREEN, OLIVE_DRAB, 85);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_OLIVE_GREEN, OLIVE_DRAB, 95);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_ORANGE, GOLDENROD, 85);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_SALMON, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_SEA_GREEN, LIME_GREEN, 110);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_SLATE_GRAY, OLIVE_DRAB, 70);
        EnumFlowerColor.addMix(YELLOW_GREEN, DARK_TURQUOISE, MEDIUM_SEA_GREEN, 90);
        EnumFlowerColor.addMix(YELLOW_GREEN, DEEP_SKY_BLUE, MEDIUM_AQUAMARINE, 70);
        EnumFlowerColor.addMix(YELLOW_GREEN, DIM_GRAY, OLIVE_DRAB, 85);
        EnumFlowerColor.addMix(YELLOW_GREEN, DODGER_BLUE, LIGHT_SEA_GREEN, 55);
        EnumFlowerColor.addMix(YELLOW_GREEN, GOLD, YELLOW, 105);
        EnumFlowerColor.addMix(YELLOW_GREEN, GOLDENROD, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(YELLOW_GREEN, GRAY, OLIVE_DRAB, 90);
        EnumFlowerColor.addMix(YELLOW_GREEN, GREEN, OLIVE_DRAB, 100);
        EnumFlowerColor.addMix(YELLOW_GREEN, HOT_PINK, TAN, 45);
        EnumFlowerColor.addMix(YELLOW_GREEN, INDIAN_RED, DARK_GOLDENROD, 65);
        EnumFlowerColor.addMix(YELLOW_GREEN, KHAKI, DARK_KHAKI, 110);
        EnumFlowerColor.addMix(YELLOW_GREEN, LAVENDER, DARK_SEA_GREEN, 85);
        EnumFlowerColor.addMix(YELLOW_GREEN, LEMON_CHIFFON, KHAKI, 105);
        EnumFlowerColor.addMix(YELLOW_GREEN, LIGHT_GRAY, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(YELLOW_GREEN, LIGHT_SEA_GREEN, MEDIUM_SEA_GREEN, 95);
        EnumFlowerColor.addMix(YELLOW_GREEN, LIGHT_STEEL_BLUE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(YELLOW_GREEN, LIME, LIME_GREEN, 110);
        EnumFlowerColor.addMix(YELLOW_GREEN, LIME_GREEN, LIME, 115);
        EnumFlowerColor.addMix(YELLOW_GREEN, MEDIUM_AQUAMARINE, LIME_GREEN, 105);
        EnumFlowerColor.addMix(YELLOW_GREEN, MEDIUM_PURPLE, DARK_GRAY, 45);
        EnumFlowerColor.addMix(YELLOW_GREEN, MEDIUM_SEA_GREEN, LIME_GREEN, 110);
        EnumFlowerColor.addMix(YELLOW_GREEN, MISTY_ROSE, KHAKI, 90);
        EnumFlowerColor.addMix(YELLOW_GREEN, OLIVE, OLIVE_DRAB, 105);
        EnumFlowerColor.addMix(YELLOW_GREEN, OLIVE_DRAB, LIME_GREEN, 110);
        EnumFlowerColor.addMix(YELLOW_GREEN, ORANGE, GOLD, 90);
        EnumFlowerColor.addMix(YELLOW_GREEN, PALE_GREEN, LIME_GREEN, 110);
        EnumFlowerColor.addMix(YELLOW_GREEN, PALE_TURQUOISE, PALE_GREEN, 95);
        EnumFlowerColor.addMix(YELLOW_GREEN, PALE_VIOLET_RED, TAN, 60);
        EnumFlowerColor.addMix(YELLOW_GREEN, PERU, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(YELLOW_GREEN, PINK, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(YELLOW_GREEN, PLUM, DARK_KHAKI, 55);
        EnumFlowerColor.addMix(YELLOW_GREEN, RED, CHOCOLATE, 55);
        EnumFlowerColor.addMix(YELLOW_GREEN, ROSY_BROWN, DARK_KHAKI, 80);
        EnumFlowerColor.addMix(YELLOW_GREEN, ROYAL_BLUE, CADET_BLUE, 55);
        EnumFlowerColor.addMix(YELLOW_GREEN, SALMON, GOLDENROD, 70);
        EnumFlowerColor.addMix(YELLOW_GREEN, SANDY_BROWN, DARK_KHAKI, 90);
        EnumFlowerColor.addMix(YELLOW_GREEN, SEA_GREEN, MEDIUM_SEA_GREEN, 100);
        EnumFlowerColor.addMix(YELLOW_GREEN, SIENNA, OLIVE, 70);
        EnumFlowerColor.addMix(YELLOW_GREEN, SKY_BLUE, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(YELLOW_GREEN, SLATE_GRAY, DARK_SEA_GREEN, 80);
        EnumFlowerColor.addMix(YELLOW_GREEN, SPRING_GREEN, LIME_GREEN, 110);
        EnumFlowerColor.addMix(YELLOW_GREEN, STEEL_BLUE, DARK_SEA_GREEN, 65);
        EnumFlowerColor.addMix(YELLOW_GREEN, TAN, DARK_KHAKI, 100);
        EnumFlowerColor.addMix(YELLOW_GREEN, TEAL, MEDIUM_SEA_GREEN, 85);
        EnumFlowerColor.addMix(YELLOW_GREEN, THISTLE, DARK_KHAKI, 75);
        EnumFlowerColor.addMix(YELLOW_GREEN, TURQUOISE, PALE_GREEN, 95);
        EnumFlowerColor.addMix(YELLOW_GREEN, WHEAT, KHAKI, 100);
        EnumFlowerColor.addMix(YELLOW_GREEN, WHITE, KHAKI, 95);
        EnumFlowerColor.addMix(YELLOW_GREEN, YELLOW, KHAKI, 110);
    }

    public static EnumFlowerColor get(int i) {
        return ALL_VALUES[Math.max(0, i) % ALL_VALUES.length];
    }

    @Override
    public int getColor(boolean dis) {
        return dis ? this.colorDis : this.color;
    }

    @Override
    public IAlleleInteger getAllele() {
        return this.allele;
    }

    @Override
    public int getID() {
        return this.ordinal();
    }

    @Override
    public String getName() {
        return I18N.localise("botany.colour." + this.name.toLowerCase(Locale.ENGLISH));
    }

    static {
        ALL_VALUES = EnumFlowerColor.values();
    }
}

