/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.prediction;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.crops.CropCard;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;
import speiger.src.crops.api.CropPluginAPI;
import speiger.src.crops.prediction.BreedResult;
import speiger.src.crops.prediction.Breeder;

public class NEIPlugin
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "IC2 Crop Breeding";
    }

    public String getGuiTexture() {
        return "Ic2Nei:textures/neigui.png";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)10, (int)5, (int)5, (int)166, (int)75);
    }

    public void drawExtras(int recipe) {
        BreedRecipe rec = (BreedRecipe)((Object)this.arecipes.get(recipe));
        GuiDraw.fontRenderer.func_78276_b("Made By Speiger", 50, 0, 0x404040);
        GuiDraw.fontRenderer.func_78276_b("Points: " + rec.result.getPoints(), 0, 15, 0x404040);
        GuiDraw.fontRenderer.func_78276_b("Chance: " + ItemStack.field_111284_a.format(rec.result.getChance()) + "%", 0, 25, 0x404040);
        GuiDraw.fontRenderer.func_78279_b("This data isn't Trustable, because it expects the impossible perfect condition, this feature is only back due to annoying demand", 0, 85, 160, 0x404040);
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null || Breeder.INSTANCE.craft == null) {
            super.loadCraftingRecipes(result);
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Still Generating Crop Plugin Cache");
            return;
        }
        CropCard card = CropPluginAPI.getCrop(result);
        Map<CropCard, List<BreedResult>> cropResults = Breeder.INSTANCE.craft;
        if (card != null && cropResults.containsKey(card)) {
            for (BreedResult map : cropResults.get(card)) {
                this.arecipes.add(new BreedRecipe(map));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient == null || Breeder.INSTANCE.usage == null) {
            super.loadUsageRecipes(ingredient);
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Still Generating Crop Plugin Cache");
            return;
        }
        CropCard card = CropPluginAPI.getCrop(ingredient);
        Map<CropCard, List<BreedResult>> cropResults = Breeder.INSTANCE.usage;
        if (card != null && cropResults.containsKey(card)) {
            for (BreedResult map : cropResults.get(card)) {
                this.arecipes.add(new BreedRecipe(map));
            }
        }
    }

    public class BreedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        BreedResult result;

        public BreedRecipe(BreedResult result) {
            super((TemplateRecipeHandler)NEIPlugin.this);
            this.result = result;
        }

        public CropCard getCropResult() {
            return this.result.getResult();
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.addPoints(), 75, 40);
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> ingred = new ArrayList<PositionedStack>();
            ItemStack[] items = this.result.getItemInputs();
            for (int i = 0; i < items.length; ++i) {
                int[] data = this.getCoords(i);
                ingred.add(new PositionedStack((Object)items[i], data[0], data[1]));
            }
            return ingred;
        }

        public ItemStack addPoints() {
            ItemStack item = this.result.getItemResult();
            NBTTagCompound nbt = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
            item.func_77982_d(nbt);
            NBTTagCompound display = nbt.func_74775_l("display");
            nbt.func_74782_a("display", (NBTBase)display);
            NBTTagList list = display.func_150295_c("Lore", 8);
            display.func_74782_a("Lore", (NBTBase)list);
            list.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.RESET + "" + EnumChatFormatting.GOLD + "Breeding Points: " + this.result.getPoints()));
            list.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.RESET + "" + EnumChatFormatting.GOLD + "Breeding Chance: " + ItemStack.field_111284_a.format(this.result.getChance()) + "%"));
            return item;
        }

        public int[] getCoords(int type) {
            switch (type) {
                case 0: {
                    return new int[]{43, 40};
                }
                case 1: {
                    return new int[]{107, 40};
                }
                case 2: {
                    return new int[]{75, 67};
                }
                case 3: {
                    return new int[]{75, 12};
                }
            }
            return new int[0];
        }
    }
}

