/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.SawmillManager;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Sawmill")
public class Sawmill {
    public static final String name = "Thermal Expansion Sawmill";

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output) {
        Sawmill.addRecipe(energy, input, output, null, 0);
    }

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output, @Optional IItemStack secondary, @Optional int secondaryChance) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (SawmillManager.recipeExists((ItemStack)InputHelper.toStack(input))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(InputHelper.toStack(input))));
            return;
        }
        SawmillManager.RecipeSawmill recipe = ReflectionHelper.getInstance(ThermalHelper.sawmillRecipe, InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toStack(secondary), secondaryChance, energy);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", name));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        SawmillManager.RecipeSawmill[] list;
        LinkedList<SawmillManager.RecipeSawmill> recipes = new LinkedList<SawmillManager.RecipeSawmill>();
        for (SawmillManager.RecipeSawmill recipe : list = SawmillManager.getRecipeList()) {
            if (recipe == null || recipe.getInput() == null || !StackHelper.matches(input, InputHelper.toIItemStack(recipe.getInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s.", name, input.toString()));
        }
    }

    @ZenMethod
    public static void refreshRecipes() {
        MineTweakerAPI.apply((IUndoableAction)new Refresh());
    }

    private static class Refresh
    implements IUndoableAction {
        private Refresh() {
        }

        public void apply() {
            SawmillManager.refreshRecipes();
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Refreshing Thermal Expansion Sawmill recipes";
        }

        public void undo() {
        }

        public String describeUndo() {
            return "Ignoring undo of Thermal Expansion Sawmill recipe refresh";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    extends BaseListRemoval<SawmillManager.RecipeSawmill> {
        public Remove(List<SawmillManager.RecipeSawmill> recipes) {
            super(Sawmill.name, null, recipes);
        }

        @Override
        public void apply() {
            for (SawmillManager.RecipeSawmill recipe : this.recipes) {
                boolean removed = SawmillManager.removeRecipe((ItemStack)recipe.getInput());
                if (!removed) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (SawmillManager.RecipeSawmill recipe : this.successful) {
                SawmillManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getPrimaryOutput(), (ItemStack)recipe.getSecondaryOutput(), (int)recipe.getSecondaryOutputChance());
            }
        }

        @Override
        protected boolean equals(SawmillManager.RecipeSawmill recipe, SawmillManager.RecipeSawmill otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(SawmillManager.RecipeSawmill recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }

    private static class Add
    extends BaseListAddition<SawmillManager.RecipeSawmill> {
        public Add(SawmillManager.RecipeSawmill recipe) {
            super(Sawmill.name, null);
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            for (SawmillManager.RecipeSawmill recipe : this.recipes) {
                boolean applied = SawmillManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getPrimaryOutput(), (ItemStack)recipe.getSecondaryOutput(), (int)recipe.getSecondaryOutputChance());
                if (!applied) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (SawmillManager.RecipeSawmill recipe : this.successful) {
                SawmillManager.removeRecipe((ItemStack)recipe.getInput());
            }
        }

        @Override
        protected boolean equals(SawmillManager.RecipeSawmill recipe, SawmillManager.RecipeSawmill otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(SawmillManager.RecipeSawmill recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }
}

