/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.recipe;

import appeng.util.ReadableNumberConverter;
import codechicken.nei.PositionedStack;
import com.github.technus.tectech.recipe.EyeOfHarmonyRecipe;
import com.github.technus.tectech.util.CommonValues;
import com.google.common.math.LongMath;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.GT_NEI_DefaultHandler;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EyeOfHarmonyFrontend
extends RecipeMapFrontend {
    private static final int xDirMaxCount = 9;
    private static final int itemRows = 9;
    private static final int fluidRows = 2;
    public static final int maxItemInputs = 1;
    public static final int maxItemOutputs = 81;
    public static final int maxFluidInputs = 0;
    public static final int maxFluidOutputs = 18;
    private static final int yOrigin = 8;
    private static final long TRILLION = LongMath.pow((long)10L, (int)12);
    public static final int maxItemsToRender = 80;

    public EyeOfHarmonyFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder.logoPos(new Pos2d(8, 8)), neiPropertiesBuilder.recipeBackgroundSize(new Size(170, 243)).neiSpecialInfoFormatter((INEISpecialInfoFormatter)new EyeOfHarmonySpecialValueFormatter()));
    }

    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return UIHelper.getGridPositions((int)itemInputCount, (int)79, (int)8, (int)1, (int)1);
    }

    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return UIHelper.getGridPositions((int)Math.min(itemOutputCount, 81), (int)7, (int)44, (int)9, (int)12);
    }

    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions((int)fluidInputCount, (int)0, (int)0, (int)0, (int)0);
    }

    public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
        return UIHelper.getGridPositions((int)fluidOutputCount, (int)7, (int)206, (int)9, (int)3);
    }

    public List<String> handleNEIItemTooltip(ItemStack stack, List<String> currentTip, GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
        super.handleNEIItemTooltip(stack, currentTip, neiCachedRecipe);
        EyeOfHarmonyRecipe currentRecipe = (EyeOfHarmonyRecipe)neiCachedRecipe.mRecipe.mSpecialItems;
        if (stack.func_77969_a(currentRecipe.getRecipeTriggerItem())) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"tt.nei.eoh.total_items", (Object[])new Object[]{GT_Utility.formatNumbers((long)currentRecipe.getSumOfItems())}));
            return currentTip;
        }
        double percentage = (Double)currentRecipe.getItemStackToProbabilityMap().getOrDefault((Object)stack, (Object)-1.0);
        if (percentage != -1.0) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"tt.nei.eoh.solid_mass", (Object[])new Object[]{percentage}));
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"tt.nei.eoh.item_count", (Object[])new Object[]{GT_Utility.formatNumbers((long)((Long)currentRecipe.getItemStackToTrueStackSizeMap().get((Object)stack)))}));
        }
        return currentTip;
    }

    public void drawNEIOverlays(GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
        EyeOfHarmonyRecipe EOHRecipe = (EyeOfHarmonyRecipe)neiCachedRecipe.mRecipe.mSpecialItems;
        for (PositionedStack stack : neiCachedRecipe.mInputs) {
            if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack) || !stack.item.func_77969_a(EOHRecipe.getRecipeTriggerItem())) continue;
            this.drawNEIOverlayText(StatCollector.func_74838_a((String)"NC"), stack);
        }
        for (PositionedStack stack : neiCachedRecipe.mOutputs) {
            if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack) || !EOHRecipe.getItemStackToTrueStackSizeMap().containsKey((Object)stack.item)) continue;
            long stackSize = (Long)EOHRecipe.getItemStackToTrueStackSizeMap().get((Object)stack.item);
            String displayString = stackSize > 9999L ? ReadableNumberConverter.INSTANCE.toWideReadableForm(stackSize) : String.valueOf(stackSize);
            this.drawNEIOverlayText(displayString, stack, 0xFFFFFF, 0.5f, true, Alignment.BottomRight);
        }
    }

    private static class EyeOfHarmonySpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private EyeOfHarmonySpecialValueFormatter() {
        }

        public List<String> format(RecipeDisplayInfo recipeInfo) {
            EyeOfHarmonyRecipe recipe = (EyeOfHarmonyRecipe)recipeInfo.recipe.mSpecialItems;
            ArrayList<String> result = new ArrayList<String>();
            result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.Hydrogen.In", (String)"Hydrogen") + ": " + GT_Utility.formatNumbers((long)recipe.getHydrogenRequirement()) + " L");
            result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.Helium.In", (String)"Helium") + ": " + GT_Utility.formatNumbers((long)recipe.getHydrogenRequirement()) + " L");
            result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.SpacetimeTier", (String)"Spacetime Tier") + ": " + CommonValues.EOH_TIER_FANCY_NAMES[(int)recipe.getSpacetimeCasingTierRequired()]);
            if (recipe.getEUOutput() < TRILLION) {
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.EU.Out", (String)"EU Output") + ": " + GT_Utility.formatNumbers((long)recipe.getEUOutput()) + " EU");
            } else {
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.EU.Out", (String)"EU Output") + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(recipe.getEUOutput()) + " EU");
            }
            if (recipe.getEUOutput() < TRILLION) {
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.EU.In", (String)"EU Input") + ": " + GT_Utility.formatNumbers((long)recipe.getEUStartCost()) + " EU");
            } else {
                result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.EU.In", (String)"EU Input") + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(recipe.getEUStartCost()) + " EU");
            }
            result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.BaseRecipeChance", (String)"Base Recipe Chance") + ": " + GT_Utility.formatNumbers((double)(100.0 * recipe.getBaseRecipeSuccessChance())) + "%");
            result.add(GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.RecipeEnergyEfficiency", (String)"Recipe Energy Efficiency") + ": " + GT_Utility.formatNumbers((double)(100.0 * recipe.getRecipeEnergyEfficiency())) + "%");
            if (recipe.getOutputItems().size() > 80) {
                result.add("" + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.Warning.0", (String)"Warning") + EnumChatFormatting.RESET + ": " + GT_LanguageManager.addStringLocalization((String)"EOH.Recipe.Warning.1", (String)"Not all items displayed."));
            }
            return result;
        }
    }
}

