/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.pipe;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.mechanics.pipe.IActivePipe;
import com.github.technus.tectech.mechanics.pipe.IConnectsToDataPipe;
import com.github.technus.tectech.mechanics.pipe.PipeActivityMessage;
import com.github.technus.tectech.util.CommonValues;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.common.GT_Client;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Pipe_Data
extends MetaPipeEntity
implements IConnectsToDataPipe,
IActivePipe {
    private static Textures.BlockIcons.CustomIcon EMpipe;
    private static Textures.BlockIcons.CustomIcon EMbar;
    private static Textures.BlockIcons.CustomIcon EMbarActive;
    public byte connectionCount = 0;
    private boolean active;

    public GT_MetaTileEntity_Pipe_Data(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 0);
    }

    public GT_MetaTileEntity_Pipe_Data(String aName) {
        super(aName, 0);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_Pipe_Data(this.mName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        EMpipe = new Textures.BlockIcons.CustomIcon("iconsets/EM_DATA");
        EMbar = new Textures.BlockIcons.CustomIcon("iconsets/EM_BAR");
        EMbarActive = new Textures.BlockIcons.CustomIcon("iconsets/EM_BAR_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, int aConnections, int colorIndex, boolean aConnected, boolean aRedstone) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)EMpipe), new GT_RenderedTexture((IIconContainer)(this.getActive() ? EMbarActive : EMbar), Dyes.getModulation((int)colorIndex, (short[])Dyes.MACHINE_METAL.getRGBA()))};
    }

    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    public void loadNBTData(NBTTagCompound nbtTagCompound) {
        this.active = nbtTagCompound.func_74767_n("eActive");
    }

    public void saveNBTData(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74757_a("eActive", this.active);
    }

    public boolean renderInside(ForgeDirection side) {
        return false;
    }

    public byte getTileEntityBaseType() {
        return 4;
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.pipe.datastream.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.datastream.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.datastream.desc.2"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.datastream.desc.3")};
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isClientSide()) {
            NetworkDispatcher.INSTANCE.sendToServer(new PipeActivityMessage.PipeActivityQuery(this));
        }
        this.onPostTick(aBaseMetaTileEntity, 31L);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if ((aTick & 0x1FL) == 31L) {
                if (TecTech.RANDOM.nextInt(15) == 0) {
                    NetworkDispatcher.INSTANCE.sendToAllAround(new PipeActivityMessage.PipeActivityData(this), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord(), 256.0);
                }
                if (this.active) {
                    this.active = false;
                }
                this.mConnections = 0;
                this.connectionCount = 0;
                byte myColor = aBaseMetaTileEntity.getColorization();
                if (aBaseMetaTileEntity.getColorization() < 0) {
                    return;
                }
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    byte tColor;
                    IMetaTileEntity meta;
                    ForgeDirection oppositeSide = side.getOpposite();
                    TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(side);
                    if (tTileEntity instanceof IConnectsToDataPipe) {
                        byte tColor2 = ((IConnectsToDataPipe)tTileEntity).getColorization();
                        if (tColor2 != myColor || !((IConnectsToDataPipe)tTileEntity).canConnectData(oppositeSide)) continue;
                        this.mConnections = (byte)(this.mConnections | 1 << side.ordinal());
                        this.connectionCount = (byte)(this.connectionCount + 1);
                        continue;
                    }
                    if (!(tTileEntity instanceof IGregTechTileEntity) || !((meta = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity()) instanceof IConnectsToDataPipe) || (tColor = ((IConnectsToDataPipe)meta).getColorization()) != myColor || !((IConnectsToDataPipe)meta).canConnectData(oppositeSide)) continue;
                    this.mConnections = (byte)(this.mConnections | 1 << side.ordinal());
                    this.connectionCount = (byte)(this.connectionCount + 1);
                }
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GT_Client.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return true;
    }

    @Override
    public IConnectsToDataPipe getNext(IConnectsToDataPipe source) {
        if (this.connectionCount != 2) {
            return null;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IMetaTileEntity meta;
            if ((this.mConnections & 1 << side.ordinal()) == 0) continue;
            TileEntity next = this.getBaseMetaTileEntity().getTileEntityAtSide(side);
            if (next instanceof IConnectsToDataPipe && next != source) {
                if (!((IConnectsToDataPipe)next).isDataInputFacing(side.getOpposite())) continue;
                return (IConnectsToDataPipe)next;
            }
            if (!(next instanceof IGregTechTileEntity) || !((meta = ((IGregTechTileEntity)next).getMetaTileEntity()) instanceof IConnectsToDataPipe)) continue;
            IConnectsToDataPipe connecsToPipe = (IConnectsToDataPipe)meta;
            if (meta == source) continue;
            if (meta instanceof GT_MetaTileEntity_Pipe_Data) {
                GT_MetaTileEntity_Pipe_Data pipeData = (GT_MetaTileEntity_Pipe_Data)meta;
                if (pipeData.connectionCount == 2) {
                    pipeData.markUsed();
                    return connecsToPipe;
                }
            }
            if (!connecsToPipe.isDataInputFacing(side.getOpposite())) continue;
            return connecsToPipe;
        }
        return null;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float tSide0 = tSpace = 0.3125f;
        float tSide1 = 1.0f - tSpace;
        float tSide2 = tSpace;
        float tSide3 = 1.0f - tSpace;
        float tSide4 = tSpace;
        float tSide5 = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.DOWN) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.UP) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.NORTH) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.SOUTH) != 0) {
            tSide4 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.WEST) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.EAST) != 0) {
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & 1 << ForgeDirection.DOWN.ordinal()) != 0) {
            tSide0 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.UP.ordinal()) != 0) {
            tSide1 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.NORTH.ordinal()) != 0) {
            tSide2 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.SOUTH.ordinal()) != 0) {
            tSide3 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.WEST.ordinal()) != 0) {
            tSide4 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.EAST.ordinal()) != 0) {
            tSide5 = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)aX + tSide4), (double)((float)aY + tSide0), (double)((float)aZ + tSide2), (double)((float)aX + tSide5), (double)((float)aY + tSide1), (double)((float)aZ + tSide3));
    }

    public float getThickNess() {
        if (GT_Mod.instance.isClientSide() && GT_Client.hideValue == 1) {
            return 0.0625f;
        }
        return 0.375f;
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public byte getColorization() {
        return this.getBaseMetaTileEntity().getColorization();
    }

    @Override
    public void markUsed() {
        this.active = true;
    }

    @Override
    public void setActive(boolean state) {
        if (state != this.active) {
            this.active = state;
            this.getBaseMetaTileEntity().issueTextureUpdate();
        }
    }

    @Override
    public boolean getActive() {
        return this.active;
    }
}

