/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface.widgets.component.world;

import com.bymarcin.openglasses.surface.ClientSurface;
import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.RenderType;
import com.bymarcin.openglasses.surface.Widget;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.core.attribute.I3DPositionable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IAlpha;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IColorizable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.ILookable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IScalable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.ITextable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IThroughVisibility;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IViewDistance;
import com.bymarcin.openglasses.utils.OGUtils;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

public class FloatingText
extends Widget
implements IViewDistance,
ILookable,
I3DPositionable,
ITextable,
IColorizable,
IScalable,
IAlpha,
IThroughVisibility {
    float x;
    float y;
    float z;
    int lookingAtX;
    int lookingAtY;
    int lookingAtZ;
    boolean isLookingAtEnable;
    int viewDistance = 100;
    float r;
    float g;
    float b;
    float alpha = 0.5f;
    boolean isThroughVisibility = true;
    float scale = 0.05f;
    String text = "";

    @Override
    public double getPosX() {
        return this.x;
    }

    @Override
    public double getPosY() {
        return this.y;
    }

    @Override
    public double getPosZ() {
        return this.z;
    }

    @Override
    public void setPos(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    @Override
    public void writeData(ByteBuf buff) {
        buff.writeFloat(this.x);
        buff.writeFloat(this.y);
        buff.writeFloat(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.text);
        buff.writeFloat(this.r);
        buff.writeFloat(this.g);
        buff.writeFloat(this.b);
        buff.writeFloat(this.scale);
        buff.writeFloat(this.alpha);
        buff.writeBoolean(this.isThroughVisibility);
        buff.writeInt(this.lookingAtX);
        buff.writeInt(this.lookingAtY);
        buff.writeInt(this.lookingAtZ);
        buff.writeBoolean(this.isLookingAtEnable);
        buff.writeInt(this.viewDistance);
    }

    @Override
    public void readData(ByteBuf buff) {
        this.x = buff.readFloat();
        this.y = buff.readFloat();
        this.z = buff.readFloat();
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buff);
        this.r = buff.readFloat();
        this.g = buff.readFloat();
        this.b = buff.readFloat();
        this.scale = buff.readFloat();
        this.alpha = buff.readFloat();
        this.isThroughVisibility = buff.readBoolean();
        this.lookingAtX = buff.readInt();
        this.lookingAtY = buff.readInt();
        this.lookingAtZ = buff.readInt();
        this.isLookingAtEnable = buff.readBoolean();
        this.viewDistance = buff.readInt();
    }

    @Override
    public WidgetType getType() {
        return WidgetType.FLOATINGTEXT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableFloatingText();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setColor(double d, double e, double f) {
        this.r = (float)d;
        this.g = (float)e;
        this.b = (float)f;
    }

    @Override
    public float getColorR() {
        return this.r;
    }

    @Override
    public float getColorG() {
        return this.g;
    }

    @Override
    public float getColorB() {
        return this.b;
    }

    @Override
    public void setScale(double scale) {
        this.scale = (float)scale;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = (float)alpha;
    }

    @Override
    public boolean isVisibleThroughObjects() {
        return this.isThroughVisibility;
    }

    @Override
    public void setVisibleThroughObjects(boolean visible) {
        this.isThroughVisibility = visible;
    }

    @Override
    public void setLookingAt(int x, int y, int z) {
        this.lookingAtX = x;
        this.lookingAtY = y;
        this.lookingAtZ = z;
    }

    @Override
    public boolean isLookingAtEnable() {
        return this.isLookingAtEnable;
    }

    @Override
    public void setLookingAtEnable(boolean enable) {
        this.isLookingAtEnable = enable;
    }

    @Override
    public int getLookingAtX() {
        return this.lookingAtX;
    }

    @Override
    public int getLookingAtY() {
        return this.lookingAtY;
    }

    @Override
    public int getLookingAtZ() {
        return this.lookingAtZ;
    }

    @Override
    public int getDistanceView() {
        return this.viewDistance;
    }

    @Override
    public void setDistanceView(int distance) {
        this.viewDistance = distance;
    }

    @SideOnly(value=Side.CLIENT)
    class RenderableFloatingText
    implements IRenderableWidget {
        FontRenderer fontRender;
        double offsetX;
        double offsetY;
        int color;

        RenderableFloatingText() {
            this.fontRender = Minecraft.func_71410_x().field_71466_p;
            this.offsetX = (double)this.fontRender.func_78256_a(FloatingText.this.text) / 2.0;
            this.offsetY = (double)this.fontRender.field_78288_b / 2.0;
            this.color = OGUtils.getIntFromColor(FloatingText.this.r, FloatingText.this.g, FloatingText.this.b, FloatingText.this.alpha);
        }

        @Override
        public void render(EntityPlayer player, double playerX, double playerY, double playerZ) {
            MovingObjectPosition pos;
            if (!OGUtils.inRange(playerX, playerY, playerZ, FloatingText.this.x, FloatingText.this.y, FloatingText.this.z, FloatingText.this.viewDistance)) {
                return;
            }
            if (FloatingText.this.isLookingAtEnable && ((pos = ClientSurface.getBlockCoordsLookingAt(player, 200)) == null || pos.field_72311_b != FloatingText.this.lookingAtX || pos.field_72312_c != FloatingText.this.lookingAtY || pos.field_72309_d != FloatingText.this.lookingAtZ)) {
                return;
            }
            GL11.glPushMatrix();
            if (FloatingText.this.isThroughVisibility) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            GL11.glTranslated((double)FloatingText.this.x, (double)FloatingText.this.y, (double)FloatingText.this.z);
            GL11.glScaled((double)FloatingText.this.scale, (double)FloatingText.this.scale, (double)FloatingText.this.scale);
            GL11.glTranslated((double)this.offsetX, (double)this.offsetY, (double)0.0);
            GL11.glPushMatrix();
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)this.offsetX, (double)this.offsetY, (double)0.0);
            GL11.glRotated((double)player.field_70177_z, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-player.field_70125_A), (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)(-this.offsetX), (double)((double)(-this.fontRender.field_78288_b) / 2.0), (double)0.0);
            this.fontRender.func_78276_b(FloatingText.this.text, 0, 0, this.color);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glEnable((int)2929);
        }

        @Override
        public RenderType getRenderType() {
            return RenderType.WorldLocated;
        }

        @Override
        public boolean shouldWidgetBeRendered() {
            return FloatingText.this.isVisible();
        }
    }
}

