/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import java.util.Random;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.ProxyAccess;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class VanishingTileEntity
extends TileEntity {
    public static final int maxTransitionTime = 8;
    public static final int maxVibratingTime = 15;
    public Block copiedBlock;
    public int copiedMetadata;
    public TileEntity copiedTileEntity;
    public int frameType;
    public boolean powered;
    protected int duration = 8;
    public int transitionTimer;
    public boolean inTransition;
    public boolean vibrating;
    public int vibratingTimer;
    private final Random rand = new Random();
    private Block[] excludes = new Block[]{MalisisDoors.Blocks.vanishingBlock, Blocks.field_150350_a, Blocks.field_150468_ap, Blocks.field_150430_aB, Blocks.field_150471_bO, Blocks.field_150442_at, Blocks.field_150395_bd};

    public VanishingTileEntity() {
        this.frameType = 0;
        ProxyAccess.get((IBlockAccess)this.func_145831_w());
    }

    public VanishingTileEntity(int frameType) {
        if (frameType < 0 || frameType > 3) {
            frameType = 0;
        }
        this.frameType = frameType;
    }

    public void func_145834_a(World world) {
        this.field_145850_b = world;
        if (this.copiedTileEntity != null) {
            this.copiedTileEntity.func_145834_a((World)ProxyAccess.get((IBlockAccess)this.func_145831_w()));
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean setBlock(ItemStack itemStack, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        if (itemStack == null) {
            this.copiedBlock = null;
            this.copiedMetadata = 0;
            this.copiedTileEntity = null;
            return true;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (ArrayUtils.contains((Object[])this.excludes, (Object)block)) {
            return false;
        }
        World proxy = (World)ProxyAccess.get((IBlockAccess)this.func_145831_w());
        this.copiedBlock = block;
        this.copiedMetadata = itemStack.func_77960_j();
        this.initCopiedTileEntity();
        this.copiedMetadata = block.func_149660_a(proxy, this.field_145851_c, this.field_145848_d, this.field_145849_e, side, hitX, hitY, hitZ, this.copiedMetadata);
        if (p != null) {
            block.func_149689_a(proxy, this.field_145851_c, this.field_145848_d, this.field_145849_e, (EntityLivingBase)p, itemStack);
        }
        return true;
    }

    private void initCopiedTileEntity() {
        this.copiedTileEntity = this.copiedBlock.createTileEntity(this.func_145831_w(), this.copiedMetadata);
        if (this.copiedTileEntity != null) {
            this.copiedTileEntity.func_145834_a((World)ProxyAccess.get((IBlockAccess)this.func_145831_w()));
            this.copiedTileEntity.field_145851_c = this.field_145851_c;
            this.copiedTileEntity.field_145848_d = this.field_145848_d;
            this.copiedTileEntity.field_145849_e = this.field_145849_e;
        }
    }

    public boolean setPowerState(boolean powered) {
        if (powered == this.powered) {
            return false;
        }
        if (!this.inTransition) {
            this.transitionTimer = powered ? 0 : this.duration;
        }
        this.powered = powered;
        this.inTransition = true;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() | 8, 2);
        return true;
    }

    public void func_145845_h() {
        if (!this.inTransition && !this.powered) {
            boolean b;
            float r = this.rand.nextFloat();
            boolean bl = b = (double)r < (Double)MalisisDoorsSettings.vanishingGlitchChance.get();
            if (b && ((Boolean)MalisisDoorsSettings.enableVanishingGlitch.get()).booleanValue()) {
                this.vibrating = true;
                this.vibratingTimer = 0;
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() | 8, 2);
            }
            if (this.vibrating && this.vibratingTimer++ >= 15) {
                this.vibrating = false;
                this.vibratingTimer = 0;
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 0xFFFFFFF7, 2);
            }
        } else if (this.inTransition) {
            this.vibrating = false;
            this.vibratingTimer = 0;
            if (this.powered) {
                ++this.transitionTimer;
                if (this.transitionTimer >= this.duration) {
                    this.inTransition = false;
                    this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), 0.0, 0.0, 0.0);
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 0xFFFFFFF7, 2);
                }
            } else {
                --this.transitionTimer;
                if (this.transitionTimer <= 0) {
                    this.inTransition = false;
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 0xFFFFFFF7, 2);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int blockID = nbt.func_74762_e("BlockID");
        if (blockID != 0) {
            this.copiedBlock = Block.func_149729_e((int)blockID);
            this.copiedMetadata = nbt.func_74762_e("BlockMetadata");
            if (nbt.func_74764_b("copiedTileEntity")) {
                this.initCopiedTileEntity();
                this.copiedTileEntity.func_145839_a(nbt.func_74775_l("copiedTileEntity"));
            }
        }
        this.frameType = nbt.func_74762_e("FrameType");
        this.powered = nbt.func_74767_n("Powered");
        this.duration = nbt.func_74762_e("Duration");
        this.inTransition = nbt.func_74767_n("InTransition");
        this.transitionTimer = nbt.func_74762_e("TransitionTimer");
        this.vibrating = nbt.func_74767_n("Vibrating");
        this.vibratingTimer = nbt.func_74762_e("VibratingTimer");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.copiedBlock != null) {
            nbt.func_74768_a("BlockID", Block.field_149771_c.func_148757_b((Object)this.copiedBlock));
            nbt.func_74768_a("BlockMetadata", this.copiedMetadata);
            if (this.copiedTileEntity != null) {
                NBTTagCompound teTag = new NBTTagCompound();
                this.copiedTileEntity.func_145841_b(teTag);
                nbt.func_74782_a("copiedTileEntity", (NBTBase)teTag);
            }
        }
        nbt.func_74768_a("FrameType", this.frameType);
        nbt.func_74757_a("Powered", this.powered);
        nbt.func_74768_a("Duration", this.duration);
        nbt.func_74757_a("InTransition", this.inTransition);
        nbt.func_74768_a("TransitionTimer", this.transitionTimer);
        nbt.func_74757_a("Vibrating", this.vibrating);
        nbt.func_74768_a("VibratingTimer", this.vibratingTimer);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

