/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.nei.BuggyRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.CircuitFabricatorRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.GCNEIHighlightHandler;
import micdoodle8.mods.galacticraft.core.nei.RefineryRecipeHandler;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class NEIGalacticraftConfig
implements IConfigureNEI {
    private static final HashMap<HashMap<Integer, PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static final HashMap<HashMap<Integer, PositionedStack>, PositionedStack> buggyBenchRecipes = new HashMap();
    private static final HashMap<PositionedStack, PositionedStack> refineryRecipes = new HashMap();
    private static final HashMap<HashMap<Integer, PositionedStack>, PositionedStack> circuitFabricatorRecipes = new HashMap();
    private static final HashMap<HashMap<Integer, PositionedStack>, PositionedStack> ingotCompressorRecipes = new HashMap();

    public void loadConfig() {
        this.registerRecipes();
        for (Item item : GCItems.hiddenItems) {
            API.hideItem((ItemStack)new ItemStack(item, 1, 0));
        }
        for (Block block : GCBlocks.hiddenBlocks) {
            API.hideItem((ItemStack)new ItemStack(block, 1, 0));
            if (block != GCBlocks.slabGCDouble) continue;
            for (int j = 1; j < (GalacticraftCore.isPlanetsLoaded ? 6 : 4); ++j) {
                API.hideItem((ItemStack)new ItemStack(block, 1, j));
            }
        }
        API.registerRecipeHandler((ICraftingHandler)new BuggyRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BuggyRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RefineryRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RefineryRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CircuitFabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CircuitFabricatorRecipeHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.basicBlock, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.blockMoon, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.fakeBlock, (IHighlightHandler)new GCNEIHighlightHandler());
    }

    public String getName() {
        return "Galacticraft NEI Plugin";
    }

    public String getVersion() {
        return "3.0.74-GTNH";
    }

    public void registerIngotCompressorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        ingotCompressorRecipes.put(input, output);
    }

    public void registerCircuitFabricatorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        circuitFabricatorRecipes.put(input, output);
    }

    public void registerRocketBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public void registerBuggyBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        buggyBenchRecipes.put(input, output);
    }

    public void registerRefineryRecipe(PositionedStack input, PositionedStack output) {
        refineryRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getIngotCompressorRecipes() {
        return ingotCompressorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getBuggyBenchRecipes() {
        return buggyBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getRefineryRecipes() {
        return refineryRecipes.entrySet();
    }

    public void registerRecipes() {
        this.registerRefineryRecipe(new PositionedStack((Object)new ItemStack(GCItems.oilCanister, 1, 1), 2, 3), new PositionedStack((Object)new ItemStack(GCItems.fuelCanister, 1, 1), 148, 3));
        this.addBuggyRecipes();
        this.addCircuitFabricatorRecipes();
        this.addIngotCompressorRecipes();
    }

    private void addBuggyRecipes() {
        int x = 4;
        int y = 16;
        HashMap<Integer, PositionedStack> input = new HashMap<Integer, PositionedStack>();
        input.put(1, new PositionedStack((Object)new ItemStack(GCItems.basicItem, 1, 19), 58, 3));
        input.put(2, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 1), 58, 39));
        if (GalacticraftCore.isGalaxySpaceLoaded) {
            input.put(3, new PositionedStack((Object)GT_ModHandler.getModItem((String)"GalaxySpace", (String)"item.RocketControlComputer", (long)1L, (int)100), 58, 57));
        }
        input.put(4, new PositionedStack((Object)new ItemStack(GCItems.partBuggy), 4, 3));
        input.put(5, new PositionedStack((Object)new ItemStack(GCItems.partBuggy), 112, 3));
        input.put(6, new PositionedStack((Object)new ItemStack(GCItems.partBuggy), 4, 93));
        input.put(7, new PositionedStack((Object)new ItemStack(GCItems.partBuggy), 112, 93));
        input.put(8, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.StainlessSteel, (long)1L), 22, 3));
        input.put(9, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.StainlessSteel, (long)1L), 94, 3));
        input.put(10, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.StainlessSteel, (long)1L), 22, 93));
        input.put(11, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.StainlessSteel, (long)1L), 94, 93));
        input.put(12, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 40, 3));
        input.put(13, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 76, 3));
        input.put(14, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 40, 93));
        input.put(15, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 58, 93));
        input.put(16, new PositionedStack((Object)new ItemStack(GCItems.meteoricIronIngot, 1, 1), 76, 93));
        input.put(17, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 4, 21));
        input.put(18, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 22, 21));
        input.put(19, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 94, 21));
        input.put(20, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 112, 21));
        input.put(21, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 4, 75));
        input.put(22, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 22, 75));
        input.put(23, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 94, 75));
        input.put(24, new PositionedStack((Object)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.StainlessSteel, (long)1L), 112, 75));
        input.put(25, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 40, 21));
        input.put(26, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 58, 21));
        input.put(27, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 76, 21));
        input.put(28, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 40, 39));
        input.put(29, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 76, 39));
        input.put(30, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 40, 57));
        input.put(31, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 76, 57));
        input.put(32, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 40, 75));
        input.put(33, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 58, 75));
        input.put(34, new PositionedStack((Object)new ItemStack(GCItems.heavyPlatingTier1), 76, 75));
        this.registerBuggyBenchRecipe(input, new PositionedStack((Object)new ItemStack(GCItems.buggy), 139, 48));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input);
        input2.put(35, new PositionedStack((Object)RecipeUtil.getChestItemStack(1, 3), 103, 48));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 1), 139, 48));
        input2 = new HashMap<Integer, PositionedStack>(input);
        input2.put(35, new PositionedStack((Object)RecipeUtil.getChestItemStack(1, 0), 103, 48));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 2), 139, 48));
        input2 = new HashMap<Integer, PositionedStack>(input);
        input2.put(35, new PositionedStack((Object)RecipeUtil.getChestItemStack(1, 1), 103, 48));
        this.registerBuggyBenchRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.buggy, 1, 3), 139, 48));
    }

    private void addCircuitFabricatorRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(Items.field_151045_i), 10, 22));
        int siliconCount = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).size();
        ItemStack[] silicons = new ItemStack[siliconCount];
        for (int j = 0; j < siliconCount; ++j) {
            silicons[j] = (ItemStack)OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).get(j);
        }
        input1.put(1, new PositionedStack((Object)silicons, 69, 51));
        input1.put(2, new PositionedStack((Object)silicons, 69, 69));
        input1.put(3, new PositionedStack((Object)new ItemStack(Items.field_151137_ax), 117, 51));
        input1.put(4, new PositionedStack((Object)new ItemStack(Blocks.field_150429_aA), 140, 25));
        this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)new ItemStack(GCItems.basicItem, ConfigManagerCore.quickMode ? 5 : 3, 13), 147, 91));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151100_aR, 1, 4), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.basicItem, 9, 12), 147, 91));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151107_aW), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.basicItem, ConfigManagerCore.quickMode ? 2 : 1, 14), 147, 91));
    }

    private void addIngotCompressorRecipes() {
        for (IRecipe rec : CompressorRecipes.getRecipeList()) {
            int j;
            HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
            if (rec instanceof ShapedRecipes) {
                ShapedRecipes recipe = (ShapedRecipes)rec;
                for (j = 0; j < recipe.field_77574_d.length; ++j) {
                    ItemStack stack = recipe.field_77574_d[j];
                    input1.put(j, new PositionedStack((Object)stack, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            } else if (rec instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe recipe = (ShapelessOreRecipe)rec;
                for (j = 0; j < recipe.getInput().size(); ++j) {
                    Object obj = recipe.getInput().get(j);
                    input1.put(j, new PositionedStack(obj, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            }
            ItemStack resultItemStack = rec.func_77571_b();
            if (ConfigManagerCore.quickMode && resultItemStack.func_77973_b().func_77667_c(resultItemStack).contains("compressed")) {
                resultItemStack.field_77994_a *= 2;
            }
            this.registerIngotCompressorRecipe(input1, new PositionedStack((Object)resultItemStack, 140, 46));
        }
    }
}

