/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega.GT_TileEntity_MegaMultiBlockBase;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementCheckOnly;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_Output_ME;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_MegaDistillTower
extends GT_TileEntity_MegaMultiBlockBase<GT_TileEntity_MegaDistillTower>
implements ISurvivalConstructable {
    protected static final int CASING_INDEX = 49;
    protected static final String STRUCTURE_PIECE_BASE = "base";
    protected static final String STRUCTURE_PIECE_LAYER = "layer";
    protected static final String STRUCTURE_PIECE_TOP_HINT = "top";
    private static final IStructureDefinition<GT_TileEntity_MegaDistillTower> STRUCTURE_DEFINITION;
    protected final List<List<GT_MetaTileEntity_Hatch_Output>> mOutputHatchesByLayer = new ArrayList<List<GT_MetaTileEntity_Hatch_Output>>();
    protected int mHeight;
    protected int mCasing;
    protected boolean mTopLayerFound;
    private int mTopState = -1;

    public GT_TileEntity_MegaDistillTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_MegaDistillTower(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaDistillTower(this.mName);
    }

    protected void onCasingFound() {
        ++this.mCasing;
    }

    protected int getCurrentLayerOutputHatchCount() {
        return this.mOutputHatchesByLayer.size() < this.mHeight || this.mHeight <= 0 ? 0 : this.mOutputHatchesByLayer.get(this.mHeight - 1).size();
    }

    protected boolean addLayerOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null || aTileEntity.isDead() || !(aTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        while (this.mOutputHatchesByLayer.size() < this.mHeight) {
            this.mOutputHatchesByLayer.add(new ArrayList());
        }
        GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aTileEntity.getMetaTileEntity();
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatchesByLayer.get(this.mHeight - 1).add(tHatch);
    }

    protected void onTopLayerFound(boolean aIsCasing) {
        this.mTopLayerFound = true;
        if (aIsCasing) {
            this.onCasingFound();
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49)};
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.distillationTowerRecipes;
    }

    public int getRecipeCatalystPriority() {
        return -1;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Distillery").addInfo("Controller block for the Distillation Tower").addInfo("Fluids are only put out at the correct height").addInfo("The correct height equals the slot number in the NEI recipe").addSeparator().beginVariableStructureBlock(15, 15, 16, 56, 15, 15, true).addController("Front bottom").addOtherStructurePart("Clean Stainless Steel Machine Casing", "15 x h - 5 (minimum)").addEnergyHatch("Any casing").addMaintenanceHatch("Any casing").addInputHatch("Any bottom layer casing").addOutputBus("Any bottom layer casing").addOutputHatch("2-11x Output Hatches (One per Output Layer except bottom layer)").addStructureInfo("An \"Output Layer\" consists of 5 layers!").addStructureHint("The interior of this Mega Multiblock's hologram is empty, it should be all air.").toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS);
        return tt;
    }

    public IStructureDefinition<GT_TileEntity_MegaDistillTower> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputHatchesByLayer.forEach(List::clear);
        this.mHeight = 1;
        this.mTopLayerFound = false;
        this.mTopState = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 7, 0, 0)) {
            return false;
        }
        while (this.mHeight < 12 && this.checkPiece(STRUCTURE_PIECE_LAYER, 7, this.mHeight * 5, 0) && !this.mTopLayerFound) {
            if (this.mOutputHatchesByLayer.size() < this.mHeight || this.mOutputHatchesByLayer.get(this.mHeight - 1).isEmpty()) {
                return false;
            }
            this.mTopState = -1;
            ++this.mHeight;
        }
        return this.mCasing >= 75 * this.mHeight + 10 && this.mHeight >= 2 && this.mTopLayerFound && this.mMaintenanceHatches.size() == 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 7, 0, 0);
        int tTotalHeight = Math.min(12, stackSize.field_77994_a + 2);
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LAYER, stackSize, hintsOnly, 7, 5 * i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, hintsOnly, 7, 5 * (tTotalHeight - 1), 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        this.mHeight = 0;
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 7, 0, 0, realBudget, source, actor, false, true);
        if (built >= 0) {
            return built;
        }
        int tTotalHeight = Math.min(12, stackSize.field_77994_a + 2);
        int i = 1;
        while (i < tTotalHeight - 1) {
            this.mHeight = i++;
            built = this.survivialBuildPiece(STRUCTURE_PIECE_LAYER, stackSize, 7, 5 * this.mHeight, 0, realBudget, source, actor, false, true);
            if (built < 0) continue;
            return built;
        }
        this.mHeight = tTotalHeight - 1;
        return this.survivialBuildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, 7, 5 * this.mHeight, 0, realBudget, source, actor, false, true);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (!aNBT.func_74764_b("batchMode")) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setMaxParallel(ConfigHandler.megaMachinesMax);
    }

    public boolean canDumpFluidToME() {
        for (List<GT_MetaTileEntity_Hatch_Output> tLayerOutputHatches : this.mOutputHatchesByLayer) {
            boolean foundMEHatch = false;
            for (IFluidStore iFluidStore : tLayerOutputHatches) {
                if (!(iFluidStore instanceof GT_MetaTileEntity_Hatch_Output_ME)) continue;
                foundMEHatch = true;
                break;
            }
            if (foundMEHatch) continue;
            return false;
        }
        return true;
    }

    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (int i = 0; i < mOutputFluids2.length && i < this.mOutputHatchesByLayer.size(); ++i) {
            FluidStack tStack = mOutputFluids2[i].copy();
            if (GT_TileEntity_MegaDistillTower.dumpFluid(this.mOutputHatchesByLayer.get(i), (FluidStack)tStack, (boolean)true)) continue;
            GT_TileEntity_MegaDistillTower.dumpFluid(this.mOutputHatchesByLayer.get(i), (FluidStack)tStack, (boolean)false);
        }
    }

    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        return this.getFluidOutputSlotsByLayer(toOutput, this.mOutputHatchesByLayer);
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    static {
        IHatchElement layeredOutputHatch = GT_HatchElement.OutputHatch.withCount(GT_TileEntity_MegaDistillTower::getCurrentLayerOutputHatchCount).withAdder(GT_TileEntity_MegaDistillTower::addLayerOutputHatch);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_BASE, StructureUtility.transpose((String[][])new String[][]{{"bbbbbbb~bbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb", "bbbbbbbbbbbbbbb"}})).addShape(STRUCTURE_PIECE_LAYER, StructureUtility.transpose((String[][])new String[][]{{"lllllllllllllll", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lcccccccccccccl", "lllllllllllllll"}, {"lllllllllllllll", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "lllllllllllllll"}, {"lllllllllllllll", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "lllllllllllllll"}, {"lllllllllllllll", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "lllllllllllllll"}, {"lllllllllllllll", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "lllllllllllllll"}})).addShape(STRUCTURE_PIECE_TOP_HINT, StructureUtility.transpose((String[][])new String[][]{{"lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll", "lllllllllllllll"}, {"lllllllllllllll", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "lllllllllllllll"}, {"lllllllllllllll", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "lllllllllllllll"}, {"lllllllllllllll", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "lllllllllllllll"}, {"lllllllllllllll", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "l=============l", "lllllllllllllll"}})).addElement('=', GT_TileEntity_MegaMultiBlockBase.StructureElementAirNoHint.getInstance()).addElement('b', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaDistillTower.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy.or((IHatchElement)GT_HatchElement.ExoticEnergy)}).casingIndex(49).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(GT_TileEntity_MegaDistillTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement('l', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaDistillTower.class).atLeast(new IHatchElement[]{layeredOutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy.or((IHatchElement)GT_HatchElement.ExoticEnergy)}).casingIndex(49).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(GT_TileEntity_MegaDistillTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement('c', (IStructureElement)((IStructureElementCheckOnly)(t, world, x, y, z) -> {
            IGregTechTileEntity entity;
            if (world.func_147437_c(x, y, z)) {
                if (t.mTopState < 1) {
                    t.mTopState = 0;
                    return true;
                }
                return false;
            }
            if (t.mTopState == 0) {
                return false;
            }
            t.mTopState = 1;
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof IGregTechTileEntity && t.addLayerOutputHatch(entity = (IGregTechTileEntity)tileEntity, 49)) {
                t.onTopLayerFound(false);
                return true;
            }
            if (world.func_147439_a(x, y, z) == GregTech_API.sBlockCasings4 && world.func_72805_g(x, y, z) == 1) {
                t.onTopLayerFound(true);
                return true;
            }
            return false;
        })).build();
    }
}

