/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.galacticgreg;

import bloodasp.galacticgreg.GT_Worldgen_GT_Ore_Layer_Space;
import bloodasp.galacticgreg.GT_Worldgen_GT_Ore_SmallPieces_Space;
import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.ModDimensionDef;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_Layer_Space;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_SmallOre_Space;
import bloodasp.galacticgreg.registry.GalacticGregRegistry;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_OreLayer;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gregtech.common.GT_Worldgen_GT_Ore_SmallPieces;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_TileEntity_VoidMiner_Base
extends GT_MetaTileEntity_DrillerBase {
    private static ArrayListMultimap<Integer, Pair<Pair<Integer, Boolean>, Float>> extraDropsDimMap = ArrayListMultimap.create();
    private static FluidStack[] NOBLE_GASSES = new FluidStack[]{WerkstoffLoader.Neon.getFluidOrGas(1), WerkstoffLoader.Krypton.getFluidOrGas(1), WerkstoffLoader.Xenon.getFluidOrGas(1), WerkstoffLoader.Oganesson.getFluidOrGas(1)};
    private Map<Pair<Integer, Boolean>, Float> dropmap = null;
    private float totalWeight;
    private int multiplier = 1;
    protected final byte TIER_MULTIPLIER;
    private boolean mBlacklist = false;

    public static void addMatierialToDimensionList(int DimensionID, ISubTagContainer Material2, float weight) {
        if (Material2 instanceof Materials) {
            GT_TileEntity_VoidMiner_Base.getExtraDropsDimMap().put((Object)DimensionID, new Pair<Pair<Integer, Boolean>, Float>(new Pair<Integer, Boolean>(((Materials)Material2).mMetaItemSubID, false), Float.valueOf(weight)));
        } else if (Material2 instanceof Werkstoff) {
            GT_TileEntity_VoidMiner_Base.getExtraDropsDimMap().put((Object)DimensionID, new Pair<Pair<Integer, Boolean>, Float>(new Pair<Integer, Boolean>(Integer.valueOf(((Werkstoff)Material2).getmID()), true), Float.valueOf(weight)));
        }
    }

    public GT_TileEntity_VoidMiner_Base(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
        this.TIER_MULTIPLIER = (byte)Math.max(tier, 1);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mBlacklist", this.mBlacklist);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mBlacklist = aNBT.func_74767_n("mBlacklist");
    }

    public GT_TileEntity_VoidMiner_Base(String aName, int tier) {
        super(aName);
        this.TIER_MULTIPLIER = (byte)tier;
    }

    protected int getMinTier() {
        return this.TIER_MULTIPLIER + 5;
    }

    protected boolean checkHatches() {
        return true;
    }

    protected void setElectricityStats() {
        try {
            this.mEUt = this.isPickingPipes ? 60 : Math.toIntExact(GT_Values.V[this.getMinTier()]);
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            this.mEUt = 0x7FFFFFF8;
        }
        this.mOutputItems = new ItemStack[0];
        this.mProgresstime = 0;
        this.mMaxProgresstime = 10;
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        this.mEUt = this.mEUt > 0 ? -this.mEUt : this.mEUt;
    }

    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.dropmap == null || this.totalWeight == 0.0f) {
            this.calculateDropMap();
        }
        if (this.totalWeight != 0.0f) {
            this.handleFluidConsumption();
            this.handleOutputs();
            return true;
        }
        this.stopMachine();
        return false;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Miner").addInfo("Controller Block for the Void Miner " + GT_Values.VN[this.getMinTier()]).addInfo("Consumes " + GT_Values.V[this.getMinTier()] + "EU/t").addInfo("Can be supplied with 2L/s of Neon(x4), Krypton(x8), Xenon(x16) or Oganesson(x64) for higher outputs.").addInfo("Will output " + 2 * this.TIER_MULTIPLIER + " Ores per Second depending on the Dimension it is build in").addInfo("Put the Ore into the input bus to set the Whitelist/Blacklist").addInfo("Use a screwdriver to toggle Whitelist/Blacklist").addInfo("Blacklist or non Whitelist Ore will be VOIDED").addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GT_Values.VN[this.getMinTier()] + "+, Any base casing").addMaintenanceHatch("Any base casing").addInputBus("Mining Pipes or Ores, optional, any base casing").addInputHatch("Optional noble gas, any base casing").addOutputBus("Any base casing").toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS);
        return tt;
    }

    protected List<IHatchElement<? super GT_MetaTileEntity_DrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)GT_HatchElement.InputHatch, (Object)GT_HatchElement.InputBus, (Object)GT_HatchElement.OutputBus, (Object)GT_HatchElement.Maintenance, (Object)GT_HatchElement.Energy);
    }

    public static ArrayListMultimap<Integer, Pair<Pair<Integer, Boolean>, Float>> getExtraDropsDimMap() {
        return extraDropsDimMap;
    }

    private Predicate<GT_Worldgen_GT_Ore_Layer> makeOreLayerPredicate() {
        Predicate<GT_Worldgen_GT_Ore_Layer> predicate;
        World world = this.getBaseMetaTileEntity().getWorld();
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                predicate = gt_worldgen -> gt_worldgen.mNether;
                break;
            }
            case 0: {
                predicate = gt_worldgen -> gt_worldgen.mOverworld;
                break;
            }
            case 1: {
                predicate = gt_worldgen -> gt_worldgen.mEnd || gt_worldgen.mEndAsteroid;
                break;
            }
            case 7: {
                predicate = gt_worldgen -> gt_worldgen.isGenerationAllowed(world, 0, 7);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return predicate;
    }

    private Predicate<GT_Worldgen_GT_Ore_SmallPieces> makeSmallOresPredicate() {
        Predicate<GT_Worldgen_GT_Ore_SmallPieces> predicate;
        World world = this.getBaseMetaTileEntity().getWorld();
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                predicate = gt_worldgen -> gt_worldgen.mNether;
                break;
            }
            case 0: {
                predicate = gt_worldgen -> gt_worldgen.mOverworld;
                break;
            }
            case 1: {
                predicate = gt_worldgen -> gt_worldgen.mEnd;
                break;
            }
            case 7: {
                predicate = gt_worldgen -> gt_worldgen.isGenerationAllowed(world, 0, 7);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return predicate;
    }

    private void addDrop(Pair<Integer, Boolean> key, float value) {
        ItemStack ore = this.getOreItemStack(key);
        if (ConfigHandler.voidMinerBlacklist.contains(String.format("%s:%d", GameRegistry.findUniqueIdentifierFor((Item)ore.func_77973_b()).toString(), ore.func_77960_j()))) {
            return;
        }
        if (!this.dropmap.containsKey(key)) {
            this.dropmap.put(key, Float.valueOf(value));
        } else {
            this.dropmap.put(key, Float.valueOf(this.dropmap.get(key).floatValue() + value));
        }
    }

    private void getDropsVanillaVeins(Predicate<GT_Worldgen_GT_Ore_Layer> oreLayerPredicate) {
        GT_Worldgen_GT_Ore_Layer.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && oreLayerPredicate.test((GT_Worldgen_GT_Ore_Layer)gt_worldgen)).forEach(element -> {
            this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mPrimaryMeta), false), element.mWeight);
            this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mSecondaryMeta), false), element.mWeight);
            this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mSporadicMeta), false), (float)element.mWeight / 8.0f);
            this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mBetweenMeta), false), (float)element.mWeight / 8.0f);
        });
    }

    private void getDropsVanillaSmallOres(Predicate<GT_Worldgen_GT_Ore_SmallPieces> smallOresPredicate) {
        GT_Worldgen_GT_Ore_SmallPieces.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && smallOresPredicate.test((GT_Worldgen_GT_Ore_SmallPieces)gt_worldgen)).forEach(element -> this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mMeta), false), element.mAmount));
    }

    private void getDropsOreVeinsSpace(ModDimensionDef finalDef) {
        GalacticGreg.oreVeinWorldgenList.stream().filter(gt_worldgen -> {
            GT_Worldgen_GT_Ore_Layer_Space oreLayerSpace;
            return gt_worldgen.mEnabled && gt_worldgen instanceof GT_Worldgen_GT_Ore_Layer_Space && (oreLayerSpace = (GT_Worldgen_GT_Ore_Layer_Space)gt_worldgen).isEnabledForDim(finalDef);
        }).map(gt_worldgen -> (GT_Worldgen_GT_Ore_Layer_Space)gt_worldgen).forEach(element -> {
            this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mPrimaryMeta), false), element.mWeight);
            this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mSecondaryMeta), false), element.mWeight);
            this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mSporadicMeta), false), (float)element.mWeight / 8.0f);
            this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mBetweenMeta), false), (float)element.mWeight / 8.0f);
        });
    }

    private void getDropsSmallOreSpace(ModDimensionDef finalDef) {
        GalacticGreg.smallOreWorldgenList.stream().filter(gt_worldgen -> {
            GT_Worldgen_GT_Ore_SmallPieces_Space oreSmallPiecesSpace;
            return gt_worldgen.mEnabled && gt_worldgen instanceof GT_Worldgen_GT_Ore_SmallPieces_Space && (oreSmallPiecesSpace = (GT_Worldgen_GT_Ore_SmallPieces_Space)gt_worldgen).isEnabledForDim(finalDef);
        }).map(gt_worldgen -> (GT_Worldgen_GT_Ore_SmallPieces_Space)gt_worldgen).forEach(element -> this.addDrop(new Pair<Integer, Boolean>(Integer.valueOf(element.mMeta), false), element.mAmount));
    }

    private Pair<Integer, Boolean> getOreDamage() {
        Map.Entry<Pair<Integer, Boolean>, Float> entry;
        float curentWeight = 0.0f;
        block0: while (true) {
            float randomnumber = XSTR.XSTR_INSTANCE.nextFloat() * this.totalWeight;
            Iterator<Map.Entry<Pair<Integer, Boolean>, Float>> iterator = this.dropmap.entrySet().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(randomnumber < (curentWeight += (entry = iterator.next()).getValue().floatValue())));
            break;
        }
        return entry.getKey();
    }

    private FluidStack getNobleGasInputAndSetMultiplier() {
        for (FluidStack s : this.getStoredFluids()) {
            for (int i = 0; i < NOBLE_GASSES.length; ++i) {
                FluidStack ng = NOBLE_GASSES[i];
                if (!ng.isFluidEqual(s)) continue;
                this.multiplier = this.TIER_MULTIPLIER * (2 << (i == NOBLE_GASSES.length - 1 ? i + 2 : i + 1));
                return s;
            }
        }
        return null;
    }

    private boolean consumeNobleGas(FluidStack gasToConsume) {
        for (FluidStack s : this.getStoredFluids()) {
            if (!s.isFluidEqual(gasToConsume) || s.amount < 1) continue;
            --s.amount;
            this.updateSlots();
            return true;
        }
        return false;
    }

    private void handleFluidConsumption() {
        FluidStack storedNobleGas = this.getNobleGasInputAndSetMultiplier();
        if (storedNobleGas == null || !this.consumeNobleGas(storedNobleGas)) {
            this.multiplier = this.TIER_MULTIPLIER;
        }
    }

    private void getDropMapRoss(int aID) {
        Consumer<BW_OreLayer> addToList = this.makeAddToList();
        BW_OreLayer.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && gt_worldgen instanceof BW_OreLayer && gt_worldgen.isGenerationAllowed(null, aID, 0)).forEach(addToList);
    }

    private Consumer<BW_OreLayer> makeAddToList() {
        return element -> {
            List<Pair<Integer, Boolean>> data = element.getStacksRawData();
            for (int i = 0; i < data.size(); ++i) {
                if (i < data.size() - 2) {
                    this.addDrop(data.get(i), element.mWeight);
                    continue;
                }
                this.addDrop(data.get(i), (float)element.mWeight / 8.0f);
            }
        };
    }

    private ModDimensionDef makeModDimDef() {
        return GalacticGregRegistry.getModContainers().stream().flatMap(modContainer -> modContainer.getDimensionList().stream()).filter(modDimensionDef -> modDimensionDef.getChunkProviderName().equals(((ChunkProviderServer)this.getBaseMetaTileEntity().getWorld().func_72863_F()).field_73246_d.getClass().getName())).findFirst().orElse(null);
    }

    private void addOresVeinsBartworks(ModDimensionDef finalDef, Consumer<BW_OreLayer> addToList) {
        try {
            GalacticGreg.oreVeinWorldgenList.stream().filter(gt_worldgen -> {
                BW_Worldgen_Ore_Layer_Space oreLayerSpace;
                return gt_worldgen.mEnabled && gt_worldgen instanceof BW_Worldgen_Ore_Layer_Space && (oreLayerSpace = (BW_Worldgen_Ore_Layer_Space)gt_worldgen).isEnabledForDim(finalDef);
            }).map(gt_worldgen -> (BW_Worldgen_Ore_Layer_Space)gt_worldgen).forEach(addToList);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void addSmallOresBartworks(ModDimensionDef finalDef) {
        try {
            GalacticGreg.smallOreWorldgenList.stream().filter(gt_worldgen -> {
                BW_Worldgen_Ore_SmallOre_Space smallOreSpace;
                return gt_worldgen.mEnabled && gt_worldgen instanceof BW_Worldgen_Ore_SmallOre_Space && (smallOreSpace = (BW_Worldgen_Ore_SmallOre_Space)gt_worldgen).isEnabledForDim(finalDef);
            }).map(gt_worldgen -> (BW_Worldgen_Ore_SmallOre_Space)gt_worldgen).forEach(element -> this.addDrop(new Pair<Integer, Boolean>(element.mPrimaryMeta, element.bwOres != 0), element.mDensity));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void handleExtraDrops(int id) {
        Optional.ofNullable(GT_TileEntity_VoidMiner_Base.getExtraDropsDimMap().get((Object)id)).ifPresent(e -> e.forEach(f -> this.addDrop((Pair)f.getKey(), ((Float)f.getValue()).floatValue())));
    }

    private void calculateTotalWeight() {
        this.totalWeight = 0.0f;
        this.dropmap.values().forEach(f -> this.totalWeight += f.floatValue());
    }

    private void handleModDimDef(int id) {
        if (id <= 1 && id >= -1 || id == 7) {
            this.getDropsVanillaVeins(this.makeOreLayerPredicate());
            this.getDropsVanillaSmallOres(this.makeSmallOresPredicate());
        } else if (id == ConfigHandler.ross128BID || id == ConfigHandler.ross128BAID) {
            this.getDropMapRoss(id);
        } else {
            Optional.ofNullable(this.makeModDimDef()).ifPresent(def -> {
                this.getDropsOreVeinsSpace((ModDimensionDef)def);
                this.getDropsSmallOreSpace((ModDimensionDef)def);
                Consumer<BW_OreLayer> addToList = this.makeAddToList();
                this.addOresVeinsBartworks((ModDimensionDef)def, addToList);
                this.addSmallOresBartworks((ModDimensionDef)def);
            });
        }
    }

    private void calculateDropMap() {
        this.dropmap = new HashMap<Pair<Integer, Boolean>, Float>();
        int id = this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
        this.handleModDimDef(id);
        this.handleExtraDrops(id);
        this.calculateTotalWeight();
    }

    private void handleOutputs() {
        List inputOres = this.getStoredInputs().stream().filter(GT_Utility::isOre).collect(Collectors.toList());
        ItemStack output = this.getOreItemStack(this.getOreDamage());
        if (inputOres.size() == 0 || this.mBlacklist && inputOres.stream().allMatch(is -> !GT_Utility.areStacksEqual((ItemStack)is, (ItemStack)output)) || !this.mBlacklist && inputOres.stream().anyMatch(is -> GT_Utility.areStacksEqual((ItemStack)is, (ItemStack)output))) {
            this.addOutput(output);
        }
        this.updateSlots();
    }

    private ItemStack getOreItemStack(Pair<Integer, Boolean> stats) {
        return new ItemStack(stats.getValue() != false ? WerkstoffLoader.BWOres : GregTech_API.sBlockOres1, this.multiplier, stats.getKey().intValue());
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mBlacklist = !this.mBlacklist;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Mode: " + (this.mBlacklist ? "Blacklist" : "Whitelist")));
    }

    static {
        GT_TileEntity_VoidMiner_Base.addMatierialToDimensionList(0, (ISubTagContainer)Materials.Tellurium, 8.0f);
    }
}

