/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tgregworks;

import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import net.minecraftforge.common.config.Property;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.item.ItemTGregPart;
import vexatos.tgregworks.reference.Config;

@Mod(modid="bartworkscrossmodtgregworkscontainer", name="BartWorks Mod Additions - TGregworks Container", version="0.8.21", dependencies="required-after:IC2;required-after:gregtech;required-after:bartworks;before:TGregworks;before:miscutils;")
public class MaterialsInjector {
    public static final String NAME = "BartWorks Mod Additions - TGregworks Container";
    public static final String VERSION = "0.8.21";
    public static final String MOD_ID = "bartworkscrossmodtgregworkscontainer";

    @Mod.EventHandler
    public void init(FMLInitializationEvent init) {
        if (Mods.TinkersGregworks.isModLoaded()) {
            MaterialsInjector.run();
        }
    }

    public static void run() {
        MainMod.LOGGER.info("Registering TGregworks - BartWorks tool parts.");
        Werkstoff.werkstoffHashSet.stream().filter(x -> x.hasItemType(OrePrefixes.gem) || x.hasItemType(OrePrefixes.plate)).map(Werkstoff::getBridgeMaterial).filter(x -> x.mMetaItemSubID == -1).filter(x -> x.mDurability != 0).forEach(m -> {
            MaterialsInjector.setConfigProps(m);
            MaterialsInjector.registerParts(m);
        });
        TGregworks.registry.configProps.clear();
        TGregworks.registry.configIDs.clear();
        ItemTGregPart.toolMaterialNames = TGregworks.registry.toolMaterialNames;
    }

    private static void registerParts(Materials m) {
        TGregworks.registry.toolMaterialNames.add(m.mDefaultLocalName);
        int matID = TGregworks.registry.getMaterialID(m);
        TGregworks.registry.addToolMaterial(matID, m);
        TGregworks.registry.addBowMaterial(matID, m);
        TGregworks.registry.addArrowMaterial(matID, m);
        TGregworks.registry.matIDs.put(m, matID);
        TGregworks.registry.materialIDMap.put(matID, m);
    }

    private static void setConfigProps(Materials m) {
        if (TGregworks.config.get("enable", m.mName, true).getBoolean(true)) {
            TGregworks.registry.toolMaterials.add(m);
            Property configProp = TGregworks.config.get(Config.onMaterial((String)"material-id"), m.mName, 0, null, 0, 100000);
            TGregworks.registry.configProps.put(m, configProp);
            TGregworks.registry.configIDs.add(configProp.getInt());
        }
    }
}

