/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.overlay;

import com.caedis.duradisplay.config.ConfigDurabilityLike;
import com.caedis.duradisplay.overlay.OverlayDurability;
import com.caedis.duradisplay.overlay.OverlayDurabilityLike;
import com.caedis.duradisplay.utils.ColorType;
import com.caedis.duradisplay.utils.DurabilityFormatter;
import com.caedis.duradisplay.utils.DurabilityLikeInfo;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayGadgets
extends OverlayDurabilityLike {
    public static final Set<String> AllowListUnLocalized = Sets.newHashSet((Object[])new String[]{"item.flintAndSteel", "ic2.itemWeedEx", "item.for.waxCast", "item.for.solderingIron", "ic2.itemTreetap", "item.appliedenergistics2.ToolCertusQuartzCuttingKnife", "item.appliedenergistics2.ToolNetherQuartzCuttingKnife", "ic2.itemToolForgeHammer", "item.spellCloth", "item.WoodenBrickForm"});

    public OverlayGadgets() {
        super(new ConfigDurabilityLike(true, OverlayDurabilityLike.Style.Text, DurabilityFormatter.Format.remaining, 2, true, true, 0xFFFFFF, ColorType.Single, new double[]{30.0, 70.0}, new int[]{0xFF0000, 16760264, 0xFFFFFF}, true, 2, true){

            @Override
            public void postLoadConfig() {
                this.configCategory.setComment("Gadgets are items that show UseCount(remain) as default\nincluding some items whose maxDurability<100\nand GregTech lighters and Paint Sprayer\n");
            }

            @Override
            @NotNull
            public String category() {
                return "gadgets";
            }
        });
        this.addHandler("gregtech.api.items.GT_MetaBase_Item", OverlayGadgets::handleGregtech);
        this.addHandler("buildcraft.core.ItemPaintbrush", OverlayGadgets::handleBCBrush);
        this.addHandler("tmechworks.items.SpoolOfWire", OverlayGadgets::handleMechworks);
        this.addHandler("ic2.core.item.tool.ItemToolPainter", OverlayDurability::handleDefault);
        this.addHandler("WayofTime.alchemicalWizardry.common.items.ScribeTool", OverlayDurability::handleDefault);
        this.addHandler("thaumcraft.api.IScribeTools", OverlayDurability::handleDefault);
        this.addHandler("net.minecraft.item.Item", OverlayGadgets::handleByAllowList);
    }

    @Override
    @NotNull
    ConfigDurabilityLike config() {
        return this.config;
    }

    private static DurabilityLikeInfo handleMechworks(@NotNull ItemStack stack) {
        Item item = stack.func_77973_b();
        assert (item != null);
        double max = item.func_77612_l();
        double current = max - (double)item.getDamage(stack);
        return new DurabilityLikeInfo(current, max);
    }

    @Nullable
    public static DurabilityLikeInfo handleBCBrush(@NotNull ItemStack stack) {
        Item item = stack.func_77973_b();
        assert (item != null);
        if (!stack.func_77942_o()) {
            return null;
        }
        double max = item.func_77612_l() + 1;
        double current = max - (double)item.getDamage(stack);
        return new DurabilityLikeInfo(current, max);
    }

    @Nullable
    public static DurabilityLikeInfo handleByAllowList(@NotNull ItemStack stack) {
        if (!AllowListUnLocalized.contains(stack.func_77977_a())) {
            return null;
        }
        Item item = stack.func_77973_b();
        assert (item != null);
        if (!item.func_77645_m()) {
            return null;
        }
        double max = item.func_77612_l();
        double current = max - (double)item.getDamage(stack);
        return new DurabilityLikeInfo(current, max);
    }

    @Nullable
    public static DurabilityLikeInfo handleGregtech(@NotNull ItemStack stack) {
        long max;
        long current = 0L;
        if (stack.field_77994_a != 1) {
            return null;
        }
        int damage = stack.func_77960_j();
        switch (damage) {
            case 32472: {
                max = 16L;
                break;
            }
            case 32473: {
                current = max = 16L;
                break;
            }
            case 32474: 
            case 32475: {
                max = 100L;
                break;
            }
            case 32476: {
                current = max = 100L;
                break;
            }
            case 32477: 
            case 32478: {
                max = 1000L;
                break;
            }
            case 32479: {
                current = max = 1000L;
                break;
            }
            case 32430: 
            case 32431: 
            case 32432: 
            case 32433: 
            case 32434: 
            case 32435: 
            case 32436: 
            case 32437: 
            case 32438: 
            case 32439: 
            case 32440: 
            case 32441: 
            case 32442: 
            case 32443: 
            case 32444: 
            case 32445: 
            case 32446: 
            case 32447: 
            case 32448: 
            case 32449: 
            case 32450: 
            case 32451: 
            case 32452: 
            case 32453: 
            case 32454: 
            case 32455: 
            case 32456: 
            case 32457: 
            case 32458: 
            case 32459: 
            case 32460: {
                max = 512L;
                if (damage % 2 != 0) break;
                current = max;
                break;
            }
            default: {
                return null;
            }
        }
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b("GT.RemainingPaint")) {
                current = tag.func_74763_f("GT.RemainingPaint");
            }
            if (tag.func_74764_b("GT.LighterFuel")) {
                current = tag.func_74763_f("GT.LighterFuel");
            }
        }
        return new DurabilityLikeInfo(current, max);
    }
}

