/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.helpers.ColorHelper;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.helpers.KeyHelper;
import squeek.spiceoflife.helpers.StringHelper;

@SideOnly(value=Side.CLIENT)
public class TooltipHandler {
    private static final DecimalFormat df = new DecimalFormat("##.##");
    private static final FoodGroupComparator foodGroupComparator = new FoodGroupComparator();

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event == null || event.entityPlayer == null || event.itemStack == null || !FoodHelper.isValidFood(event.itemStack)) {
            return;
        }
        int totalFoodEaten = FoodHistory.get((EntityPlayer)event.entityPlayer).totalFoodsEatenAllTime;
        ArrayList<String> toolTipStringsToAdd = new ArrayList<String>();
        Set<FoodGroup> foodGroups = FoodGroupRegistry.getFoodGroupsForFood(event.itemStack);
        Set<FoodGroup> visibleFoodGroups = TooltipHandler.getFoodGroupsForDisplay(foodGroups);
        if (ModConfig.FOOD_MODIFIER_ENABLED && !visibleFoodGroups.isEmpty()) {
            String foodGroupString = visibleFoodGroups.size() > 1 ? StatCollector.func_74838_a((String)"spiceoflife.tooltip.food.groups") : StatCollector.func_74838_a((String)"spiceoflife.tooltip.food.group");
            String joinedFoodGroups = TooltipHandler.joinFoodGroupsForDisplay(visibleFoodGroups, ", ", EnumChatFormatting.GRAY.toString());
            toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + foodGroupString + EnumChatFormatting.GRAY + EnumChatFormatting.ITALIC + joinedFoodGroups);
        }
        if (ModConfig.FOOD_EATEN_THRESHOLD > 0 && totalFoodEaten < ModConfig.FOOD_EATEN_THRESHOLD) {
            if (ModConfig.FOOD_MODIFIER_ENABLED) {
                int timesUntilMeetsThreshold = ModConfig.FOOD_EATEN_THRESHOLD - totalFoodEaten;
                toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"spiceoflife.tooltip.food.until.enabled.1"));
                toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)"spiceoflife.tooltip.food.until.enabled.2", (Object[])new Object[]{timesUntilMeetsThreshold, timesUntilMeetsThreshold == 1 ? StatCollector.func_74838_a((String)"spiceoflife.tooltip.times.singular") : StatCollector.func_74838_a((String)"spiceoflife.tooltip.times.plural")}));
            }
        } else {
            FoodHistory foodHistory = FoodHistory.get(event.entityPlayer);
            float foodModifier = FoodModifier.getFoodModifier(foodHistory, event.itemStack);
            FoodValues foodValues = FoodValues.get((ItemStack)event.itemStack, (EntityPlayer)event.entityPlayer);
            boolean foodOrItsFoodGroupsEatenRecently = foodHistory.containsFoodOrItsFoodGroups(event.itemStack);
            if (FoodHelper.canFoodDiminish(event.itemStack) && (foodOrItsFoodGroupsEatenRecently || foodModifier != 1.0f)) {
                toolTipStringsToAdd.add(0, EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"spiceoflife.tooltip.nutritional.value") + this.getNutritionalValueString(foodModifier) + (foodValues.hunger == 0 && foodModifier != 0.0f ? EnumChatFormatting.DARK_RED + " (" + foodValues.hunger + " " + StatCollector.func_74838_a((String)"spiceoflife.tooltip.hunger") + ")" : ""));
            }
            boolean shouldShowPressShift = visibleFoodGroups.size() > 1 && !KeyHelper.isShiftKeyDown();
            boolean shouldShowFoodGroupDetails = visibleFoodGroups.size() <= 1 || KeyHelper.isShiftKeyDown();
            String bulletPoint = EnumChatFormatting.DARK_GRAY + "- " + EnumChatFormatting.GRAY;
            if (shouldShowPressShift) {
                toolTipStringsToAdd.add(bulletPoint + EnumChatFormatting.DARK_GRAY + StatCollector.func_74837_a((String)"spiceoflife.tooltip.hold.key.for.details", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GRAY}));
            }
            if (shouldShowFoodGroupDetails) {
                int foodGroupsToShow = Math.max(1, visibleFoodGroups.size());
                FoodGroup[] visibleFoodGroupsArray = visibleFoodGroups.toArray(new FoodGroup[visibleFoodGroups.size()]);
                for (int i = 0; i < foodGroupsToShow; ++i) {
                    FoodGroup foodGroup = i < visibleFoodGroupsArray.length ? visibleFoodGroupsArray[i] : null;
                    boolean shouldShowNutritionalValue = foodGroupsToShow > 1;
                    String prefix = foodGroupsToShow > 1 ? bulletPoint : "";
                    toolTipStringsToAdd.add(prefix + this.getEatenRecentlyTooltip(foodHistory, event.itemStack, foodGroup, shouldShowNutritionalValue));
                    toolTipStringsToAdd.add(this.getFullHistoryToolTip(foodHistory, event.itemStack));
                }
            }
        }
        event.toolTip.addAll(toolTipStringsToAdd);
    }

    public static Set<FoodGroup> getFoodGroupsForDisplay(Set<FoodGroup> foodGroups) {
        TreeSet<FoodGroup> visibleFoodGroups = new TreeSet<FoodGroup>(foodGroupComparator);
        for (FoodGroup foodGroup : foodGroups) {
            if (foodGroup.hidden()) continue;
            visibleFoodGroups.add(foodGroup);
        }
        return visibleFoodGroups;
    }

    public static String joinFoodGroupsForDisplay(Set<FoodGroup> foodGroups, String delimiter, String resetFormatting) {
        ArrayList<String> stringsToJoin = new ArrayList<String>();
        for (FoodGroup foodGroup : foodGroups) {
            stringsToJoin.add(foodGroup.formatString(EnumChatFormatting.ITALIC.toString() + foodGroup) + resetFormatting);
        }
        return StringHelper.join(stringsToJoin, delimiter);
    }

    public String getNutritionalValueString(float foodModifier) {
        return ColorHelper.getRelativeColor(foodModifier, 0.0, 1.0) + df.format(foodModifier * 100.0f) + "%";
    }

    public String getEatenRecentlyTooltip(FoodHistory foodHistory, ItemStack itemStack, FoodGroup foodGroup, boolean shouldShowNutritionalValue) {
        int count = foodHistory.getFoodCountForFoodGroup(itemStack, foodGroup);
        String prefix = "Diminishing Returns: " + (foodGroup != null ? foodGroup.formatString(EnumChatFormatting.ITALIC.toString() + foodGroup) + " " : "") + EnumChatFormatting.RESET.toString() + EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC;
        String nutritionalValue = shouldShowNutritionalValue ? EnumChatFormatting.DARK_GRAY + " [" + this.getNutritionalValueString(FoodModifier.getFoodGroupModifier(foodHistory, itemStack, foodGroup)) + EnumChatFormatting.DARK_GRAY + "]" : "";
        String eatenRecently = count > 0 ? StatCollector.func_74837_a((String)"spiceoflife.tooltip.eaten.recently", (Object[])new Object[]{StringHelper.getQuantityDescriptor(count), ModConfig.FOOD_HISTORY_LENGTH}) : StatCollector.func_74838_a((String)"spiceoflife.tooltip.not.eaten.recently");
        return prefix + (foodGroup != null ? StringHelper.decapitalize(eatenRecently, StringHelper.getMinecraftLocale()) : eatenRecently) + nutritionalValue;
    }

    public String getFullHistoryToolTip(FoodHistory foodHistory, ItemStack itemStack) {
        String prefix = "Extra Hearts: " + EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC.toString();
        if (!foodHistory.hasEverEaten(itemStack)) {
            return prefix + StatCollector.func_74838_a((String)"spiceoflife.tooltip.not.eaten.ever");
        }
        return prefix + StatCollector.func_74838_a((String)"spiceoflife.tooltip.eaten.ever");
    }

    static class FoodGroupComparator
    implements Comparator<FoodGroup>,
    Serializable {
        private static final long serialVersionUID = -4556648064321616158L;

        FoodGroupComparator() {
        }

        @Override
        public int compare(FoodGroup a, FoodGroup b) {
            return a.getLocalizedName().compareToIgnoreCase(b.getLocalizedName());
        }
    }
}

