/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.util;

import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.events.CompendiumEvents;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import chylex.hee.mechanics.compendium.objects.ObjectBlock;
import chylex.hee.mechanics.compendium.objects.ObjectItem;
import chylex.hee.mechanics.compendium.objects.ObjectMob;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C03KnowledgeNotification;
import chylex.hee.packets.client.C19CompendiumData;
import net.minecraft.entity.player.EntityPlayer;

public final class KnowledgeObservation {
    private KnowledgeObject<? extends IKnowledgeObjectInstance<?>> object;
    private byte type;

    public void setEmpty() {
        this.object = null;
        this.type = 0;
    }

    public KnowledgeObservation setBlock(KnowledgeObject<ObjectBlock> obj) {
        if (obj == null) {
            return this;
        }
        this.object = obj;
        this.type = 1;
        return this;
    }

    public KnowledgeObservation setItem(KnowledgeObject<ObjectItem> obj) {
        if (obj == null) {
            return this;
        }
        this.object = obj;
        this.type = (byte)2;
        return this;
    }

    public KnowledgeObservation setMob(KnowledgeObject<ObjectMob> obj) {
        if (obj == null) {
            return this;
        }
        this.object = obj;
        this.type = (byte)3;
        return this;
    }

    public KnowledgeObject<? extends IKnowledgeObjectInstance<?>> getObject() {
        return this.object;
    }

    public void discover(EntityPlayer player) {
        boolean result = false;
        switch (this.type) {
            case 1: {
                result = CompendiumEvents.getPlayerData(player).tryDiscoverBlock(this.object, true);
                break;
            }
            case 2: {
                result = CompendiumEvents.getPlayerData(player).tryDiscoverItem(this.object, true);
                break;
            }
            case 3: {
                result = CompendiumEvents.getPlayerData(player).tryDiscoverMob(this.object, true);
                break;
            }
            default: {
                return;
            }
        }
        if (result) {
            PacketPipeline.sendToPlayer(player, new C03KnowledgeNotification(this.object));
            PacketPipeline.sendToPlayer(player, new C19CompendiumData(player));
        }
    }
}

