/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.misc;

import chylex.hee.system.logging.Log;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.ItemPattern;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.ArrayUtils;

public final class StardustDecomposition {
    private static final List<ItemPattern> patterns = new ArrayList<ItemPattern>();
    private static IdentityHashMap<Item, short[]> blacklist = new IdentityHashMap();

    public static void addToBlacklist(ItemPattern pattern) {
        patterns.add(pattern);
    }

    public static void addFromString(String list) {
        String[] split;
        if (list.isEmpty()) {
            return;
        }
        int added = 0;
        for (String entry : split = list.split(",")) {
            String[] itemId;
            if ((entry = entry.trim()).length() == 0) continue;
            String itemName = entry;
            short[] dmgs = new short[]{-1};
            if (entry.contains("/")) {
                String[] sep = entry.split("/");
                if (sep.length != 2) {
                    Log.warn("Invalid entry in Decomposition Blacklist: $0", entry);
                    continue;
                }
                itemName = sep[0];
                try {
                    if (sep[1].contains("+")) {
                        String[] dmgVals = sep[1].split("\\+");
                        dmgs = new short[dmgVals.length];
                        for (int a = 0; a < dmgVals.length; ++a) {
                            dmgs[a] = Short.parseShort(dmgVals[a]);
                        }
                    } else {
                        dmgs = new short[]{Short.parseShort(sep[1])};
                    }
                }
                catch (NumberFormatException e) {
                    Log.warn("Invalid entry in Decomposition Blacklist, wrong damage values: $0", entry);
                    continue;
                }
            }
            if ((itemId = itemName.split(":")).length > 2) {
                Log.warn("Invalid entry in Decomposition Blacklist, wrong item identifier: $0", entry);
                continue;
            }
            if (itemId.length == 1) {
                itemId = new String[]{"minecraft", itemId[0]};
            }
            if (itemId[1].equals("*")) {
                String identifier = itemId[0] + ":";
                for (String key : GameData.getBlockRegistry().func_148742_b()) {
                    if (!key.startsWith(identifier)) continue;
                    Block block = (Block)GameData.getBlockRegistry().getRaw(key);
                    if (block == null) {
                        if (!itemId[0].equals("minecraft") && !Loader.isModLoaded((String)itemId[0])) continue;
                        Log.warn("Stumbled upon invalid entry in block registry while parsing Decomposition Blacklist, object not found: $0", key);
                        continue;
                    }
                    blacklist.put(Item.func_150898_a((Block)block), dmgs);
                    ++added;
                }
                for (String key : GameData.getItemRegistry().func_148742_b()) {
                    if (!key.startsWith(identifier)) continue;
                    Item item = (Item)GameData.getItemRegistry().getRaw(key);
                    if (item == null) {
                        if (!itemId[0].equals("minecraft") && !Loader.isModLoaded((String)itemId[0])) continue;
                        Log.warn("Stumbled upon invalid entry in item registry while parsing Decomposition Blacklist, object not found: $0", key);
                        continue;
                    }
                    blacklist.put(item, dmgs);
                    ++added;
                }
                continue;
            }
            Item item = GameRegistry.findItem((String)itemId[0], (String)itemId[1]);
            if (item == null) {
                Block block = GameRegistry.findBlock((String)itemId[0], (String)itemId[1]);
                if (block == null) {
                    if (!itemId[0].equals("minecraft") && !Loader.isModLoaded((String)itemId[0])) continue;
                    Log.warn("Invalid entry in Decomposition Blacklist, item not found: $0", entry);
                    continue;
                }
                item = Item.func_150898_a((Block)block);
            }
            blacklist.put(item, dmgs);
            ++added;
        }
        if (added > 0) {
            Log.info("Added $0 items into Decomposition blacklist", added);
        }
    }

    private static boolean isBlacklisted(ItemStack is) {
        for (ItemPattern pattern : patterns) {
            if (!pattern.matches(is)) continue;
            return true;
        }
        short[] blacklistedDamages = blacklist.get(is.func_77973_b());
        return blacklistedDamages != null && blacklistedDamages.length > 0 && (blacklistedDamages[0] == -1 || ArrayUtils.contains((short[])blacklistedDamages, (short)((short)is.func_77960_j())));
    }

    public static List<ItemStack> getRandomRecipeIngredientsFor(ItemStack is, Random rand) {
        Item item = is.func_77973_b();
        if (StardustDecomposition.isBlacklisted(is)) {
            return null;
        }
        ArrayList<ItemStack[]> ingredients = new ArrayList<ItemStack[]>();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            Object[] objs;
            ItemStack[] ing;
            ItemStack output = recipe.func_77571_b();
            if (output == null || output.func_77973_b() != item || output.field_77994_a != is.field_77994_a || !is.func_77984_f() && output.func_77960_j() != is.func_77960_j()) continue;
            if (recipe instanceof ShapedRecipes) {
                ingredients.add(DragonUtil.getNonNullValues(((ShapedRecipes)recipe).field_77574_d));
                continue;
            }
            if (recipe instanceof ShapelessRecipes) {
                ShapelessRecipes shapeless = (ShapelessRecipes)recipe;
                ing = new ItemStack[shapeless.field_77579_b.size()];
                for (int a = 0; a < ing.length; ++a) {
                    ing[a] = (ItemStack)shapeless.field_77579_b.get(a);
                }
                ingredients.add(ing);
                continue;
            }
            Object object = recipe instanceof ShapedOreRecipe ? DragonUtil.getNonNullValues(((ShapedOreRecipe)recipe).getInput()) : (objs = recipe instanceof ShapelessOreRecipe ? ((ShapelessOreRecipe)recipe).getInput().toArray() : null);
            if (objs == null) continue;
            ing = new ItemStack[objs.length];
            boolean failed = false;
            for (int a = 0; a < ing.length; ++a) {
                if (objs[a] instanceof ItemStack) {
                    ing[a] = (ItemStack)objs[a];
                    continue;
                }
                if (!(objs[a] instanceof ArrayList)) continue;
                ArrayList list = (ArrayList)objs[a];
                if (list.isEmpty()) {
                    failed = true;
                    break;
                }
                ing[a] = (ItemStack)list.get(rand.nextInt(list.size()));
            }
            if (failed) continue;
            ingredients.add(ing);
        }
        while (!ingredients.isEmpty()) {
            ArrayList<Object> randRecipeIngredients = CollectionUtil.newList((Object[])ingredients.remove(rand.nextInt(ingredients.size())));
            Iterator iter = randRecipeIngredients.iterator();
            while (iter.hasNext()) {
                ItemStack ingredient = (ItemStack)iter.next();
                if (ingredient == null) {
                    return null;
                }
                if (ingredient.func_77973_b().hasContainerItem(ingredient) || StardustDecomposition.isBlacklisted(ingredient)) {
                    iter.remove();
                    continue;
                }
                if (ingredient.func_77960_j() != Short.MAX_VALUE) continue;
                ingredient.func_77964_b(0);
            }
            if (randRecipeIngredients.isEmpty()) continue;
            return randRecipeIngredients;
        }
        return null;
    }

    private StardustDecomposition() {
    }
}

