/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.graphs.Lock;
import gregtech.api.graphs.Node;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IDebugableTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IPipeRenderedTileEntity;
import gregtech.api.metatileentity.CommonMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.net.GT_Packet_TileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.covers.CoverInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class BaseMetaPipeEntity
extends CommonMetaTileEntity
implements IGregTechTileEntity,
IPipeRenderedTileEntity,
IDebugableTileEntity {
    public byte mConnections = 0;
    protected MetaPipeEntity mMetaTileEntity;
    private final int[] mTimeStatistics = new int[GregTech_API.TICKS_FOR_LAG_AVERAGING];
    private boolean hasTimeStatisticsStarted;
    private boolean mWorkUpdate = false;
    private boolean mWorks = true;
    private byte mColor = 0;
    private byte oColor = 0;
    private byte oStrongRedstone = 0;
    private byte oRedstoneData = (byte)63;
    private byte oTextureData = 0;
    private byte oUpdateData = 0;
    private byte mLagWarningCount = 0;
    private int oX = 0;
    private int oY = 0;
    private int oZ = 0;
    private int mTimeStatisticsIndex = 0;
    protected Node node;
    protected NodePath nodePath;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public NodePath getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(NodePath nodePath) {
        this.nodePath = nodePath;
    }

    public void addToLock(TileEntity tileEntity, ForgeDirection side) {
        if (this.node != null) {
            Lock lock = this.node.locks[side.ordinal()];
            if (lock != null) {
                lock.addTileEntity(tileEntity);
            }
        } else if (this.nodePath != null) {
            this.nodePath.lock.addTileEntity(tileEntity);
        }
    }

    public void removeFromLock(TileEntity tileEntity, ForgeDirection side) {
        if (this.node != null) {
            Lock lock = this.node.locks[side.ordinal()];
            if (lock != null) {
                lock.removeTileEntity(tileEntity);
            }
        } else if (this.nodePath != null) {
            this.nodePath.lock.removeTileEntity(tileEntity);
        }
    }

    public void reloadLocks() {
        IMetaTileEntity meta = this.getMetaTileEntity();
        if (meta instanceof MetaPipeEntity) {
            ((MetaPipeEntity)meta).reloadLocks();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound aNBT) {
        try {
            super.func_145841_b(aNBT);
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity", e);
        }
        try {
            aNBT.func_74768_a("mID", (int)this.mID);
            this.writeCoverNBT(aNBT, false);
            aNBT.func_74774_a("mConnections", this.mConnections);
            aNBT.func_74774_a("mColor", this.mColor);
            aNBT.func_74757_a("mWorks", !this.mWorks);
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity", e);
        }
        this.saveMetaTileNBT(aNBT);
    }

    public void func_145839_a(NBTTagCompound aNBT) {
        super.func_145839_a(aNBT);
        this.setInitialValuesAsNBT(aNBT, (short)0);
    }

    @Override
    public void setInitialValuesAsNBT(NBTTagCompound aNBT, short aID) {
        if (aNBT == null) {
            if (aID > 0) {
                this.mID = aID;
            } else {
                short s = this.mID = this.mID > 0 ? this.mID : (short)0;
            }
            if (this.mID != 0) {
                this.createNewMetatileEntity(this.mID);
            }
        } else {
            this.mID = aID <= 0 ? (short)aNBT.func_74762_e("mID") : aID;
            this.mConnections = aNBT.func_74771_c("mConnections");
            this.mColor = aNBT.func_74771_c("mColor");
            boolean bl = this.mWorks = !aNBT.func_74767_n("mWorks");
            if (this.mSidedRedstone.length != 6) {
                this.mSidedRedstone = new byte[]{0, 0, 0, 0, 0, 0};
            }
            this.readCoverNBT(aNBT);
            this.loadMetaTileNBT(aNBT);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.hasValidMetaTileEntity()) {
            if (this.mMetaTileEntity == null) {
                return;
            }
            this.mMetaTileEntity.setBaseMetaTileEntity(this);
        }
        long tTime = this.hasTimeStatisticsStarted ? System.nanoTime() : 0L;
        try {
            if (this.hasValidMetaTileEntity()) {
                if (this.mTickTimer++ == 0L) {
                    this.oX = this.field_145851_c;
                    this.oY = this.field_145848_d;
                    this.oZ = this.field_145849_e;
                    if (this.isServerSide()) {
                        this.checkDropCover();
                    } else {
                        this.requestCoverDataIfNeeded();
                    }
                    this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                    this.mMetaTileEntity.onFirstTick(this);
                    if (!this.hasValidMetaTileEntity()) {
                        return;
                    }
                }
                if (this.isClientSide()) {
                    if (this.mColor != this.oColor) {
                        this.oColor = this.mColor;
                        this.mMetaTileEntity.onColorChangeClient(this.oColor);
                        this.issueTextureUpdate();
                    }
                    if (this.mNeedsUpdate) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.mNeedsUpdate = false;
                    }
                }
                if (this.isServerSide() && this.mTickTimer > 10L) {
                    if (!this.doCoverThings()) {
                        return;
                    }
                    byte oldConnections = this.mConnections;
                    this.mConnections = (byte)(this.mMetaTileEntity.mConnections | this.mConnections & 0xFFFFFFC0);
                    if ((this.mConnections & 0xC0) == 64 && this.getRandomNumber(1000) == 0) {
                        this.mConnections = (byte)(this.mConnections & 0xFFFFFFBF | 0x80);
                    }
                    if (this.mTickTimer > 12L && oldConnections != this.mConnections) {
                        GregTech_API.causeCableUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
                this.mMetaTileEntity.onPreTick(this, this.mTickTimer);
                if (!this.hasValidMetaTileEntity()) {
                    return;
                }
                if (this.isServerSide()) {
                    if (this.mTickTimer == 10L) {
                        this.updateCoverBehavior();
                        this.issueBlockUpdate();
                        this.joinEnet();
                    }
                    if (this.field_145851_c != this.oX || this.field_145848_d != this.oY || this.field_145849_e != this.oZ) {
                        this.oX = this.field_145851_c;
                        this.oY = this.field_145848_d;
                        this.oZ = this.field_145849_e;
                        this.issueClientUpdate();
                        this.clearTileEntityBuffer();
                    }
                }
                this.mMetaTileEntity.onPostTick(this, this.mTickTimer);
                if (!this.hasValidMetaTileEntity()) {
                    return;
                }
                if (this.isServerSide()) {
                    if (this.mTickTimer % 10L == 0L) {
                        this.sendClientData();
                    }
                    if (this.mTickTimer > 10L) {
                        byte tData;
                        if (this.mConnections != this.oTextureData) {
                            this.oTextureData = this.mConnections;
                            this.sendBlockEvent((byte)0, this.oTextureData);
                        }
                        if ((tData = this.mMetaTileEntity.getUpdateData()) != this.oUpdateData) {
                            this.oUpdateData = tData;
                            this.sendBlockEvent((byte)1, this.oUpdateData);
                        }
                        if (this.mColor != this.oColor) {
                            this.oColor = this.mColor;
                            this.sendBlockEvent((byte)2, this.oColor);
                        }
                        if ((tData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0))) != this.oRedstoneData) {
                            this.oRedstoneData = tData;
                            this.sendBlockEvent((byte)3, this.oRedstoneData);
                        }
                    }
                    if (this.mNeedsBlockUpdate) {
                        this.updateNeighbours(this.mStrongRedstone, this.oStrongRedstone);
                        this.oStrongRedstone = this.mStrongRedstone;
                        this.mNeedsBlockUpdate = false;
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            e.printStackTrace(GT_Log.err);
        }
        if (this.isServerSide() && this.hasTimeStatisticsStarted && this.hasValidMetaTileEntity()) {
            tTime = System.nanoTime() - tTime;
            this.mTimeStatisticsIndex = (this.mTimeStatisticsIndex + 1) % this.mTimeStatistics.length;
            this.mTimeStatistics[this.mTimeStatisticsIndex] = (int)tTime;
            if (tTime > 0L && tTime > (long)GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING * 1000000L && this.mTickTimer > 1000L && this.getMetaTileEntity().doTickProfilingMessageDuringThisTick()) {
                byte by = this.mLagWarningCount;
                this.mLagWarningCount = (byte)(by + 1);
                if (by < 10) {
                    GT_Mod.GT_FML_LOGGER.warn("WARNING: Possible Lag Source at [" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + "] in Dimension " + this.field_145850_b.field_73011_w.field_76574_g + " with " + tTime + " ns caused by an instance of " + this.getMetaTileEntity().getClass());
                }
            }
        }
        this.mInventoryChanged = false;
        this.mWorkUpdate = false;
    }

    private void sendClientData() {
        if (this.mSendClientData) {
            this.oTextureData = this.mConnections;
            this.oUpdateData = this.hasValidMetaTileEntity() ? this.mMetaTileEntity.getUpdateData() : (byte)0;
            this.oRedstoneData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0));
            this.oColor = this.mColor;
            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GT_Packet_TileEntity(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mID, this.getCoverInfoAtSide(ForgeDirection.DOWN).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.UP).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.NORTH).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.SOUTH).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.WEST).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.EAST).getCoverID(), this.oTextureData, this.oUpdateData, this.oRedstoneData, this.oColor), this.field_145851_c, this.field_145849_e);
            this.mSendClientData = false;
        }
        this.sendCoverDataIfNeeded();
    }

    public final void receiveMetaTileEntityData(short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aTextureData, byte aUpdateData, byte aRedstoneData, byte aColorData) {
        this.issueTextureUpdate();
        if (aID > 0 && this.mID != aID) {
            this.mID = aID;
            this.createNewMetatileEntity(this.mID);
        }
        this.setCoverIDAtSide(ForgeDirection.DOWN, aCover0);
        this.setCoverIDAtSide(ForgeDirection.UP, aCover1);
        this.setCoverIDAtSide(ForgeDirection.NORTH, aCover2);
        this.setCoverIDAtSide(ForgeDirection.SOUTH, aCover3);
        this.setCoverIDAtSide(ForgeDirection.WEST, aCover4);
        this.setCoverIDAtSide(ForgeDirection.EAST, aCover5);
        this.func_145842_c(0, aTextureData);
        this.func_145842_c(1, aUpdateData);
        this.func_145842_c(2, aColorData);
        this.func_145842_c(3, aRedstoneData);
    }

    public boolean func_145842_c(int aEventID, int aValue) {
        super.func_145842_c(aEventID, aValue);
        if (this.hasValidMetaTileEntity()) {
            try {
                this.mMetaTileEntity.receiveClientEvent((byte)aEventID, (byte)aValue);
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("Encountered Exception while receiving Data from the Server", e);
            }
        }
        if (this.isClientSide()) {
            this.issueTextureUpdate();
            switch (aEventID) {
                case 0: {
                    this.mConnections = (byte)aValue;
                    break;
                }
                case 1: {
                    if (!this.hasValidMetaTileEntity()) break;
                    this.mMetaTileEntity.onValueUpdate((byte)aValue);
                    break;
                }
                case 2: {
                    if (aValue > 16 || aValue < 0) {
                        aValue = 0;
                    }
                    this.mColor = (byte)aValue;
                    break;
                }
                case 3: {
                    this.mSidedRedstone[0] = (byte)((aValue & 1) == 1 ? 15 : 0);
                    this.mSidedRedstone[1] = (byte)((aValue & 2) == 2 ? 15 : 0);
                    this.mSidedRedstone[2] = (byte)((aValue & 4) == 4 ? 15 : 0);
                    this.mSidedRedstone[3] = (byte)((aValue & 8) == 8 ? 15 : 0);
                    this.mSidedRedstone[4] = (byte)((aValue & 0x10) == 16 ? 15 : 0);
                    this.mSidedRedstone[5] = (byte)((aValue & 0x20) == 32 ? 15 : 0);
                    break;
                }
                case 4: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.doSound((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 5: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.startSoundLoop((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 6: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.stopSoundLoop((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                }
            }
        }
        return true;
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aLogLevel) {
        ArrayList<String> tList = new ArrayList<String>();
        if (aLogLevel > 3) {
            tList.add("Meta-ID: " + EnumChatFormatting.BLUE + this.mID + EnumChatFormatting.RESET + (this.hasValidMetaTileEntity() ? EnumChatFormatting.GREEN + " valid" + EnumChatFormatting.RESET : EnumChatFormatting.RED + " invalid" + EnumChatFormatting.RESET) + (this.mMetaTileEntity == null ? EnumChatFormatting.RED + " MetaTileEntity == null!" + EnumChatFormatting.RESET : " "));
        }
        if (aLogLevel > 1) {
            if (this.hasTimeStatisticsStarted) {
                double tAverageTime = 0.0;
                double tWorstTime = 0.0;
                int amountOfZero = 0;
                for (int tTime : this.mTimeStatistics) {
                    tAverageTime += (double)tTime;
                    if ((double)tTime > tWorstTime) {
                        tWorstTime = tTime;
                    }
                    if (tTime != 0) continue;
                    ++amountOfZero;
                }
                int samples = this.mTimeStatistics.length - amountOfZero;
                if (samples > 0) {
                    tList.add("Average CPU-load of ~" + tAverageTime / (double)samples + "ns since " + samples + " ticks with worst time of " + tWorstTime + "ns.");
                }
            } else {
                this.startTimeStatistics();
                tList.add("Just started tick time statistics.");
            }
            if (this.mLagWarningCount > 0) {
                tList.add("Caused " + (this.mLagWarningCount >= 10 ? "more than 10" : Byte.valueOf(this.mLagWarningCount)) + " Lag Spike Warnings (anything taking longer than " + GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING + "ms) on the Server.");
            }
            if (this.mMetaTileEntity != null) {
                tList.add("Is" + (this.mMetaTileEntity.isAccessAllowed(aPlayer) ? " " : EnumChatFormatting.RED + " not " + EnumChatFormatting.RESET) + "accessible for you");
            }
        }
        if (this.joinedIc2Enet) {
            tList.add("Joined IC2 ENet");
        }
        return this.mMetaTileEntity != null ? this.mMetaTileEntity.getSpecialDebugInfo(this, aPlayer, aLogLevel, tList) : new ArrayList<String>();
    }

    @Override
    public boolean isGivingInformation() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isGivingInformation();
        }
        return false;
    }

    @Override
    public ForgeDirection getBackFacing() {
        return this.getFrontFacing().getOpposite();
    }

    @Override
    public ForgeDirection getFrontFacing() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public void setFrontFacing(ForgeDirection aFacing) {
        this.doEnetUpdate();
    }

    public int func_70302_i_() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70301_a(aIndex);
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        this.func_70296_d();
        this.mInventoryChanged = true;
        if (this.canAccessData()) {
            this.mMetaTileEntity.func_70299_a(aIndex, this.field_145850_b.field_72995_K ? aStack : GT_OreDictUnificator.setStack(true, aStack));
        }
    }

    public String func_145825_b() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_145825_b();
        }
        if (GregTech_API.METATILEENTITIES[this.mID] != null) {
            return GregTech_API.METATILEENTITIES[this.mID].func_145825_b();
        }
        return "";
    }

    public int func_70297_j_() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70297_j_();
        }
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return this.hasValidMetaTileEntity() && this.mTickTimer > 40L && this.getTileEntityOffset(0, 0, 0) == this && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0 && this.mMetaTileEntity.isAccessAllowed(aPlayer);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.mTickTimer = 0L;
    }

    @Override
    public void func_145843_s() {
        this.field_145846_f = false;
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.onRemoval();
            this.mMetaTileEntity.setBaseMetaTileEntity(null);
        }
        this.leaveEnet();
        super.func_145843_s();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    @Override
    public void onMachineBlockUpdate() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onMachineBlockUpdate();
        }
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return this.canAccessData() && this.mMetaTileEntity.isMachineBlockUpdateRecursive();
    }

    @Override
    public int getProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.getProgresstime() : 0;
    }

    @Override
    public int getMaxProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.maxProgresstime() : 0;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.canAccessData() && this.mMetaTileEntity.increaseProgress(aProgressAmountInTicks) != aProgressAmountInTicks;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public void enableWorking() {
        if (!this.mWorks) {
            this.mWorkUpdate = true;
        }
        this.mWorks = true;
        this.reloadLocks();
    }

    @Override
    public void disableWorking() {
        this.mWorks = false;
        this.reloadLocks();
    }

    @Override
    public boolean isAllowedToWork() {
        return this.mWorks;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.mWorkUpdate;
    }

    @Override
    public byte getWorkDataValue() {
        return 0;
    }

    @Override
    public void setWorkDataValue(byte aValue) {
    }

    @Override
    public int getMetaTileID() {
        return this.mID;
    }

    @Override
    public int setMetaTileID(short aID) {
        this.mID = aID;
        return this.mID;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void setActive(boolean aActive) {
    }

    @Override
    public long getTimer() {
        return this.mTickTimer;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        return false;
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    @Override
    public boolean inputEnergyFrom(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean inputEnergyFrom(ForgeDirection side, boolean waitForActive) {
        return false;
    }

    @Override
    public boolean outputsEnergyTo(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean outputsEnergyTo(ForgeDirection side, boolean waitForActive) {
        return false;
    }

    @Override
    public long getOutputAmperage() {
        return 0L;
    }

    @Override
    public long getOutputVoltage() {
        return 0L;
    }

    @Override
    public long getInputAmperage() {
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        return 0L;
    }

    @Override
    public long getUniversalEnergyStored() {
        return Math.max(this.getStoredEU(), this.getStoredSteam());
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return Math.max(this.getEUCapacity(), this.getSteamCapacity());
    }

    @Override
    public long getStoredEU() {
        return 0L;
    }

    @Override
    public long getEUCapacity() {
        return 0L;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, ForgeDirection side) {
        ITexture rIcon = this.getCoverTexture(side);
        if (rIcon != null) {
            return new ITexture[]{rIcon};
        }
        return this.getTextureUncovered(side);
    }

    @Override
    public ITexture[] getTextureCovered(ForgeDirection side) {
        ITexture coverTexture = this.getCoverTexture(side);
        ITexture[] textureUncovered = this.getTextureUncovered(side);
        if (coverTexture != null) {
            ITexture[] textureCovered = Arrays.copyOf(textureUncovered, textureUncovered.length + 1);
            textureCovered[textureUncovered.length] = coverTexture;
            return textureCovered;
        }
        return textureUncovered;
    }

    @Override
    public ITexture[] getTextureUncovered(ForgeDirection sideDirection) {
        if ((this.mConnections & 0x40) != 0) {
            return Textures.BlockIcons.FRESHFOAM;
        }
        if ((this.mConnections & 0x80) != 0) {
            return Textures.BlockIcons.HARDENEDFOAMS[this.mColor];
        }
        if ((this.mConnections & 0xC0) != 0) {
            return Textures.BlockIcons.ERROR_RENDERING;
        }
        int tConnections = this.mConnections;
        if (tConnections == 16 || tConnections == 32) {
            tConnections = 48;
        } else if (tConnections == 1 || tConnections == 2) {
            tConnections = 3;
        } else if (tConnections == 4 || tConnections == 8) {
            tConnections = 12;
        }
        if (this.hasValidMetaTileEntity()) {
            return this.mMetaTileEntity.getTexture((IGregTechTileEntity)this, sideDirection, tConnections, this.mColor - 1, tConnections == 0 || (tConnections & sideDirection.flag) != 0, this.getOutputRedstoneSignal(sideDirection) > 0);
        }
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    @Override
    protected boolean hasValidMetaTileEntity() {
        return this.mMetaTileEntity != null && this.mMetaTileEntity.getBaseMetaTileEntity() == this;
    }

    @Override
    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onExplosion();
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    @Override
    public ArrayList<ItemStack> getDrops() {
        ItemStack rStack = new ItemStack(GregTech_API.sBlockMachines, 1, (int)this.mID);
        NBTTagCompound tNBT = new NBTTagCompound();
        this.writeCoverNBT(tNBT, true);
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.setItemNBT(tNBT);
        }
        if (!tNBT.func_82582_d()) {
            rStack.func_77982_d(tNBT);
        }
        this.onBaseTEDestroyed();
        return new ArrayList<ItemStack>(Collections.singletonList(rStack));
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return this.mMetaTileEntity == null || this.mMetaTileEntity.shouldDropItemAt(index);
    }

    @Override
    public boolean onRightclick(EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (this.isClientSide()) {
            if (aPlayer.func_70093_af()) {
                ForgeDirection tSide = this.getCoverIDAtSide(side) == 0 ? GT_Utility.determineWrenchingSide(side, aX, aY, aZ) : side;
                return this.getCoverInfoAtSide(tSide).hasCoverGUI();
            }
            if (this.getCoverBehaviorAtSideNew(side).onCoverRightclickClient(side, this, aPlayer, aX, aY, aZ)) {
                return true;
            }
        }
        if (this.isServerSide()) {
            ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
            if (tCurrentItem != null) {
                CoverInfo coverInfo;
                if (this.getColorization() >= 0 && GT_Utility.areStacksEqual(new ItemStack(Items.field_151131_as, 1), tCurrentItem)) {
                    this.mMetaTileEntity.func_70296_d();
                    tCurrentItem.func_150996_a(Items.field_151133_ar);
                    this.setColorization((byte)-1);
                    return true;
                }
                ForgeDirection tSide = GT_Utility.determineWrenchingSide(side, aX, aY, aZ);
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList)) {
                    if (this.mMetaTileEntity.onWrenchRightClick(side, tSide, aPlayer, aX, aY, aZ)) {
                        this.mMetaTileEntity.func_70296_d();
                        GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList)) {
                    if (this.getCoverIDAtSide(side) == 0 && this.getCoverIDAtSide(tSide) != 0) {
                        if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 200, (EntityLivingBase)aPlayer)) {
                            this.setCoverDataAtSide(tSide, this.getCoverInfoAtSide(tSide).onCoverScrewdriverClick(aPlayer, 0.5f, 0.5f, 0.5f));
                            this.mMetaTileEntity.onScrewdriverRightClick(tSide, aPlayer, aX, aY, aZ);
                            this.mMetaTileEntity.func_70296_d();
                            GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    } else if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        this.setCoverDataAtSide(side, this.getCoverInfoAtSide(side).onCoverScrewdriverClick(aPlayer, aX, aY, aZ));
                        this.mMetaTileEntity.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
                        this.mMetaTileEntity.func_70296_d();
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sHardHammerList)) {
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        if (this.mWorks) {
                            this.disableWorking();
                        } else {
                            this.enableWorking();
                        }
                        this.mMetaTileEntity.func_70296_d();
                        GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("090", "Machine Processing: ") + (this.isAllowedToWork() ? GT_Utility.trans("088", "Enabled") : GT_Utility.trans("087", "Disabled")));
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList)) {
                    if (this.mMetaTileEntity.onWireCutterRightClick(side, tSide, aPlayer, aX, aY, aZ)) {
                        this.mMetaTileEntity.func_70296_d();
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    this.doEnetUpdate();
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList)) {
                    if (this.mMetaTileEntity.onSolderingToolRightClick(side, tSide, aPlayer, aX, aY, aZ)) {
                        this.mMetaTileEntity.func_70296_d();
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_BATTERY_USE, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    } else if (GT_ModHandler.useSolderingIron(tCurrentItem, (EntityLivingBase)aPlayer)) {
                        this.mMetaTileEntity.func_70296_d();
                        this.mStrongRedstone = (byte)(this.mStrongRedstone ^ tSide.flag);
                        GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("091", "Redstone Output at Side ") + tSide + GT_Utility.trans("092", " set to: ") + ((this.mStrongRedstone & tSide.flag) != 0 ? GT_Utility.trans("093", "Strong") : GT_Utility.trans("094", "Weak")));
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_BATTERY_USE, 3.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.issueBlockUpdate();
                    }
                    this.doEnetUpdate();
                    return true;
                }
                ForgeDirection coverSide = side;
                if (this.getCoverIDAtSide(side) == 0) {
                    coverSide = tSide;
                }
                if ((coverInfo = this.getCoverInfoAtSide(coverSide)).getCoverID() == 0) {
                    if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCovers.keySet())) {
                        GT_CoverBehaviorBase<?> coverBehavior = GregTech_API.getCoverBehaviorNew(tCurrentItem);
                        if (coverBehavior.isCoverPlaceable(coverSide, tCurrentItem, (ICoverable)this) && this.mMetaTileEntity.allowCoverOnSide(coverSide, new GT_ItemStack(tCurrentItem))) {
                            this.setCoverItemAtSide(coverSide, tCurrentItem);
                            coverBehavior.onPlayerAttach(aPlayer, tCurrentItem, this, side);
                            this.mMetaTileEntity.func_70296_d();
                            if (!aPlayer.field_71075_bZ.field_75098_d) {
                                --tCurrentItem.field_77994_a;
                            }
                            GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return true;
                    }
                } else if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCrowbarList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.RANDOM_BREAK, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.dropCover(coverSide, side, false);
                        this.mMetaTileEntity.func_70296_d();
                    }
                    return true;
                }
            } else if (aPlayer.func_70093_af()) {
                side = this.getCoverIDAtSide(side) == 0 ? GT_Utility.determineWrenchingSide(side, aX, aY, aZ) : side;
                CoverInfo coverInfo = this.getCoverInfoAtSide(side);
                return coverInfo.isValid() && coverInfo.onCoverShiftRightClick(aPlayer);
            }
            if (this.getCoverInfoAtSide(side).onCoverRightClick(aPlayer, aX, aY, aZ)) {
                return true;
            }
        }
        if (!this.getCoverInfoAtSide(side).isGUIClickable()) {
            return false;
        }
        try {
            if (!aPlayer.func_70093_af() && this.hasValidMetaTileEntity()) {
                boolean handled = this.mMetaTileEntity.onRightclick(this, aPlayer, side, aX, aY, aZ);
                if (handled) {
                    this.mMetaTileEntity.func_70296_d();
                }
                return handled;
            }
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("Encountered Exception while right clicking TileEntity", e);
        }
        return false;
    }

    @Override
    public void onLeftclick(EntityPlayer aPlayer) {
        try {
            if (aPlayer != null && this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.onLeftclick(this, aPlayer);
            }
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("Encountered Exception while left clicking TileEntity", e);
        }
    }

    @Override
    public boolean isDigitalChest() {
        return false;
    }

    @Override
    public ItemStack[] getStoredItemData() {
        return null;
    }

    @Override
    public void setItemCount(int aCount) {
    }

    @Override
    public int getMaxItemCount() {
        return 0;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mMetaTileEntity.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int ordinalSide) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(ForgeDirection.getOrientation((int)ordinalSide));
        if (this.canAccessData() && (coverInfo.letsItemsOut(-1) || coverInfo.letsItemsIn(-1))) {
            return this.mMetaTileEntity.func_94128_d(ordinalSide);
        }
        return GT_Values.emptyIntArray;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.canAccessData() && this.getCoverInfoAtSide(ForgeDirection.getOrientation((int)ordinalSide)).letsItemsIn(aIndex) && this.mMetaTileEntity.func_102007_a(aIndex, aStack, ordinalSide);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        return this.canAccessData() && this.getCoverBehaviorAtSideNew(side).letsItemsOut(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), aIndex, this) && this.mMetaTileEntity.func_102008_b(aIndex, aStack, ordinalSide);
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isSteamEngineUpgradable() {
        return this.isUpgradable() && !this.hasSteamEngineUpgrade() && this.getSteamCapacity() > 0L;
    }

    @Override
    public boolean addSteamEngineUpgrade() {
        if (this.isSteamEngineUpgradable()) {
            this.issueBlockUpdate();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSteamEngineUpgrade() {
        return false;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
    }

    @Override
    public int getErrorDisplayID() {
        return 0;
    }

    @Override
    public void setErrorDisplayID(int aErrorID) {
    }

    @Override
    public IMetaTileEntity getMetaTileEntity() {
        return this.hasValidMetaTileEntity() ? this.mMetaTileEntity : null;
    }

    @Override
    public void setMetaTileEntity(IMetaTileEntity aMetaTileEntity) {
        this.mMetaTileEntity = (MetaPipeEntity)aMetaTileEntity;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    @Override
    public long getAverageElectricInput() {
        return 0L;
    }

    @Override
    public long getAverageElectricOutput() {
        return 0L;
    }

    @Override
    public String getOwnerName() {
        return "Player";
    }

    @Override
    public String setOwnerName(String aName) {
        return "Player";
    }

    @Override
    public UUID getOwnerUuid() {
        return GT_Utility.defaultUuid;
    }

    @Override
    public void setOwnerUuid(UUID uuid) {
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(side) : (byte)0;
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mMetaTileEntity.func_70298_a(aIndex, aAmount);
        }
        return null;
    }

    @Override
    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.injectEnergyUnits(side, aVoltage, aAmperage);
        }
        return 0L;
    }

    @Override
    public boolean drainEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return false;
    }

    @Override
    public boolean acceptsRotationalEnergy(ForgeDirection side) {
        if (!this.canAccessData() || this.getCoverIDAtSide(side) != 0) {
            return false;
        }
        return this.mMetaTileEntity.acceptsRotationalEnergy(side);
    }

    @Override
    public boolean injectRotationalEnergy(ForgeDirection side, long aSpeed, long aEnergy) {
        if (!this.canAccessData() || this.getCoverIDAtSide(side) != 0) {
            return false;
        }
        return this.mMetaTileEntity.injectRotationalEnergy(side, aSpeed, aEnergy);
    }

    private boolean canMoveFluidOnSide(ForgeDirection side, Fluid fluid, boolean isFill) {
        if (side == ForgeDirection.UNKNOWN) {
            return true;
        }
        IFluidHandler tTileEntity = this.getITankContainerAtSide(side);
        if (tTileEntity != null && !this.mMetaTileEntity.isConnectedAtSide(side)) {
            return false;
        }
        if (isFill && this.mMetaTileEntity.isLiquidInput(side) && this.getCoverInfoAtSide(side).letsFluidIn(fluid)) {
            return true;
        }
        return !isFill && this.mMetaTileEntity.isLiquidOutput(side) && this.getCoverInfoAtSide(side).letsFluidOut(fluid);
    }

    public int fill(ForgeDirection side, FluidStack aFluidStack, boolean doFill) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, aFluidStack == null ? null : aFluidStack.getFluid(), true)) {
            return this.mMetaTileEntity.fill(side, aFluidStack, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection side, int maxDrain, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, this.mMetaTileEntity.getFluid() == null ? null : this.mMetaTileEntity.getFluid().getFluid(), false)) {
            return this.mMetaTileEntity.drain(side, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection side, FluidStack aFluidStack, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, aFluidStack == null ? null : aFluidStack.getFluid(), false)) {
            return this.mMetaTileEntity.drain(side, aFluidStack, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection side, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, aFluid, true)) {
            return this.mMetaTileEntity.canFill(side, aFluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection side, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(side, aFluid, false)) {
            return this.mMetaTileEntity.canDrain(side, aFluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (this.canAccessData() && (side == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput(side) && coverInfo.letsFluidIn(null) || this.mMetaTileEntity.isLiquidOutput(side) && coverInfo.letsFluidOut(null))) {
            return this.mMetaTileEntity.getTankInfo(side);
        }
        return new FluidTankInfo[0];
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack tStack = this.func_70301_a(aIndex);
        if (GT_Utility.isStackInvalid(tStack)) {
            this.func_70299_a(aIndex, aStack);
            return true;
        }
        if (GT_Utility.areStacksEqual(tStack, aStack = GT_OreDictUnificator.get(aStack)) && tStack.field_77994_a + aStack.field_77994_a <= Math.min(aStack.func_77976_d(), this.func_70297_j_())) {
            this.func_70296_d();
            tStack.field_77994_a += aStack.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GT_Utility.copyAmount(aAmount, aStack));
    }

    @Override
    public byte getColorization() {
        return (byte)(this.mColor - 1);
    }

    @Override
    public byte setColorization(byte aColor) {
        if (aColor > 15 || aColor < -1) {
            aColor = (byte)-1;
        }
        this.mColor = (byte)(aColor + 1);
        if (this.canAccessData()) {
            this.mMetaTileEntity.onColorChangeServer(aColor);
        }
        return this.mColor;
    }

    @Override
    public float getThickNess() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getThickNess();
        }
        return 1.0f;
    }

    public boolean renderInside(ForgeDirection side) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.renderInside(side);
        }
        return false;
    }

    @Override
    public float getBlastResistance(ForgeDirection side) {
        return this.canAccessData() ? Math.max(0.0f, this.getMetaTileEntity().getExplosionResistance(side)) : 5.0f;
    }

    @Override
    public void onBlockDestroyed() {
        if (this.canAccessData()) {
            this.getMetaTileEntity().onBlockDestroyed();
        }
    }

    @Override
    public boolean isMufflerUpgradable() {
        return false;
    }

    @Override
    public boolean addMufflerUpgrade() {
        return false;
    }

    @Override
    public boolean hasMufflerUpgrade() {
        return false;
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return this.getUniversalEnergyStored() >= aEnergyAmount;
    }

    @Override
    public String[] getInfoData() {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().getInfoData();
        }
        return new String[0];
    }

    @Override
    public byte getConnections() {
        return this.mConnections;
    }

    public void onNeighborBlockChange(int aX, int aY, int aZ) {
        IMetaTileEntity meta;
        if (this.canAccessData() && (meta = this.getMetaTileEntity()) instanceof MetaPipeEntity) {
            ((MetaPipeEntity)meta).setCheckConnections();
        }
    }

    @Override
    public int getLightOpacity() {
        return this.mMetaTileEntity == null ? 0 : this.mMetaTileEntity.getLightOpacity();
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        this.mMetaTileEntity.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return this.mMetaTileEntity.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
        this.mMetaTileEntity.onEntityCollidedWithBlock(aWorld, aX, aY, aZ, collider);
    }

    @Override
    public int[] getTimeStatistics() {
        return this.mTimeStatistics;
    }

    @Override
    public void startTimeStatistics() {
        this.hasTimeStatisticsStarted = true;
    }
}

