/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.IConfigElement;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Mods;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GT_GUI_ClientConfig
extends GuiConfig {
    public GT_GUI_ClientConfig(GuiScreen parentScreen) {
        super(parentScreen, GT_GUI_ClientConfig.getConfigElements(), Mods.GregTech.ID, "client", false, false, GT_GUI_ClientConfig.getAbridgedConfigPath((String)GregTech_API.sClientDataFile.mConfig.toString()));
    }

    private static List<IConfigElement> getConfigElements() {
        Configuration config = GregTech_API.sClientDataFile.mConfig;
        GT_GUI_ClientConfig.setLanguageKeys(config);
        return config.getCategoryNames().stream().filter(name -> name.indexOf(46) == -1).map(name -> new ConfigElement(config.getCategory(name))).collect(Collectors.toList());
    }

    private static void setLanguageKeys(Configuration config) {
        for (String categoryName : config.getCategoryNames()) {
            ConfigCategory category = config.getCategory(categoryName);
            category.setLanguageKey("GT5U.config." + categoryName);
            for (Map.Entry entry : category.entrySet()) {
                String realName;
                String name = (String)entry.getKey();
                int defaultStart = name.lastIndexOf(95);
                String string = realName = defaultStart >= 0 ? name.substring(0, defaultStart) : name;
                if (categoryName.equals("nei.recipe_categories")) {
                    ((Property)entry.getValue()).setLanguageKey(name);
                    continue;
                }
                ((Property)entry.getValue()).setLanguageKey(String.format("%s.%s", category.getLanguagekey(), realName));
            }
        }
    }
}

