/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_RenderingWorld;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.CoverInfo;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_Cover_FacadeBase
extends GT_CoverBehaviorBase<FacadeData> {
    public GT_Cover_FacadeBase() {
        super(FacadeData.class);
    }

    @Override
    public boolean isSimpleCover() {
        return true;
    }

    @Override
    public FacadeData createDataObject(int aLegacyData) {
        return new FacadeData();
    }

    @Override
    public FacadeData createDataObject() {
        return new FacadeData();
    }

    @Override
    protected FacadeData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable.mFlags = aCoverVariable.mFlags + 1 & 0xF;
        GT_Utility.sendChatToPlayer(aPlayer, ((aCoverVariable.mFlags & 1) != 0 ? GT_Utility.trans("128.1", "Redstone ") : "") + ((aCoverVariable.mFlags & 2) != 0 ? GT_Utility.trans("129.1", "Energy ") : "") + ((aCoverVariable.mFlags & 4) != 0 ? GT_Utility.trans("130.1", "Fluids ") : "") + ((aCoverVariable.mFlags & 8) != 0 ? GT_Utility.trans("131.1", "Items ") : ""));
        return aCoverVariable;
    }

    @Override
    protected boolean letsRedstoneGoInImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 1) != 0;
    }

    @Override
    protected boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 1) != 0;
    }

    @Override
    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 2) != 0;
    }

    @Override
    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 2) != 0;
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 4) != 0;
    }

    @Override
    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 4) != 0;
    }

    @Override
    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 8) != 0;
    }

    @Override
    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return (aCoverVariable.mFlags & 8) != 0;
    }

    @Override
    public void placeCover(ForgeDirection side, ItemStack aCover, ICoverable aTileEntity) {
        aTileEntity.setCoverIdAndDataAtSide(side, GT_Utility.stackToInt(aCover), new FacadeData(GT_Utility.copyAmount(1, aCover), 0));
        if (aTileEntity.isClientSide()) {
            GT_RenderingWorld.getInstance().register(aTileEntity.getXCoord(), aTileEntity.getYCoord(), aTileEntity.getZCoord(), this.getTargetBlock(aCover), this.getTargetMeta(aCover));
        }
    }

    @Override
    protected ItemStack getDropImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return aCoverVariable.mStack;
    }

    @Override
    protected ITexture getSpecialCoverFGTextureImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverTextureImpl(side, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    protected ITexture getSpecialCoverTextureImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (GT_Utility.isStackInvalid(aCoverVariable.mStack)) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        Block block = this.getTargetBlock(aCoverVariable.mStack);
        if (block == null) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        if (block.func_149701_w() != 0) {
            return Textures.BlockIcons.ERROR_RENDERING[0];
        }
        return TextureFactory.builder().setFromBlock(block, this.getTargetMeta(aCoverVariable.mStack)).useWorldCoord().setFromSide(side).build();
    }

    @Override
    protected Block getFacadeBlockImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (GT_Utility.isStackInvalid(aCoverVariable.mStack)) {
            return null;
        }
        return this.getTargetBlock(aCoverVariable.mStack);
    }

    @Override
    protected int getFacadeMetaImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (GT_Utility.isStackInvalid(aCoverVariable.mStack)) {
            return 0;
        }
        return this.getTargetMeta(aCoverVariable.mStack);
    }

    protected abstract Block getTargetBlock(ItemStack var1);

    protected abstract int getTargetMeta(ItemStack var1);

    @Override
    protected boolean isDataNeededOnClientImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected void onDataChangedImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (aTileEntity.isClientSide()) {
            GT_RenderingWorld.getInstance().register(aTileEntity.getXCoord(), aTileEntity.getYCoord(), aTileEntity.getZCoord(), this.getTargetBlock(aCoverVariable.mStack), this.getTargetMeta(aCoverVariable.mStack));
        }
    }

    @Override
    protected void onDroppedImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity) {
        if (aTileEntity.isClientSide()) {
            for (ForgeDirection iSide : ForgeDirection.VALID_DIRECTIONS) {
                if (iSide == side || !(aTileEntity.getCoverBehaviorAtSideNew(iSide) instanceof GT_Cover_FacadeBase)) continue;
                return;
            }
            if (aCoverVariable.mStack != null) {
                GT_RenderingWorld.getInstance().unregister(aTileEntity.getXCoord(), aTileEntity.getYCoord(), aTileEntity.getZCoord(), this.getTargetBlock(aCoverVariable.mStack), this.getTargetMeta(aCoverVariable.mStack));
            }
        }
    }

    @Override
    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, FacadeData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aTileEntity.issueCoverUpdate(side);
        return super.onCoverRightClickImpl(side, aCoverID, aCoverVariable, aTileEntity, aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean isCoverPlaceable(ForgeDirection side, ItemStack aStack, ICoverable aTileEntity) {
        if (!super.isCoverPlaceable(side, aStack, aTileEntity)) {
            return false;
        }
        Block targetBlock = this.getTargetBlock(aStack);
        if (targetBlock == null) {
            return false;
        }
        for (ForgeDirection iSide : ForgeDirection.VALID_DIRECTIONS) {
            Block facadeBlock;
            CoverInfo coverInfo;
            if (iSide == side || !(coverInfo = aTileEntity.getCoverInfoAtSide(iSide)).isValid() || (facadeBlock = coverInfo.getFacadeBlock()) == null) continue;
            if (facadeBlock != targetBlock) {
                return false;
            }
            if (coverInfo.getFacadeMeta() == this.getTargetMeta(aStack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new FacadeBaseUIFactory(buildContext).createWindow();
    }

    public static class FacadeData
    implements ISerializableObject {
        ItemStack mStack;
        int mFlags;

        public FacadeData() {
        }

        public FacadeData(ItemStack mStack, int mFlags) {
            this.mStack = mStack;
            this.mFlags = mFlags;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FacadeData(this.mStack, this.mFlags);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.mStack != null) {
                tag.func_74782_a("mStack", (NBTBase)this.mStack.func_77955_b(new NBTTagCompound()));
            }
            tag.func_74774_a("mFlags", (byte)this.mFlags);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            ByteBufUtils.writeItemStack((ByteBuf)aBuf, (ItemStack)this.mStack);
            aBuf.writeByte(this.mFlags);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.mStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("mStack"));
            this.mFlags = tag.func_74771_c("mFlags");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.mStack = ISerializableObject.readItemStackFromGreggyByteBuf(aBuf);
            this.mFlags = aBuf.readByte();
            return this;
        }
    }

    private class FacadeBaseUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public FacadeBaseUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_FacadeBase.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<FacadeData>(this::getCoverData, this::setCoverData, GT_Cover_FacadeBase.this, this::isEnabled, (id, coverData) -> {
                coverData.mFlags = this.getNewCoverVariable((int)id, (FacadeData)coverData);
                return coverData;
            }).addToggleButton(0, CoverDataFollower_ToggleButtonWidget.ofCheckAndCross(), widget -> widget.setPos(0, 0)).addToggleButton(1, CoverDataFollower_ToggleButtonWidget.ofCheckAndCross(), widget -> widget.setPos(0, 18)).addToggleButton(2, CoverDataFollower_ToggleButtonWidget.ofCheckAndCross(), widget -> widget.setPos(0, 36)).addToggleButton(3, CoverDataFollower_ToggleButtonWidget.ofCheckAndCross(), widget -> widget.setPos(0, 54)).setPos(10, 25))).widget(new ItemDrawable(() -> this.getCoverData() != null ? ((FacadeData)this.getCoverData()).mStack : null).asWidget().setPos(5, 5).setSize(16, 16))).widget(TextWidget.dynamicString(() -> this.getCoverData() != null ? ((FacadeData)this.getCoverData()).mStack.func_82833_r() : "").setSynced(false).setDefaultColor(((Integer)this.COLOR_TITLE.get()).intValue()).setPos(25, 9))).widget(new TextWidget(GT_Utility.trans("128", "Redstone")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(31, 29))).widget(new TextWidget(GT_Utility.trans("129", "Energy")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(31, 47))).widget(new TextWidget(GT_Utility.trans("130", "Fluids")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(31, 65))).widget(new TextWidget(GT_Utility.trans("131", "Items")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(31, 83));
        }

        @Override
        protected void addTitleToUI(ModularWindow.Builder builder) {
        }

        private int getNewCoverVariable(int id, FacadeData coverVariable) {
            int n;
            switch (id) {
                case 0: {
                    n = coverVariable.mFlags ^ 1;
                    break;
                }
                case 1: {
                    n = coverVariable.mFlags ^ 2;
                    break;
                }
                case 2: {
                    n = coverVariable.mFlags ^ 4;
                    break;
                }
                case 3: {
                    n = coverVariable.mFlags ^ 8;
                    break;
                }
                default: {
                    n = coverVariable.mFlags;
                }
            }
            return n;
        }

        private boolean isEnabled(int id, FacadeData coverVariable) {
            boolean bl;
            switch (id) {
                case 0: {
                    if ((coverVariable.mFlags & 1) > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    if ((coverVariable.mFlags & 2) > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if ((coverVariable.mFlags & 4) > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if ((coverVariable.mFlags & 8) > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }
}

