/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.redstonecircuits;

import gregtech.api.interfaces.IRedstoneCircuitBlock;
import gregtech.api.util.GT_CircuitryBehavior;

public class GT_Circuit_Pulser
extends GT_CircuitryBehavior {
    public GT_Circuit_Pulser(int aIndex) {
        super(aIndex);
    }

    @Override
    public void initParameters(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        aCircuitData[0] = 1;
        aCircuitData[1] = 16;
        aCircuitData[4] = 0;
    }

    @Override
    public void validateParameters(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        if (aCircuitData[0] < 1) {
            aCircuitData[0] = 1;
        }
        if (aCircuitData[1] < 0) {
            aCircuitData[1] = 0;
        }
        if (aCircuitData[1] > 16) {
            aCircuitData[1] = 16;
        }
        if (aCircuitData[4] < 0) {
            aCircuitData[4] = 0;
        }
    }

    @Override
    public void onTick(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        byte redstoneSignal;
        byte by = redstoneSignal = aCircuitData[1] == 0 ? GT_Circuit_Pulser.getWeakestNonZeroRedstone(aRedstoneCircuitBlock) : GT_Circuit_Pulser.getStrongestRedstone(aRedstoneCircuitBlock);
        if (aCircuitData[4] == 0) {
            aCircuitData[5] = redstoneSignal;
        }
        if (redstoneSignal > 0 || aCircuitData[4] > 0) {
            int index = 4;
            int tmp42_41 = aCircuitData[index];
            aCircuitData[index] = tmp42_41 + 1;
            if (tmp42_41 >= aCircuitData[0] && redstoneSignal <= 0) {
                aCircuitData[4] = 0;
            }
        }
        aRedstoneCircuitBlock.setRedstone(aCircuitData[4] > 0 && aCircuitData[4] <= aCircuitData[0] ? (byte)aCircuitData[1] : (aCircuitData[1] <= 0 || aCircuitData[1] > 15 ? (byte)aCircuitData[5] : (byte)0), aRedstoneCircuitBlock.getOutputFacing());
    }

    @Override
    public String getName() {
        return "Pulser";
    }

    @Override
    public String getDescription() {
        return "Limits&Enlengths";
    }

    @Override
    public String getDataDescription(int[] aCircuitData, int aCircuitDataIndex) {
        String string;
        switch (aCircuitDataIndex) {
            case 0: {
                string = "Length";
                break;
            }
            case 1: {
                string = "RS Out";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public boolean displayItemStack(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock, int aIndex) {
        return false;
    }

    @Override
    public String getDataDisplay(int[] aCircuitData, int aCircuitDataIndex) {
        if (aCircuitDataIndex == 1) {
            if (aCircuitData[aCircuitDataIndex] == 16) {
                return "HIGHEST";
            }
            if (aCircuitData[aCircuitDataIndex] == 0) {
                return "LOWEST";
            }
        }
        return aCircuitDataIndex > 1 ? "" : null;
    }
}

