/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei.formatter;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FusionSpecialValueFormatter
implements INEISpecialInfoFormatter {
    public static final FusionSpecialValueFormatter INSTANCE = new FusionSpecialValueFormatter();
    private static final long M = 1000000L;

    @Override
    public List<String> format(RecipeDisplayInfo recipeInfo) {
        int euToStart = recipeInfo.recipe.mSpecialValue;
        int voltage = recipeInfo.recipe.mEUt;
        int tier = FusionSpecialValueFormatter.getFusionTier(euToStart, voltage);
        return Collections.singletonList(StatCollector.func_74837_a((String)"GT5U.nei.start_eu", (Object[])new Object[]{GT_Utility.formatNumbers(euToStart), tier}));
    }

    public static int getFusionTier(long startupPower, long voltage) {
        int tier = startupPower <= 160000000L ? 1 : (startupPower <= 320000000L ? 2 : (startupPower <= 640000000L ? 3 : (startupPower <= 5120000000L ? 4 : 5)));
        if (voltage > GT_Values.V[6]) {
            tier = voltage <= GT_Values.V[7] ? Math.max(tier, 2) : (voltage <= GT_Values.V[8] ? Math.max(tier, 3) : (voltage <= GT_Values.V[9] ? Math.max(tier, 4) : 5));
        }
        return tier;
    }
}

