/*
 * Decompiled with CFR 0.152.
 */
package net.glease.ggfab.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GGMetaItem_DumbItems
extends GT_MetaBase_Item {
    public static final int MAX_ID = 32766;
    private final BitSet mEnabledItems = new BitSet();
    private final BitSet mVisibleItems = new BitSet();
    private final ArrayList<IIcon> mIconList = new ArrayList();
    private final TIntObjectMap<IItemContainer> mIconOverride = new TIntObjectHashMap();

    public GGMetaItem_DumbItems(String aUnlocalized) {
        super(aUnlocalized);
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aID < 0 || aID > 32766) {
            return null;
        }
        if (aToolTip == null) {
            aToolTip = "";
        }
        ItemStack rStack = new ItemStack((Item)this, 1, aID);
        this.mEnabledItems.set(aID);
        this.mVisibleItems.set(aID);
        GT_LanguageManager.addStringLocalization((String)(this.func_77667_c(rStack) + ".name"), (String)aEnglish);
        GT_LanguageManager.addStringLocalization((String)(this.func_77667_c(rStack) + ".tooltip"), (String)aToolTip);
        ArrayList tAspects = new ArrayList();
        for (Object tRandomData : aRandomData) {
            if (!(tRandomData instanceof SubTag)) continue;
            if (tRandomData == SubTag.INVISIBLE) {
                this.mVisibleItems.set(aID, false);
                continue;
            }
            if (tRandomData != SubTag.NO_UNIFICATION) continue;
            GT_OreDictUnificator.addToBlacklist((ItemStack)rStack);
        }
        for (Object tRandomData : aRandomData) {
            if (tRandomData == null) continue;
            boolean tUseOreDict = true;
            if (tRandomData instanceof IItemBehaviour) {
                IItemBehaviour behavior = (IItemBehaviour)tRandomData;
                this.addItemBehavior(aID, behavior);
                tUseOreDict = false;
            }
            if (tRandomData instanceof IItemContainer) {
                ((IItemContainer)tRandomData).set(rStack);
                tUseOreDict = false;
            }
            if (tRandomData instanceof SubTag) continue;
            if (tRandomData instanceof IItemContainer) {
                this.mIconOverride.put(aID, (Object)((IItemContainer)tRandomData));
                continue;
            }
            if (tRandomData instanceof TC_Aspects.TC_AspectStack) {
                ((TC_Aspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                continue;
            }
            if (tRandomData instanceof ItemData) {
                if (GT_Utility.isStringValid((Object)tRandomData)) {
                    GT_OreDictUnificator.registerOre((Object)tRandomData, (ItemStack)rStack);
                    continue;
                }
                GT_OreDictUnificator.addItemData((ItemStack)rStack, (ItemData)((ItemData)tRandomData));
                continue;
            }
            if (!tUseOreDict) continue;
            GT_OreDictUnificator.registerOre((Object)tRandomData, (ItemStack)rStack);
        }
        if (GregTech_API.sThaumcraftCompat != null) {
            GregTech_API.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
        }
        return rStack;
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_94581_a(IIconRegister aIconRegister) {
        short j = (short)this.mEnabledItems.length();
        this.mIconList.clear();
        this.mIconList.ensureCapacity(j);
        for (short i = 0; i < j; i = (short)(i + 1)) {
            if (this.mEnabledItems.get(i)) {
                this.mIconList.add(aIconRegister.func_94245_a("ggfab:" + this.func_77658_a() + "/" + i));
                continue;
            }
            this.mIconList.add(null);
        }
    }

    public IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0 || aMetaData >= this.mIconList.size() || this.mIconList.get(aMetaData) == null) {
            return super.func_77617_a(aMetaData);
        }
        return this.mIconList.get(aMetaData);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List aList) {
        int j = this.mEnabledItems.length();
        for (int i = 0; i < j; ++i) {
            if (!this.mVisibleItems.get(i) && (!GT_Values.D1 || !this.mEnabledItems.get(i))) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    public Long[] getElectricStats(ItemStack aStack) {
        return null;
    }

    public Long[] getFluidContainerStats(ItemStack aStack) {
        return null;
    }
}

