/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.processor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.processor.GregTech5RecipeProcessor;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class GTPPRecipeProcessor
implements IRecipeProcessor {
    private final boolean isNH;

    public GTPPRecipeProcessor(boolean isNH) {
        this.isNH = isNH;
    }

    @Override
    @Nonnull
    public Set<String> getAllOverlayIdentifier() {
        HashSet<String> identifiers = new HashSet<String>();
        identifiers.add("GTPP_Decayables");
        if (this.isNH) {
            return identifiers;
        }
        try {
            Class<?> gtRecipeMapClazz = Class.forName("gregtech.api.util.GT_Recipe$GT_Recipe_Map");
            Class<?> gtppRecipeMapClazz = Class.forName("gregtech.api.util.GTPP_Recipe$GTPP_Recipe_Map_Internal");
            Collection sMappingsEx = (Collection)gtppRecipeMapClazz.getDeclaredField("sMappingsEx").get(null);
            for (Object gtppMap : sMappingsEx) {
                boolean mNEIAllowed = gtRecipeMapClazz.getDeclaredField("mNEIAllowed").getBoolean(gtppMap);
                if (!mNEIAllowed) continue;
                String mNEIName = (String)gtRecipeMapClazz.getDeclaredField("mNEIName").get(gtppMap);
                identifiers.add(mNEIName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return identifiers;
    }

    @Override
    @Nonnull
    public String getRecipeProcessorId() {
        return "GT++";
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeInput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeInputs = new ArrayList<PositionedStack>();
        if (this.getAllOverlayIdentifier().contains(identifier)) {
            recipeInputs.addAll(recipe.getIngredientStacks(recipeIndex));
            recipeInputs.removeIf(positionedStack -> GregTech5RecipeProcessor.getFluidFromDisplayStack(positionedStack.items[0]) != null || positionedStack.item.field_77994_a == 0);
            return recipeInputs;
        }
        return recipeInputs;
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeOutput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeOutputs = new ArrayList<PositionedStack>();
        if (this.getAllOverlayIdentifier().contains(identifier)) {
            recipeOutputs.addAll(recipe.getOtherStacks(recipeIndex));
            recipeOutputs.removeIf(positionedStack -> GregTech5RecipeProcessor.getFluidFromDisplayStack(positionedStack.items[0]) != null);
            return recipeOutputs;
        }
        return recipeOutputs;
    }
}

