/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.recipe;

import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBuilder;
import gregtech.api.recipe.maps.FluidOnlyFrontend;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.recipe.maps.LargeNEIFrontend;
import gregtech.api.util.GT_Utility;
import gregtech.nei.formatter.FuelSpecialValueFormatter;
import gregtech.nei.formatter.HeatingCoilSpecialValueFormatter;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import gregtech.nei.formatter.SimpleSpecialValueFormatter;
import gtPlusPlus.api.recipe.ChemicalPlantFrontend;
import gtPlusPlus.api.recipe.MillingFrontend;
import gtPlusPlus.api.recipe.TGSFrontend;
import gtPlusPlus.api.recipe.ThermalBoilerFrontend;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.GregtechMetaTileEntityTreeFarm;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.util.StatCollector;

public class GTPPRecipeMaps {
    public static final RecipeMap<RecipeMapBackend> cokeOvenRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.cokeoven").maxIO(2, 9, 1, 1).minInputs(1, 0).progressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN).build();
    public static final RecipeMap<RecipeMapBackend> multiblockMassFabricatorRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.matterfab2").maxIO(2, 0, 1, 1).build();
    public static final RecipeMap<FuelBackend> rocketFuels = RecipeMapBuilder.of((String)"gtpp.recipe.rocketenginefuel", FuelBackend::new).maxIO(0, 0, 1, 0).neiSpecialInfoFormatter(recipeInfo -> Collections.singletonList(StatCollector.func_74837_a((String)"GT5U.nei.fuel", (Object[])new Object[]{GT_Utility.formatNumbers((long)((long)recipeInfo.recipe.mSpecialValue * 3000L))}))).build();
    public static final RecipeMap<RecipeMapBackend> quantumForceTransformerRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.quantumforcesmelter").maxIO(6, 6, 6, 6).minInputs(1, 0).progressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE).neiSpecialInfoFormatter((INEISpecialInfoFormatter)new SimpleSpecialValueFormatter("GT5U.nei.tier")).frontend(LargeNEIFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> chemicalDehydratorRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.chemicaldehydrator").maxIO(2, 9, 1, 1).progressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN).build();
    public static final RecipeMap<RecipeMapBackend> vacuumFurnaceRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.vacfurnace").maxIO(9, 9, 3, 3).minInputs(1, 0).neiSpecialInfoFormatter((INEISpecialInfoFormatter)HeatingCoilSpecialValueFormatter.INSTANCE).frontend(LargeNEIFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> alloyBlastSmelterRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.alloyblastsmelter").maxIO(9, 9, 3, 3).minInputs(1, 0).frontend(LargeNEIFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> liquidFluorineThoriumReactorRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.lftr").maxIO(0, 0, 6, 6).minInputs(0, 2).frontend(FluidOnlyFrontend::new).neiSpecialInfoFormatter(recipeInfo -> {
        long eut = recipeInfo.recipe.mSpecialValue;
        int duration = recipeInfo.recipe.mDuration;
        return Arrays.asList(StatCollector.func_74837_a((String)"gtpp.nei.lftr.power", (Object[])new Object[]{GT_Utility.formatNumbers((long)eut)}), StatCollector.func_74837_a((String)"gtpp.nei.lftr.dynamo", (Object[])new Object[]{MathUtils.formatNumbers((long)duration * eut)}), StatCollector.func_74837_a((String)"gtpp.nei.lftr.total", (Object[])new Object[]{MathUtils.formatNumbers((long)duration * eut * 4L)}));
    }).build();
    public static final RecipeMap<RecipeMapBackend> nuclearSaltProcessingPlantRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.nuclearsaltprocessingplant").maxIO(1, 6, 2, 3).frontend(LargeNEIFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> millingRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.oremill").maxIO(3, 1, 0, 0).minInputs(1, 0).frontend(MillingFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> fissionFuelProcessingRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.fissionfuel").maxIO(0, 0, 6, 1).frontend(FluidOnlyFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> coldTrapRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.coldtrap").maxIO(2, 9, 1, 1).progressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN).build();
    public static final RecipeMap<RecipeMapBackend> reactorProcessingUnitRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.reactorprocessingunit").maxIO(2, 9, 1, 1).progressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN).build();
    public static final RecipeMap<RecipeMapBackend> simpleWasherRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.simplewasher").maxIO(1, 1, 1, 0).slotOverlays((index, isFluid, isOutput, isSpecial) -> !isFluid && !isOutput ? GT_UITextures.OVERLAY_SLOT_CAULDRON : null).progressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE).build();
    public static final RecipeMap<RecipeMapBackend> molecularTransformerRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.moleculartransformer").maxIO(1, 1, 0, 0).slotOverlays((index, isFluid, isOutput, isSpecial) -> !isFluid && !isOutput ? GT_UITextures.OVERLAY_SLOT_MICROSCOPE : null).neiHandlerInfo(builder -> builder.setDisplayStack(ItemUtils.getItemStackFromFQRN("AdvancedSolarPanel:BlockMolecularTransformer", 1))).build();
    public static final RecipeMap<RecipeMapBackend> chemicalPlantRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.fluidchemicaleactor").maxIO(4, 6, 4, 3).slotOverlays((index, isFluid, isOutput, isSpecial) -> {
        if (isFluid) {
            if (isOutput) {
                return GT_UITextures.OVERLAY_SLOT_VIAL_2;
            }
            return GT_UITextures.OVERLAY_SLOT_MOLECULAR_3;
        }
        if (isOutput) {
            return GT_UITextures.OVERLAY_SLOT_VIAL_1;
        }
        return GT_UITextures.OVERLAY_SLOT_MOLECULAR_1;
    }).progressBar(GTPP_UITextures.PROGRESSBAR_FLUID_REACTOR, ProgressBar.Direction.CIRCULAR_CW).progressBarPos(82, 24).neiSpecialInfoFormatter(recipeInfo -> {
        int tier = recipeInfo.recipe.mSpecialValue + 1;
        String materialName = StatCollector.func_74838_a((String)("gtpp.nei.chemplant.tier." + tier));
        return Collections.singletonList(StatCollector.func_74837_a((String)"GT5U.nei.tier", (Object[])new Object[]{tier + " - " + materialName}));
    }).frontend(ChemicalPlantFrontend::new).build();
    public static final RecipeMap<FuelBackend> rtgFuels = RecipeMapBuilder.of((String)"gtpp.recipe.RTGgenerators", FuelBackend::new).maxIO(1, 0, 0, 0).neiSpecialInfoFormatter((INEISpecialInfoFormatter)new SimpleSpecialValueFormatter("gtpp.nei.rtg.days", 365)).build();
    public static final RecipeMap<RecipeMapBackend> thermalBoilerRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.thermalgeneratorfuel").maxIO(0, 9, 2, 3).frontend(ThermalBoilerFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> solarTowerRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.solartower").maxIO(0, 0, 1, 1).neiSpecialInfoFormatter(recipeInfo -> Arrays.asList(StatCollector.func_74838_a((String)"gtpp.nei.solar_tower.1"), StatCollector.func_74838_a((String)"gtpp.nei.solar_tower.2"), StatCollector.func_74838_a((String)"gtpp.nei.solar_tower.3"))).frontend(FluidOnlyFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> cyclotronRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.cyclotron").maxIO(9, 9, 1, 1).build();
    public static final RecipeMap<RecipeMapBackend> fishPondRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.fishpond").maxIO(1, 1, 0, 0).slotOverlays((index, isFluid, isOutput, isSpecial) -> !isFluid && !isOutput ? GT_UITextures.OVERLAY_SLOT_CAULDRON : null).progressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE).build();
    public static final RecipeMap<RecipeMapBackend> spargeTowerFakeRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.spargetower").maxIO(0, 0, 9, 9).disableRegisterNEI().build();
    public static final RecipeMap<RecipeMapBackend> advancedFreezerRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.cryogenicfreezer").maxIO(1, 1, 2, 1).build();
    public static final RecipeMap<RecipeMapBackend> centrifugeNonCellRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.multicentrifuge").maxIO(6, 6, 6, 6).progressBar(GT_UITextures.PROGRESSBAR_EXTRACT).frontend(LargeNEIFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> electrolyzerNonCellRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.multielectro").maxIO(6, 6, 6, 6).progressBar(GT_UITextures.PROGRESSBAR_EXTRACT).frontend(LargeNEIFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> mixerNonCellRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.multimixer").maxIO(9, 9, 6, 6).progressBar(GT_UITextures.PROGRESSBAR_MIXER, ProgressBar.Direction.CIRCULAR_CW).frontend(LargeNEIFrontend::new).build();
    public static final RecipeMap<RecipeMapBackend> chemicalDehydratorNonCellRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.multidehydrator").maxIO(6, 9, 3, 3).frontend(LargeNEIFrontend::new).build();
    public static final RecipeMap<FuelBackend> semiFluidFuels = RecipeMapBuilder.of((String)"gtpp.recipe.semifluidgeneratorfuels", FuelBackend::new).maxIO(0, 0, 1, 0).neiSpecialInfoFormatter((INEISpecialInfoFormatter)FuelSpecialValueFormatter.INSTANCE).build();
    public static final RecipeMap<RecipeMapBackend> flotationCellRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.flotationcell").maxIO(6, 0, 1, 1).build();
    public static final RecipeMap<RecipeMapBackend> treeGrowthSimulatorFakeRecipes = RecipeMapBuilder.of((String)"gtpp.recipe.treefarm").maxIO(GregtechMetaTileEntityTreeFarm.Mode.values().length, GregtechMetaTileEntityTreeFarm.Mode.values().length, 0, 0).minInputs(1, 0).useSpecialSlot().frontend(TGSFrontend::new).build();
}

