/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GT4Entity_ThermalBoiler
extends GregtechMeta_MultiBlockBase<GT4Entity_ThermalBoiler>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<GT4Entity_ThermalBoiler> STRUCTURE_DEFINITION = null;
    private static final int lavaFilterResilience = 30;
    private int dryHeatCounter = 0;
    private static final int dryHeatMaximum = 10;
    private static final Item itemLavaFilter = ItemList.Component_LavaFilter.getItem();
    private static final Item itemObsidian = Item.func_150898_a((Block)Blocks.field_150343_Z);
    private static final Fluid fluidWater = FluidRegistry.WATER;
    private static final Fluid fluidDistilledWater = FluidUtils.getDistilledWater(1).getFluid();
    private static final Fluid fluidSteam = FluidUtils.getSteam(1).getFluid();
    private static final Fluid fluidSHSteam = FluidUtils.getSuperHeatedSteam(1).getFluid();

    public GT4Entity_ThermalBoiler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT4Entity_ThermalBoiler(String mName) {
        super(mName);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT4Entity_ThermalBoiler(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Boiler";
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return aStack != null && aStack.func_77973_b() == itemLavaFilter ? 1 : 0;
    }

    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.thermalBoilerRecipes;
    }

    protected boolean filtersFluid() {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected Stream<GT_Recipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                if (this.lastRecipe != null && GT4Entity_ThermalBoiler.this.depleteInput(this.lastRecipe.mFluidInputs[0], true)) {
                    return Stream.of(this.lastRecipe);
                }
                if (map == null) {
                    return Stream.empty();
                }
                return map.getAllRecipes().stream().filter(recipe -> GT4Entity_ThermalBoiler.this.depleteInput(recipe.mFluidInputs[0], true));
            }

            @NotNull
            protected GT_ParallelHelper createParallelHelper(@Nonnull GT_Recipe recipe) {
                GT_Recipe adjustedRecipe = recipe.copy();
                for (FluidStack fluidStack : adjustedRecipe.mFluidInputs) {
                    if (fluidStack == null || fluidStack.getFluid() != fluidWater && fluidStack.getFluid() != fluidDistilledWater) continue;
                    fluidStack.amount = 0;
                }
                if (!GT4Entity_ThermalBoiler.this.findLavaFilter()) {
                    for (FluidStack fluidStack : adjustedRecipe.mOutputs) {
                        if (fluidStack == null || fluidStack.func_77973_b() == itemObsidian) continue;
                        fluidStack.field_77994_a = 0;
                    }
                }
                return super.createParallelHelper(adjustedRecipe);
            }
        };
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        int efficiency = this.mEfficiency;
        CheckRecipeResult result = super.checkProcessing();
        if (result.wasSuccessful()) {
            this.mEfficiency = efficiency;
            this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
            if (this.mOutputFluids != null) {
                for (FluidStack fluidStack : this.mOutputFluids) {
                    if (fluidStack == null || fluidStack.getFluid() != fluidSteam && fluidStack.getFluid() != fluidSHSteam) continue;
                    this.lEUt = fluidStack.getFluid() == fluidSteam ? (long)(fluidStack.amount / this.mMaxProgresstime / 2) : (long)(fluidStack.amount / this.mMaxProgresstime);
                    if (this.mEfficiency < this.getMaxEfficiency(null)) {
                        fluidStack.amount = Math.max(1, fluidStack.amount * this.mEfficiency / this.getMaxEfficiency(null));
                    }
                    if (this.useWater(fluidStack.amount)) continue;
                    fluidStack.amount = 0;
                    this.lEUt = 0L;
                }
            }
            if (this.mOutputItems != null && this.mOutputItems.length > 0 && !this.damageLavaFilter()) {
                for (FluidStack fluidStack : this.mOutputItems) {
                    if (fluidStack == null || fluidStack.func_77973_b() == itemObsidian) continue;
                    fluidStack.field_77994_a = 0;
                }
            }
        }
        return result;
    }

    private boolean findLavaFilter() {
        if (this.getControllerSlot() == null) {
            for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
                for (ItemStack stack : bus.mInventory) {
                    if (stack == null || stack.func_77973_b() != itemLavaFilter) continue;
                    this.setGUIItemStack(stack);
                    return true;
                }
            }
            return false;
        }
        return this.getControllerSlot().func_77973_b() == itemLavaFilter;
    }

    private boolean damageLavaFilter() {
        if (!this.findLavaFilter()) {
            return false;
        }
        if (this.getBaseMetaTileEntity().getRandomNumber(30) > 0) {
            return true;
        }
        ItemStack filter = this.getControllerSlot();
        if (filter.func_96631_a(1, this.getBaseMetaTileEntity().getWorld().field_73012_v)) {
            this.mInventory[1] = null;
        }
        return true;
    }

    private boolean useWater(int steamAmount) {
        int waterAmount = Math.floorDiv(steamAmount + 160 - 1, 160);
        if (this.depleteInput(FluidUtils.getWater(waterAmount)) || this.depleteInput(FluidUtils.getDistilledWater(waterAmount))) {
            this.dryHeatCounter = 0;
            return true;
        }
        if (this.dryHeatCounter < 10) {
            ++this.dryHeatCounter;
        } else {
            GT_Log.exp.println(this.mName + " was too hot and had no more Water!");
            this.explodeMultiblock();
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    public int getEfficiencyIncrease() {
        return 12;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiThermalBoiler;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Thermal Boiler Controller").addInfo("Converts Water & Heat into Steam").addInfo("Filters raw materials from lava").addInfo("Explodes if water is not supplied").addInfo("Consult user manual for more information").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin("Thermal Containment Casings", 10, false).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(1);
    }

    public IStructureDefinition<GT4Entity_ThermalBoiler> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT4Entity_ThermalBoiler.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.getIndexFromPage(0, 1)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)11))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }
}

