/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class GregtechMetaTileEntity_QuantumForceTransformer
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<GregtechMetaTileEntity_QuantumForceTransformer>
implements ISurvivalConstructable {
    private int mCasing;
    protected int mCraftingTier = 0;
    protected int mFocusingTier = 0;
    protected int mMaxParallel = 0;
    private boolean mFluidMode = false;
    private boolean doFermium = false;
    private boolean doNeptunium = false;
    private static final Fluid mNeptunium = ELEMENT.getInstance().NEPTUNIUM.getPlasma();
    private static final Fluid mFermium = ELEMENT.getInstance().FERMIUM.getPlasma();
    private static final String MAIN_PIECE = "main";
    private GT_MetaTileEntity_Hatch_Input mNeptuniumHatch;
    private GT_MetaTileEntity_Hatch_Input mFermiumHatch;
    private static final IStructureDefinition<GregtechMetaTileEntity_QuantumForceTransformer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "   BBBBABBBB   ", "   BAAAAAAAB   ", "   BABBABBAB   ", "   BA     AB   ", "    A     A    ", "    A     A    ", "    A     A    "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "   AAABBBAAA   ", "  BAAAAAAAAAB  ", "  B         B  ", "  A         A  ", "  A         A  ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "    AA   AA    ", "  AA       AA  ", " BAA       AAB ", " B           B ", " A           A ", " A           A ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "     BAAAB     ", "   AA     AA   ", " AA         AA ", "BAA         AAB", "B             B", "A             A", "A             A", "A             A", "A             A", "A             A"}, {"      TTT      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "      EEE      ", "      DDD      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "    BAEEEAB    ", "  AA  EEE  AA  ", " A    EEE    A ", "BA    DDD    AB", "B     EEE     B", "B     DDD     B", "      EEE      ", "      EEE      ", "      EEE      ", "      Z~X      "}, {"     TTTTT     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D   D     ", "     ECCCE     ", "     D   D     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D   D     ", "   BAECCCEAB   ", "  A  ECCCE  A  ", " A   ECCCE   A ", "BA   D   D   AB", "B    ECCCE    B", "B    D   D    B", "B    ECCCE    B", "     ECCCE     ", "     ECCCE     ", "     HHHHH     "}, {"    TTTTTTT    ", "    ECCCCCE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "  BAEC   CEAB  ", " B  EC   CE  B ", "BB  EC   CE  BB", "BA  D     D  AB", "A   EC   CE   A", "A   D     D   A", "A   EC   CE   A", "    EC   CE    ", "    EC   CE    ", "    HHHHHHH    "}, {"    TTTTTTT    ", "    ECCCCCE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "  AAEC   CEAA  ", " A  EC   CE  A ", "AB  EC   CE  BA", "AA  D     D  AA", "A   EC   CE   A", "A   D     D   A", "    EC   CE    ", "    EC   CE    ", "    EC   CE    ", "    HHHHHHH    "}, {"    TTTTTTT    ", "    ECCCCCE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "  BAEC   CEAB  ", " B  EC   CE  B ", "BB  EC   CE  BB", "BA  D     D  AB", "A   EC   CE   A", "A   D     D   A", "A   EC   CE   A", "    EC   CE    ", "    EC   CE    ", "    HHHHHHH    "}, {"     TTTTT     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D   D     ", "     ECCCE     ", "     D   D     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D   D     ", "   BAECCCEAB   ", "  A  ECCCE  A  ", " A   ECCCE   A ", "BA   D   D   AB", "B    ECCCE    B", "B    D   D    B", "B    ECCCE    B", "     ECCCE     ", "     ECCCE     ", "     HHHHH     "}, {"      TTT      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "      EEE      ", "      DDD      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "    BAEEEAB    ", "  AA  EEE  AA  ", " A    EEE    A ", "BA    DDD    AB", "B     EEE     B", "B     DDD     B", "      EEE      ", "      EEE      ", "      EEE      ", "      HHH      "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "     BAAAB     ", "   AA     AA   ", " AA         AA ", "BAA         AAB", "B             B", "A             A", "A             A", "A             A", "A             A", "A             A"}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "    AA   AA    ", "  AA       AA  ", " BAA       AAB ", " B           B ", " A           A ", " A           A ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "   AAABBBAAA   ", "  BAAAAAAAAAB  ", "  B         B  ", "  A         A  ", "  A         A  ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "   BBBBABBBB   ", "   BBBAAABBB   ", "   ABBAAABBA   ", "   A BA AB A   ", "      A A      ", "      A A      ", "      A A      "}}).addElement('A', StructureUtility.withChannel((String)"manipulator", (IStructureElement)StructureUtility.ofBlocksTiered(GregtechMetaTileEntity_QuantumForceTransformer.craftingTierConverter(), GregtechMetaTileEntity_QuantumForceTransformer.getAllCraftingTiers(), (Object)0, GregtechMetaTileEntity_QuantumForceTransformer::setCraftingTier, GregtechMetaTileEntity_QuantumForceTransformer::getCraftingTier))).addElement('B', StructureUtility.withChannel((String)"shielding", (IStructureElement)StructureUtility.ofBlocksTiered(GregtechMetaTileEntity_QuantumForceTransformer.focusingTierConverter(), GregtechMetaTileEntity_QuantumForceTransformer.getAllFocusingTiers(), (Object)0, GregtechMetaTileEntity_QuantumForceTransformer::setFocusingTier, GregtechMetaTileEntity_QuantumForceTransformer::getFocusingTier))).addElement('C', StructureUtility.ofBlock((Block)ModBlocks.blockCasings4Misc, (int)4)).addElement('D', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12)).addElement('E', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock1(), (int)t.getCasingMeta1()))).addElement('H', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_QuantumForceTransformer.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy.or((IHatchElement)GT_HatchElement.ExoticEnergy)}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(4).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).addElement('T', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_QuantumForceTransformer.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(5).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).addElement('Z', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_QuantumForceTransformer.class).hatchClass(GT_MetaTileEntity_Hatch_Input.class).adder(GregtechMetaTileEntity_QuantumForceTransformer::addNeptuniumHatch).casingIndex(TAE.getIndexFromPage(0, 10)).dot(5).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).addElement('X', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_QuantumForceTransformer.class).hatchClass(GT_MetaTileEntity_Hatch_Input.class).adder(GregtechMetaTileEntity_QuantumForceTransformer::addFermiumHatch).casingIndex(TAE.getIndexFromPage(0, 10)).dot(5).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).build();
    private byte runningTick = 0;

    public GregtechMetaTileEntity_QuantumForceTransformer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_QuantumForceTransformer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_QuantumForceTransformer(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Quantum Force Transformer").addInfo("Controller Block for the Quantum Force Transformer").addInfo("Allows Complex chemical lines to be performed instantly in one step").addInfo("Every recipe requires a catalyst, each catalyst adds 1 parallel and lasts forever").addInfo("Accepts TecTech Energy and Laser Hatches").addInfo("All inputs go on the bottom, all outputs go on the top").addInfo("Put a circuit in the controller to specify the focused output").addInfo("Check NEI to see the order of outputs, and which circuit number you need.").addInfo("If separate input busses are enabled put the circuit in the circuit slot of the bus").addInfo("Uses FocusTier*4*sqrt(parallels) Neptunium Plasma if focusing").addInfo("Can use FocusTier*4*sqrt(parallels) Fermium Plasma for additional chance output").addInfo("Use a screwdriver to enable Fluid mode").addInfo("Fluid mode turns all possible outputs into their fluid variant, those which can't are left as they were.").addInfo("This multi gets improved when all casings of some types are upgraded").addInfo("Casing functions:").addInfo("Pulse Manipulators: Recipe Tier Allowed (check NEI for the tier of each recipe)").addInfo("Shielding Cores: Focusing Tier (equal to or higher than recipe tier to allow focus)").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(15, 21, 15, true).addController("Bottom Center").addCasingInfoMin("Bulk Production Frame", 80, false).addCasingInfoMin("Quantum Force Conductor", 177, false).addCasingInfoMin("Force Field Glass", 224, false).addCasingInfoMin("Pulse Manipulators", 236, true).addCasingInfoMin("Shielding Cores", 142, true).addInputBus(EnumChatFormatting.BLUE + "Bottom" + EnumChatFormatting.GRAY + " Layer", new int[]{4}).addInputHatch(EnumChatFormatting.BLUE + "Bottom" + EnumChatFormatting.GRAY + " Layer", new int[]{4}).addOutputHatch(EnumChatFormatting.AQUA + "Top" + EnumChatFormatting.GRAY + " Layer", new int[]{5}).addOutputBus(EnumChatFormatting.AQUA + "Top" + EnumChatFormatting.GRAY + " Layer", new int[]{5}).addEnergyHatch(EnumChatFormatting.BLUE + "Bottom" + EnumChatFormatting.GRAY + " Layer", new int[]{4}).addMaintenanceHatch(EnumChatFormatting.BLUE + "Bottom" + EnumChatFormatting.GRAY + " or " + EnumChatFormatting.AQUA + "Top" + EnumChatFormatting.GRAY + " Layer", new int[]{4, 5}).addStructureInfo(EnumChatFormatting.WHITE + "Neptunium Plasma Hatch: " + EnumChatFormatting.GREEN + "Left" + EnumChatFormatting.GRAY + " side of Controller").addStructureInfo(EnumChatFormatting.WHITE + "Fermium Plasma Hatch: " + EnumChatFormatting.DARK_GREEN + "Right" + EnumChatFormatting.GRAY + " side of Controller").toolTipFinisher(GT_Values.AuthorBlueWeabo + EnumChatFormatting.RESET + EnumChatFormatting.GREEN + " + Steelux" + EnumChatFormatting.RESET + " - [GT++]");
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_QuantumForceTransformer> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mCraftingTier = 0;
        this.mFocusingTier = 0;
        if (!this.checkPiece(MAIN_PIECE, 7, 20, 4)) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1 || this.mOutputBusses.isEmpty() || this.mOutputHatches.isEmpty()) {
            return false;
        }
        return this.checkExoticAndNormalEnergyHatches();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(MAIN_PIECE, stackSize, hintsOnly, 7, 20, 4);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(MAIN_PIECE, stackSize, 7, 20, 4, elementBudget, env, false, true);
    }

    public static List<Pair<Block, Integer>> getAllCraftingTiers() {
        return new ArrayList<Pair<Block, Integer>>(){
            {
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)7));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)8));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)9));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)10));
            }
        };
    }

    public static List<Pair<Block, Integer>> getAllFocusingTiers() {
        return new ArrayList<Pair<Block, Integer>>(){
            {
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)11));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)12));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)13));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)14));
            }
        };
    }

    public static ITierConverter<Integer> craftingTierConverter() {
        return (block, meta) -> {
            if (block == null) {
                return -1;
            }
            if (block == ModBlocks.blockCasings5Misc) {
                switch (meta) {
                    case 7: {
                        return 1;
                    }
                    case 8: {
                        return 2;
                    }
                    case 9: {
                        return 3;
                    }
                    case 10: {
                        return 4;
                    }
                }
            }
            return -1;
        };
    }

    public static ITierConverter<Integer> focusingTierConverter() {
        return (block, meta) -> {
            if (block == null) {
                return -1;
            }
            if (block == ModBlocks.blockCasings5Misc) {
                switch (meta) {
                    case 11: {
                        return 1;
                    }
                    case 12: {
                        return 2;
                    }
                    case 13: {
                        return 3;
                    }
                    case 14: {
                        return 4;
                    }
                }
            }
            return -1;
        };
    }

    private void setCraftingTier(int tier) {
        this.mCraftingTier = tier;
    }

    private void setFocusingTier(int tier) {
        this.mFocusingTier = tier;
    }

    private int getCraftingTier() {
        return this.mCraftingTier;
    }

    private int getFocusingTier() {
        return this.mFocusingTier;
    }

    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(0, 10);
    }

    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.quantumForceTransformerRecipes;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){
            private int[] chances;
            private FluidStack[] fluidModeItems;

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                if (recipe.mSpecialValue > GregtechMetaTileEntity_QuantumForceTransformer.this.getCraftingTier()) {
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)recipe.mSpecialValue);
                }
                ItemStack catalyst = null;
                for (ItemStack item : recipe.mInputs) {
                    if (!ItemUtils.isCatalyst(item)) continue;
                    catalyst = item;
                    break;
                }
                if (catalyst == null) {
                    return SimpleCheckRecipeResult.ofFailure((String)"no_catalyst");
                }
                this.maxParallel = 0;
                for (ItemStack item : this.inputItems) {
                    if (!ItemUtils.isCatalyst(item) || !item.func_77969_a(catalyst)) continue;
                    this.maxParallel += item.field_77994_a;
                }
                GregtechMetaTileEntity_QuantumForceTransformer.this.mMaxParallel = this.maxParallel;
                GregtechMetaTileEntity_QuantumForceTransformer.this.doFermium = false;
                GregtechMetaTileEntity_QuantumForceTransformer.this.doNeptunium = false;
                if (recipe.mSpecialValue <= GregtechMetaTileEntity_QuantumForceTransformer.this.getFocusingTier()) {
                    if (GregtechMetaTileEntity_QuantumForceTransformer.this.drain((GT_MetaTileEntity_Hatch)GregtechMetaTileEntity_QuantumForceTransformer.this.mFermiumHatch, new FluidStack(mFermium, 1), false)) {
                        GregtechMetaTileEntity_QuantumForceTransformer.this.doFermium = true;
                    }
                    if (GregtechMetaTileEntity_QuantumForceTransformer.this.drain((GT_MetaTileEntity_Hatch)GregtechMetaTileEntity_QuantumForceTransformer.this.mNeptuniumHatch, new FluidStack(mNeptunium, 1), false)) {
                        GregtechMetaTileEntity_QuantumForceTransformer.this.doNeptunium = true;
                    }
                }
                this.chances = GregtechMetaTileEntity_QuantumForceTransformer.this.getOutputChances(recipe, GregtechMetaTileEntity_QuantumForceTransformer.this.doNeptunium ? this.findProgrammedCircuitNumber() : -1);
                this.fluidModeItems = new FluidStack[recipe.mOutputs.length];
                if (GregtechMetaTileEntity_QuantumForceTransformer.this.mFluidMode) {
                    for (int i = 0; i < recipe.mOutputs.length; ++i) {
                        Materials mat;
                        ItemStack item = recipe.getOutput(i);
                        if (item == null) continue;
                        ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)item);
                        Materials materials = mat = data == null ? null : data.mMaterial.mMaterial;
                        if (mat == null) continue;
                        if (mat.mStandardMoltenFluid != null) {
                            this.fluidModeItems[i] = mat.getMolten(144L);
                            continue;
                        }
                        if (mat.mFluid == null) continue;
                        this.fluidModeItems[i] = mat.getFluid(1000L);
                    }
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            public GT_ParallelHelper createParallelHelper(@Nonnull GT_Recipe recipe) {
                return super.createParallelHelper(recipe).setCustomItemOutputCalculation(parallel -> {
                    ArrayList items = new ArrayList();
                    for (int i = 0; i < recipe.mOutputs.length; ++i) {
                        ItemStack item = recipe.getOutput(i);
                        if (item == null || this.fluidModeItems[i] != null) continue;
                        ItemStack itemToAdd = item.func_77946_l();
                        double outputMultiplier = GT_ParallelHelper.calculateChancedOutputMultiplier((int)this.chances[i], (int)parallel);
                        long itemAmount = (long)((double)item.field_77994_a * outputMultiplier);
                        GT_ParallelHelper.addItemsLong(items, (ItemStack)itemToAdd, (long)itemAmount);
                    }
                    return items.toArray(new ItemStack[0]);
                }).setCustomFluidOutputCalculation(parallel -> {
                    double outputMultiplier;
                    FluidStack fluidToAdd;
                    FluidStack fluid;
                    int i;
                    ArrayList fluids = new ArrayList();
                    if (GregtechMetaTileEntity_QuantumForceTransformer.this.mFluidMode) {
                        for (i = 0; i < recipe.mOutputs.length; ++i) {
                            fluid = this.fluidModeItems[i];
                            if (fluid == null) continue;
                            fluidToAdd = fluid.copy();
                            outputMultiplier = GT_ParallelHelper.calculateChancedOutputMultiplier((int)this.chances[i], (int)parallel);
                            int itemAmount = recipe.mOutputs[i].field_77994_a;
                            long fluidAmount = (long)((double)fluidToAdd.amount * outputMultiplier * (double)itemAmount);
                            GT_ParallelHelper.addFluidsLong(fluids, (FluidStack)fluidToAdd, (long)fluidAmount);
                        }
                    }
                    for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                        fluid = recipe.getFluidOutput(i);
                        if (fluid == null) continue;
                        fluidToAdd = fluid.copy();
                        outputMultiplier = GT_ParallelHelper.calculateChancedOutputMultiplier((int)this.chances[i + recipe.mOutputs.length], (int)parallel);
                        long fluidAmount = (long)((double)fluidToAdd.amount * outputMultiplier);
                        GT_ParallelHelper.addFluidsLong(fluids, (FluidStack)fluidToAdd, (long)fluidAmount);
                    }
                    return fluids.toArray(new FluidStack[0]);
                });
            }

            private int findProgrammedCircuitNumber() {
                if (GregtechMetaTileEntity_QuantumForceTransformer.this.isInputSeparationEnabled()) {
                    for (ItemStack stack : this.inputItems) {
                        if (!GT_Utility.isAnyIntegratedCircuit((ItemStack)stack)) continue;
                        return stack.func_77960_j() - 1;
                    }
                    return -1;
                }
                ItemStack controllerStack = GregtechMetaTileEntity_QuantumForceTransformer.this.getControllerSlot();
                return GT_Utility.isAnyIntegratedCircuit((ItemStack)controllerStack) ? controllerStack.func_77960_j() - 1 : -1;
            }
        };
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getAverageInputVoltage());
        logic.setAvailableAmperage(this.getMaxInputAmps());
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (!super.onRunningTick(aStack)) {
            return false;
        }
        if (this.runningTick % 20 == 0) {
            FluidStack neptuniumToConsume;
            FluidStack fermiumToConsume;
            int amount = (int)((double)(this.getFocusingTier() * 4) * Math.sqrt(Math.min(this.mMaxParallel, this.processingLogic.getCurrentParallels())));
            if (this.doFermium && !this.drain((GT_MetaTileEntity_Hatch)this.mFermiumHatch, fermiumToConsume = new FluidStack(mFermium, amount), true)) {
                this.doFermium = false;
                this.stopMachine(ShutDownReasonRegistry.outOfFluid((FluidStack)fermiumToConsume));
                return false;
            }
            if (this.doNeptunium && !this.drain((GT_MetaTileEntity_Hatch)this.mNeptuniumHatch, neptuniumToConsume = new FluidStack(mNeptunium, amount), true)) {
                this.doNeptunium = false;
                this.stopMachine(ShutDownReasonRegistry.outOfFluid((FluidStack)neptuniumToConsume));
                return false;
            }
            this.runningTick = 1;
        } else {
            this.runningTick = (byte)(this.runningTick + 1);
        }
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mUpdate <= -550) {
            this.mUpdate = 50;
        }
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private int[] getOutputChances(GT_Recipe tRecipe, int aChanceIncreased) {
        int difference = this.getFocusingTier() - tRecipe.mSpecialValue;
        int aOutputsAmount = tRecipe.mOutputs.length + tRecipe.mFluidOutputs.length;
        int aChancePerOutput = 10000 / aOutputsAmount;
        int[] tChances = new int[aOutputsAmount];
        Arrays.fill(tChances, aChancePerOutput);
        switch (difference) {
            case 0: {
                for (int i = 0; i < tChances.length; ++i) {
                    if (this.doNeptunium) {
                        if (i == aChanceIncreased) {
                            int n = i;
                            tChances[n] = tChances[n] + aChancePerOutput / 2 * (aOutputsAmount - 1);
                        } else {
                            int n = i;
                            tChances[n] = tChances[n] / 2;
                        }
                    }
                    if (!this.doFermium) continue;
                    int n = i;
                    tChances[n] = tChances[n] + (10000 - tChances[i]) / 4;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < tChances.length; ++i) {
                    if (this.doNeptunium) {
                        if (i == aChanceIncreased) {
                            int n = i;
                            tChances[n] = tChances[n] + aChancePerOutput * 3 / 4 * (aOutputsAmount - 1);
                        } else {
                            int n = i;
                            tChances[n] = tChances[n] / 4;
                        }
                    }
                    if (!this.doFermium) continue;
                    int n = i;
                    tChances[n] = tChances[n] + (10000 - tChances[i]) / 3;
                }
                break;
            }
            case 2: 
            case 3: {
                for (int i = 0; i < tChances.length; ++i) {
                    if (this.doNeptunium) {
                        tChances[i] = i == aChanceIncreased ? 10000 : 0;
                    }
                    if (!this.doFermium) continue;
                    int n = i;
                    tChances[n] = tChances[n] + (10000 - tChances[i]) / 2;
                }
                break;
            }
        }
        return tChances;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mFluidMode = !this.mFluidMode;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"miscutils.machines.QFTFluidMode") + " " + this.mFluidMode));
    }

    public boolean addNeptuniumHatch(IGregTechTileEntity aTileEntity, short aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture((int)aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = null;
            this.mNeptuniumHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addFermiumHatch(IGregTechTileEntity aTileEntity, short aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture((int)aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = null;
            this.mFermiumHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public Block getCasingBlock1() {
        return ModBlocks.blockCasings5Misc;
    }

    public byte getCasingMeta1() {
        return 15;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mFluidMode", this.mFluidMode);
        aNBT.func_74757_a("doFermium", this.doFermium);
        aNBT.func_74757_a("doNeptunium", this.doNeptunium);
        aNBT.func_74768_a("mMaxParallel", this.mMaxParallel);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (!aNBT.func_74764_b("inputSeparation")) {
            this.inputSeparation = aNBT.func_74767_n("mSeparateInputBusses");
        }
        if (!aNBT.func_74764_b("batchMode")) {
            this.batchMode = aNBT.func_74767_n("mBatchMode");
        }
        this.mFluidMode = aNBT.func_74767_n("mFluidMode");
        this.doFermium = aNBT.func_74767_n("doFermium");
        this.doNeptunium = aNBT.func_74767_n("doNeptunium");
        this.mMaxParallel = aNBT.func_74762_e("mMaxParallel");
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{this.getCasingTexture(), TextureFactory.builder().addIcon(new IIconContainer[]{this.getActiveOverlay()}).extFacing().build()};
            }
            return new ITexture[]{this.getCasingTexture(), TextureFactory.builder().addIcon(new IIconContainer[]{this.getInactiveOverlay()}).extFacing().build()};
        }
        return new ITexture[]{this.getCasingTexture()};
    }

    private ITexture getCasingTexture() {
        return Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureId());
    }

    @SideOnly(value=Side.CLIENT)
    private void renderForceField(double x, double y, double z, int side, double minU, double maxU, double minV, double maxV) {
        Tessellator tes = Tessellator.field_78398_a;
        switch (side) {
            case 0: {
                tes.func_78374_a(x + 3.0, y, z + 7.0, maxU, maxV);
                tes.func_78374_a(x + 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x - 3.0, y + 4.0, z + 7.0, minU, minV);
                tes.func_78374_a(x - 3.0, y, z + 7.0, minU, maxV);
                tes.func_78374_a(x - 3.0, y, z + 7.0, minU, maxV);
                tes.func_78374_a(x - 3.0, y + 4.0, z + 7.0, minU, minV);
                tes.func_78374_a(x + 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x + 3.0, y, z + 7.0, maxU, maxV);
                break;
            }
            case 1: {
                tes.func_78374_a(x + 7.0, y, z + 4.0, maxU, maxV);
                tes.func_78374_a(x + 7.0, y + 4.0, z + 4.0, maxU, minV);
                tes.func_78374_a(x + 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x + 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x + 7.0, y + 4.0, z + 4.0, maxU, minV);
                tes.func_78374_a(x + 7.0, y, z + 4.0, maxU, maxV);
                break;
            }
            case 2: {
                tes.func_78374_a(x + 3.0, y, z - 7.0, maxU, maxV);
                tes.func_78374_a(x + 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x - 3.0, y + 4.0, z - 7.0, minU, minV);
                tes.func_78374_a(x - 3.0, y, z - 7.0, minU, maxV);
                tes.func_78374_a(x - 3.0, y, z - 7.0, minU, maxV);
                tes.func_78374_a(x - 3.0, y + 4.0, z - 7.0, minU, minV);
                tes.func_78374_a(x + 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x + 3.0, y, z - 7.0, maxU, maxV);
                break;
            }
            case 3: {
                tes.func_78374_a(x - 7.0, y, z + 4.0, maxU, maxV);
                tes.func_78374_a(x - 7.0, y + 4.0, z + 4.0, maxU, minV);
                tes.func_78374_a(x - 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x - 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x - 7.0, y + 4.0, z + 4.0, maxU, minV);
                tes.func_78374_a(x - 7.0, y, z + 4.0, maxU, maxV);
                break;
            }
            case 4: {
                tes.func_78374_a(x - 3.0, y, z + 7.0, maxU, maxV);
                tes.func_78374_a(x - 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x - 7.0, y + 4.0, z + 4.0, minU, minV);
                tes.func_78374_a(x - 7.0, y, z + 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y, z + 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y + 4.0, z + 4.0, minU, minV);
                tes.func_78374_a(x - 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x - 3.0, y, z + 7.0, maxU, maxV);
                break;
            }
            case 5: {
                tes.func_78374_a(x - 3.0, y, z - 7.0, maxU, maxV);
                tes.func_78374_a(x - 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x - 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x - 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x - 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x - 3.0, y, z - 7.0, maxU, maxV);
                break;
            }
            case 6: {
                tes.func_78374_a(x + 3.0, y, z + 7.0, maxU, maxV);
                tes.func_78374_a(x + 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x + 7.0, y + 4.0, z + 4.0, minU, minV);
                tes.func_78374_a(x + 7.0, y, z + 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y, z + 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y + 4.0, z + 4.0, minU, minV);
                tes.func_78374_a(x + 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x + 3.0, y, z + 7.0, maxU, maxV);
                break;
            }
            case 7: {
                tes.func_78374_a(x + 3.0, y, z - 7.0, maxU, maxV);
                tes.func_78374_a(x + 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x + 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x + 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x + 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x + 3.0, y, z - 7.0, maxU, maxV);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderInWorld(IBlockAccess aWorld, int x, int y, int z, Block block, RenderBlocks renderer) {
        Tessellator tes = Tessellator.field_78398_a;
        IIcon forceField = TexturesGtBlock.ForceField.getIcon();
        if (this.getBaseMetaTileEntity().isActive()) {
            double minU = forceField.func_94209_e();
            double maxU = forceField.func_94212_f();
            double minV = forceField.func_94206_g();
            double maxV = forceField.func_94210_h();
            double xBaseOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
            double zBaseOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
            tes.func_78386_a(1.0f, 1.0f, 1.0f);
            tes.func_78380_c(0xF000F0);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 0, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 1, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 2, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 3, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 4, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 5, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 6, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 7, minU, maxU, minV, maxV);
        }
        return false;
    }

    public boolean supportsInputSeparation() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }
}

