/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.chemplant;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Triplet;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.chemistry.general.ItemGenericChemBase;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers.GT_MetaTileEntity_Hatch_Catalysts;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class GregtechMTE_ChemicalPlant
extends GregtechMeta_MultiBlockBase<GregtechMTE_ChemicalPlant>
implements ISurvivalConstructable {
    private int mSolidCasingTier = 0;
    private int mMachineCasingTier = 0;
    private int mPipeCasingTier = 0;
    private int mCoilTier = 0;
    private HeatingCoilLevel checkCoil;
    private int[] checkCasing = new int[8];
    private int checkMachine;
    private int checkPipe;
    private int maxTierOfHatch;
    private int mCasing;
    private static IStructureDefinition<GregtechMTE_ChemicalPlant> STRUCTURE_DEFINITION = null;
    private final ArrayList<GT_MetaTileEntity_Hatch_Catalysts> mCatalystBuses = new ArrayList();
    private static final HashMap<Integer, Triplet<Block, Integer, Integer>> mTieredBlockRegistry = new HashMap();

    public GregtechMTE_ChemicalPlant(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_ChemicalPlant(String aName) {
        super(aName);
    }

    public static boolean registerMachineCasingForTier(int aTier, Block aBlock, int aMeta, int aCasingTextureID) {
        Triplet<Block, Integer, Integer> aCasingData = new Triplet<Block, Integer, Integer>(aBlock, aMeta, aCasingTextureID);
        if (mTieredBlockRegistry.containsKey(aTier)) {
            CORE.crash("Tried to register a Machine casing for tier " + aTier + " to the Chemical Plant, however this tier already contains one.");
        }
        mTieredBlockRegistry.put(aTier, aCasingData);
        return true;
    }

    private static int getCasingTextureIdForTier(int aTier) {
        if (!mTieredBlockRegistry.containsKey(aTier)) {
            return 10;
        }
        int aCasingID = mTieredBlockRegistry.get(aTier).getValue_3();
        return aCasingID;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_ChemicalPlant(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Chemical Plant";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Chemical Plant").addInfo("Heavy Industry, now right at your doorstep!").addInfo("Please read the user manual for more information on construction and usage").addSeparator().addController("Bottom Center").addStructureHint("Catalyst Housing", new int[]{1}).addInputBus("Bottom Casing", new int[]{1}).addOutputBus("Bottom Casing", new int[]{1}).addInputHatch("Bottom Casing", new int[]{1}).addOutputHatch("Bottom Casing", new int[]{1}).addEnergyHatch("Bottom Casing", new int[]{1}).addMaintenanceHatch("Bottom Casing", new int[]{1}).addSubChannelUsage("casing", "metal machine casing").addSubChannelUsage("machine", "tier machine casing").addSubChannelUsage("coil", "heating coil blocks").addSubChannelUsage("pipe", "pipe casing blocks").toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public void setMachineMeta(int meta) {
        this.checkMachine = meta;
    }

    public int getMachineMeta() {
        return this.checkMachine;
    }

    public void setPipeMeta(int meta) {
        this.checkPipe = meta;
    }

    public int getPipeMeta() {
        return this.checkPipe;
    }

    public void setCoilMeta(HeatingCoilLevel meta) {
        this.checkCoil = meta;
    }

    public HeatingCoilLevel getCoilMeta() {
        return this.checkCoil;
    }

    public IStructureDefinition<GregtechMTE_ChemicalPlant> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            IStructureElement allCasingsElement = StructureUtility.withChannel((String)"casing", (IStructureElement)StructureUtility.ofChain(IntStream.range(0, 8).mapToObj(GregtechMTE_ChemicalPlant::ofSolidCasing).collect(Collectors.toList())));
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX"}, {"X     X", " MMMMM ", " MHHHM ", " MHHHM ", " MHHHM ", " MMMMM ", "X     X"}, {"X     X", "       ", "  PPP  ", "  PPP  ", "  PPP  ", "       ", "X     X"}, {"X     X", "       ", "  HHH  ", "  HHH  ", "  HHH  ", "       ", "X     X"}, {"X     X", "       ", "  PPP  ", "  PPP  ", "  PPP  ", "       ", "X     X"}, {"X     X", " MMMMM ", " MHHHM ", " MHHHM ", " MHHHM ", " MMMMM ", "X     X"}, {"CCC~CCC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CCCCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMTE_ChemicalPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance}).casingIndex(this.getCasingTextureID()).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMTE_ChemicalPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus}).adder(GregtechMTE_ChemicalPlant::addChemicalPlantList).hatchItemFilterAnd((t, s) -> GT_StructureUtility.filterByMTETier((int)Integer.MIN_VALUE, (int)(s.field_77994_a >= 10 ? Integer.MAX_VALUE : s.field_77994_a))).casingIndex(this.getCasingTextureID()).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMTE_ChemicalPlant.class).hatchClass(GT_MetaTileEntity_Hatch_Catalysts.class).shouldReject(t -> t.mCatalystBuses.size() >= 1).adder(GregtechMTE_ChemicalPlant::addChemicalPlantList).casingIndex(this.getCasingTextureID()).dot(1).build(), allCasingsElement})).addElement('X', allCasingsElement).addElement('M', StructureUtility.withChannel((String)"machine", GregtechMTE_ChemicalPlant.addTieredBlock(GregTech_API.sBlockCasings1, GregtechMTE_ChemicalPlant::setMachineMeta, GregtechMTE_ChemicalPlant::getMachineMeta, 10))).addElement('H', StructureUtility.withChannel((String)"coil", (IStructureElement)GT_StructureUtility.ofCoil(GregtechMTE_ChemicalPlant::setCoilMeta, GregtechMTE_ChemicalPlant::getCoilMeta))).addElement('P', StructureUtility.withChannel((String)"pipe", GregtechMTE_ChemicalPlant.addTieredBlock(GregTech_API.sBlockCasings2, GregtechMTE_ChemicalPlant::setPipeMeta, GregtechMTE_ChemicalPlant::getPipeMeta, 12, 16))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private static IStructureElement<GregtechMTE_ChemicalPlant> ofSolidCasing(final int aIndex) {
        return new IStructureElement<GregtechMTE_ChemicalPlant>(){

            public boolean check(GregtechMTE_ChemicalPlant t, World world, int x, int y, int z) {
                if (this.check(aIndex, world, x, y, z)) {
                    int[] nArray = t.checkCasing;
                    int n = aIndex;
                    nArray[n] = nArray[n] + 1;
                    t.mCasing++;
                    return true;
                }
                return false;
            }

            private boolean check(int aIndex2, World world, int x, int y, int z) {
                Block block = world.func_147439_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                Block target = (Block)((Triplet)mTieredBlockRegistry.get(aIndex2)).getValue_1();
                int targetMeta = (Integer)((Triplet)mTieredBlockRegistry.get(aIndex2)).getValue_2();
                return target.equals(block) && meta == targetMeta;
            }

            int getIndex(int size) {
                if (size > 8) {
                    size = 8;
                }
                return size - 1;
            }

            public boolean spawnHint(GregtechMTE_ChemicalPlant t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)((Block)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_1()), (int)((Integer)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_2()));
                return true;
            }

            public boolean placeBlock(GregtechMTE_ChemicalPlant t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, (Block)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_1(), ((Integer)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_2()).intValue(), 3);
            }

            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(GregtechMTE_ChemicalPlant gregtechMTE_chemicalPlant, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)((Block)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_1()), (int)((Integer)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_2()));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(GregtechMTE_ChemicalPlant t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(this.getIndex(trigger.field_77994_a), world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)((Block)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_1()), (int)((Integer)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_2()), (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 3, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 3, 6, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int i;
        this.mCasing = 0;
        for (i = 0; i < 8; ++i) {
            this.checkCasing[i] = 0;
        }
        this.checkPipe = 0;
        this.checkMachine = 0;
        this.mSolidCasingTier = 0;
        this.mMachineCasingTier = 0;
        this.mPipeCasingTier = 0;
        this.mCoilTier = 0;
        this.mCatalystBuses.clear();
        this.setCoilMeta(HeatingCoilLevel.None);
        if (this.checkPiece(this.mName, 3, 6, 0) && this.mCasing >= 70) {
            for (i = 0; i < 8; ++i) {
                if (this.checkCasing[i] == this.mCasing) {
                    this.mSolidCasingTier = i;
                    continue;
                }
                if (this.checkCasing[i] <= 0) continue;
                return false;
            }
            this.mMachineCasingTier = this.checkMachine - 1;
            this.mPipeCasingTier = this.checkPipe - 12;
            this.mCoilTier = this.checkCoil.getTier();
            this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
            this.updateHatchTexture();
            return (this.mMachineCasingTier >= 9 || this.mMachineCasingTier >= this.maxTierOfHatch) && this.mCatalystBuses.size() <= 1;
        }
        return false;
    }

    public void updateHatchTexture() {
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mCatalystBuses) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (IDualInputHatch iDualInputHatch : this.mDualInputHatches) {
            iDualInputHatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mInputBusses) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mMaintenanceHatches) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mEnergyHatches) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mOutputBusses) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mInputHatches) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mOutputHatches) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
    }

    public final boolean addChemicalPlantList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Catalysts) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_ELECTROFURNACE_LOOP;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getCasingTextureID();
    }

    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.chemicalPlantRecipes;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * this.getPipeCasingTier();
    }

    private int getSolidCasingTier() {
        return this.mSolidCasingTier;
    }

    private int getMachineCasingTier() {
        return this.mMachineCasingTier;
    }

    private int getPipeCasingTier() {
        return this.mPipeCasingTier;
    }

    private int getCasingTextureID() {
        int aTier = this.mSolidCasingTier;
        return GregtechMTE_ChemicalPlant.getCasingTextureIdForTier(aTier);
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity) {
        int aMaxTier = this.getMachineCasingTier();
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_TieredMachineBlock) {
            GT_MetaTileEntity_TieredMachineBlock aMachineBlock = (GT_MetaTileEntity_TieredMachineBlock)aMetaTileEntity;
            byte aTileTier = aMachineBlock.mTier;
            if (aTileTier > aMaxTier) {
                this.log("Hatch tier too high.");
                return false;
            }
            return this.addToMachineList(aTileEntity, this.getCasingTextureID());
        }
        this.log("Bad Tile Entity being added to hatch map.");
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mSolidCasingTier", this.mSolidCasingTier);
        aNBT.func_74768_a("mMachineCasingTier", this.mMachineCasingTier);
        aNBT.func_74768_a("mPipeCasingTier", this.mPipeCasingTier);
        aNBT.func_74768_a("mCoilTier", this.mCoilTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSolidCasingTier = aNBT.func_74762_e("mSolidCasingTier");
        this.mMachineCasingTier = aNBT.func_74762_e("mMachineCasingTier");
        this.mPipeCasingTier = aNBT.func_74762_e("mPipeCasingTier");
        this.mCoilTier = aNBT.func_74762_e("mCoilTier");
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Catalysts) {
            this.log("Found GT_MetaTileEntity_Hatch_Catalysts");
            return this.addToMachineListInternal(this.mCatalystBuses, aMetaTileEntity, aBaseCasingIndex);
        }
        return super.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public int getSpeedBonus() {
        return 50 * (this.mCoilTier + 1);
    }

    public int getMaxCatalystDurability() {
        return 50;
    }

    public byte getUpdateData() {
        return (byte)this.mSolidCasingTier;
    }

    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && (aValue & 0x80) == 0) {
            this.mSolidCasingTier = aValue;
        }
    }

    private void damageCatalyst(@Nonnull ItemStack aStack, int minParallel) {
        if (!this.isCatalystDamageable()) {
            return;
        }
        for (int i = 0; i < minParallel; ++i) {
            if (!((double)(MathUtils.randFloat(0.0f, 1.0E7f) / 1.0E7f) < (double)1.2f - 0.2 * (double)this.mPipeCasingTier)) continue;
            int damage = this.getDamage(aStack) + 1;
            if (damage >= this.getMaxCatalystDurability()) {
                this.addOutput(CI.getEmptyCatalyst(1));
                --aStack.field_77994_a;
                return;
            }
            this.setDamage(aStack, damage);
        }
    }

    private boolean isCatalystDamageable() {
        return this.mCoilTier < 10 || this.mPipeCasingTier < 4;
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){
            ItemStack catalyst;

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                if (recipe.mSpecialValue > GregtechMTE_ChemicalPlant.this.mSolidCasingTier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)(recipe.mSpecialValue + 1));
                }
                ItemStack catalystInRecipe = null;
                for (ItemStack item : recipe.mInputs) {
                    if (!ItemUtils.isCatalyst(item)) continue;
                    catalystInRecipe = item;
                    break;
                }
                if (catalystInRecipe != null) {
                    this.catalyst = GregtechMTE_ChemicalPlant.this.findCatalyst(GregtechMTE_ChemicalPlant.this.getCatalystInputs().toArray(new ItemStack[0]), catalystInRecipe);
                    if (this.catalyst == null) {
                        return SimpleCheckRecipeResult.ofFailure((String)"no_catalyst");
                    }
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            public CheckRecipeResult process() {
                ArrayList<ItemStack> inputItemsList = new ArrayList<ItemStack>(Arrays.asList(this.inputItems));
                inputItemsList.addAll(GregtechMTE_ChemicalPlant.this.getCatalystInputs());
                this.inputItems = inputItemsList.toArray(new ItemStack[0]);
                return super.process();
            }

            @NotNull
            protected CheckRecipeResult onRecipeStart(@NotNull GT_Recipe recipe) {
                if (this.catalyst != null) {
                    GregtechMTE_ChemicalPlant.this.damageCatalyst(this.catalyst, this.getCurrentParallels());
                }
                return super.onRecipeStart(recipe);
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setSpeedBonus(100.0f / (100.0f + (float)this.getSpeedBonus()));
    }

    @Override
    public void updateSlots() {
        super.updateSlots();
        for (GT_MetaTileEntity_Hatch_Catalysts h : this.mCatalystBuses) {
            h.updateSlots();
            h.tryFillUsageSlots();
        }
    }

    private ItemStack findCatalyst(ItemStack[] aItemInputs, ItemStack catalyst) {
        if (aItemInputs != null) {
            for (ItemStack item : aItemInputs) {
                if (!GT_Utility.areStacksEqual((ItemStack)item, (ItemStack)catalyst, (boolean)true)) continue;
                return item;
            }
        }
        return null;
    }

    private int getDamage(@Nonnull ItemStack aStack) {
        return ItemGenericChemBase.getCatalystDamage(aStack);
    }

    private void setDamage(@Nonnull ItemStack aStack, int aAmount) {
        ItemGenericChemBase.setCatalystDamage(aStack, aAmount);
    }

    public ArrayList<ItemStack> getCatalystInputs() {
        ArrayList<ItemStack> tItems = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Catalysts tHatch : (ArrayList)GT_Utility.filterValidMTEs(this.mCatalystBuses)) {
            AutoMap<ItemStack> aHatchContent = tHatch.getContentUsageSlots();
            if (aHatchContent.isEmpty()) continue;
            tItems.addAll(aHatchContent);
        }
        return tItems;
    }
}

