/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import gravisuite.network.PacketKeyPress;
import gravisuite.network.PacketKeyboardUpdate;
import gravisuite.network.PacketManagePoints;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public class PacketHandler {
    public static String channelName = "GraviSuite";
    private static FMLEventChannel channel;

    public PacketHandler() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        channel.register((Object)this);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), null);
    }

    public void onPacketData(InputStream is, EntityPlayer player) {
        DataInputStream data = new DataInputStream(is);
        try {
            byte packetId = data.readByte();
            switch (packetId) {
                case 0: {
                    PacketKeyboardUpdate packetKU = new PacketKeyboardUpdate();
                    packetKU.readData(data);
                    packetKU.execute(player);
                    break;
                }
                case 1: {
                    PacketKeyPress packetKP = new PacketKeyPress();
                    packetKP.readData(data);
                    packetKP.execute(player);
                    break;
                }
                case 2: {
                    PacketManagePoints packetMngPoint = new PacketManagePoints();
                    packetMngPoint.readData(data);
                    packetMngPoint.managePoint(player, packetMngPoint.pointName, packetMngPoint.action);
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static FMLProxyPacket makePacket(byte[] data) {
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])data), channelName);
    }

    public static void sendPacket(byte[] data) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            channel.sendToServer(PacketHandler.makePacket(data));
        } else {
            channel.sendToAll(PacketHandler.makePacket(data));
        }
    }

    public static void sendPacket(byte[] data, EntityPlayerMP player) {
        channel.sendTo(PacketHandler.makePacket(data), player);
    }
}

