/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu.handler;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import lumien.custommainmenu.CustomMainMenu;
import lumien.custommainmenu.gui.GuiCustom;
import lumien.custommainmenu.gui.GuiCustomButton;
import lumien.custommainmenu.gui.GuiCustomWrappedButton;
import lumien.custommainmenu.gui.GuiFakeMain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.apache.logging.log4j.Level;

public class CMMEventHandler {
    public long displayMs = -1L;
    Field guiField;
    GuiCustom actualGui;

    public CMMEventHandler() {
        try {
            this.guiField = GuiScreenEvent.class.getDeclaredField("gui");
            this.guiField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void openGui(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu) {
            GuiCustom customMainMenu = CustomMainMenu.INSTANCE.config.getGUI("mainmenu");
            if (customMainMenu != null) {
                event.gui = customMainMenu;
            }
        } else {
            GuiScreen customMainMenu = event.gui;
            if (customMainMenu instanceof GuiCustom) {
                GuiCustom custom = (GuiCustom)customMainMenu;
                GuiCustom target = CustomMainMenu.INSTANCE.config.getGUI(custom.guiConfig.name);
                if (target != custom) {
                    event.gui = target;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void initGuiPostEarly(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen guiScreen = event.gui;
        if (guiScreen instanceof GuiCustom) {
            GuiCustom custom = (GuiCustom)guiScreen;
            if (custom.guiConfig.name.equals("mainmenu")) {
                event.buttonList = new ArrayList();
                this.actualGui = custom;
                try {
                    this.guiField.set(event, (Object)new GuiFakeMain());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void initGuiPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiFakeMain) {
            HashMap<Integer, GuiButton> removedButtons = new HashMap<Integer, GuiButton>();
            Iterator iterator = event.buttonList.iterator();
            while (iterator.hasNext()) {
                GuiButton b = (GuiButton)iterator.next();
                if (b instanceof GuiCustomButton) continue;
                iterator.remove();
                removedButtons.put(b.field_146127_k, b);
                if (b.field_146127_k == 666 && Loader.isModLoaded((String)"OpenEye")) {
                    CustomMainMenu.INSTANCE.logger.log(Level.DEBUG, "Found OpenEye button, use a wrapped button to config this. (" + b.field_146127_k + ")");
                    continue;
                }
                if (b.field_146127_k == 404 && Loader.isModLoaded((String)"VersionChecker")) {
                    CustomMainMenu.INSTANCE.logger.log(Level.DEBUG, "Found VersionChecker button, use a wrapped button to config this. (" + b.field_146127_k + ")");
                    continue;
                }
                CustomMainMenu.INSTANCE.logger.log(Level.DEBUG, "Found unsupported button, use a wrapped button to config this. (" + b.field_146127_k + ")");
            }
            for (GuiButton o : this.actualGui.getButtonList()) {
                if (!(o instanceof GuiCustomWrappedButton)) continue;
                GuiCustomWrappedButton b = (GuiCustomWrappedButton)o;
                CustomMainMenu.INSTANCE.logger.log(Level.DEBUG, "Initiating Wrapped Button " + b.wrappedButtonID + " with " + removedButtons.get(b.wrappedButtonID));
                b.init((GuiButton)removedButtons.get(b.wrappedButtonID));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.displayMs != -1L) {
            if (System.currentTimeMillis() - this.displayMs < 5000L) {
                Minecraft.func_71410_x().field_71466_p.func_78261_a("Error loading config file, see console for more information", 0, 80, 0xFF0000);
            } else {
                this.displayMs = -1L;
            }
        }
    }
}

