/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica;

import com.github.lunatrius.schematica.proxy.CommonProxy;
import com.github.lunatrius.schematica.reference.Reference;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;

@Mod(modid="Schematica", name="Schematica", version="1.11.0-GTNH", dependencies="required-after:LunatriusCore;", guiFactory="com.github.lunatrius.schematica.client.gui.GuiFactory")
public class Schematica {
    @Mod.Instance(value="Schematica")
    public static Schematica instance;
    @SidedProxy(serverSide="com.github.lunatrius.schematica.proxy.ServerProxy", clientSide="com.github.lunatrius.schematica.proxy.ClientProxy")
    public static CommonProxy proxy;

    @NetworkCheckHandler
    public boolean checkModList(Map<String, String> versions, Side side) {
        if (side == Side.CLIENT && versions.containsKey("Schematica")) {
            String version = versions.get("Schematica");
            String[] splitVersion = version.split("\\.");
            boolean isAllowed = false;
            if (splitVersion.length < 3) {
                return false;
            }
            try {
                int major = Integer.parseInt(splitVersion[0]);
                int rev = Integer.parseInt(splitVersion[1]);
                if (major > 1) {
                    isAllowed = true;
                } else if (major == 1 && rev >= 11) {
                    isAllowed = true;
                }
            }
            catch (NumberFormatException e) {
                Reference.logger.warn("Failed to parse client version of " + version);
            }
            return isAllowed;
        }
        return true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        proxy.serverStarting(event);
    }
}

