/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega.GT_TileEntity_MegaMultiBlockBase;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_MegaBlastFurnace
extends GT_TileEntity_MegaMultiBlockBase<GT_TileEntity_MegaBlastFurnace>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 11;
    private static final IStructureDefinition<GT_TileEntity_MegaBlastFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", GT_TileEntity_MegaBlastFurnace.createShape()).addElement('=', GT_TileEntity_MegaMultiBlockBase.StructureElementAirNoHint.getInstance()).addElement('t', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaBlastFurnace.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputHatch.withAdder(GT_TileEntity_MegaBlastFurnace::addOutputHatchToTopList).withCount(t -> t.mPollutionOutputHatches.size())}).casingIndex(11).dot(1).buildAndChain(GregTech_API.sBlockCasings1, 11)).addElement('m', GT_HatchElement.Muffler.newAny(11, 2)).addElement('C', StructureUtility.withChannel((String)"coil", (IStructureElement)GT_StructureUtility.ofCoil(GT_TileEntity_MegaBlastFurnace::setCoilLevel, GT_TileEntity_MegaBlastFurnace::getCoilLevel))).addElement('g', StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier))).addElement('b', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaBlastFurnace.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy.or((IHatchElement)GT_HatchElement.ExoticEnergy)}).casingIndex(11).dot(1).buildAndChain(GregTech_API.sBlockCasings1, 11)).build();
    private HeatingCoilLevel mCoilLevel;
    protected final ArrayList<GT_MetaTileEntity_Hatch_Output> mPollutionOutputHatches = new ArrayList();
    protected final FluidStack[] pollutionFluidStacks = new FluidStack[]{Materials.CarbonDioxide.getGas(1000L), Materials.CarbonMonoxide.getGas(1000L), Materials.SulfurDioxide.getGas(1000L)};
    private int mHeatingCapacity;
    private byte glassTier;
    private static final int polPtick = ConfigHandler.basePollutionMBFSecond / 20 * ConfigHandler.megaMachinesMax;

    private static String[][] createShape() {
        int i;
        String[][] raw = new String[20][];
        raw[0] = new String[15];
        String topCasing = "ttttttttttttttt";
        String middleTopCasing = "tttttttmttttttt";
        raw[0][0] = topCasing;
        for (int i2 = 1; i2 < 15; ++i2) {
            raw[0][i2] = topCasing;
        }
        raw[0][7] = middleTopCasing;
        raw[1] = new String[15];
        String allGlass = "ggggggggggggggg";
        String allCoil = "gCCCCCCCCCCCCCg";
        String middleLine = "gC===========Cg";
        raw[1][0] = allGlass;
        raw[1][1] = allCoil;
        raw[1][13] = allCoil;
        raw[1][14] = allGlass;
        for (i = 2; i < 13; ++i) {
            raw[1][i] = middleLine;
        }
        for (i = 2; i < 19; ++i) {
            raw[i] = raw[1];
        }
        String bottomCasing = "bbbbbbbbbbbbbbb";
        raw[19] = new String[15];
        for (int i3 = 0; i3 < 15; ++i3) {
            raw[19][i3] = bottomCasing;
        }
        raw[17] = Arrays.copyOf(raw[17], raw[17].length);
        raw[17][0] = "ggggggg~ggggggg";
        return StructureUtility.transpose((String[][])raw);
    }

    public GT_TileEntity_MegaBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaBlastFurnace(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_MegaBlastFurnace(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Blast Furnace").addInfo("Controller block for the Mega Blast Furnace").addInfo("You can use some fluids to reduce recipe time. Place the circuit in the Input Bus").addInfo("Each 900K over the min. Heat required reduces power consumption by 5% (multiplicatively)").addInfo("Each 1800K over the min. Heat allows for an overclock to be upgraded to a perfect overclock.").addInfo("That means the EBF will reduce recipe time by a factor 4 instead of 2 (giving 100% efficiency).").addInfo("Additionally gives +100K for every tier past MV").addPollutionAmount(20 * this.getPollutionPerTick(null)).addSeparator().beginStructureBlock(15, 20, 15, true).addController("3rd layer center").addCasingInfoRange("Heat Proof Machine Casing", 0, 279, false).addOtherStructurePart("864x Heating Coils", "Inner 13x18x13 (Hollow)").addOtherStructurePart("1007x Borosilicate Glass", "Outer 15x18x15").addStructureInfo("The glass tier limits the Energy Input tier").addEnergyHatch("Any bottom layer casing").addMaintenanceHatch("Any bottom layer casing").addMufflerHatch("Top middle").addInputBus("Any bottom layer casing").addInputHatch("Any bottom layer casing").addOutputBus("Any bottom layer casing").addOutputHatch("Gasses, Any top layer casing").addStructureInfo("Recovery amount scales with Muffler Hatch tier").addOutputHatch("Platline fluids, Any bottom layer casing").addStructureHint("This Mega Multiblock is too big to have its structure hologram displayed fully.").toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS);
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.glassTier = aNBT.func_74771_c("glasTier");
        if (!aNBT.func_74764_b("inputSeparation")) {
            this.inputSeparation = aNBT.func_74767_n("isBussesSeparate");
        }
        if (!aNBT.func_74764_b("batchMode")) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!aPlayer.func_70093_af()) {
            this.inputSeparation = !this.inputSeparation;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation));
            return true;
        }
        boolean bl = this.batchMode = !this.batchMode;
        if (this.batchMode) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("glasTier", this.glassTier);
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return polPtick;
    }

    public boolean addOutputHatchToTopList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mPollutionOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        return false;
    }

    @Override
    protected String[] getExtendedInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.EBF.heat") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)this.mHeatingCapacity) + EnumChatFormatting.RESET + " K"};
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Nonnull
            protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).setRecipeHeat(recipe.mSpecialValue).setMachineHeat(GT_TileEntity_MegaBlastFurnace.this.mHeatingCapacity).setHeatOC(true).setHeatDiscount(true);
            }

            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                return recipe.mSpecialValue <= GT_TileEntity_MegaBlastFurnace.this.mHeatingCapacity ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientHeat((int)recipe.mSpecialValue);
            }
        }.setMaxParallel(ConfigHandler.megaMachinesMax);
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    public IStructureDefinition<GT_TileEntity_MegaBlastFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 7, 17, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        this.glassTier = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        return this.survivialBuildPiece("main", stackSize, 7, 17, 0, realBudget, source, actor, false, true);
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.mCoilLevel = aCoilLevel;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.mCoilLevel;
    }

    public boolean addOutput(FluidStack aLiquid) {
        ArrayList tOutputHatches;
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        boolean isOutputPollution = false;
        for (FluidStack pollutionFluidStack : this.pollutionFluidStacks) {
            if (!tLiquid.isFluidEqual(pollutionFluidStack)) continue;
            isOutputPollution = true;
            break;
        }
        if (isOutputPollution) {
            tOutputHatches = this.mPollutionOutputHatches;
            int pollutionReduction = 0;
            Iterator iterator = ((ArrayList)GT_Utility.filterValidMTEs((Collection)this.mMufflerHatches)).iterator();
            if (iterator.hasNext()) {
                GT_MetaTileEntity_Hatch_Muffler tHatch = (GT_MetaTileEntity_Hatch_Muffler)iterator.next();
                pollutionReduction = 100 - tHatch.calculatePollutionReduction(100);
            }
            tLiquid.amount = tLiquid.amount * pollutionReduction / 100;
        } else {
            tOutputHatches = this.mOutputHatches;
        }
        return GT_TileEntity_MegaBlastFurnace.dumpFluid((List)tOutputHatches, (FluidStack)tLiquid, (boolean)true) || GT_TileEntity_MegaBlastFurnace.dumpFluid((List)tOutputHatches, (FluidStack)tLiquid, (boolean)false);
    }

    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.mHeatingCapacity = 0;
        this.glassTier = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        this.mPollutionOutputHatches.clear();
        if (!this.checkPiece("main", 7, 17, 0) || this.getCoilLevel() == HeatingCoilLevel.None || this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (this.glassTier < 8) {
            for (GT_MetaTileEntity_Hatch hatch : this.mExoticEnergyHatches) {
                if (hatch.getConnectionType() == GT_MetaTileEntity_Hatch.ConnectionType.LASER) {
                    return false;
                }
                if (this.glassTier >= hatch.mTier) continue;
                return false;
            }
        }
        this.mHeatingCapacity = (int)this.getCoilLevel().getHeat() + 100 * (BW_Util.getTier(this.getMaxInputEu()) - 2);
        return true;
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.blastFurnaceRecipes;
    }

    public int getRecipeCatalystPriority() {
        return -2;
    }

    public boolean supportsInputSeparation() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean supportsVoidProtection() {
        return true;
    }
}

