/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NonNullWrappedHashMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 46345163103910175L;
    private V defaultValue;

    public NonNullWrappedHashMap(int initialCapacity, float loadFactor, V defaultValue) {
        super(initialCapacity, loadFactor);
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    public NonNullWrappedHashMap(int initialCapacity, V defaultValue) {
        super(initialCapacity);
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    public NonNullWrappedHashMap(V defaultValue) {
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    public NonNullWrappedHashMap(Map<? extends K, ? extends V> m, V defaultValue) {
        super(m);
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    @Override
    public V get(Object key) {
        return this.getOrDefault(key, this.defaultValue);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return Objects.requireNonNull(Optional.ofNullable(super.getOrDefault(key, defaultValue)).orElse(this.defaultValue));
    }
}

