/*
 * Decompiled with CFR 0.152.
 */
package ru.npo6ka.sleepingbag.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.npo6ka.sleepingbag.ExtendedPlayer;
import ru.npo6ka.sleepingbag.ItemsRegister;
import ru.npo6ka.sleepingbag.blocks.BlockSleepingBag;

public class ItemSleepingBag
extends Item {
    public static final String TAG_POSITION = "player_pos_sleaping_bag";
    public static final int[][] field_149981_a = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public ItemSleepingBag() {
        this.func_77637_a(CreativeTabs.field_78031_c);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        this.setSleepingBag(itemstack, entityplayer, world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        return itemstack;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, float px, float py, float pz) {
        return side == 1 && this.setSleepingBag(itemstack, entityplayer, world, x, ++y, z);
    }

    public boolean setSleepingBag(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return true;
        }
        boolean side = true;
        if (!this.canPlayerSetBad(itemstack, entityplayer, world, 1, x, y, z)) {
            return false;
        }
        if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            return false;
        }
        Integer offsetX = 0;
        Integer offsetZ = 0;
        int dir = MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (dir == 0) {
            offsetZ = -1;
        } else if (dir == 1) {
            offsetX = 1;
        } else if (dir == 2) {
            offsetZ = 1;
        } else if (dir == 3) {
            offsetX = -1;
        }
        if (this.canPlayerSetBad(itemstack, entityplayer, world, 1, x + offsetX, y, z + offsetZ)) {
            return this.setBlockSleepingBag(itemstack, entityplayer, world, 1, x, y, z, dir, offsetX, offsetZ);
        }
        offsetX = offsetX * -1;
        offsetZ = offsetZ * -1;
        if (this.canPlayerSetBad(itemstack, entityplayer, world, 1, x + offsetX, y, z + offsetZ)) {
            return this.setBlockSleepingBag(itemstack, entityplayer, world, 1, x, y, z, dir, offsetX, offsetZ);
        }
        if (offsetX == 0) {
            offsetX = 1;
            offsetZ = 0;
        } else {
            offsetZ = 1;
            offsetX = 0;
        }
        if (this.canPlayerSetBad(itemstack, entityplayer, world, 1, x + offsetX, y, z + offsetZ)) {
            return this.setBlockSleepingBag(itemstack, entityplayer, world, 1, x, y, z, dir, offsetX, offsetZ);
        }
        offsetX = offsetX * -1;
        offsetZ = offsetZ * -1;
        return this.canPlayerSetBad(itemstack, entityplayer, world, 1, x + offsetX, y, z + offsetZ) && this.setBlockSleepingBag(itemstack, entityplayer, world, 1, x, y, z, dir, offsetX, offsetZ);
    }

    public boolean canPlayerSetBad(ItemStack itemstack, EntityPlayer entityplayer, World world, int side, int x, int y, int z) {
        return entityplayer.func_82247_a(x, y, z, side, itemstack) && world.func_147437_c(x, y, z);
    }

    public boolean canPlayerSleep(World world, EntityPlayer entityplayer, int x, int y, int z) {
        if (entityplayer.func_70608_bn() || !entityplayer.func_70089_S() || !entityplayer.field_70170_p.field_73011_w.func_76569_d()) {
            return false;
        }
        if (entityplayer.field_70170_p.func_72935_r()) {
            entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.noSleep", new Object[0]));
            return false;
        }
        int i1 = world.func_72805_g(x, y, z);
        Block bed = world.func_147439_a(x, y, z);
        if (!(bed instanceof BlockSleepingBag)) {
            return false;
        }
        BlockSleepingBag blockSleepingBag = (BlockSleepingBag)bed;
        if (!BlockSleepingBag.func_149975_b((int)i1)) {
            BlockSleepingBag blockSleepingBag2 = (BlockSleepingBag)bed;
            int j1 = BlockSleepingBag.func_149895_l((int)i1);
            x += field_149981_a[j1][0];
            z += field_149981_a[j1][1];
        }
        if (Math.abs(entityplayer.field_70165_t - (double)x) > 3.0 || Math.abs(entityplayer.field_70163_u - (double)y) > 2.0 || Math.abs(entityplayer.field_70161_v - (double)z) > 3.0) {
            return false;
        }
        double d0 = 9.0;
        double d2 = 5.0;
        List list = entityplayer.field_70170_p.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)((double)x - 9.0), (double)((double)y - 5.0), (double)((double)z - 9.0), (double)((double)x + 9.0), (double)((double)y + 5.0), (double)((double)z + 9.0)));
        if (!list.isEmpty()) {
            entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.notSafe", new Object[0]));
            return false;
        }
        return true;
    }

    public boolean setBlockSleepingBag(ItemStack itemstack, EntityPlayer entityplayer, World world, int side, int x, int y, int z, int dir, Integer offsetX, Integer offsetZ) {
        BlockSleepingBag blockbed = ItemsRegister.sleepingBagBlock;
        if (offsetZ == 1) {
            dir = 0;
        } else if (offsetX == -1) {
            dir = 1;
        } else if (offsetZ == -1) {
            dir = 2;
        } else if (offsetX == 1) {
            dir = 3;
        }
        world.func_147465_d(x, y, z, (Block)blockbed, dir, 3);
        if (world.func_147439_a(x, y, z) == blockbed) {
            world.func_147465_d(x + offsetX, y, z + offsetZ, (Block)blockbed, dir + 8, 3);
        }
        if (!this.canPlayerSleep(world, entityplayer, x, y, z)) {
            if (world.func_147439_a(x, y, z) == blockbed) {
                world.func_147468_f(x, y, z);
            }
            if (world.func_147439_a(x + offsetX, y, z + offsetZ) == blockbed) {
                world.func_147468_f(x + offsetX, y, z + offsetZ);
            }
            return false;
        }
        --itemstack.field_77994_a;
        ItemSleepingBag.storeOriginalPosition(entityplayer, x, y, z);
        return true;
    }

    private static void storeOriginalPosition(EntityPlayer entity, int x, int y, int z) {
        if (entity != null) {
            ExtendedPlayer ep = ExtendedPlayer.get(entity);
            ep.setSleepingFlag(1);
            ep.setBedCoord(new ChunkCoordinates(x, y, z));
            ep.setLastCoord(new ChunkCoordinates((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v));
            ep.setlastSpawnCoord(entity.getBedLocation(entity.field_70170_p.field_73011_w.field_76574_g));
        }
    }
}

