/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mantle.utils.ItemMetaWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import tconstruct.library.crafting.Smeltery;
import tconstruct.plugins.nei.RecipeHandlerBase;

public class RecipeHandlerMelting
extends RecipeHandlerBase {
    public static final Rectangle MOLTEN_TANK = new Rectangle(115, 20, 18, 18);

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tconstruct.nei.melting");
    }

    @Override
    public String getRecipeID() {
        return "tconstruct.smeltery.melting";
    }

    public String getGuiTexture() {
        return "tinker:textures/gui/nei/smeltery.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 20, 16, 34), this.getRecipeID(), new Object[0]));
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)160, (int)55);
    }

    public void drawExtras(int recipe) {
        int temperature = ((CachedMeltingRecipe)((Object)this.arecipes.get(recipe))).temperature;
        GuiDraw.drawStringC((String)(temperature + " C"), (int)81, (int)9, (int)0x808080, (boolean)false);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeID())) {
            for (ItemMetaWrapper key : Smeltery.getSmeltingList().keySet()) {
                this.arecipes.add(new CachedMeltingRecipe(new ItemStack(key.item, 1, key.meta.intValue())));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (Map.Entry<ItemMetaWrapper, FluidStack> pair : Smeltery.getSmeltingList().entrySet()) {
            if (!RecipeHandlerMelting.areFluidsEqual(pair.getValue(), result)) continue;
            this.arecipes.add(new CachedMeltingRecipe(new ItemStack(pair.getKey().item, 1, pair.getKey().meta.intValue())));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        for (ItemMetaWrapper key : Smeltery.getSmeltingList().keySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack(key.item, 1, key.meta.intValue()), (ItemStack)ingred)) continue;
            this.arecipes.add(new CachedMeltingRecipe(new ItemStack(key.item, 1, key.meta.intValue())));
        }
    }

    public class CachedMeltingRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        private final PositionedStack input;
        private final int temperature;
        private final RecipeHandlerBase.FluidTankElement output;

        public CachedMeltingRecipe(ItemStack input) {
            super(RecipeHandlerMelting.this);
            this.input = new PositionedStack((Object)input, 28, 21);
            this.temperature = Smeltery.getLiquifyTemperature(input);
            this.output = new RecipeHandlerBase.FluidTankElement(MOLTEN_TANK, 1, Smeltery.getSmelteryResult(input));
            this.output.capacity = this.output.fluid != null ? this.output.fluid.amount : 1000;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public List<RecipeHandlerBase.FluidTankElement> getFluidTanks() {
            ArrayList<RecipeHandlerBase.FluidTankElement> tanks = new ArrayList<RecipeHandlerBase.FluidTankElement>();
            tanks.add(this.output);
            return tanks;
        }
    }
}

