/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.EnumNotificationLocation;
import serverutils.client.EnumSidebarButtonPlacement;
import serverutils.lib.math.Ticks;

public class ServerUtilitiesClientConfig {
    public static Configuration config;
    public static ServerUtilitiesClientConfig INST;
    public static final String CLIENT_LANG_KEY = "serverutilities_client.";
    public static final General general;
    public static boolean item_ore_names;
    public static boolean item_nbt;
    public static EnumSidebarButtonPlacement sidebar_buttons;
    public static boolean sidebar_buttons_above_potion;
    public static boolean sidebar_buttons_vertical;
    public static String[] sidebar_buttons_locations;
    public static EnumNotificationLocation notifications;
    public static String[] notification_locations;
    public static boolean show_dotted_lines;

    public static void init(FMLPreInitializationEvent event) {
        config = new Configuration(new File(event.getModConfigurationDirectory() + "/../" + "serverutilities/client/" + "serverutilities.cfg"));
        config.load();
        ServerUtilitiesClientConfig.sync();
    }

    public static boolean sync() {
        config.setCategoryLanguageKey("general", "serverutilities_client.general");
        item_ore_names = config.get("general", "item_ore_names", false, "Show item Ore Dictionary names in inventory.").setLanguageKey("serverutilities_client.item_ore_names").getBoolean();
        item_nbt = config.get("general", "item_nbt", false, "Show item NBT in inventory.").setLanguageKey("serverutilities_client.item_nbt").getBoolean();
        sidebar_buttons = EnumSidebarButtonPlacement.string2placement(config.get("general", "sidebar_buttons", "auto", "DISABLED: Buttons are hidden.\nTOP_LEFT: Buttons are placed on top-left corner, where NEI has its buttons.\nINVENTORY_SIDE: Buttons are placed on the left side of your inventory.\nAUTO: When NEI is installed, INVENTORY_SIDE, else TOP_LEFT.").setLanguageKey("serverutilities_client.sidebar_buttons").setValidValues(sidebar_buttons_locations).getString());
        notifications = EnumNotificationLocation.string2placement(config.get("general", "notification_location", "SCREEN", "SCREEN: Receive notifications as normal above the hotbar.\nCHAT: Convert all non-important notifications to chat messages.\nDISABLED: Disable non-important notifications entirely.").setLanguageKey("serverutilities_client.notification_location").setValidValues(notification_locations).getString());
        sidebar_buttons_above_potion = config.get("general", "sidebar_buttons_above_potion", false, "Move buttons above potion effect label whenever an effect is active.").setLanguageKey("serverutilities_client.sidebar_buttons_above_potion").getBoolean();
        sidebar_buttons_vertical = config.get("general", "sidebar_buttons_vertical", false, "Draw sidebar buttons in a vertical line.").setLanguageKey("serverutilities_client.sidebar_buttons_vertical").getBoolean();
        show_dotted_lines = config.get("general", "show_dotted_lines", true, "Draw dotted lines on loaded chunks to improve noticeability.").setLanguageKey("serverutilities_client.show_dotted_lines").getBoolean();
        general.show_shutdown_timer_ms = -1L;
        ServerUtilitiesClientConfig.general.journeymap_overlay = config.get("general", "journeymap_overlay", true, "Enable JourneyMap overlay. Requires VisualProspecting installed. Changes will apply after restart.").getBoolean();
        ServerUtilitiesClientConfig.general.show_shutdown_timer = config.get("general", "show_shutdown_timer", true, "Show when server will shut down in corner.").setLanguageKey("serverutilities_client.show_shutdown_timer").getBoolean();
        ServerUtilitiesClientConfig.general.shutdown_timer_start = config.get("general", "shutdown_timer_start", "1m", "When will it start to show the shutdown timer.").setLanguageKey("serverutilities_client.shutdown_timer_start").getString();
        ServerUtilitiesClientConfig.general.button_daytime = config.get("general", "button_daytime", 6000, "", 0, 23999).setLanguageKey("serverutilities_client.button_daytime").getInt();
        ServerUtilitiesClientConfig.general.button_nighttime = config.get("general", "button_nighttime", 18000, "", 0, 239999).setLanguageKey("serverutilities_client.button_nighttime").getInt();
        config.save();
        return true;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("serverutilities")) {
            ServerUtilitiesClientConfig.sync();
            ServerUtilitiesConfig.sync();
        }
    }

    static {
        INST = new ServerUtilitiesClientConfig();
        general = new General();
        sidebar_buttons_locations = new String[]{"DISABLED", "TOP_LEFT", "INVENTORY_SIDE", "AUTO"};
        notification_locations = new String[]{"SCREEN", "CHAT", "DISABLED"};
    }

    public static class General {
        public boolean journeymap_overlay;
        public boolean show_shutdown_timer;
        public String shutdown_timer_start;
        private long show_shutdown_timer_ms = -1L;
        public int button_daytime;
        public int button_nighttime;

        public long getShowShutdownTimer() {
            if (this.show_shutdown_timer_ms == -1L) {
                this.show_shutdown_timer_ms = Ticks.get(this.shutdown_timer_start).millis();
            }
            return this.show_shutdown_timer_ms;
        }
    }
}

