/*
 * Decompiled with CFR 0.152.
 */
package serverutils.handlers;

import codechicken.nei.GuiExtendedCreativeInv;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.EnumSidebarButtonPlacement;
import serverutils.client.ServerUtilitiesClient;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.GuiClaimedChunks;
import serverutils.client.gui.GuiClientConfig;
import serverutils.client.gui.SidebarButton;
import serverutils.client.gui.SidebarButtonGroup;
import serverutils.client.gui.SidebarButtonManager;
import serverutils.events.chunks.UpdateClientDataEvent;
import serverutils.events.client.CustomClickEvent;
import serverutils.integration.vp.VPIntegration;
import serverutils.lib.OtherMods;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.Widget;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.IconRenderer;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.InvUtils;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.SidedUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.Notification;
import serverutils.net.MessageAdminPanelGui;
import serverutils.net.MessageClaimedChunksUpdate;
import serverutils.net.MessageEditNBTRequest;
import serverutils.net.MessageLeaderboardList;
import serverutils.net.MessageMyTeamGui;
import serverutils.net.MessageRequestBadge;

public class ServerUtilitiesClientEventHandler {
    public static final ServerUtilitiesClientEventHandler INST = new ServerUtilitiesClientEventHandler();
    private static Temp currentNotification;
    public static Rectangle lastDrawnArea;
    public static boolean shouldRenderIcons;
    private static final Map<UUID, Icon> BADGE_CACHE;
    public static long shutdownTime;

    public static void readSyncData(NBTTagCompound nbt) {
        shutdownTime = System.currentTimeMillis() + nbt.func_74763_f("ShutdownTime");
    }

    public static Icon getBadge(UUID id) {
        Icon tex = BADGE_CACHE.get(id);
        if (tex == null) {
            tex = Icon.EMPTY;
            BADGE_CACHE.put(id, tex);
            new MessageRequestBadge(id).sendToServer();
        }
        return tex;
    }

    public static void setBadge(UUID id, String url) {
        BADGE_CACHE.put(id, Icon.getIcon(url));
    }

    @SubscribeEvent
    public void onClientDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        BADGE_CACHE.clear();
        shutdownTime = 0L;
        SidedUtils.SERVER_MODS.clear();
        if (OtherMods.isVPLoaded()) {
            VPIntegration.CLAIMS.clear();
        }
    }

    @SubscribeEvent
    public void onClientWorldTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71441_e != null && mc.field_71441_e.field_73011_w.field_76574_g == ServerUtilitiesConfig.world.spawn_dimension) {
            if (ServerUtilitiesConfig.world.forced_spawn_dimension_time != -1) {
                mc.field_71441_e.func_72877_b((long)ServerUtilitiesConfig.world.forced_spawn_dimension_time);
            }
            if (ServerUtilitiesConfig.world.forced_spawn_dimension_weather != -1) {
                mc.field_71441_e.func_72912_H().func_76084_b(ServerUtilitiesConfig.world.forced_spawn_dimension_weather >= 1);
                mc.field_71441_e.func_72912_H().func_76069_a(ServerUtilitiesConfig.world.forced_spawn_dimension_weather >= 2);
            }
        }
    }

    @SubscribeEvent
    public void onChunkDataUpdate(UpdateClientDataEvent event) {
        MessageClaimedChunksUpdate message = event.getMessage();
        GuiClaimedChunks.onChunkDataUpdate(message);
        if (OtherMods.isVPLoaded()) {
            VPIntegration.onChunkDataUpdate(message);
        }
    }

    @SubscribeEvent
    public void onDebugInfoEvent(RenderGameOverlayEvent.Text event) {
        long timeLeft;
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        if (shutdownTime > 0L && ServerUtilitiesClientConfig.general.show_shutdown_timer && (timeLeft = Math.max(0L, shutdownTime - System.currentTimeMillis())) > 0L && timeLeft <= ServerUtilitiesClientConfig.general.getShowShutdownTimer()) {
            event.left.add(EnumChatFormatting.DARK_RED + I18n.func_135052_a((String)"serverutilities.lang.timer.shutdown", (Object[])new Object[]{StringUtils.getTimeString(timeLeft)}));
        }
        if (ServerUtilitiesConfig.world.show_playtime) {
            event.left.add(StatList.field_75948_k.func_150951_e().func_150260_c() + ": " + Ticks.get(Minecraft.func_71410_x().field_71439_g.func_146107_m().func_77444_a(StatList.field_75948_k)).toTimeString());
        }
    }

    @SubscribeEvent
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (ServerUtilitiesClient.KEY_NBT.func_151468_f()) {
            MessageEditNBTRequest.editNBT();
        }
        if (ServerUtilitiesClient.KEY_TRASH.func_151468_f()) {
            ClientUtils.execClientCommand("/trash_can");
        }
    }

    @SubscribeEvent
    public void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("serverutilities")) {
            switch (event.getID().func_110623_a()) {
                case "client_config_gui": {
                    new GuiClientConfig().openGui();
                    break;
                }
                case "my_team_gui": {
                    new MessageMyTeamGui().sendToServer();
                    break;
                }
                case "admin_panel_gui": {
                    new MessageAdminPanelGui().sendToServer();
                    break;
                }
                case "toggle_gamemode": {
                    ClientUtils.execClientCommand("/gamemode " + (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d ? "survival" : "creative"));
                    break;
                }
                case "daytime": {
                    long addDay = (24000L - Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L + (long)ServerUtilitiesClientConfig.general.button_daytime) % 24000L;
                    if (addDay == 0L) break;
                    ClientUtils.execClientCommand("/time add " + addDay);
                    break;
                }
                case "nighttime": {
                    long addNight = (24000L - Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L + (long)ServerUtilitiesClientConfig.general.button_nighttime) % 24000L;
                    if (addNight == 0L) break;
                    ClientUtils.execClientCommand("/time add " + addNight);
                    break;
                }
                case "claims_gui": {
                    GuiClaimedChunks.instance = new GuiClaimedChunks();
                    GuiClaimedChunks.instance.openGui();
                    break;
                }
                case "leaderboards_gui": {
                    new MessageLeaderboardList().sendToServer();
                }
            }
            event.setCanceled(true);
        }
    }

    public void onNotify(IChatComponent component) {
        Notification noti;
        boolean importantNotification;
        boolean bl = importantNotification = component instanceof Notification && (noti = (Notification)component).isImportant();
        if (ServerUtilitiesClientConfig.notifications.disabled() && !importantNotification) {
            return;
        }
        if (ServerUtilitiesClientConfig.notifications.chat() && !importantNotification) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a(component);
        } else if (component instanceof Notification) {
            Notification notification = (Notification)component;
            ResourceLocation id = notification.getId();
            if (notification.isVanilla()) {
                Minecraft.func_71410_x().field_71456_v.func_110326_a(component.func_150254_d(), false);
                return;
            }
            Temp.MAP.remove(id);
            if (currentNotification != null && ((Temp)ServerUtilitiesClientEventHandler.currentNotification).widget.id.equals((Object)id)) {
                currentNotification = null;
            }
            Temp.MAP.put(id, notification);
        }
    }

    @SubscribeEvent
    public void onClientChatEvent(ClientChatReceivedEvent event) {
        IChatComponent component = event.message;
        if (component instanceof Notification) {
            Notification notification = (Notification)component;
            this.onNotify((IChatComponent)notification);
            event.message = null;
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        Set<String> ores;
        if (ServerUtilitiesClientConfig.item_ore_names && !(ores = InvUtils.getOreNames(null, event.itemStack)).isEmpty()) {
            event.toolTip.add(I18n.func_135052_a((String)"serverutilities_client.item_ore_names.item_tooltip", (Object[])new Object[0]));
            for (String or : ores) {
                event.toolTip.add("> " + or);
            }
        }
        if (ServerUtilitiesClientConfig.item_nbt && GuiScreen.func_146272_n()) {
            NBTTagCompound nbt;
            NBTTagCompound nBTTagCompound = nbt = Widget.isAltKeyDown() ? event.itemStack.func_77955_b(new NBTTagCompound()) : event.itemStack.func_77978_p();
            if (nbt != null) {
                event.toolTip.add(NBTUtils.getColoredNBTString((NBTBase)nbt));
            }
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (ServerUtilitiesClientEventHandler.areButtonsVisible(event.gui)) {
            event.buttonList.add(new GuiButtonSidebarGroup((GuiContainer)event.gui));
        }
    }

    public static boolean areButtonsVisible(@Nullable GuiScreen gui) {
        return ServerUtilitiesClientConfig.sidebar_buttons != EnumSidebarButtonPlacement.DISABLED && (gui instanceof InventoryEffectRenderer || ServerUtilitiesClientEventHandler.isCreativePlusGui(gui)) && !SidebarButtonManager.INSTANCE.groups.isEmpty();
    }

    private static boolean isCreativePlusGui(GuiScreen gui) {
        if (OtherMods.isNEILoaded()) {
            return gui instanceof GuiExtendedCreativeInv;
        }
        return false;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (Minecraft.func_71410_x().field_71441_e == null) {
                currentNotification = null;
                Temp.MAP.clear();
            }
            if (currentNotification != null && ServerUtilitiesClientEventHandler.currentNotification.tick()) {
                currentNotification = null;
            }
            if (currentNotification == null && !Temp.MAP.isEmpty()) {
                currentNotification = new Temp((IChatComponent)Temp.MAP.values().iterator().next());
                Temp.MAP.remove(((Temp)ServerUtilitiesClientEventHandler.currentNotification).widget.id);
            }
        } else if (event.phase == TickEvent.Phase.END && !ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onGameOverlayRender(RenderGameOverlayEvent.Text event) {
        if (currentNotification != null && !ServerUtilitiesClientEventHandler.currentNotification.isImportant()) {
            currentNotification.render(event.resolution, event.partialTicks);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.enableTexture2D();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (shouldRenderIcons) {
                IconRenderer.render();
            }
        } else if (currentNotification != null && ServerUtilitiesClientEventHandler.currentNotification.isImportant()) {
            Minecraft mc = Minecraft.func_71410_x();
            currentNotification.render(new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d), event.renderTickTime);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.enableTexture2D();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onFrameStart(TickEvent.RenderTickEvent e) {
    }

    static {
        lastDrawnArea = new Rectangle();
        shouldRenderIcons = false;
        BADGE_CACHE = new HashMap<UUID, Icon>();
        shutdownTime = 0L;
    }

    private static class Temp {
        private static final LinkedHashMap<ResourceLocation, IChatComponent> MAP = new LinkedHashMap();
        private long tick;
        private long endTick;
        private NotificationWidget widget;

        private Temp(IChatComponent n) {
            this.widget = new NotificationWidget(n, Minecraft.func_71410_x().field_71466_p);
            this.endTick = -1L;
            this.tick = -1L;
        }

        public void render(ScaledResolution screen, float partialTicks) {
            if (this.tick == -1L || this.tick >= this.endTick) {
                return;
            }
            int alpha = (int)Math.min(255.0f, ((float)(this.endTick - this.tick) - partialTicks) * 255.0f / 20.0f);
            if (alpha <= 2) {
                return;
            }
            GlStateManager.pushMatrix();
            GlStateManager.translate((int)((float)screen.func_78326_a() / 2.0f), (int)((float)screen.func_78328_b() - 67.0f), 0.0f);
            GlStateManager.disableDepth();
            GlStateManager.depthMask(false);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            int offy = -(this.widget.text.size() * 11) / 2;
            for (int i = 0; i < this.widget.text.size(); ++i) {
                String string = this.widget.text.get(i);
                this.widget.font.func_78261_a(string, (int)((float)(-this.widget.font.func_78256_a(string)) / 2.0f), offy + i * 11, 0xFFFFFF | alpha << 24);
            }
            GlStateManager.depthMask(true);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
            GlStateManager.enableDepth();
        }

        private boolean tick() {
            this.tick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            if (this.endTick == -1L) {
                this.endTick = this.tick + this.widget.timer;
            }
            return this.tick >= this.endTick || Math.min(255.0f, (float)(this.endTick - this.tick) * 255.0f / 20.0f) <= 2.0f;
        }

        private boolean isImportant() {
            return this.widget.notification instanceof Notification && ((Notification)this.widget.notification).isImportant();
        }
    }

    public static class NotificationWidget {
        public final IChatComponent notification;
        public final ResourceLocation id;
        public final List<String> text;
        public int width;
        public int height;
        public final FontRenderer font;
        public final long timer;

        public NotificationWidget(IChatComponent n, FontRenderer f) {
            String s0;
            this.notification = n;
            this.id = n instanceof Notification ? ((Notification)n).getId() : Notification.VANILLA_STATUS;
            this.width = 0;
            this.font = f;
            this.text = new ArrayList<String>();
            this.timer = n instanceof Notification ? ((Notification)n).getTimer().ticks() : 60L;
            try {
                s0 = this.notification.func_150254_d();
            }
            catch (Exception ex) {
                s0 = EnumChatFormatting.RED + ex.toString();
            }
            Minecraft mc = Minecraft.func_71410_x();
            for (String s : this.font.func_78271_c(s0, new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d).func_78326_a())) {
                for (String line : s.split("\n")) {
                    if (line.isEmpty()) continue;
                    line = line.trim();
                    this.text.add(line);
                    this.width = Math.max(this.width, this.font.func_78256_a(line));
                }
            }
            this.width += 4;
            this.height = this.text.size() * 11;
            if (this.text.isEmpty()) {
                this.width = 20;
                this.height = 20;
            }
        }
    }

    private static class GuiButtonSidebarGroup
    extends GuiButton {
        private final GuiContainer gui;
        public final List<GuiButtonSidebar> buttons;
        private GuiButtonSidebar mouseOver;

        public GuiButtonSidebarGroup(GuiContainer g) {
            super(495829, 0, 0, 0, 0, "");
            this.gui = g;
            this.buttons = new ArrayList<GuiButtonSidebar>();
        }

        /*
         * WARNING - void declaration
         */
        public void func_146112_a(Minecraft mc, int mx, int my) {
            void var13_30;
            this.buttons.clear();
            this.mouseOver = null;
            int rx = 0;
            int ry = 0;
            boolean top = ServerUtilitiesClientConfig.sidebar_buttons.top();
            boolean above = ServerUtilitiesClientConfig.sidebar_buttons.above();
            boolean vertical = ServerUtilitiesClientConfig.sidebar_buttons.vertical();
            for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
                if (above && !ServerUtilitiesClientEventHandler.isCreativePlusGui((GuiScreen)this.gui)) {
                    for (SidebarButton sidebarButton : group.getButtons()) {
                        if (!sidebarButton.isActuallyVisible()) continue;
                        this.buttons.add(new GuiButtonSidebar(rx, ry, sidebarButton));
                        if (++ry < 7) continue;
                        ry = 0;
                        --rx;
                    }
                    continue;
                }
                if (vertical) {
                    for (SidebarButton sidebarButton : group.getButtons()) {
                        if (!sidebarButton.isActuallyVisible()) continue;
                        this.buttons.add(new GuiButtonSidebar(rx, ry, sidebarButton));
                        if (++rx < 9) continue;
                        rx = 0;
                        ++ry;
                    }
                    continue;
                }
                rx = 0;
                boolean addedAny = false;
                for (SidebarButton sidebarButton : group.getButtons()) {
                    if (!sidebarButton.isActuallyVisible()) continue;
                    this.buttons.add(new GuiButtonSidebar(rx, ry, sidebarButton));
                    ++rx;
                    addedAny = true;
                }
                if (!addedAny) continue;
                ++ry;
            }
            int guiLeft = this.gui.field_147003_i;
            int guiTop = this.gui.field_147009_r;
            if (top) {
                for (GuiButtonSidebar guiButtonSidebar : this.buttons) {
                    guiButtonSidebar.x = 1 + guiButtonSidebar.buttonX * 17;
                    guiButtonSidebar.y = 1 + guiButtonSidebar.buttonY * 17;
                }
            } else {
                int n;
                int offsetX = 18;
                int n2 = 8;
                if (this.gui instanceof GuiContainerCreative) {
                    int n3 = 6;
                }
                if (above) {
                    offsetX = 22;
                    int n4 = -18;
                }
                if (ServerUtilitiesClientEventHandler.isCreativePlusGui((GuiScreen)this.gui)) {
                    n = 22;
                    offsetX = 41;
                }
                for (GuiButtonSidebar button : this.buttons) {
                    button.x = guiLeft - offsetX - button.buttonY * 17;
                    button.y = guiTop + n + button.buttonX * 17;
                }
            }
            int x = Integer.MAX_VALUE;
            int n = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (GuiButtonSidebar guiButtonSidebar : this.buttons) {
                if (guiButtonSidebar.x >= 0 && guiButtonSidebar.y >= 0) {
                    int n5;
                    x = Math.min(x, guiButtonSidebar.x);
                    n5 = Math.min(n5, guiButtonSidebar.y);
                    maxX = Math.max(maxX, guiButtonSidebar.x + 16);
                    maxY = Math.max(maxY, guiButtonSidebar.y + 16);
                }
                if (mx < guiButtonSidebar.x || my < guiButtonSidebar.y || mx >= guiButtonSidebar.x + 16 || my >= guiButtonSidebar.y + 16) continue;
                this.mouseOver = guiButtonSidebar;
            }
            this.field_146120_f = (maxX += 2) - (x -= 2);
            this.field_146121_g = (maxY += 2) - (var13_30 -= 2);
            this.field_73735_i = 0.0f;
            this.field_146128_h = x;
            this.field_146129_i = var13_30;
            GlStateManager.pushMatrix();
            GlStateManager.translate(0.0f, 0.0f, 500.0f);
            FontRenderer font = mc.field_71466_p;
            GlStateManager.enableBlend();
            GlStateManager.enableDepth();
            GlStateManager.blendFunc(770, 771);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            for (GuiButtonSidebar b : this.buttons) {
                String text;
                b.button.getIcon().draw(b.x, b.y, 16, 16);
                if (b == this.mouseOver) {
                    Color4I.WHITE.withAlpha(33).draw(b.x, b.y, 16, 16);
                }
                if (b.button.getCustomTextHandler() == null || (text = b.button.getCustomTextHandler().get()).isEmpty()) continue;
                int nw = font.func_78256_a(text);
                int width = 16;
                Color4I.LIGHT_RED.draw(b.x + width - nw, b.y - 1, nw + 1, 9);
                font.func_78276_b(text, b.x + width - nw + 1, b.y, -1);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (this.mouseOver != null) {
                int n6 = mx + 10;
                int my1 = Math.max(3, my - 9);
                ArrayList<String> list = new ArrayList<String>();
                list.add(I18n.func_135052_a((String)this.mouseOver.button.getLangKey(), (Object[])new Object[0]));
                if (this.mouseOver.button.getTooltipHandler() != null) {
                    this.mouseOver.button.getTooltipHandler().accept(list);
                }
                int tw = 0;
                for (String s : list) {
                    tw = Math.max(tw, font.func_78256_a(s));
                }
                GlStateManager.pushMatrix();
                GlStateManager.translate(0.0f, 0.0f, 500.0f);
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(770, 771);
                Color4I.DARK_GRAY.draw(n6 - 3, my1 - 2, tw + 6, 2 + list.size() * 10);
                for (int i = 0; i < list.size(); ++i) {
                    font.func_78276_b((String)list.get(i), n6, my1 + i * 10, -1);
                }
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                GlStateManager.popMatrix();
            }
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.disableDepth();
            GlStateManager.popMatrix();
            this.field_73735_i = 0.0f;
            lastDrawnArea = new Rectangle(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        }

        public boolean func_146116_c(Minecraft mc, int mx, int my) {
            if (super.func_146116_c(mc, mx, my)) {
                if (this.mouseOver != null) {
                    this.mouseOver.button.onClicked(GuiScreen.func_146272_n());
                }
                return true;
            }
            return false;
        }
    }

    private static class GuiButtonSidebar {
        public final int buttonX;
        public final int buttonY;
        public final SidebarButton button;
        public int x;
        public int y;

        public GuiButtonSidebar(int x, int y, SidebarButton b) {
            this.buttonX = x;
            this.buttonY = y;
            this.button = b;
        }
    }
}

