/*
 * Decompiled with CFR 0.152.
 */
package serverutils.integration.vp;

import com.sinthoras.visualprospecting.VisualProspecting_API;
import com.sinthoras.visualprospecting.integration.journeymap.buttons.LayerButton;
import com.sinthoras.visualprospecting.integration.journeymap.render.LayerRenderer;
import com.sinthoras.visualprospecting.integration.model.buttons.ButtonManager;
import com.sinthoras.visualprospecting.integration.model.layers.LayerManager;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.integration.vp.VPButtonManager;
import serverutils.integration.vp.VPLayerManager;
import serverutils.integration.vp.journeymap.VPClaimsRenderer;
import serverutils.integration.vp.journeymap.VPLayerButton;
import serverutils.lib.math.ChunkDimPos;
import serverutils.net.MessageClaimedChunksUpdate;
import serverutils.net.MessageJourneyMapUpdate;
import serverutils.shadow.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import serverutils.shadow.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;

public class VPIntegration {
    public static final Object2ObjectMap<ChunkDimPos, ClientClaimedChunks.ChunkData> CLAIMS = new Object2ObjectOpenHashMap<ChunkDimPos, ClientClaimedChunks.ChunkData>();
    public static ClientClaimedChunks.ChunkData OWNTEAM = null;
    public static int maxClaimedChunks;
    public static int currentClaimedChunks;

    public static void init() {
        VisualProspecting_API.LogicalClient.registerCustomButtonManager((ButtonManager)VPButtonManager.INSTANCE);
        VisualProspecting_API.LogicalClient.registerJourneyMapButton((LayerButton)VPLayerButton.INSTANCE);
        VisualProspecting_API.LogicalClient.registerCustomLayer((LayerManager)VPLayerManager.INSTANCE);
        VisualProspecting_API.LogicalClient.registerJourneyMapRenderer((LayerRenderer)VPClaimsRenderer.INSTANCE);
    }

    public static void updateMap(MessageJourneyMapUpdate message) {
        for (ClientClaimedChunks.Team team : message.teams.values()) {
            CLAIMS.putAll(team.chunkPos);
            if (OWNTEAM != null || !team.isMember) continue;
            OWNTEAM = ((ClientClaimedChunks.ChunkData)team.chunkPos.values().iterator().next()).copy().setLoaded(false);
        }
        VPLayerManager.INSTANCE.forceRefresh();
    }

    public static void addToOwnTeam(ChunkDimPos pos) {
        if (OWNTEAM == null) {
            return;
        }
        if (currentClaimedChunks >= maxClaimedChunks) {
            return;
        }
        CLAIMS.put(pos, OWNTEAM);
        VPLayerManager.INSTANCE.forceRefresh();
    }

    public static void onChunkDataUpdate(MessageClaimedChunksUpdate message) {
        maxClaimedChunks = message.maxClaimedChunks;
        currentClaimedChunks = message.claimedChunks;
    }
}

