/*
 * Decompiled with CFR 0.152.
 */
package serverutils.integration.vp;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.integration.model.buttons.ButtonManager;
import com.sinthoras.visualprospecting.integration.model.layers.WaypointProviderManager;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import journeymap.client.model.BlockCoordIntPair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.world.ChunkCoordIntPair;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.integration.vp.VPButtonManager;
import serverutils.integration.vp.VPClaimsLocation;
import serverutils.integration.vp.VPIntegration;
import serverutils.lib.math.ChunkDimPos;
import serverutils.net.MessageClaimedChunksModify;
import serverutils.net.MessageJourneyMapRequest;

public class VPLayerManager
extends WaypointProviderManager {
    public static final VPLayerManager INSTANCE = new VPLayerManager();
    private int oldMinBlockX = 0;
    private int oldMinBlockZ = 0;
    private int oldMaxBlockX = 0;
    private int oldMaxBlockZ = 0;
    private long lastRequest = 0L;

    public VPLayerManager() {
        super((ButtonManager)VPButtonManager.INSTANCE);
    }

    public boolean doActionOutsideLayer(BlockCoordIntPair blockCoord) {
        Minecraft mc = Minecraft.func_71410_x();
        int selectionMode = 0;
        int blockX = blockCoord.x;
        int blockZ = blockCoord.z;
        int chunkX = Utils.coordBlockToChunk((int)blockX);
        int chunkZ = Utils.coordBlockToChunk((int)blockZ);
        Set<ChunkCoordIntPair> chunk = Collections.singleton(new ChunkCoordIntPair(chunkX, chunkZ));
        ChunkDimPos chunkDimPos = new ChunkDimPos(chunkX, chunkZ, mc.field_71439_g.field_71093_bK);
        new MessageClaimedChunksModify(chunkX, chunkZ, selectionMode, chunk).sendToServer();
        if (VPIntegration.OWNTEAM == null) {
            new MessageJourneyMapRequest(blockX, blockX, blockZ, blockZ).sendToServer();
        } else {
            VPIntegration.addToOwnTeam(chunkDimPos);
        }
        return true;
    }

    protected boolean needsRegenerateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        if (minBlockX != this.oldMinBlockX || minBlockZ != this.oldMinBlockZ || maxBlockX != this.oldMaxBlockX || maxBlockZ != this.oldMaxBlockZ) {
            this.oldMinBlockX = minBlockX;
            this.oldMinBlockZ = minBlockZ;
            this.oldMaxBlockX = maxBlockX;
            this.oldMaxBlockZ = maxBlockZ;
            if (System.currentTimeMillis() - this.lastRequest >= TimeUnit.SECONDS.toMillis(10L)) {
                this.lastRequest = System.currentTimeMillis();
                new MessageJourneyMapRequest(minBlockX, maxBlockX, minBlockZ, maxBlockZ).sendToServer();
            }
            return true;
        }
        return false;
    }

    protected List<? extends IWaypointAndLocationProvider> generateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int minX = Utils.coordBlockToChunk((int)minBlockX);
        int minZ = Utils.coordBlockToChunk((int)minBlockZ);
        int maxX = Utils.coordBlockToChunk((int)maxBlockX);
        int maxZ = Utils.coordBlockToChunk((int)maxBlockZ);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ArrayList<VPClaimsLocation> locations = new ArrayList<VPClaimsLocation>();
        for (Map.Entry entry : VPIntegration.CLAIMS.entrySet()) {
            boolean withinRange;
            ChunkDimPos key = (ChunkDimPos)entry.getKey();
            ClientClaimedChunks.ChunkData value = (ClientClaimedChunks.ChunkData)entry.getValue();
            boolean bl = withinRange = key.posX >= minX && key.posX <= maxX && key.posZ >= minZ && key.posZ <= maxZ && key.dim == player.field_71093_bK;
            if (!withinRange) continue;
            locations.add(new VPClaimsLocation(key, value));
        }
        return locations;
    }
}

