/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.command;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.DimensionManager;
import serverutils.ServerUtilities;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.math.MathUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.permission.PermissionAPI;

public class CommandUtils {
    public static CommandException error(IChatComponent component) {
        return new CommandException("disconnect.genericReason", new Object[]{component});
    }

    public static ForgePlayer getForgePlayer(ICommandSender sender) throws CommandException {
        ForgePlayer p = Universe.get().getPlayer(sender);
        if (p.isFake()) {
            throw new CommandException("commands.generic.player.notFound", new Object[]{sender.func_70005_c_()});
        }
        return p;
    }

    public static ForgePlayer getForgePlayer(ICommandSender sender, String name) throws CommandException {
        ForgePlayer p;
        switch (name) {
            case "@r": {
                ForgePlayer[] players = Universe.get().getOnlinePlayers().toArray(new ForgePlayer[0]);
                p = players.length == 0 ? null : players[MathUtils.RAND.nextInt(players.length)];
                break;
            }
            case "@ra": {
                ForgePlayer[] players = Universe.get().getPlayers().toArray(new ForgePlayer[0]);
                p = players.length == 0 ? null : players[MathUtils.RAND.nextInt(players.length)];
                break;
            }
            case "@p": {
                EntityPlayerMP playerMP;
                if (sender instanceof EntityPlayerMP && !ServerUtils.isFake(playerMP = (EntityPlayerMP)sender)) {
                    return Universe.get().getPlayer(sender);
                }
                p = null;
                double dist = Double.POSITIVE_INFINITY;
                for (ForgePlayer p1 : Universe.get().getOnlinePlayers()) {
                    if (p == null) {
                        p = p1;
                        continue;
                    }
                    ChunkCoordinates pos = sender.func_82114_b();
                    double d = p1.getPlayer().func_70092_e((double)pos.field_71574_a, (double)pos.field_71572_b, (double)pos.field_71573_c);
                    if (!(d < dist)) continue;
                    dist = d;
                    p = p1;
                }
                break;
            }
            default: {
                EntityPlayerMP e = PlayerSelector.func_82386_a((ICommandSender)sender, (String)name);
                p = e == null ? Universe.get().getPlayer(name) : Universe.get().getPlayer((ICommandSender)e);
            }
        }
        if (p == null || p.isFake()) {
            throw new CommandException("commands.generic.player.notFound", new Object[]{name});
        }
        return p;
    }

    public static ForgeTeam getTeam(ICommandSender sender, String id) throws CommandException {
        ForgeTeam team = Universe.get().getTeam(id);
        if (team.isValid()) {
            return team;
        }
        throw ServerUtilities.error(sender, "serverutilities.lang.team.error.not_found", id);
    }

    public static ForgePlayer getSelfOrOther(ICommandSender sender, String[] args, int index) throws CommandException {
        return CommandUtils.getSelfOrOther(sender, args, index, "");
    }

    public static ForgePlayer getSelfOrOther(ICommandSender sender, String[] args, int index, String specialPermForOther) throws CommandException {
        if (args.length <= index) {
            return CommandUtils.getForgePlayer(sender);
        }
        ForgePlayer p = CommandUtils.getForgePlayer(sender, args[index]);
        if (!specialPermForOther.isEmpty() && sender instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)sender;
            if (!p.getId().equals(playerMP.func_110124_au()) && !PermissionAPI.hasPermission((EntityPlayer)playerMP, specialPermForOther)) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
        }
        return p;
    }

    public static List<String> getDimensionNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("all");
        list.add("overworld");
        list.add("nether");
        list.add("end");
        for (Integer dim : DimensionManager.getStaticDimensionIDs()) {
            if (dim == null || dim >= -1 && dim <= 1) continue;
            list.add(dim.toString());
        }
        return list;
    }

    public static OptionalInt parseDimension(ICommandSender sender, String[] args, int index) throws CommandException {
        OptionalInt optionalInt;
        if (args.length <= index) {
            return OptionalInt.empty();
        }
        switch (args[index].toLowerCase()) {
            case "overworld": 
            case "0": {
                optionalInt = OptionalInt.of(0);
                break;
            }
            case "nether": 
            case "-1": {
                optionalInt = OptionalInt.of(-1);
                break;
            }
            case "end": 
            case "1": {
                optionalInt = OptionalInt.of(1);
                break;
            }
            case "this": 
            case "~": {
                optionalInt = OptionalInt.of(sender.func_130014_f_().field_73011_w.field_76574_g);
                break;
            }
            case "all": 
            case "*": {
                optionalInt = OptionalInt.empty();
                break;
            }
            default: {
                optionalInt = OptionalInt.of(CommandBase.func_71526_a((ICommandSender)sender, (String)args[index]));
            }
        }
        return optionalInt;
    }
}

