/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import javax.annotation.Nullable;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.data.ServerUtilitiesAPI;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.icon.Icon;
import serverutils.lib.io.Bits;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.util.FinalIDObject;

public final class ConfigValueInstance
extends FinalIDObject {
    private static final int HAS_NAME = 1;
    private static final int HIDDEN = 2;
    private static final int CANT_EDIT = 4;
    private static final int USE_SCROLL_BAR = 8;
    private static final int EXCLUDED = 16;
    private static final int HAS_INFO = 32;
    private final ConfigGroup group;
    private final ConfigValue value;
    private ConfigValue defaultValue;
    private int flags;
    private IChatComponent displayName;
    private IChatComponent info;
    private int order;
    private Icon icon;

    public ConfigValueInstance(String id, ConfigGroup g, ConfigValue v) {
        super(id);
        this.group = g;
        this.value = v;
        this.defaultValue = ConfigNull.INSTANCE;
        this.flags = 0;
        this.displayName = null;
        this.info = null;
        this.order = 0;
        this.icon = GuiIcons.SETTINGS_RED;
    }

    public ConfigValueInstance(ConfigGroup g, DataIn data) {
        super(data.readString());
        this.group = g;
        this.value = ServerUtilitiesAPI.createConfigValueFromId(data.readString());
        this.value.readData(data);
        this.defaultValue = ServerUtilitiesAPI.createConfigValueFromId(data.readString());
        this.defaultValue.readData(data);
        this.flags = data.readVarInt();
        this.order = data.readVarInt();
        this.displayName = Bits.getFlag(this.flags, 1) ? data.readTextComponent() : null;
        this.info = Bits.getFlag(this.flags, 32) ? data.readTextComponent() : null;
    }

    public ConfigGroup getGroup() {
        return this.group;
    }

    public ConfigValue getValue() {
        return this.value;
    }

    public ConfigValueInstance setDefaultValue(ConfigValue def) {
        if (def.isNull()) {
            this.defaultValue = ConfigNull.INSTANCE;
        } else {
            this.defaultValue = this.value.copy();
            this.defaultValue.setValueFromOtherValue(def);
        }
        return this;
    }

    public ConfigValue getDefaultValue() {
        return this.defaultValue;
    }

    public ConfigValueInstance setDisplayName(@Nullable IChatComponent name) {
        this.displayName = name;
        this.flags = Bits.setFlag(this.flags, 1, this.displayName != null);
        return this;
    }

    public IChatComponent getDisplayName() {
        return this.displayName == null ? this.group.getDisplayNameOf(this) : this.displayName;
    }

    public ConfigValueInstance setInfo(@Nullable IChatComponent component) {
        this.info = component;
        this.flags = Bits.setFlag(this.flags, 32, this.info != null);
        return this;
    }

    public IChatComponent getInfo() {
        return this.info == null ? this.group.getInfoOf(this) : this.info;
    }

    public ConfigValueInstance setHidden(boolean v) {
        this.flags = Bits.setFlag(this.flags, 2, v);
        return this;
    }

    public boolean getHidden() {
        return Bits.getFlag(this.flags, 2);
    }

    public ConfigValueInstance setCanEdit(boolean v) {
        this.flags = Bits.setFlag(this.flags, 4, !v);
        return this;
    }

    public boolean getCanEdit() {
        return !Bits.getFlag(this.flags, 4);
    }

    public ConfigValueInstance setUseScrollBar(boolean v) {
        this.flags = Bits.setFlag(this.flags, 8, v);
        return this;
    }

    public boolean getUseScrollBar() {
        return Bits.getFlag(this.flags, 8);
    }

    public ConfigValueInstance setExcluded(boolean v) {
        this.flags = Bits.setFlag(this.flags, 16, v);
        return this;
    }

    public boolean getExcluded() {
        return Bits.getFlag(this.flags, 16);
    }

    public ConfigValueInstance setOrder(int o) {
        this.order = o;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public ConfigValueInstance setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void writeData(DataOut data) {
        data.writeString(this.value.getId());
        this.value.writeData(data);
        data.writeString(this.defaultValue.getId());
        this.defaultValue.writeData(data);
        data.writeVarInt(this.flags);
        data.writeVarInt(this.order);
        if (this.displayName != null) {
            data.writeTextComponent(this.displayName);
        }
        if (this.info != null) {
            data.writeTextComponent(this.info);
        }
    }

    public ConfigValueInstance copy(ConfigGroup g) {
        ConfigValueInstance inst = new ConfigValueInstance(this.getId(), g, this.value.copy());
        inst.defaultValue = this.defaultValue.copy();
        inst.displayName = this.displayName == null ? null : this.displayName.func_150259_f();
        inst.info = this.info == null ? null : this.info.func_150259_f();
        inst.flags = this.flags;
        inst.order = this.order;
        inst.icon = this.icon == null || this.icon.isEmpty() ? Icon.EMPTY : this.icon.copy();
        return inst;
    }

    public String getPath() {
        return this.group.getPath() + "." + this.getId();
    }
}

