/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.NBTUtils;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageUpdateTabName
extends MessageToClient {
    private UUID playerId;
    private String name;
    private IChatComponent displayName;
    private boolean afk;
    private boolean rec;

    public MessageUpdateTabName() {
    }

    public MessageUpdateTabName(EntityPlayerMP player) {
        this.playerId = player.func_110124_au();
        this.name = player.getDisplayName();
        this.displayName = new ChatComponentText(player.getDisplayName());
        this.afk = System.currentTimeMillis() - player.func_154331_x() >= ServerUtilitiesConfig.afk.getNotificationTimer();
        this.rec = NBTUtils.getPersistedData((EntityPlayer)player, false).func_74767_n("recording");
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeUUID(this.playerId);
        data.writeString(this.name);
        data.writeTextComponent(this.displayName);
        data.writeBoolean(this.afk);
        data.writeBoolean(this.rec);
    }

    @Override
    public void readData(DataIn data) {
        this.playerId = data.readUUID();
        this.name = data.readString();
        this.displayName = data.readTextComponent();
        this.afk = data.readBoolean();
        this.rec = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
    }
}

