/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.entity.EntityBaseLaserArrow;
import de.katzenpapst.amunra.item.ItemAbstractBatteryUser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class ItemAbstractRaygun
extends ItemAbstractBatteryUser {
    protected boolean chargeMode = false;

    public ItemAbstractRaygun(String assetName) {
        this.func_77655_b(assetName);
        this.func_111206_d("amunra:" + assetName);
        this.field_77777_bU = 1;
    }

    public CreativeTabs func_77640_w() {
        return AmunRa.arTab;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void func_77615_a(ItemStack p_77615_1_, World p_77615_2_, EntityPlayer p_77615_3_, int p_77615_4_) {
        if (!this.chargeMode) {
            return;
        }
        this.fire(p_77615_1_, p_77615_3_, p_77615_2_);
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || this.getElectricityStored(itemStackIn) >= this.getEnergyPerShot()) {
            player.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
            if (!this.chargeMode) {
                this.fire(itemStackIn, player, worldIn);
            }
        } else if (!worldIn.field_72995_K) {
            worldIn.func_72956_a((Entity)player, this.getEmptySound(), 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
        }
        return itemStackIn;
    }

    public float getEnergyPerShot() {
        return 300.0f;
    }

    protected String getFiringSound() {
        return "amunra:weapon.lasergun.shot";
    }

    protected String getEmptySound() {
        return "amunra:weapon.lasergun.empty";
    }

    protected boolean fire(ItemStack itemStack, EntityPlayer entityPlayer, World world) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - this.getModifiedEnergyPerShot(itemStack));
        }
        if (!world.field_72995_K) {
            world.func_72956_a((Entity)entityPlayer, this.getFiringSound(), 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
            this.spawnProjectile(itemStack, entityPlayer, world);
        }
        return true;
    }

    protected float getModifiedEnergyPerShot(ItemStack stack) {
        float base = this.getEnergyPerShot();
        int efficiency = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)stack);
        float relativeEff = (float)efficiency / 10.0f;
        return base * (1.0f - relativeEff);
    }

    protected void spawnProjectile(ItemStack itemStack, EntityPlayer entityPlayer, World world) {
        EntityBaseLaserArrow ent = this.createProjectile(itemStack, entityPlayer, world);
        world.func_72838_d((Entity)ent);
    }

    protected abstract EntityBaseLaserArrow createProjectile(ItemStack var1, EntityPlayer var2, World var3);

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
    }
}

