/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.handshake.IHandshakeState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.embeddedt.archaicfix.ArchaicFix;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.ducks.IAcceleratedRecipe;
import org.embeddedt.archaicfix.helpers.OreDictIterator;
import org.embeddedt.archaicfix.recipe.IFasterCraftingManager;

public class FixHelper {
    public static ArrayList<IAcceleratedRecipe> recipesHoldingPotentialItems = new ArrayList();
    public static Set<Object> unmoddedNetHandlers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    public static Map<ChannelHandlerContext, Attribute<IHandshakeState<?>>> handshakeStateMap = Collections.synchronizedMap(new WeakHashMap());

    @SubscribeEvent
    public void onSizeUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.field_70170_p.field_72995_K && entity instanceof EntitySlime && entity.func_70654_ax() <= 1) {
            float newSize;
            EntitySlime slime = (EntitySlime)entity;
            slime.field_70130_N = newSize = 0.6f * (float)slime.func_70809_q();
            slime.field_70131_O = newSize;
            slime.func_70107_b(slime.field_70165_t, slime.field_70163_u, slime.field_70161_v);
        }
    }

    @SubscribeEvent
    public void onOreRegister(OreDictionary.OreRegisterEvent event) {
        for (IAcceleratedRecipe recipe : recipesHoldingPotentialItems) {
            if (recipe == null) continue;
            recipe.invalidatePotentialItems();
        }
        recipesHoldingPotentialItems.clear();
        if (CraftingManager.func_77594_a() != null) {
            ((IFasterCraftingManager)CraftingManager.func_77594_a()).clearRecipeCache();
        }
        OreDictIterator.clearCache(event.Name);
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.connectionType.equals("MODDED")) {
            ArchaicLogger.LOGGER.info("Connected to vanilla server");
            ArchaicFix.IS_VANILLA_SERVER = true;
        }
    }

    @SubscribeEvent
    public void onNetworkRegister(FMLNetworkEvent.CustomPacketRegistrationEvent event) {
        if (event.operation.equals("REGISTER")) {
            boolean hasArchaic = event.registrations.contains((Object)"archaicfix");
            if (event.handler instanceof NetHandlerPlayServer) {
                if (!hasArchaic) {
                    ArchaicLogger.LOGGER.info("Player is connecting without ArchaicFix installed");
                    unmoddedNetHandlers.add(event.handler);
                }
            } else {
                boolean bl = ArchaicFix.IS_VANILLA_SERVER = !hasArchaic;
                if (!hasArchaic) {
                    ArchaicLogger.LOGGER.info("Connecting to server without ArchaicFix installed");
                }
            }
        }
    }
}

